/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.integration.android;

import android.os.Build;
import android.security.keystore.KeyGenParameterSpec;
import androidx.annotation.ChecksSdkIntAtLeast;
import androidx.annotation.RequiresApi;
import com.google.crypto.tink.Aead;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;

public final class AndroidKeystore {
    @RequiresApi(value=23)
    public static void generateNewAes256GcmKey(String alias) throws GeneralSecurityException {
        KeyGenParameterSpec spec = new KeyGenParameterSpec.Builder(alias, 3).setKeySize(256).setBlockModes(new String[]{"GCM"}).setEncryptionPaddings(new String[]{"NoPadding"}).build();
        AndroidKeystore.generateNewKeyWithSpec(spec);
    }

    @RequiresApi(value=23)
    public static void generateNewKeyWithSpec(KeyGenParameterSpec spec) throws GeneralSecurityException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES", "AndroidKeyStore");
        keyGenerator.init((AlgorithmParameterSpec)spec);
        keyGenerator.generateKey();
    }

    public static Aead getAead(String alias) throws GeneralSecurityException {
        return new AeadImpl(alias, AndroidKeystore.getAndroidKeyStore());
    }

    public static void deleteKey(String alias) throws GeneralSecurityException {
        KeyStore keyStore = AndroidKeystore.getAndroidKeyStore();
        keyStore.deleteEntry(alias);
    }

    public static boolean hasKey(String alias) throws GeneralSecurityException {
        KeyStore keyStore = AndroidKeystore.getAndroidKeyStore();
        return keyStore.containsAlias(alias);
    }

    private static KeyStore getAndroidKeyStore() throws GeneralSecurityException {
        if (!AndroidKeystore.isAtLeastM()) {
            throw new IllegalStateException("Need Android Keystore on Android M or newer");
        }
        try {
            KeyStore keyStore = KeyStore.getInstance("AndroidKeyStore");
            keyStore.load(null);
            return keyStore;
        }
        catch (IOException ex) {
            throw new GeneralSecurityException(ex);
        }
    }

    @ChecksSdkIntAtLeast(api=23)
    private static boolean isAtLeastM() {
        return Build.VERSION.SDK_INT >= 23;
    }

    private AndroidKeystore() {
    }

    private static final class AeadImpl
    implements Aead {
        private static final int IV_SIZE_IN_BYTES = 12;
        private static final int TAG_SIZE_IN_BYTES = 16;
        private final SecretKey key;

        public AeadImpl(String alias, KeyStore keyStore) throws GeneralSecurityException {
            this.key = (SecretKey)keyStore.getKey(alias, null);
            if (this.key == null) {
                throw new InvalidKeyException("Keystore cannot load the key with ID: " + alias);
            }
        }

        @Override
        public byte[] encrypt(byte[] plaintext, byte[] associatedData) throws GeneralSecurityException {
            if (plaintext.length > 2147483619) {
                throw new GeneralSecurityException("plaintext too long");
            }
            byte[] ciphertext = new byte[12 + plaintext.length + 16];
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(1, this.key);
            cipher.updateAAD(associatedData);
            int unusedWritten = cipher.doFinal(plaintext, 0, plaintext.length, ciphertext, 12);
            byte[] iv = cipher.getIV();
            if (iv.length != 12) {
                throw new GeneralSecurityException("IV has unexpected length");
            }
            System.arraycopy(iv, 0, ciphertext, 0, 12);
            return ciphertext;
        }

        @Override
        public byte[] decrypt(byte[] ciphertext, byte[] associatedData) throws GeneralSecurityException {
            if (ciphertext.length < 28) {
                throw new BadPaddingException("ciphertext too short");
            }
            GCMParameterSpec params = new GCMParameterSpec(128, ciphertext, 0, 12);
            Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
            cipher.init(2, (Key)this.key, params);
            cipher.updateAAD(associatedData);
            return cipher.doFinal(ciphertext, 12, ciphertext.length - 12);
        }
    }
}

