/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.widget;

import androidx.annotation.NonNull;
import androidx.collection.LongSparseArray;

interface StableIdStorage {
    @NonNull
    public StableIdLookup createStableIdLookup();

    public static class IsolatedStableIdStorage
    implements StableIdStorage {
        long mNextStableId = 0L;

        long obtainId() {
            return this.mNextStableId++;
        }

        @Override
        @NonNull
        public StableIdLookup createStableIdLookup() {
            return new WrapperStableIdLookup();
        }

        class WrapperStableIdLookup
        implements StableIdLookup {
            private final LongSparseArray<Long> mLocalToGlobalLookup = new LongSparseArray();

            WrapperStableIdLookup() {
            }

            @Override
            public long localToGlobal(long localId) {
                Long globalId = (Long)this.mLocalToGlobalLookup.get(localId);
                if (globalId == null) {
                    globalId = IsolatedStableIdStorage.this.obtainId();
                    this.mLocalToGlobalLookup.put(localId, (Object)globalId);
                }
                return globalId;
            }
        }
    }

    public static class SharedPoolStableIdStorage
    implements StableIdStorage {
        private final StableIdLookup mSameIdLookup = new StableIdLookup(){

            @Override
            public long localToGlobal(long localId) {
                return localId;
            }
        };

        @Override
        @NonNull
        public StableIdLookup createStableIdLookup() {
            return this.mSameIdLookup;
        }
    }

    public static class NoStableIdStorage
    implements StableIdStorage {
        private final StableIdLookup mNoIdLookup = new StableIdLookup(){

            @Override
            public long localToGlobal(long localId) {
                return -1L;
            }
        };

        @Override
        @NonNull
        public StableIdLookup createStableIdLookup() {
            return this.mNoIdLookup;
        }
    }

    public static interface StableIdLookup {
        public long localToGlobal(long var1);
    }
}

