/*
 * Decompiled with CFR 0.152.
 */
package androidx.emoji2.text;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.core.provider.FontRequest;
import androidx.core.util.Preconditions;
import androidx.emoji2.text.EmojiCompat;
import androidx.emoji2.text.FontRequestEmojiCompatConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DefaultEmojiCompatConfig {
    private DefaultEmojiCompatConfig() {
    }

    @Nullable
    public static FontRequestEmojiCompatConfig create(@NonNull Context context) {
        return (FontRequestEmojiCompatConfig)new DefaultEmojiCompatConfigFactory(null).create(context);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static class DefaultEmojiCompatConfigFactory {
        @NonNull
        private static final String TAG = "emoji2.text.DefaultEmojiConfig";
        @NonNull
        private static final String INTENT_LOAD_EMOJI_FONT = "androidx.content.action.LOAD_EMOJI_FONT";
        @NonNull
        private static final String DEFAULT_EMOJI_QUERY = "emojicompat-emoji-font";
        private final DefaultEmojiCompatConfigHelper mHelper;

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public DefaultEmojiCompatConfigFactory(@Nullable DefaultEmojiCompatConfigHelper helper) {
            this.mHelper = helper != null ? helper : DefaultEmojiCompatConfigFactory.getHelperForApi();
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public EmojiCompat.Config create(@NonNull Context context) {
            return this.configOrNull(context, this.queryForDefaultFontRequest(context));
        }

        @Nullable
        private EmojiCompat.Config configOrNull(@NonNull Context context, @Nullable FontRequest fontRequest) {
            if (fontRequest == null) {
                return null;
            }
            return new FontRequestEmojiCompatConfig(context, fontRequest);
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        @VisibleForTesting
        FontRequest queryForDefaultFontRequest(@NonNull Context context) {
            PackageManager packageManager = context.getPackageManager();
            Preconditions.checkNotNull((Object)packageManager, (Object)"Package manager required to locate emoji font provider");
            ProviderInfo providerInfo = this.queryDefaultInstalledContentProvider(packageManager);
            if (providerInfo == null) {
                return null;
            }
            try {
                return this.generateFontRequestFrom(providerInfo, packageManager);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.wtf((String)TAG, (Throwable)e);
                return null;
            }
        }

        @Nullable
        private ProviderInfo queryDefaultInstalledContentProvider(@NonNull PackageManager packageManager) {
            List<ResolveInfo> providers = this.mHelper.queryIntentContentProviders(packageManager, new Intent(INTENT_LOAD_EMOJI_FONT), 0);
            for (ResolveInfo resolveInfo : providers) {
                ProviderInfo providerInfo = this.mHelper.getProviderInfo(resolveInfo);
                if (!this.hasFlagSystem(providerInfo)) continue;
                return providerInfo;
            }
            return null;
        }

        private boolean hasFlagSystem(@Nullable ProviderInfo providerInfo) {
            return providerInfo != null && providerInfo.applicationInfo != null && (providerInfo.applicationInfo.flags & 1) == 1;
        }

        @NonNull
        private FontRequest generateFontRequestFrom(@NonNull ProviderInfo providerInfo, @NonNull PackageManager packageManager) throws PackageManager.NameNotFoundException {
            String providerAuthority = providerInfo.authority;
            String providerPackage = providerInfo.packageName;
            Signature[] signingSignatures = this.mHelper.getSigningSignatures(packageManager, providerPackage);
            List<List<byte[]>> signatures = this.convertToByteArray(signingSignatures);
            return new FontRequest(providerAuthority, providerPackage, DEFAULT_EMOJI_QUERY, signatures);
        }

        @NonNull
        private List<List<byte[]>> convertToByteArray(@NonNull Signature[] signatures) {
            ArrayList<byte[]> shaList = new ArrayList<byte[]>();
            for (Signature signature : signatures) {
                shaList.add(signature.toByteArray());
            }
            return Collections.singletonList(shaList);
        }

        @NonNull
        private static DefaultEmojiCompatConfigHelper getHelperForApi() {
            if (Build.VERSION.SDK_INT >= 28) {
                return new DefaultEmojiCompatConfigHelper_API28();
            }
            return new DefaultEmojiCompatConfigHelper();
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static class DefaultEmojiCompatConfigHelper {
        @NonNull
        public List<ResolveInfo> queryIntentContentProviders(@NonNull PackageManager packageManager, @NonNull Intent intent, int flags) {
            return packageManager.queryIntentContentProviders(intent, flags);
        }

        @Nullable
        public ProviderInfo getProviderInfo(@NonNull ResolveInfo resolveInfo) {
            return resolveInfo.providerInfo;
        }

        @NonNull
        public Signature[] getSigningSignatures(@NonNull PackageManager packageManager, @NonNull String providerPackage) throws PackageManager.NameNotFoundException {
            PackageInfo packageInfoForSignatures = packageManager.getPackageInfo(providerPackage, 64);
            return packageInfoForSignatures.signatures;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @RequiresApi(value=28)
    public static class DefaultEmojiCompatConfigHelper_API28
    extends DefaultEmojiCompatConfigHelper {
        @Override
        @NonNull
        public Signature[] getSigningSignatures(@NonNull PackageManager packageManager, @NonNull String providerPackage) throws PackageManager.NameNotFoundException {
            PackageInfo packageInfoForSignatures = packageManager.getPackageInfo(providerPackage, 64);
            return packageInfoForSignatures.signatures;
        }
    }
}

