/*
 * Decompiled with CFR 0.152.
 */
package androidx.emoji2.text;

import android.content.Context;
import android.os.Bundle;
import android.text.Editable;
import android.view.KeyEvent;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import androidx.annotation.AnyThread;
import androidx.annotation.CheckResult;
import androidx.annotation.ColorInt;
import androidx.annotation.GuardedBy;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.collection.ArraySet;
import androidx.core.util.Preconditions;
import androidx.emoji2.text.ConcurrencyHelpers;
import androidx.emoji2.text.DefaultEmojiCompatConfig;
import androidx.emoji2.text.DefaultGlyphChecker;
import androidx.emoji2.text.EmojiExclusions;
import androidx.emoji2.text.EmojiProcessor;
import androidx.emoji2.text.EmojiSpan;
import androidx.emoji2.text.MetadataRepo;
import androidx.emoji2.text.TypefaceEmojiRasterizer;
import androidx.emoji2.text.TypefaceEmojiSpan;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@AnyThread
public class EmojiCompat {
    public static final String EDITOR_INFO_METAVERSION_KEY = "android.support.text.emoji.emojiCompat_metadataVersion";
    public static final String EDITOR_INFO_REPLACE_ALL_KEY = "android.support.text.emoji.emojiCompat_replaceAll";
    public static final int LOAD_STATE_DEFAULT = 3;
    public static final int LOAD_STATE_LOADING = 0;
    public static final int LOAD_STATE_SUCCEEDED = 1;
    public static final int LOAD_STATE_FAILED = 2;
    public static final int REPLACE_STRATEGY_DEFAULT = 0;
    public static final int REPLACE_STRATEGY_ALL = 1;
    public static final int REPLACE_STRATEGY_NON_EXISTENT = 2;
    public static final int LOAD_STRATEGY_DEFAULT = 0;
    public static final int LOAD_STRATEGY_MANUAL = 1;
    public static final int EMOJI_UNSUPPORTED = 0;
    public static final int EMOJI_SUPPORTED = 1;
    public static final int EMOJI_FALLBACK = 2;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    static final int EMOJI_COUNT_UNLIMITED = Integer.MAX_VALUE;
    private static final Object INSTANCE_LOCK = new Object();
    private static final Object CONFIG_LOCK = new Object();
    @GuardedBy(value="INSTANCE_LOCK")
    @Nullable
    private static volatile EmojiCompat sInstance;
    @GuardedBy(value="CONFIG_LOCK")
    private static volatile boolean sHasDoneDefaultConfigLookup;
    @NonNull
    private final ReadWriteLock mInitLock = new ReentrantReadWriteLock();
    @GuardedBy(value="mInitLock")
    @NonNull
    private final Set<InitWithExecutor> mInitCallbacks;
    @GuardedBy(value="mInitLock")
    private volatile int mLoadState = 3;
    @NonNull
    private final CompatInternal mHelper;
    @NonNull
    final MetadataRepoLoader mMetadataLoader;
    @NonNull
    private final SpanFactory mSpanFactory;
    final boolean mReplaceAll;
    final boolean mUseEmojiAsDefaultStyle;
    @Nullable
    final int[] mEmojiAsDefaultStyleExceptions;
    private final boolean mEmojiSpanIndicatorEnabled;
    private final int mEmojiSpanIndicatorColor;
    private final int mMetadataLoadStrategy;
    private final GlyphChecker mGlyphChecker;
    private static final String NOT_INITIALIZED_ERROR_TEXT = "EmojiCompat is not initialized.\n\nYou must initialize EmojiCompat prior to referencing the EmojiCompat instance.\n\nThe most likely cause of this error is disabling the EmojiCompatInitializer\neither explicitly in AndroidManifest.xml, or by including\nandroidx.emoji2:emoji2-bundled.\n\nAutomatic initialization is typically performed by EmojiCompatInitializer. If\nyou are not expecting to initialize EmojiCompat manually in your application,\nplease check to ensure it has not been removed from your APK's manifest. You can\ndo this in Android Studio using Build > Analyze APK.\n\nIn the APK Analyzer, ensure that the startup entry for\nEmojiCompatInitializer and InitializationProvider is present in\n AndroidManifest.xml. If it is missing or contains tools:node=\"remove\", and you\nintend to use automatic configuration, verify:\n\n  1. Your application does not include emoji2-bundled\n  2. All modules do not contain an exclusion manifest rule for\n     EmojiCompatInitializer or InitializationProvider. For more information\n     about manifest exclusions see the documentation for the androidx startup\n     library.\n\nIf you intend to use emoji2-bundled, please call EmojiCompat.init. You can\nlearn more in the documentation for BundledEmojiCompatConfig.\n\nIf you intended to perform manual configuration, it is recommended that you call\nEmojiCompat.init immediately on application startup.\n\nIf you still cannot resolve this issue, please open a bug with your specific\nconfiguration to help improve error message.";

    private EmojiCompat(@NonNull Config config) {
        this.mReplaceAll = config.mReplaceAll;
        this.mUseEmojiAsDefaultStyle = config.mUseEmojiAsDefaultStyle;
        this.mEmojiAsDefaultStyleExceptions = config.mEmojiAsDefaultStyleExceptions;
        this.mEmojiSpanIndicatorEnabled = config.mEmojiSpanIndicatorEnabled;
        this.mEmojiSpanIndicatorColor = config.mEmojiSpanIndicatorColor;
        this.mMetadataLoader = config.mMetadataLoader;
        this.mMetadataLoadStrategy = config.mMetadataLoadStrategy;
        this.mGlyphChecker = config.mGlyphChecker;
        this.mInitCallbacks = new ArraySet();
        SpanFactory localSpanFactory = config.mSpanFactory;
        SpanFactory spanFactory = this.mSpanFactory = localSpanFactory != null ? localSpanFactory : new DefaultSpanFactory();
        if (config.mInitCallbacks != null && !config.mInitCallbacks.isEmpty()) {
            this.mInitCallbacks.addAll(config.mInitCallbacks);
        }
        this.mHelper = new CompatInternal(this);
        this.loadMetadata();
    }

    @Nullable
    public static EmojiCompat init(@NonNull Context context) {
        return EmojiCompat.init(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @Nullable
    public static EmojiCompat init(@NonNull Context context, @Nullable DefaultEmojiCompatConfig.DefaultEmojiCompatConfigFactory defaultFactory) {
        if (sHasDoneDefaultConfigLookup) {
            return sInstance;
        }
        DefaultEmojiCompatConfig.DefaultEmojiCompatConfigFactory factory = defaultFactory != null ? defaultFactory : new DefaultEmojiCompatConfig.DefaultEmojiCompatConfigFactory(null);
        Config config = factory.create(context);
        Object object = CONFIG_LOCK;
        synchronized (object) {
            if (!sHasDoneDefaultConfigLookup) {
                if (config != null) {
                    EmojiCompat.init(config);
                }
                sHasDoneDefaultConfigLookup = true;
            }
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static EmojiCompat init(@NonNull Config config) {
        EmojiCompat localInstance = sInstance;
        if (localInstance == null) {
            Object object = INSTANCE_LOCK;
            synchronized (object) {
                localInstance = sInstance;
                if (localInstance == null) {
                    sInstance = localInstance = new EmojiCompat(config);
                }
            }
        }
        return localInstance;
    }

    public static boolean isConfigured() {
        return sInstance != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public static EmojiCompat reset(@NonNull Config config) {
        Object object = INSTANCE_LOCK;
        synchronized (object) {
            EmojiCompat localInstance;
            sInstance = localInstance = new EmojiCompat(config);
            return localInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @VisibleForTesting
    @Nullable
    public static EmojiCompat reset(@Nullable EmojiCompat emojiCompat) {
        Object object = INSTANCE_LOCK;
        synchronized (object) {
            sInstance = emojiCompat;
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @VisibleForTesting
    public static void skipDefaultConfigurationLookup(boolean shouldSkip) {
        Object object = CONFIG_LOCK;
        synchronized (object) {
            sHasDoneDefaultConfigLookup = shouldSkip;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static EmojiCompat get() {
        Object object = INSTANCE_LOCK;
        synchronized (object) {
            EmojiCompat localInstance = sInstance;
            Preconditions.checkState((localInstance != null ? 1 : 0) != 0, (String)NOT_INITIALIZED_ERROR_TEXT);
            return localInstance;
        }
    }

    public void load() {
        Preconditions.checkState((this.mMetadataLoadStrategy == 1 ? 1 : 0) != 0, (String)"Set metadataLoadStrategy to LOAD_STRATEGY_MANUAL to execute manual loading");
        if (this.isInitialized()) {
            return;
        }
        this.mInitLock.writeLock().lock();
        try {
            if (this.mLoadState == 0) {
                return;
            }
            this.mLoadState = 0;
        }
        finally {
            this.mInitLock.writeLock().unlock();
        }
        this.mHelper.loadMetadata();
    }

    private void loadMetadata() {
        this.mInitLock.writeLock().lock();
        try {
            if (this.mMetadataLoadStrategy == 0) {
                this.mLoadState = 0;
            }
        }
        finally {
            this.mInitLock.writeLock().unlock();
        }
        if (this.getLoadState() == 0) {
            this.mHelper.loadMetadata();
        }
    }

    void onMetadataLoadSuccess() {
        Set<InitWithExecutor> localRefCbs = this.mInitCallbacks;
        ArrayList<InitWithExecutor> initCallbacks = new ArrayList<InitWithExecutor>(localRefCbs.size());
        this.mInitLock.writeLock().lock();
        try {
            this.mLoadState = 1;
            initCallbacks.addAll(localRefCbs);
            localRefCbs.clear();
        }
        finally {
            this.mInitLock.writeLock().unlock();
        }
        for (int i = 0; i < initCallbacks.size(); ++i) {
            ((InitWithExecutor)initCallbacks.get(i)).dispatchInitialized();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onMetadataLoadFailed(@NonNull Throwable throwable) {
        Set<InitWithExecutor> localRefCbs = this.mInitCallbacks;
        ArrayList<InitWithExecutor> initCallbacks = new ArrayList<InitWithExecutor>(localRefCbs.size());
        this.mInitLock.writeLock().lock();
        try {
            this.mLoadState = 2;
            initCallbacks.addAll(localRefCbs);
            localRefCbs.clear();
        }
        finally {
            this.mInitLock.writeLock().unlock();
        }
        for (int i = 0; i < initCallbacks.size(); ++i) {
            ((InitWithExecutor)initCallbacks.get(i)).dispatchFailed(throwable);
        }
    }

    public void registerInitCallback(@NonNull InitCallback initCallback) {
        this.registerInitCallback(ConcurrencyHelpers.mainThreadExecutor(), initCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInitCallback(@NonNull Executor executor, @NonNull InitCallback initCallback) {
        Preconditions.checkNotNull((Object)initCallback, (Object)"initCallback cannot be null");
        Preconditions.checkNotNull((Object)executor, (Object)"executor cannot be null");
        InitWithExecutor newCb = new InitWithExecutor(executor, initCallback);
        this.mInitLock.writeLock().lock();
        try {
            if (this.mLoadState == 1) {
                newCb.dispatchInitialized();
            } else if (this.mLoadState == 2) {
                newCb.dispatchFailed(new IllegalStateException("Initialization failed prior to registering this callback, please add an initialization callback to the EmojiCompat.Config instead to see the cause."));
            } else {
                this.mInitCallbacks.add(newCb);
            }
        }
        finally {
            this.mInitLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterInitCallback(@NonNull InitCallback initCallback) {
        Preconditions.checkNotNull((Object)initCallback, (Object)"initCallback cannot be null");
        this.mInitLock.writeLock().lock();
        try {
            ArrayList<InitWithExecutor> toRemove = new ArrayList<InitWithExecutor>();
            for (InitWithExecutor item : this.mInitCallbacks) {
                if (item.mInitCallback != initCallback) continue;
                toRemove.add(item);
            }
            for (InitWithExecutor item : toRemove) {
                this.mInitCallbacks.remove(item);
            }
        }
        finally {
            this.mInitLock.writeLock().unlock();
        }
    }

    public int getLoadState() {
        this.mInitLock.readLock().lock();
        try {
            int n = this.mLoadState;
            return n;
        }
        finally {
            this.mInitLock.readLock().unlock();
        }
    }

    private boolean isInitialized() {
        return this.getLoadState() == 1;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean isEmojiSpanIndicatorEnabled() {
        return this.mEmojiSpanIndicatorEnabled;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @ColorInt
    public int getEmojiSpanIndicatorColor() {
        return this.mEmojiSpanIndicatorColor;
    }

    public int getEmojiStart(@NonNull CharSequence charSequence, @IntRange(from=0L) int offset) {
        Preconditions.checkState((boolean)this.isInitialized(), (String)"Not initialized yet");
        Preconditions.checkNotNull((Object)charSequence, (Object)"charSequence cannot be null");
        return this.mHelper.getEmojiStart(charSequence, offset);
    }

    public int getEmojiEnd(@NonNull CharSequence charSequence, @IntRange(from=0L) int offset) {
        Preconditions.checkState((boolean)this.isInitialized(), (String)"Not initialized yet");
        Preconditions.checkNotNull((Object)charSequence, (Object)"charSequence cannot be null");
        return this.mHelper.getEmojiEnd(charSequence, offset);
    }

    public static boolean handleOnKeyDown(@NonNull Editable editable, int keyCode, @NonNull KeyEvent event) {
        return EmojiProcessor.handleOnKeyDown(editable, keyCode, event);
    }

    public static boolean handleDeleteSurroundingText(@NonNull InputConnection inputConnection, @NonNull Editable editable, @IntRange(from=0L) int beforeLength, @IntRange(from=0L) int afterLength, boolean inCodePoints) {
        return EmojiProcessor.handleDeleteSurroundingText(inputConnection, editable, beforeLength, afterLength, inCodePoints);
    }

    @Deprecated
    public boolean hasEmojiGlyph(@NonNull CharSequence sequence) {
        Preconditions.checkState((boolean)this.isInitialized(), (String)"Not initialized yet");
        Preconditions.checkNotNull((Object)sequence, (Object)"sequence cannot be null");
        return this.mHelper.hasEmojiGlyph(sequence);
    }

    @Deprecated
    public boolean hasEmojiGlyph(@NonNull CharSequence sequence, @IntRange(from=0L) int metadataVersion) {
        Preconditions.checkState((boolean)this.isInitialized(), (String)"Not initialized yet");
        Preconditions.checkNotNull((Object)sequence, (Object)"sequence cannot be null");
        return this.mHelper.hasEmojiGlyph(sequence, metadataVersion);
    }

    public int getEmojiMatch(@NonNull CharSequence sequence, @IntRange(from=0L) int metadataVersion) {
        Preconditions.checkState((boolean)this.isInitialized(), (String)"Not initialized yet");
        Preconditions.checkNotNull((Object)sequence, (Object)"sequence cannot be null");
        return this.mHelper.getEmojiMatch(sequence, metadataVersion);
    }

    @Nullable
    @CheckResult
    public CharSequence process(@Nullable CharSequence charSequence) {
        int length = charSequence == null ? 0 : charSequence.length();
        return this.process(charSequence, 0, length);
    }

    @Nullable
    @CheckResult
    public CharSequence process(@Nullable CharSequence charSequence, @IntRange(from=0L) int start, @IntRange(from=0L) int end) {
        return this.process(charSequence, start, end, Integer.MAX_VALUE);
    }

    @Nullable
    @CheckResult
    public CharSequence process(@Nullable CharSequence charSequence, @IntRange(from=0L) int start, @IntRange(from=0L) int end, @IntRange(from=0L) int maxEmojiCount) {
        return this.process(charSequence, start, end, maxEmojiCount, 0);
    }

    @Nullable
    @CheckResult
    public CharSequence process(@Nullable CharSequence charSequence, @IntRange(from=0L) int start, @IntRange(from=0L) int end, @IntRange(from=0L) int maxEmojiCount, int replaceStrategy) {
        boolean replaceAll;
        Preconditions.checkState((boolean)this.isInitialized(), (String)"Not initialized yet");
        Preconditions.checkArgumentNonnegative((int)start, (String)"start cannot be negative");
        Preconditions.checkArgumentNonnegative((int)end, (String)"end cannot be negative");
        Preconditions.checkArgumentNonnegative((int)maxEmojiCount, (String)"maxEmojiCount cannot be negative");
        Preconditions.checkArgument((start <= end ? 1 : 0) != 0, (Object)"start should be <= than end");
        if (charSequence == null) {
            return null;
        }
        Preconditions.checkArgument((start <= charSequence.length() ? 1 : 0) != 0, (Object)"start should be < than charSequence length");
        Preconditions.checkArgument((end <= charSequence.length() ? 1 : 0) != 0, (Object)"end should be < than charSequence length");
        if (charSequence.length() == 0 || start == end) {
            return charSequence;
        }
        switch (replaceStrategy) {
            case 1: {
                replaceAll = true;
                break;
            }
            case 2: {
                replaceAll = false;
                break;
            }
            default: {
                replaceAll = this.mReplaceAll;
            }
        }
        return this.mHelper.process(charSequence, start, end, maxEmojiCount, replaceAll);
    }

    @NonNull
    public String getAssetSignature() {
        Preconditions.checkState((boolean)this.isInitialized(), (String)"Not initialized yet");
        return this.mHelper.getAssetSignature();
    }

    public void updateEditorInfo(@NonNull EditorInfo outAttrs) {
        if (!this.isInitialized() || outAttrs == null) {
            return;
        }
        if (outAttrs.extras == null) {
            outAttrs.extras = new Bundle();
        }
        this.mHelper.updateEditorInfoAttrs(outAttrs);
    }

    public static interface GlyphChecker {
        public boolean hasGlyph(@NonNull CharSequence var1, @IntRange(from=0L) int var2, @IntRange(from=0L) int var3, @IntRange(from=0L) int var4);
    }

    public static interface SpanFactory {
        @NonNull
        public EmojiSpan createSpan(@NonNull TypefaceEmojiRasterizer var1);
    }

    public static abstract class Config {
        @NonNull
        final MetadataRepoLoader mMetadataLoader;
        SpanFactory mSpanFactory;
        boolean mReplaceAll;
        boolean mUseEmojiAsDefaultStyle;
        @Nullable
        int[] mEmojiAsDefaultStyleExceptions;
        @Nullable
        Set<InitWithExecutor> mInitCallbacks;
        boolean mEmojiSpanIndicatorEnabled;
        int mEmojiSpanIndicatorColor = -16711936;
        int mMetadataLoadStrategy = 0;
        @NonNull
        GlyphChecker mGlyphChecker = new DefaultGlyphChecker();

        protected Config(@NonNull MetadataRepoLoader metadataLoader) {
            Preconditions.checkNotNull((Object)metadataLoader, (Object)"metadataLoader cannot be null.");
            this.mMetadataLoader = metadataLoader;
        }

        @NonNull
        public Config registerInitCallback(@NonNull InitCallback initCallback) {
            this.registerInitCallback(ConcurrencyHelpers.mainThreadExecutor(), initCallback);
            return this;
        }

        @NonNull
        public Config registerInitCallback(@NonNull Executor executor, @NonNull InitCallback initCallback) {
            Preconditions.checkNotNull((Object)initCallback, (Object)"initCallback cannot be null");
            Preconditions.checkNotNull((Object)executor, (Object)"executor cannot be null");
            if (this.mInitCallbacks == null) {
                this.mInitCallbacks = new ArraySet();
            }
            this.mInitCallbacks.add(new InitWithExecutor(executor, initCallback));
            return this;
        }

        @NonNull
        public Config unregisterInitCallback(@NonNull InitCallback initCallback) {
            Preconditions.checkNotNull((Object)initCallback, (Object)"initCallback cannot be null");
            if (this.mInitCallbacks != null) {
                ArrayList<InitWithExecutor> toRemove = new ArrayList<InitWithExecutor>();
                for (InitWithExecutor item : this.mInitCallbacks) {
                    if (item.mInitCallback != initCallback) continue;
                    toRemove.add(item);
                }
                for (InitWithExecutor item : toRemove) {
                    this.mInitCallbacks.remove(item);
                }
            }
            return this;
        }

        @NonNull
        public Config setReplaceAll(boolean replaceAll) {
            this.mReplaceAll = replaceAll;
            return this;
        }

        @NonNull
        public Config setUseEmojiAsDefaultStyle(boolean useEmojiAsDefaultStyle) {
            return this.setUseEmojiAsDefaultStyle(useEmojiAsDefaultStyle, null);
        }

        @NonNull
        public Config setUseEmojiAsDefaultStyle(boolean useEmojiAsDefaultStyle, @Nullable List<Integer> emojiAsDefaultStyleExceptions) {
            this.mUseEmojiAsDefaultStyle = useEmojiAsDefaultStyle;
            if (this.mUseEmojiAsDefaultStyle && emojiAsDefaultStyleExceptions != null) {
                this.mEmojiAsDefaultStyleExceptions = new int[emojiAsDefaultStyleExceptions.size()];
                int i = 0;
                for (Integer exception : emojiAsDefaultStyleExceptions) {
                    this.mEmojiAsDefaultStyleExceptions[i++] = exception;
                }
                Arrays.sort(this.mEmojiAsDefaultStyleExceptions);
            } else {
                this.mEmojiAsDefaultStyleExceptions = null;
            }
            return this;
        }

        @NonNull
        public Config setEmojiSpanIndicatorEnabled(boolean emojiSpanIndicatorEnabled) {
            this.mEmojiSpanIndicatorEnabled = emojiSpanIndicatorEnabled;
            return this;
        }

        @NonNull
        public Config setEmojiSpanIndicatorColor(@ColorInt int color) {
            this.mEmojiSpanIndicatorColor = color;
            return this;
        }

        @NonNull
        public Config setMetadataLoadStrategy(int strategy) {
            this.mMetadataLoadStrategy = strategy;
            return this;
        }

        @NonNull
        public Config setSpanFactory(@NonNull SpanFactory factory) {
            this.mSpanFactory = factory;
            return this;
        }

        @NonNull
        public Config setGlyphChecker(@NonNull GlyphChecker glyphChecker) {
            Preconditions.checkNotNull((Object)glyphChecker, (Object)"GlyphChecker cannot be null");
            this.mGlyphChecker = glyphChecker;
            return this;
        }

        @NonNull
        protected final MetadataRepoLoader getMetadataRepoLoader() {
            return this.mMetadataLoader;
        }
    }

    public static interface MetadataRepoLoader {
        public void load(@NonNull MetadataRepoLoaderCallback var1);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static class DefaultSpanFactory
    implements SpanFactory {
        @Override
        @NonNull
        public EmojiSpan createSpan(@NonNull TypefaceEmojiRasterizer rasterizer) {
            return new TypefaceEmojiSpan(rasterizer);
        }
    }

    private static final class CompatInternal {
        private volatile EmojiProcessor mProcessor;
        private volatile MetadataRepo mMetadataRepo;
        private final EmojiCompat mEmojiCompat;

        CompatInternal(EmojiCompat emojiCompat) {
            this.mEmojiCompat = emojiCompat;
        }

        void loadMetadata() {
            try {
                MetadataRepoLoaderCallback callback = new MetadataRepoLoaderCallback(){

                    @Override
                    public void onLoaded(@NonNull MetadataRepo metadataRepo) {
                        this.onMetadataLoadSuccess(metadataRepo);
                    }

                    @Override
                    public void onFailed(@Nullable Throwable throwable) {
                        mEmojiCompat.onMetadataLoadFailed(throwable);
                    }
                };
                this.mEmojiCompat.mMetadataLoader.load(callback);
            }
            catch (Throwable t) {
                this.mEmojiCompat.onMetadataLoadFailed(t);
            }
        }

        void onMetadataLoadSuccess(@NonNull MetadataRepo metadataRepo) {
            if (metadataRepo == null) {
                this.mEmojiCompat.onMetadataLoadFailed(new IllegalArgumentException("metadataRepo cannot be null"));
                return;
            }
            this.mMetadataRepo = metadataRepo;
            this.mProcessor = new EmojiProcessor(this.mMetadataRepo, this.mEmojiCompat.mSpanFactory, this.mEmojiCompat.mGlyphChecker, this.mEmojiCompat.mUseEmojiAsDefaultStyle, this.mEmojiCompat.mEmojiAsDefaultStyleExceptions, EmojiExclusions.getEmojiExclusions());
            this.mEmojiCompat.onMetadataLoadSuccess();
        }

        boolean hasEmojiGlyph(@NonNull CharSequence sequence) {
            return this.mProcessor.getEmojiMatch(sequence) == 1;
        }

        boolean hasEmojiGlyph(@NonNull CharSequence sequence, int metadataVersion) {
            int emojiMatch = this.mProcessor.getEmojiMatch(sequence, metadataVersion);
            return emojiMatch == 1;
        }

        public int getEmojiMatch(CharSequence sequence, int metadataVersion) {
            return this.mProcessor.getEmojiMatch(sequence, metadataVersion);
        }

        int getEmojiStart(@NonNull CharSequence sequence, int offset) {
            return this.mProcessor.getEmojiStart(sequence, offset);
        }

        int getEmojiEnd(@NonNull CharSequence sequence, int offset) {
            return this.mProcessor.getEmojiEnd(sequence, offset);
        }

        CharSequence process(@NonNull CharSequence charSequence, int start, int end, int maxEmojiCount, boolean replaceAll) {
            return this.mProcessor.process(charSequence, start, end, maxEmojiCount, replaceAll);
        }

        void updateEditorInfoAttrs(@NonNull EditorInfo outAttrs) {
            outAttrs.extras.putInt(EmojiCompat.EDITOR_INFO_METAVERSION_KEY, this.mMetadataRepo.getMetadataVersion());
            outAttrs.extras.putBoolean(EmojiCompat.EDITOR_INFO_REPLACE_ALL_KEY, this.mEmojiCompat.mReplaceAll);
        }

        String getAssetSignature() {
            String sha = this.mMetadataRepo.getMetadataList().sourceSha();
            return sha == null ? "" : sha;
        }
    }

    private static final class InitWithExecutor {
        InitCallback mInitCallback;
        Executor mExecutor;

        InitWithExecutor(@NonNull Executor executor, @NonNull InitCallback initCallback) {
            this.mInitCallback = initCallback;
            this.mExecutor = executor;
        }

        void dispatchInitialized() {
            this.mExecutor.execute(() -> this.mInitCallback.onInitialized());
        }

        void dispatchFailed(Throwable throwable) {
            this.mExecutor.execute(() -> this.mInitCallback.onFailed(throwable));
        }
    }

    public static abstract class InitCallback {
        public void onInitialized() {
        }

        public void onFailed(@Nullable Throwable throwable) {
        }
    }

    public static abstract class MetadataRepoLoaderCallback {
        public abstract void onLoaded(@NonNull MetadataRepo var1);

        public abstract void onFailed(@Nullable Throwable var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface CodepointSequenceMatchResult {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface LoadStrategy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface ReplaceStrategy {
    }
}

