/*
 * Decompiled with CFR 0.152.
 */
package androidx.emoji2.text;

import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.method.MetaKeyKeyListener;
import android.view.KeyEvent;
import android.view.inputmethod.InputConnection;
import androidx.annotation.AnyThread;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.emoji2.text.EmojiCompat;
import androidx.emoji2.text.EmojiSpan;
import androidx.emoji2.text.MetadataRepo;
import androidx.emoji2.text.SpannableBuilder;
import androidx.emoji2.text.TypefaceEmojiRasterizer;
import androidx.emoji2.text.UnprecomputeTextOnModificationSpannable;
import java.util.Arrays;
import java.util.Set;

@AnyThread
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
final class EmojiProcessor {
    private static final int ACTION_ADVANCE_BOTH = 1;
    private static final int ACTION_ADVANCE_END = 2;
    private static final int ACTION_FLUSH = 3;
    private static final int MAX_LOOK_AROUND_CHARACTER = 16;
    @NonNull
    private final EmojiCompat.SpanFactory mSpanFactory;
    @NonNull
    private final MetadataRepo mMetadataRepo;
    @NonNull
    private EmojiCompat.GlyphChecker mGlyphChecker;
    private final boolean mUseEmojiAsDefaultStyle;
    @Nullable
    private final int[] mEmojiAsDefaultStyleExceptions;

    EmojiProcessor(@NonNull MetadataRepo metadataRepo, @NonNull EmojiCompat.SpanFactory spanFactory, @NonNull EmojiCompat.GlyphChecker glyphChecker, boolean useEmojiAsDefaultStyle, @Nullable int[] emojiAsDefaultStyleExceptions, @NonNull Set<int[]> emojiExclusions) {
        this.mSpanFactory = spanFactory;
        this.mMetadataRepo = metadataRepo;
        this.mGlyphChecker = glyphChecker;
        this.mUseEmojiAsDefaultStyle = useEmojiAsDefaultStyle;
        this.mEmojiAsDefaultStyleExceptions = emojiAsDefaultStyleExceptions;
        this.initExclusions(emojiExclusions);
    }

    private void initExclusions(@NonNull Set<int[]> emojiExclusions) {
        if (emojiExclusions.isEmpty()) {
            return;
        }
        for (int[] codepoints : emojiExclusions) {
            String emoji = new String(codepoints, 0, codepoints.length);
            MarkExclusionCallback callback = new MarkExclusionCallback(emoji);
            this.process(emoji, 0, emoji.length(), 1, true, callback);
        }
    }

    int getEmojiMatch(@NonNull CharSequence charSequence) {
        return this.getEmojiMatch(charSequence, this.mMetadataRepo.getMetadataVersion());
    }

    int getEmojiMatch(@NonNull CharSequence charSequence, int metadataVersion) {
        TypefaceEmojiRasterizer exactMatch;
        ProcessorSm sm = new ProcessorSm(this.mMetadataRepo.getRootNode(), this.mUseEmojiAsDefaultStyle, this.mEmojiAsDefaultStyleExceptions);
        int end = charSequence.length();
        int currentOffset = 0;
        int potentialSubsequenceMatch = 0;
        int subsequenceMatch = 0;
        while (currentOffset < end) {
            int codePoint = Character.codePointAt(charSequence, currentOffset);
            int action = sm.check(codePoint);
            TypefaceEmojiRasterizer currentNode = sm.getCurrentMetadata();
            switch (action) {
                case 3: {
                    currentNode = sm.getFlushMetadata();
                    if (currentNode.getCompatAdded() > metadataVersion) break;
                    ++subsequenceMatch;
                    break;
                }
                case 1: {
                    currentOffset += Character.charCount(codePoint);
                    potentialSubsequenceMatch = 0;
                    break;
                }
                case 2: {
                    currentOffset += Character.charCount(codePoint);
                }
            }
            if (currentNode == null || currentNode.getCompatAdded() > metadataVersion) continue;
            ++potentialSubsequenceMatch;
        }
        if (subsequenceMatch != 0) {
            return 2;
        }
        if (sm.isInFlushableState() && (exactMatch = sm.getCurrentMetadata()).getCompatAdded() <= metadataVersion) {
            return 1;
        }
        if (potentialSubsequenceMatch == 0) {
            return 0;
        }
        return 2;
    }

    int getEmojiStart(@NonNull CharSequence charSequence, @IntRange(from=0L) int offset) {
        Spanned spanned;
        EmojiSpan[] spans;
        if (offset < 0 || offset >= charSequence.length()) {
            return -1;
        }
        if (charSequence instanceof Spanned && (spans = (EmojiSpan[])(spanned = (Spanned)charSequence).getSpans(offset, offset + 1, EmojiSpan.class)).length > 0) {
            return spanned.getSpanStart((Object)spans[0]);
        }
        int start = Math.max(0, offset - 16);
        int end = Math.min(charSequence.length(), offset + 16);
        return this.process((CharSequence)charSequence, (int)start, (int)end, (int)Integer.MAX_VALUE, (boolean)true, new EmojiProcessLookupCallback((int)offset)).start;
    }

    int getEmojiEnd(@NonNull CharSequence charSequence, @IntRange(from=0L) int offset) {
        Spanned spanned;
        EmojiSpan[] spans;
        if (offset < 0 || offset >= charSequence.length()) {
            return -1;
        }
        if (charSequence instanceof Spanned && (spans = (EmojiSpan[])(spanned = (Spanned)charSequence).getSpans(offset, offset + 1, EmojiSpan.class)).length > 0) {
            return spanned.getSpanEnd((Object)spans[0]);
        }
        int start = Math.max(0, offset - 16);
        int end = Math.min(charSequence.length(), offset + 16);
        return this.process((CharSequence)charSequence, (int)start, (int)end, (int)Integer.MAX_VALUE, (boolean)true, new EmojiProcessLookupCallback((int)offset)).end;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CharSequence process(@NonNull CharSequence charSequence, @IntRange(from=0L) int start, @IntRange(from=0L) int end, @IntRange(from=0L) int maxEmojiCount, boolean replaceAll) {
        boolean isSpannableBuilder = charSequence instanceof SpannableBuilder;
        if (isSpannableBuilder) {
            ((SpannableBuilder)((Object)charSequence)).beginBatchEdit();
        }
        try {
            EmojiSpan[] spans;
            int nextSpanTransition;
            UnprecomputeTextOnModificationSpannable spannable = null;
            if (isSpannableBuilder || charSequence instanceof Spannable) {
                spannable = new UnprecomputeTextOnModificationSpannable((Spannable)charSequence);
            } else if (charSequence instanceof Spanned && (nextSpanTransition = ((Spanned)charSequence).nextSpanTransition(start - 1, end + 1, EmojiSpan.class)) <= end) {
                spannable = new UnprecomputeTextOnModificationSpannable(charSequence);
            }
            if (spannable != null && (spans = spannable.getSpans(start, end, EmojiSpan.class)) != null && spans.length > 0) {
                for (EmojiSpan span : spans) {
                    int spanStart = spannable.getSpanStart((Object)span);
                    int spanEnd = spannable.getSpanEnd((Object)span);
                    if (spanStart != end) {
                        spannable.removeSpan((Object)span);
                    }
                    start = Math.min(spanStart, start);
                    end = Math.max(spanEnd, end);
                }
            }
            if (start == end || start >= charSequence.length()) {
                CharSequence charSequence2 = charSequence;
                return charSequence2;
            }
            if (maxEmojiCount != Integer.MAX_VALUE && spannable != null) {
                maxEmojiCount -= spannable.getSpans(0, spannable.length(), EmojiSpan.class).length;
            }
            if ((spannable = this.process(charSequence, start, end, maxEmojiCount, replaceAll, new EmojiProcessAddSpanCallback(spannable, this.mSpanFactory))) != null) {
                Spannable spannable2 = spannable.getUnwrappedSpannable();
                return spannable2;
            }
            CharSequence charSequence3 = charSequence;
            return charSequence3;
        }
        finally {
            if (isSpannableBuilder) {
                ((SpannableBuilder)((Object)charSequence)).endBatchEdit();
            }
        }
    }

    private <T> T process(@NonNull CharSequence charSequence, @IntRange(from=0L) int start, @IntRange(from=0L) int end, @IntRange(from=0L) int maxEmojiCount, boolean processAll, EmojiProcessCallback<T> emojiProcessCallback) {
        int addedCount = 0;
        ProcessorSm sm = new ProcessorSm(this.mMetadataRepo.getRootNode(), this.mUseEmojiAsDefaultStyle, this.mEmojiAsDefaultStyleExceptions);
        int currentOffset = start;
        int codePoint = Character.codePointAt(charSequence, currentOffset);
        boolean keepProcessing = true;
        while (currentOffset < end && addedCount < maxEmojiCount && keepProcessing) {
            int action = sm.check(codePoint);
            switch (action) {
                case 1: {
                    start += Character.charCount(Character.codePointAt(charSequence, start));
                    currentOffset = start;
                    if (currentOffset >= end) break;
                    codePoint = Character.codePointAt(charSequence, currentOffset);
                    break;
                }
                case 2: {
                    if ((currentOffset += Character.charCount(codePoint)) >= end) break;
                    codePoint = Character.codePointAt(charSequence, currentOffset);
                    break;
                }
                case 3: {
                    if (processAll || !this.hasGlyph(charSequence, start, currentOffset, sm.getFlushMetadata())) {
                        keepProcessing = emojiProcessCallback.handleEmoji(charSequence, start, currentOffset, sm.getFlushMetadata());
                        ++addedCount;
                    }
                    start = currentOffset;
                }
            }
        }
        if (sm.isInFlushableState() && addedCount < maxEmojiCount && keepProcessing && (processAll || !this.hasGlyph(charSequence, start, currentOffset, sm.getCurrentMetadata()))) {
            emojiProcessCallback.handleEmoji(charSequence, start, currentOffset, sm.getCurrentMetadata());
            ++addedCount;
        }
        return emojiProcessCallback.getResult();
    }

    static boolean handleOnKeyDown(@NonNull Editable editable, int keyCode, @NonNull KeyEvent event) {
        boolean handled;
        switch (keyCode) {
            case 67: {
                handled = EmojiProcessor.delete(editable, event, false);
                break;
            }
            case 112: {
                handled = EmojiProcessor.delete(editable, event, true);
                break;
            }
            default: {
                handled = false;
            }
        }
        if (handled) {
            MetaKeyKeyListener.adjustMetaAfterKeypress((Spannable)editable);
            return true;
        }
        return false;
    }

    private static boolean delete(@NonNull Editable content, @NonNull KeyEvent event, boolean forwardDelete) {
        int end;
        if (EmojiProcessor.hasModifiers(event)) {
            return false;
        }
        int start = Selection.getSelectionStart((CharSequence)content);
        if (EmojiProcessor.hasInvalidSelection(start, end = Selection.getSelectionEnd((CharSequence)content))) {
            return false;
        }
        EmojiSpan[] spans = (EmojiSpan[])content.getSpans(start, end, EmojiSpan.class);
        if (spans != null && spans.length > 0) {
            for (EmojiSpan span : spans) {
                int spanStart = content.getSpanStart((Object)span);
                int spanEnd = content.getSpanEnd((Object)span);
                if (!(forwardDelete && spanStart == start || !forwardDelete && spanEnd == start) && (start <= spanStart || start >= spanEnd)) continue;
                content.delete(spanStart, spanEnd);
                return true;
            }
        }
        return false;
    }

    static boolean handleDeleteSurroundingText(@NonNull InputConnection inputConnection, @NonNull Editable editable, @IntRange(from=0L) int beforeLength, @IntRange(from=0L) int afterLength, boolean inCodePoints) {
        EmojiSpan[] spans;
        int end;
        int start;
        int selectionEnd;
        if (editable == null || inputConnection == null) {
            return false;
        }
        if (beforeLength < 0 || afterLength < 0) {
            return false;
        }
        int selectionStart = Selection.getSelectionStart((CharSequence)editable);
        if (EmojiProcessor.hasInvalidSelection(selectionStart, selectionEnd = Selection.getSelectionEnd((CharSequence)editable))) {
            return false;
        }
        if (inCodePoints) {
            start = CodepointIndexFinder.findIndexBackward((CharSequence)editable, selectionStart, Math.max(beforeLength, 0));
            end = CodepointIndexFinder.findIndexForward((CharSequence)editable, selectionEnd, Math.max(afterLength, 0));
            if (start == -1 || end == -1) {
                return false;
            }
        } else {
            start = Math.max(selectionStart - beforeLength, 0);
            end = Math.min(selectionEnd + afterLength, editable.length());
        }
        if ((spans = (EmojiSpan[])editable.getSpans(start, end, EmojiSpan.class)) != null && spans.length > 0) {
            for (EmojiSpan span : spans) {
                int spanStart = editable.getSpanStart((Object)span);
                int spanEnd = editable.getSpanEnd((Object)span);
                start = Math.min(spanStart, start);
                end = Math.max(spanEnd, end);
            }
            start = Math.max(start, 0);
            end = Math.min(end, editable.length());
            inputConnection.beginBatchEdit();
            editable.delete(start, end);
            inputConnection.endBatchEdit();
            return true;
        }
        return false;
    }

    private static boolean hasInvalidSelection(int start, int end) {
        return start == -1 || end == -1 || start != end;
    }

    private static boolean hasModifiers(@NonNull KeyEvent event) {
        return !KeyEvent.metaStateHasNoModifiers((int)event.getMetaState());
    }

    private boolean hasGlyph(CharSequence charSequence, int start, int end, TypefaceEmojiRasterizer rasterizer) {
        if (rasterizer.getHasGlyph() == 0) {
            boolean hasGlyph = this.mGlyphChecker.hasGlyph(charSequence, start, end, rasterizer.getSdkAdded());
            rasterizer.setHasGlyph(hasGlyph);
        }
        return rasterizer.getHasGlyph() == 2;
    }

    private static final class CodepointIndexFinder {
        private static final int INVALID_INDEX = -1;

        private CodepointIndexFinder() {
        }

        static int findIndexBackward(CharSequence cs, int from, int numCodePoints) {
            int currentIndex = from;
            boolean waitingHighSurrogate = false;
            int length = cs.length();
            if (currentIndex < 0 || length < currentIndex) {
                return -1;
            }
            if (numCodePoints < 0) {
                return -1;
            }
            int remainingCodePoints = numCodePoints;
            while (remainingCodePoints != 0) {
                if (--currentIndex < 0) {
                    if (waitingHighSurrogate) {
                        return -1;
                    }
                    return 0;
                }
                char c = cs.charAt(currentIndex);
                if (waitingHighSurrogate) {
                    if (!Character.isHighSurrogate(c)) {
                        return -1;
                    }
                    waitingHighSurrogate = false;
                    --remainingCodePoints;
                    continue;
                }
                if (!Character.isSurrogate(c)) {
                    --remainingCodePoints;
                    continue;
                }
                if (Character.isHighSurrogate(c)) {
                    return -1;
                }
                waitingHighSurrogate = true;
            }
            return currentIndex;
        }

        static int findIndexForward(CharSequence cs, int from, int numCodePoints) {
            int currentIndex = from;
            boolean waitingLowSurrogate = false;
            int length = cs.length();
            if (currentIndex < 0 || length < currentIndex) {
                return -1;
            }
            if (numCodePoints < 0) {
                return -1;
            }
            int remainingCodePoints = numCodePoints;
            while (remainingCodePoints != 0) {
                if (currentIndex >= length) {
                    if (waitingLowSurrogate) {
                        return -1;
                    }
                    return length;
                }
                char c = cs.charAt(currentIndex);
                if (waitingLowSurrogate) {
                    if (!Character.isLowSurrogate(c)) {
                        return -1;
                    }
                    --remainingCodePoints;
                    waitingLowSurrogate = false;
                    ++currentIndex;
                    continue;
                }
                if (!Character.isSurrogate(c)) {
                    --remainingCodePoints;
                    ++currentIndex;
                    continue;
                }
                if (Character.isLowSurrogate(c)) {
                    return -1;
                }
                waitingLowSurrogate = true;
                ++currentIndex;
            }
            return currentIndex;
        }
    }

    private static class MarkExclusionCallback
    implements EmojiProcessCallback<MarkExclusionCallback> {
        private final String mExclusion;

        MarkExclusionCallback(String emoji) {
            this.mExclusion = emoji;
        }

        @Override
        public boolean handleEmoji(@NonNull CharSequence charSequence, int start, int end, TypefaceEmojiRasterizer metadata) {
            if (TextUtils.equals((CharSequence)charSequence.subSequence(start, end), (CharSequence)this.mExclusion)) {
                metadata.setExclusion(true);
                return false;
            }
            return true;
        }

        @Override
        public MarkExclusionCallback getResult() {
            return this;
        }
    }

    private static interface EmojiProcessCallback<T> {
        public boolean handleEmoji(@NonNull CharSequence var1, int var2, int var3, TypefaceEmojiRasterizer var4);

        public T getResult();
    }

    static final class ProcessorSm {
        private static final int STATE_DEFAULT = 1;
        private static final int STATE_WALKING = 2;
        private int mState = 1;
        private final MetadataRepo.Node mRootNode;
        private MetadataRepo.Node mCurrentNode;
        private MetadataRepo.Node mFlushNode;
        private int mLastCodepoint;
        private int mCurrentDepth;
        private final boolean mUseEmojiAsDefaultStyle;
        private final int[] mEmojiAsDefaultStyleExceptions;

        ProcessorSm(MetadataRepo.Node rootNode, boolean useEmojiAsDefaultStyle, int[] emojiAsDefaultStyleExceptions) {
            this.mRootNode = rootNode;
            this.mCurrentNode = rootNode;
            this.mUseEmojiAsDefaultStyle = useEmojiAsDefaultStyle;
            this.mEmojiAsDefaultStyleExceptions = emojiAsDefaultStyleExceptions;
        }

        int check(int codePoint) {
            int action;
            MetadataRepo.Node node = this.mCurrentNode.get(codePoint);
            switch (this.mState) {
                case 2: {
                    if (node != null) {
                        this.mCurrentNode = node;
                        ++this.mCurrentDepth;
                        action = 2;
                        break;
                    }
                    if (ProcessorSm.isTextStyle(codePoint)) {
                        action = this.reset();
                        break;
                    }
                    if (ProcessorSm.isEmojiStyle(codePoint)) {
                        action = 2;
                        break;
                    }
                    if (this.mCurrentNode.getData() != null) {
                        if (this.mCurrentDepth == 1) {
                            if (this.shouldUseEmojiPresentationStyleForSingleCodepoint()) {
                                this.mFlushNode = this.mCurrentNode;
                                action = 3;
                                this.reset();
                                break;
                            }
                            action = this.reset();
                            break;
                        }
                        this.mFlushNode = this.mCurrentNode;
                        action = 3;
                        this.reset();
                        break;
                    }
                    action = this.reset();
                    break;
                }
                default: {
                    if (node == null) {
                        action = this.reset();
                        break;
                    }
                    this.mState = 2;
                    this.mCurrentNode = node;
                    this.mCurrentDepth = 1;
                    action = 2;
                }
            }
            this.mLastCodepoint = codePoint;
            return action;
        }

        private int reset() {
            this.mState = 1;
            this.mCurrentNode = this.mRootNode;
            this.mCurrentDepth = 0;
            return 1;
        }

        TypefaceEmojiRasterizer getFlushMetadata() {
            return this.mFlushNode.getData();
        }

        TypefaceEmojiRasterizer getCurrentMetadata() {
            return this.mCurrentNode.getData();
        }

        boolean isInFlushableState() {
            return this.mState == 2 && this.mCurrentNode.getData() != null && (this.mCurrentDepth > 1 || this.shouldUseEmojiPresentationStyleForSingleCodepoint());
        }

        private boolean shouldUseEmojiPresentationStyleForSingleCodepoint() {
            if (this.mCurrentNode.getData().isDefaultEmoji()) {
                return true;
            }
            if (ProcessorSm.isEmojiStyle(this.mLastCodepoint)) {
                return true;
            }
            if (this.mUseEmojiAsDefaultStyle) {
                if (this.mEmojiAsDefaultStyleExceptions == null) {
                    return true;
                }
                int codepoint = this.mCurrentNode.getData().getCodepointAt(0);
                int index = Arrays.binarySearch(this.mEmojiAsDefaultStyleExceptions, codepoint);
                if (index < 0) {
                    return true;
                }
            }
            return false;
        }

        private static boolean isEmojiStyle(int codePoint) {
            return codePoint == 65039;
        }

        private static boolean isTextStyle(int codePoint) {
            return codePoint == 65038;
        }
    }

    private static class EmojiProcessLookupCallback
    implements EmojiProcessCallback<EmojiProcessLookupCallback> {
        private final int mOffset;
        public int start = -1;
        public int end = -1;

        EmojiProcessLookupCallback(int offset) {
            this.mOffset = offset;
        }

        @Override
        public boolean handleEmoji(@NonNull CharSequence charSequence, int start, int end, TypefaceEmojiRasterizer metadata) {
            if (start <= this.mOffset && this.mOffset < end) {
                this.start = start;
                this.end = end;
                return false;
            }
            return end <= this.mOffset;
        }

        @Override
        public EmojiProcessLookupCallback getResult() {
            return this;
        }
    }

    private static class EmojiProcessAddSpanCallback
    implements EmojiProcessCallback<UnprecomputeTextOnModificationSpannable> {
        @Nullable
        public UnprecomputeTextOnModificationSpannable spannable;
        private final EmojiCompat.SpanFactory mSpanFactory;

        EmojiProcessAddSpanCallback(@Nullable UnprecomputeTextOnModificationSpannable spannable, EmojiCompat.SpanFactory spanFactory) {
            this.spannable = spannable;
            this.mSpanFactory = spanFactory;
        }

        @Override
        public boolean handleEmoji(@NonNull CharSequence charSequence, int start, int end, TypefaceEmojiRasterizer metadata) {
            if (metadata.isPreferredSystemRender()) {
                return true;
            }
            if (this.spannable == null) {
                this.spannable = new UnprecomputeTextOnModificationSpannable((Spannable)(charSequence instanceof Spannable ? (Spannable)charSequence : new SpannableString(charSequence)));
            }
            EmojiSpan span = this.mSpanFactory.createSpan(metadata);
            this.spannable.setSpan((Object)span, start, end, 33);
            return true;
        }

        @Override
        public UnprecomputeTextOnModificationSpannable getResult() {
            return this.spannable;
        }
    }
}

