/*
 * Decompiled with CFR 0.152.
 */
package androidx.emoji2.text;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import androidx.annotation.AnyThread;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.emoji2.text.MetadataRepo;
import androidx.emoji2.text.flatbuffer.MetadataItem;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@AnyThread
public class TypefaceEmojiRasterizer {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    static final int HAS_GLYPH_UNKNOWN = 0;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    static final int HAS_GLYPH_ABSENT = 1;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    static final int HAS_GLYPH_EXISTS = 2;
    private static final ThreadLocal<MetadataItem> sMetadataItem = new ThreadLocal();
    private final int mIndex;
    @NonNull
    private final MetadataRepo mMetadataRepo;
    private volatile int mCache = 0;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    TypefaceEmojiRasterizer(@NonNull MetadataRepo metadataRepo, @IntRange(from=0L) int index) {
        this.mMetadataRepo = metadataRepo;
        this.mIndex = index;
    }

    public void draw(@NonNull Canvas canvas, float x, float y, @NonNull Paint paint) {
        Typeface typeface = this.mMetadataRepo.getTypeface();
        Typeface oldTypeface = paint.getTypeface();
        paint.setTypeface(typeface);
        int charArrayStartIndex = this.mIndex * 2;
        canvas.drawText(this.mMetadataRepo.getEmojiCharArray(), charArrayStartIndex, 2, x, y, paint);
        paint.setTypeface(oldTypeface);
    }

    @NonNull
    public Typeface getTypeface() {
        return this.mMetadataRepo.getTypeface();
    }

    private MetadataItem getMetadataItem() {
        MetadataItem result = sMetadataItem.get();
        if (result == null) {
            result = new MetadataItem();
            sMetadataItem.set(result);
        }
        this.mMetadataRepo.getMetadataList().list(result, this.mIndex);
        return result;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public int getId() {
        return this.getMetadataItem().id();
    }

    public int getWidth() {
        return this.getMetadataItem().width();
    }

    public int getHeight() {
        return this.getMetadataItem().height();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public short getCompatAdded() {
        return this.getMetadataItem().compatAdded();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public short getSdkAdded() {
        return this.getMetadataItem().sdkAdded();
    }

    @SuppressLint(value={"KotlinPropertyAccess"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public int getHasGlyph() {
        return this.mCache & 3;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @VisibleForTesting
    public void resetHasGlyphCache() {
        boolean willExclude = this.isPreferredSystemRender();
        this.mCache = willExclude ? 4 : 0;
    }

    @SuppressLint(value={"KotlinPropertyAccess"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void setHasGlyph(boolean hasGlyph) {
        int newValue = this.mCache & 4;
        newValue = hasGlyph ? (newValue |= 2) : (newValue |= 1);
        this.mCache = newValue;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void setExclusion(boolean exclude) {
        int hasGlyphBits = this.getHasGlyph();
        this.mCache = exclude ? hasGlyphBits | 4 : hasGlyphBits;
    }

    public boolean isPreferredSystemRender() {
        return (this.mCache & 4) > 0;
    }

    public boolean isDefaultEmoji() {
        return this.getMetadataItem().emojiStyle();
    }

    public int getCodepointAt(int index) {
        return this.getMetadataItem().codepoints(index);
    }

    public int getCodepointsLength() {
        return this.getMetadataItem().codepointsLength();
    }

    @NonNull
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append(", id:");
        builder.append(Integer.toHexString(this.getId()));
        builder.append(", codepoints:");
        int codepointsLength = this.getCodepointsLength();
        for (int i = 0; i < codepointsLength; ++i) {
            builder.append(Integer.toHexString(this.getCodepointAt(i)));
            builder.append(" ");
        }
        return builder.toString();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface HasGlyph {
    }
}

