/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.RectF;
import android.os.Build;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import android.text.method.TransformationMethod;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.R;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.core.view.ViewCompat;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;

class AppCompatTextViewAutoSizeHelper {
    private static final String TAG = "ACTVAutoSizeHelper";
    private static final RectF TEMP_RECTF = new RectF();
    private static final int DEFAULT_AUTO_SIZE_MIN_TEXT_SIZE_IN_SP = 12;
    private static final int DEFAULT_AUTO_SIZE_MAX_TEXT_SIZE_IN_SP = 112;
    private static final int DEFAULT_AUTO_SIZE_GRANULARITY_IN_PX = 1;
    @SuppressLint(value={"BanConcurrentHashMap"})
    private static ConcurrentHashMap<String, Method> sTextViewMethodByNameCache = new ConcurrentHashMap();
    static final float UNSET_AUTO_SIZE_UNIFORM_CONFIGURATION_VALUE = -1.0f;
    private static final int VERY_WIDE = 0x100000;
    private int mAutoSizeTextType = 0;
    private boolean mNeedsAutoSizeText = false;
    private float mAutoSizeStepGranularityInPx = -1.0f;
    private float mAutoSizeMinTextSizeInPx = -1.0f;
    private float mAutoSizeMaxTextSizeInPx = -1.0f;
    private int[] mAutoSizeTextSizesInPx = new int[0];
    private boolean mHasPresetAutoSizeValues = false;
    private TextPaint mTempTextPaint;
    @NonNull
    private final TextView mTextView;
    private final Context mContext;
    private final Impl mImpl;

    AppCompatTextViewAutoSizeHelper(@NonNull TextView textView) {
        this.mTextView = textView;
        this.mContext = this.mTextView.getContext();
        this.mImpl = Build.VERSION.SDK_INT >= 29 ? new Impl29() : (Build.VERSION.SDK_INT >= 23 ? new Impl23() : new Impl());
    }

    void loadFromAttributes(@Nullable AttributeSet attrs, int defStyleAttr) {
        int autoSizeStepSizeArrayResId;
        float autoSizeMinTextSizeInPx = -1.0f;
        float autoSizeMaxTextSizeInPx = -1.0f;
        float autoSizeStepGranularityInPx = -1.0f;
        TypedArray a = this.mContext.obtainStyledAttributes(attrs, R.styleable.AppCompatTextView, defStyleAttr, 0);
        ViewCompat.saveAttributeDataForStyleable((View)this.mTextView, (Context)this.mTextView.getContext(), (int[])R.styleable.AppCompatTextView, (AttributeSet)attrs, (TypedArray)a, (int)defStyleAttr, (int)0);
        if (a.hasValue(R.styleable.AppCompatTextView_autoSizeTextType)) {
            this.mAutoSizeTextType = a.getInt(R.styleable.AppCompatTextView_autoSizeTextType, 0);
        }
        if (a.hasValue(R.styleable.AppCompatTextView_autoSizeStepGranularity)) {
            autoSizeStepGranularityInPx = a.getDimension(R.styleable.AppCompatTextView_autoSizeStepGranularity, -1.0f);
        }
        if (a.hasValue(R.styleable.AppCompatTextView_autoSizeMinTextSize)) {
            autoSizeMinTextSizeInPx = a.getDimension(R.styleable.AppCompatTextView_autoSizeMinTextSize, -1.0f);
        }
        if (a.hasValue(R.styleable.AppCompatTextView_autoSizeMaxTextSize)) {
            autoSizeMaxTextSizeInPx = a.getDimension(R.styleable.AppCompatTextView_autoSizeMaxTextSize, -1.0f);
        }
        if (a.hasValue(R.styleable.AppCompatTextView_autoSizePresetSizes) && (autoSizeStepSizeArrayResId = a.getResourceId(R.styleable.AppCompatTextView_autoSizePresetSizes, 0)) > 0) {
            TypedArray autoSizePreDefTextSizes = a.getResources().obtainTypedArray(autoSizeStepSizeArrayResId);
            this.setupAutoSizeUniformPresetSizes(autoSizePreDefTextSizes);
            autoSizePreDefTextSizes.recycle();
        }
        a.recycle();
        if (this.supportsAutoSizeText()) {
            if (this.mAutoSizeTextType == 1) {
                if (!this.mHasPresetAutoSizeValues) {
                    DisplayMetrics displayMetrics = this.mContext.getResources().getDisplayMetrics();
                    if (autoSizeMinTextSizeInPx == -1.0f) {
                        autoSizeMinTextSizeInPx = TypedValue.applyDimension((int)2, (float)12.0f, (DisplayMetrics)displayMetrics);
                    }
                    if (autoSizeMaxTextSizeInPx == -1.0f) {
                        autoSizeMaxTextSizeInPx = TypedValue.applyDimension((int)2, (float)112.0f, (DisplayMetrics)displayMetrics);
                    }
                    if (autoSizeStepGranularityInPx == -1.0f) {
                        autoSizeStepGranularityInPx = 1.0f;
                    }
                    this.validateAndSetAutoSizeTextTypeUniformConfiguration(autoSizeMinTextSizeInPx, autoSizeMaxTextSizeInPx, autoSizeStepGranularityInPx);
                }
                this.setupAutoSizeText();
            }
        } else {
            this.mAutoSizeTextType = 0;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    void setAutoSizeTextTypeWithDefaults(int autoSizeTextType) {
        if (this.supportsAutoSizeText()) {
            switch (autoSizeTextType) {
                case 0: {
                    this.clearAutoSizeConfiguration();
                    break;
                }
                case 1: {
                    DisplayMetrics displayMetrics = this.mContext.getResources().getDisplayMetrics();
                    float autoSizeMinTextSizeInPx = TypedValue.applyDimension((int)2, (float)12.0f, (DisplayMetrics)displayMetrics);
                    float autoSizeMaxTextSizeInPx = TypedValue.applyDimension((int)2, (float)112.0f, (DisplayMetrics)displayMetrics);
                    this.validateAndSetAutoSizeTextTypeUniformConfiguration(autoSizeMinTextSizeInPx, autoSizeMaxTextSizeInPx, 1.0f);
                    if (!this.setupAutoSizeText()) break;
                    this.autoSizeText();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown auto-size text type: " + autoSizeTextType);
                }
            }
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    void setAutoSizeTextTypeUniformWithConfiguration(int autoSizeMinTextSize, int autoSizeMaxTextSize, int autoSizeStepGranularity, int unit) throws IllegalArgumentException {
        if (this.supportsAutoSizeText()) {
            DisplayMetrics displayMetrics = this.mContext.getResources().getDisplayMetrics();
            float autoSizeMinTextSizeInPx = TypedValue.applyDimension((int)unit, (float)autoSizeMinTextSize, (DisplayMetrics)displayMetrics);
            float autoSizeMaxTextSizeInPx = TypedValue.applyDimension((int)unit, (float)autoSizeMaxTextSize, (DisplayMetrics)displayMetrics);
            float autoSizeStepGranularityInPx = TypedValue.applyDimension((int)unit, (float)autoSizeStepGranularity, (DisplayMetrics)displayMetrics);
            this.validateAndSetAutoSizeTextTypeUniformConfiguration(autoSizeMinTextSizeInPx, autoSizeMaxTextSizeInPx, autoSizeStepGranularityInPx);
            if (this.setupAutoSizeText()) {
                this.autoSizeText();
            }
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    void setAutoSizeTextTypeUniformWithPresetSizes(@NonNull int[] presetSizes, int unit) throws IllegalArgumentException {
        if (this.supportsAutoSizeText()) {
            int presetSizesLength = presetSizes.length;
            if (presetSizesLength > 0) {
                int[] presetSizesInPx = new int[presetSizesLength];
                if (unit == 0) {
                    presetSizesInPx = Arrays.copyOf(presetSizes, presetSizesLength);
                } else {
                    DisplayMetrics displayMetrics = this.mContext.getResources().getDisplayMetrics();
                    for (int i = 0; i < presetSizesLength; ++i) {
                        presetSizesInPx[i] = Math.round(TypedValue.applyDimension((int)unit, (float)presetSizes[i], (DisplayMetrics)displayMetrics));
                    }
                }
                this.mAutoSizeTextSizesInPx = this.cleanupAutoSizePresetSizes(presetSizesInPx);
                if (!this.setupAutoSizeUniformPresetSizesConfiguration()) {
                    throw new IllegalArgumentException("None of the preset sizes is valid: " + Arrays.toString(presetSizes));
                }
            } else {
                this.mHasPresetAutoSizeValues = false;
            }
            if (this.setupAutoSizeText()) {
                this.autoSizeText();
            }
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    int getAutoSizeTextType() {
        return this.mAutoSizeTextType;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    int getAutoSizeStepGranularity() {
        return Math.round(this.mAutoSizeStepGranularityInPx);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    int getAutoSizeMinTextSize() {
        return Math.round(this.mAutoSizeMinTextSizeInPx);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    int getAutoSizeMaxTextSize() {
        return Math.round(this.mAutoSizeMaxTextSizeInPx);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    int[] getAutoSizeTextAvailableSizes() {
        return this.mAutoSizeTextSizesInPx;
    }

    private void setupAutoSizeUniformPresetSizes(TypedArray textSizes) {
        int textSizesLength = textSizes.length();
        int[] parsedSizes = new int[textSizesLength];
        if (textSizesLength > 0) {
            for (int i = 0; i < textSizesLength; ++i) {
                parsedSizes[i] = textSizes.getDimensionPixelSize(i, -1);
            }
            this.mAutoSizeTextSizesInPx = this.cleanupAutoSizePresetSizes(parsedSizes);
            this.setupAutoSizeUniformPresetSizesConfiguration();
        }
    }

    private boolean setupAutoSizeUniformPresetSizesConfiguration() {
        int sizesLength = this.mAutoSizeTextSizesInPx.length;
        boolean bl = this.mHasPresetAutoSizeValues = sizesLength > 0;
        if (this.mHasPresetAutoSizeValues) {
            this.mAutoSizeTextType = 1;
            this.mAutoSizeMinTextSizeInPx = this.mAutoSizeTextSizesInPx[0];
            this.mAutoSizeMaxTextSizeInPx = this.mAutoSizeTextSizesInPx[sizesLength - 1];
            this.mAutoSizeStepGranularityInPx = -1.0f;
        }
        return this.mHasPresetAutoSizeValues;
    }

    private int[] cleanupAutoSizePresetSizes(int[] presetValues) {
        int presetValuesLength = presetValues.length;
        if (presetValuesLength == 0) {
            return presetValues;
        }
        Arrays.sort(presetValues);
        ArrayList<Integer> uniqueValidSizes = new ArrayList<Integer>();
        for (int i = 0; i < presetValuesLength; ++i) {
            int currentPresetValue = presetValues[i];
            if (currentPresetValue <= 0 || Collections.binarySearch(uniqueValidSizes, currentPresetValue) >= 0) continue;
            uniqueValidSizes.add(currentPresetValue);
        }
        if (presetValuesLength == uniqueValidSizes.size()) {
            return presetValues;
        }
        int uniqueValidSizesLength = uniqueValidSizes.size();
        int[] cleanedUpSizes = new int[uniqueValidSizesLength];
        for (int i = 0; i < uniqueValidSizesLength; ++i) {
            cleanedUpSizes[i] = (Integer)uniqueValidSizes.get(i);
        }
        return cleanedUpSizes;
    }

    private void validateAndSetAutoSizeTextTypeUniformConfiguration(float autoSizeMinTextSizeInPx, float autoSizeMaxTextSizeInPx, float autoSizeStepGranularityInPx) throws IllegalArgumentException {
        if (autoSizeMinTextSizeInPx <= 0.0f) {
            throw new IllegalArgumentException("Minimum auto-size text size (" + autoSizeMinTextSizeInPx + "px) is less or equal to (0px)");
        }
        if (autoSizeMaxTextSizeInPx <= autoSizeMinTextSizeInPx) {
            throw new IllegalArgumentException("Maximum auto-size text size (" + autoSizeMaxTextSizeInPx + "px) is less or equal to minimum auto-size text size (" + autoSizeMinTextSizeInPx + "px)");
        }
        if (autoSizeStepGranularityInPx <= 0.0f) {
            throw new IllegalArgumentException("The auto-size step granularity (" + autoSizeStepGranularityInPx + "px) is less or equal to (0px)");
        }
        this.mAutoSizeTextType = 1;
        this.mAutoSizeMinTextSizeInPx = autoSizeMinTextSizeInPx;
        this.mAutoSizeMaxTextSizeInPx = autoSizeMaxTextSizeInPx;
        this.mAutoSizeStepGranularityInPx = autoSizeStepGranularityInPx;
        this.mHasPresetAutoSizeValues = false;
    }

    private boolean setupAutoSizeText() {
        if (this.supportsAutoSizeText() && this.mAutoSizeTextType == 1) {
            if (!this.mHasPresetAutoSizeValues || this.mAutoSizeTextSizesInPx.length == 0) {
                int autoSizeValuesLength = (int)Math.floor((this.mAutoSizeMaxTextSizeInPx - this.mAutoSizeMinTextSizeInPx) / this.mAutoSizeStepGranularityInPx) + 1;
                int[] autoSizeTextSizesInPx = new int[autoSizeValuesLength];
                for (int i = 0; i < autoSizeValuesLength; ++i) {
                    autoSizeTextSizesInPx[i] = Math.round(this.mAutoSizeMinTextSizeInPx + (float)i * this.mAutoSizeStepGranularityInPx);
                }
                this.mAutoSizeTextSizesInPx = this.cleanupAutoSizePresetSizes(autoSizeTextSizesInPx);
            }
            this.mNeedsAutoSizeText = true;
        } else {
            this.mNeedsAutoSizeText = false;
        }
        return this.mNeedsAutoSizeText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    void autoSizeText() {
        if (!this.isAutoSizeEnabled()) {
            return;
        }
        if (this.mNeedsAutoSizeText) {
            if (this.mTextView.getMeasuredHeight() <= 0 || this.mTextView.getMeasuredWidth() <= 0) {
                return;
            }
            boolean horizontallyScrolling = this.mImpl.isHorizontallyScrollable(this.mTextView);
            int availableWidth = horizontallyScrolling ? 0x100000 : this.mTextView.getMeasuredWidth() - this.mTextView.getTotalPaddingLeft() - this.mTextView.getTotalPaddingRight();
            int availableHeight = this.mTextView.getHeight() - this.mTextView.getCompoundPaddingBottom() - this.mTextView.getCompoundPaddingTop();
            if (availableWidth <= 0 || availableHeight <= 0) {
                return;
            }
            RectF rectF = TEMP_RECTF;
            synchronized (rectF) {
                TEMP_RECTF.setEmpty();
                AppCompatTextViewAutoSizeHelper.TEMP_RECTF.right = availableWidth;
                AppCompatTextViewAutoSizeHelper.TEMP_RECTF.bottom = availableHeight;
                float optimalTextSize = this.findLargestTextSizeWhichFits(TEMP_RECTF);
                if (optimalTextSize != this.mTextView.getTextSize()) {
                    this.setTextSizeInternal(0, optimalTextSize);
                }
            }
        }
        this.mNeedsAutoSizeText = true;
    }

    private void clearAutoSizeConfiguration() {
        this.mAutoSizeTextType = 0;
        this.mAutoSizeMinTextSizeInPx = -1.0f;
        this.mAutoSizeMaxTextSizeInPx = -1.0f;
        this.mAutoSizeStepGranularityInPx = -1.0f;
        this.mAutoSizeTextSizesInPx = new int[0];
        this.mNeedsAutoSizeText = false;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    void setTextSizeInternal(int unit, float size) {
        Resources res = this.mContext == null ? Resources.getSystem() : this.mContext.getResources();
        this.setRawTextSize(TypedValue.applyDimension((int)unit, (float)size, (DisplayMetrics)res.getDisplayMetrics()));
    }

    @SuppressLint(value={"BanUncheckedReflection"})
    private void setRawTextSize(float size) {
        if (size != this.mTextView.getPaint().getTextSize()) {
            this.mTextView.getPaint().setTextSize(size);
            boolean isInLayout = this.mTextView.isInLayout();
            if (this.mTextView.getLayout() != null) {
                this.mNeedsAutoSizeText = false;
                String methodName = "nullLayouts";
                try {
                    Method method = AppCompatTextViewAutoSizeHelper.getTextViewMethod("nullLayouts");
                    if (method != null) {
                        method.invoke((Object)this.mTextView, new Object[0]);
                    }
                }
                catch (Exception ex) {
                    Log.w((String)TAG, (String)"Failed to invoke TextView#nullLayouts() method", (Throwable)ex);
                }
                if (!isInLayout) {
                    this.mTextView.requestLayout();
                } else {
                    this.mTextView.forceLayout();
                }
                this.mTextView.invalidate();
            }
        }
    }

    private int findLargestTextSizeWhichFits(RectF availableSpace) {
        int sizesCount = this.mAutoSizeTextSizesInPx.length;
        if (sizesCount == 0) {
            throw new IllegalStateException("No available text sizes to choose from.");
        }
        int bestSizeIndex = 0;
        int lowIndex = bestSizeIndex + 1;
        int highIndex = sizesCount - 1;
        while (lowIndex <= highIndex) {
            int sizeToTryIndex = (lowIndex + highIndex) / 2;
            if (this.suggestedSizeFitsInSpace(this.mAutoSizeTextSizesInPx[sizeToTryIndex], availableSpace)) {
                bestSizeIndex = lowIndex;
                lowIndex = sizeToTryIndex + 1;
                continue;
            }
            bestSizeIndex = highIndex = sizeToTryIndex - 1;
        }
        return this.mAutoSizeTextSizesInPx[bestSizeIndex];
    }

    @VisibleForTesting
    void initTempTextPaint(int suggestedSizeInPx) {
        if (this.mTempTextPaint == null) {
            this.mTempTextPaint = new TextPaint();
        } else {
            this.mTempTextPaint.reset();
        }
        this.mTempTextPaint.set(this.mTextView.getPaint());
        this.mTempTextPaint.setTextSize((float)suggestedSizeInPx);
    }

    @VisibleForTesting
    @NonNull
    StaticLayout createLayout(@NonNull CharSequence text, @NonNull Layout.Alignment alignment, int availableWidth, int maxLines) {
        if (Build.VERSION.SDK_INT >= 23) {
            return Api23Impl.createStaticLayoutForMeasuring(text, alignment, availableWidth, maxLines, this.mTextView, this.mTempTextPaint, this.mImpl);
        }
        float lineSpacingMultiplier = this.mTextView.getLineSpacingMultiplier();
        float lineSpacingAdd = this.mTextView.getLineSpacingExtra();
        boolean includePad = this.mTextView.getIncludeFontPadding();
        return new StaticLayout(text, this.mTempTextPaint, availableWidth, alignment, lineSpacingMultiplier, lineSpacingAdd, includePad);
    }

    private boolean suggestedSizeFitsInSpace(int suggestedSizeInPx, RectF availableSpace) {
        CharSequence transformedText;
        CharSequence text = this.mTextView.getText();
        TransformationMethod transformationMethod = this.mTextView.getTransformationMethod();
        if (transformationMethod != null && (transformedText = transformationMethod.getTransformation(text, (View)this.mTextView)) != null) {
            text = transformedText;
        }
        int maxLines = this.mTextView.getMaxLines();
        this.initTempTextPaint(suggestedSizeInPx);
        Layout.Alignment alignment = AppCompatTextViewAutoSizeHelper.invokeAndReturnWithDefault(this.mTextView, "getLayoutAlignment", Layout.Alignment.ALIGN_NORMAL);
        StaticLayout layout2 = this.createLayout(text, alignment, Math.round(availableSpace.right), maxLines);
        if (maxLines != -1 && (layout2.getLineCount() > maxLines || layout2.getLineEnd(layout2.getLineCount() - 1) != text.length())) {
            return false;
        }
        return !((float)layout2.getHeight() > availableSpace.bottom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"BanUncheckedReflection"})
    static <T> T invokeAndReturnWithDefault(@NonNull Object object, @NonNull String methodName, @NonNull T defaultValue) {
        Object result = null;
        boolean exceptionThrown = false;
        try {
            Method method = AppCompatTextViewAutoSizeHelper.getTextViewMethod(methodName);
            result = method.invoke(object, new Object[0]);
            if (result == null && exceptionThrown) {
                result = defaultValue;
            }
        }
        catch (Exception ex) {
            try {
                exceptionThrown = true;
                Log.w((String)TAG, (String)("Failed to invoke TextView#" + methodName + "() method"), (Throwable)ex);
                if (result == null && exceptionThrown) {
                    result = defaultValue;
                }
            }
            catch (Throwable throwable) {
                if (result == null && exceptionThrown) {
                    result = defaultValue;
                }
                throw throwable;
            }
        }
        return (T)result;
    }

    @Nullable
    private static Method getTextViewMethod(@NonNull String methodName) {
        try {
            Method method = sTextViewMethodByNameCache.get(methodName);
            if (method == null && (method = TextView.class.getDeclaredMethod(methodName, new Class[0])) != null) {
                method.setAccessible(true);
                sTextViewMethodByNameCache.put(methodName, method);
            }
            return method;
        }
        catch (Exception ex) {
            Log.w((String)TAG, (String)("Failed to retrieve TextView#" + methodName + "() method"), (Throwable)ex);
            return null;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    boolean isAutoSizeEnabled() {
        return this.supportsAutoSizeText() && this.mAutoSizeTextType != 0;
    }

    private boolean supportsAutoSizeText() {
        return !(this.mTextView instanceof AppCompatEditText);
    }

    @RequiresApi(value=29)
    private static class Impl29
    extends Impl23 {
        Impl29() {
        }

        @Override
        boolean isHorizontallyScrollable(TextView textView) {
            return textView.isHorizontallyScrollable();
        }

        @Override
        void computeAndSetTextDirection(StaticLayout.Builder layoutBuilder, TextView textView) {
            layoutBuilder.setTextDirection(textView.getTextDirectionHeuristic());
        }
    }

    private static class Impl {
        Impl() {
        }

        boolean isHorizontallyScrollable(TextView textView) {
            return AppCompatTextViewAutoSizeHelper.invokeAndReturnWithDefault(textView, "getHorizontallyScrolling", false);
        }

        void computeAndSetTextDirection(StaticLayout.Builder layoutBuilder, TextView textView) {
        }
    }

    @RequiresApi(value=23)
    private static class Impl23
    extends Impl {
        Impl23() {
        }

        @Override
        void computeAndSetTextDirection(StaticLayout.Builder layoutBuilder, TextView textView) {
            TextDirectionHeuristic textDirectionHeuristic = AppCompatTextViewAutoSizeHelper.invokeAndReturnWithDefault(textView, "getTextDirectionHeuristic", TextDirectionHeuristics.FIRSTSTRONG_LTR);
            layoutBuilder.setTextDirection(textDirectionHeuristic);
        }
    }

    @RequiresApi(value=23)
    private static final class Api23Impl {
        private Api23Impl() {
        }

        @DoNotInline
        @NonNull
        static StaticLayout createStaticLayoutForMeasuring(@NonNull CharSequence text, @NonNull Layout.Alignment alignment, int availableWidth, int maxLines, @NonNull TextView textView, @NonNull TextPaint tempTextPaint, @NonNull Impl impl) {
            StaticLayout.Builder layoutBuilder = StaticLayout.Builder.obtain((CharSequence)text, (int)0, (int)text.length(), (TextPaint)tempTextPaint, (int)availableWidth);
            layoutBuilder.setAlignment(alignment).setLineSpacing(textView.getLineSpacingExtra(), textView.getLineSpacingMultiplier()).setIncludePad(textView.getIncludeFontPadding()).setBreakStrategy(textView.getBreakStrategy()).setHyphenationFrequency(textView.getHyphenationFrequency()).setMaxLines(maxLines == -1 ? Integer.MAX_VALUE : maxLines);
            try {
                impl.computeAndSetTextDirection(layoutBuilder, textView);
            }
            catch (ClassCastException e) {
                Log.w((String)AppCompatTextViewAutoSizeHelper.TAG, (String)"Failed to obtain TextDirectionHeuristic, auto size may be incorrect");
            }
            return layoutBuilder.build();
        }
    }
}

