/*
 * Decompiled with CFR 0.152.
 */
package androidx.window;

import androidx.window.extensions.WindowExtensions;
import androidx.window.extensions.WindowExtensionsProvider;
import androidx.window.reflection.ReflectionUtils;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\r\u0010\u0011\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\u0006\u0012\u0002\b\u00030\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0013"}, d2={"Landroidx/window/SafeWindowExtensionsProvider;", "", "loader", "Ljava/lang/ClassLoader;", "(Ljava/lang/ClassLoader;)V", "windowExtensions", "Landroidx/window/extensions/WindowExtensions;", "getWindowExtensions", "()Landroidx/window/extensions/WindowExtensions;", "windowExtensionsClass", "Ljava/lang/Class;", "getWindowExtensionsClass$window_release", "()Ljava/lang/Class;", "windowExtensionsProviderClass", "getWindowExtensionsProviderClass", "isWindowExtensionsPresent", "", "isWindowExtensionsValid", "isWindowExtensionsValid$window_release", "window_release"})
public final class SafeWindowExtensionsProvider {
    @NotNull
    private final ClassLoader loader;

    public SafeWindowExtensionsProvider(@NotNull ClassLoader loader) {
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        this.loader = loader;
    }

    @Nullable
    public final WindowExtensions getWindowExtensions() {
        WindowExtensions windowExtensions;
        try {
            windowExtensions = this.isWindowExtensionsPresent() && this.isWindowExtensionsValid$window_release() ? WindowExtensionsProvider.getWindowExtensions() : null;
        }
        catch (Exception e) {
            windowExtensions = null;
        }
        return windowExtensions;
    }

    @NotNull
    public final Class<?> getWindowExtensionsClass$window_release() {
        Class<?> clazz = this.loader.loadClass("androidx.window.extensions.WindowExtensions");
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"loader.loadClass(WindowE\u2026.WINDOW_EXTENSIONS_CLASS)");
        return clazz;
    }

    public final boolean isWindowExtensionsValid$window_release() {
        return this.isWindowExtensionsPresent() && ReflectionUtils.validateReflection$window_release("WindowExtensionsProvider#getWindowExtensions is not valid", (Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ SafeWindowExtensionsProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                Class providerClass = SafeWindowExtensionsProvider.access$getWindowExtensionsProviderClass(this.this$0);
                Method getWindowExtensionsMethod = providerClass.getDeclaredMethod("getWindowExtensions", new Class[0]);
                Class<?> windowExtensionsClass = this.this$0.getWindowExtensionsClass$window_release();
                Intrinsics.checkNotNullExpressionValue((Object)getWindowExtensionsMethod, (String)"getWindowExtensionsMethod");
                return ReflectionUtils.INSTANCE.doesReturn$window_release(getWindowExtensionsMethod, windowExtensionsClass) && ReflectionUtils.INSTANCE.isPublic$window_release(getWindowExtensionsMethod);
            }
        }));
    }

    private final boolean isWindowExtensionsPresent() {
        return ReflectionUtils.INSTANCE.checkIsPresent$window_release((Function0)new Function0<Class<?>>(this){
            final /* synthetic */ SafeWindowExtensionsProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Class<?> invoke() {
                Class<?> clazz = SafeWindowExtensionsProvider.access$getLoader$p(this.this$0).loadClass("androidx.window.extensions.WindowExtensionsProvider");
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"loader.loadClass(WindowE\u2026XTENSIONS_PROVIDER_CLASS)");
                return clazz;
            }
        });
    }

    private final Class<?> getWindowExtensionsProviderClass() {
        Class<?> clazz = this.loader.loadClass("androidx.window.extensions.WindowExtensionsProvider");
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"loader.loadClass(WindowE\u2026XTENSIONS_PROVIDER_CLASS)");
        return clazz;
    }

    public static final /* synthetic */ Class access$getWindowExtensionsProviderClass(SafeWindowExtensionsProvider $this) {
        return $this.getWindowExtensionsProviderClass();
    }

    public static final /* synthetic */ ClassLoader access$getLoader$p(SafeWindowExtensionsProvider $this) {
        return $this.loader;
    }
}

