/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.area;

import android.app.Activity;
import android.os.Binder;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.window.area.RearDisplayPresentationSessionPresenterImpl;
import androidx.window.area.RearDisplaySessionImpl;
import androidx.window.area.WindowAreaAdapter;
import androidx.window.area.WindowAreaCapability;
import androidx.window.area.WindowAreaController;
import androidx.window.area.WindowAreaControllerImpl;
import androidx.window.area.WindowAreaInfo;
import androidx.window.area.WindowAreaPresentationSessionCallback;
import androidx.window.area.WindowAreaSession;
import androidx.window.area.WindowAreaSessionCallback;
import androidx.window.area.utils.DeviceUtils;
import androidx.window.core.BuildConfig;
import androidx.window.core.ExperimentalWindowApi;
import androidx.window.core.VerificationMode;
import androidx.window.extensions.area.ExtensionWindowAreaPresentation;
import androidx.window.extensions.area.ExtensionWindowAreaStatus;
import androidx.window.extensions.area.WindowAreaComponent;
import androidx.window.extensions.core.util.function.Consumer;
import androidx.window.layout.WindowMetrics;
import androidx.window.layout.WindowMetricsCalculator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.ExecutorsKt;
import kotlinx.coroutines.channels.ProduceKt;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 22\u00020\u0001:\u0003234B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\rH\u0002J \u0010#\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%H\u0002J \u0010&\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J(\u0010'\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\u0005H\u0002J\u0010\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020,H\u0002J \u0010-\u001a\u00020\u00172\u0006\u0010.\u001a\u00020/2\u0006\u0010)\u001a\u00020\b2\u0006\u00100\u001a\u000201H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00130\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00065"}, d2={"Landroidx/window/area/WindowAreaControllerImpl;", "Landroidx/window/area/WindowAreaController;", "windowAreaComponent", "Landroidx/window/extensions/area/WindowAreaComponent;", "vendorApiLevel", "", "(Landroidx/window/extensions/area/WindowAreaComponent;I)V", "currentRearDisplayModeStatus", "Landroidx/window/area/WindowAreaCapability$Status;", "currentRearDisplayPresentationStatus", "currentWindowAreaInfoMap", "Ljava/util/HashMap;", "", "Landroidx/window/area/WindowAreaInfo;", "Lkotlin/collections/HashMap;", "rearDisplaySessionConsumer", "Landroidx/window/extensions/core/util/function/Consumer;", "windowAreaInfos", "Lkotlinx/coroutines/flow/Flow;", "", "getWindowAreaInfos", "()Lkotlinx/coroutines/flow/Flow;", "presentContentOnWindowArea", "", "token", "Landroid/os/Binder;", "activity", "Landroid/app/Activity;", "executor", "Ljava/util/concurrent/Executor;", "windowAreaPresentationSessionCallback", "Landroidx/window/area/WindowAreaPresentationSessionCallback;", "shouldRemoveWindowAreaInfo", "", "windowAreaInfo", "startRearDisplayMode", "windowAreaSessionCallback", "Landroidx/window/area/WindowAreaSessionCallback;", "startRearDisplayPresentationMode", "transferActivityToWindowArea", "updateRearDisplayAvailability", "status", "updateRearDisplayPresentationAvailability", "extensionWindowAreaStatus", "Landroidx/window/extensions/area/ExtensionWindowAreaStatus;", "updateRearDisplayWindowArea", "operation", "Landroidx/window/area/WindowAreaCapability$Operation;", "metrics", "Landroidx/window/layout/WindowMetrics;", "Companion", "RearDisplayPresentationSessionConsumer", "RearDisplaySessionConsumer", "window_release"})
@ExperimentalWindowApi
@RequiresApi(value=29)
public final class WindowAreaControllerImpl
implements WindowAreaController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WindowAreaComponent windowAreaComponent;
    private final int vendorApiLevel;
    private Consumer<Integer> rearDisplaySessionConsumer;
    @NotNull
    private WindowAreaCapability.Status currentRearDisplayModeStatus;
    @NotNull
    private WindowAreaCapability.Status currentRearDisplayPresentationStatus;
    @NotNull
    private final HashMap<String, WindowAreaInfo> currentWindowAreaInfoMap;
    @Nullable
    private static final String TAG = Reflection.getOrCreateKotlinClass(WindowAreaControllerImpl.class).getSimpleName();
    @NotNull
    private static final String REAR_DISPLAY_BINDER_DESCRIPTOR = "WINDOW_AREA_REAR_DISPLAY";

    public WindowAreaControllerImpl(@NotNull WindowAreaComponent windowAreaComponent, int vendorApiLevel) {
        Intrinsics.checkNotNullParameter((Object)windowAreaComponent, (String)"windowAreaComponent");
        this.windowAreaComponent = windowAreaComponent;
        this.vendorApiLevel = vendorApiLevel;
        this.currentRearDisplayModeStatus = WindowAreaCapability.Status.Companion.getWINDOW_AREA_STATUS_UNKNOWN$window_release();
        this.currentRearDisplayPresentationStatus = WindowAreaCapability.Status.Companion.getWINDOW_AREA_STATUS_UNKNOWN$window_release();
        this.currentWindowAreaInfoMap = new HashMap();
    }

    @Override
    @NotNull
    public Flow<List<WindowAreaInfo>> getWindowAreaInfos() {
        return FlowKt.callbackFlow((Function2)((Function2)new Function2<ProducerScope<? super List<? extends WindowAreaInfo>>, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ WindowAreaControllerImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ProducerScope $this$callbackFlow = (ProducerScope)this.L$0;
                        Consumer rearDisplayListener = arg_0 -> windowAreaInfos.1.invokeSuspend$lambda$0(this.this$0, $this$callbackFlow, arg_0);
                        Consumer rearDisplayPresentationListener = arg_0 -> windowAreaInfos.1.invokeSuspend$lambda$1(this.this$0, $this$callbackFlow, arg_0);
                        WindowAreaControllerImpl.access$getWindowAreaComponent$p(this.this$0).addRearDisplayStatusListener(rearDisplayListener);
                        if (WindowAreaControllerImpl.access$getVendorApiLevel$p(this.this$0) > 2) {
                            WindowAreaControllerImpl.access$getWindowAreaComponent$p(this.this$0).addRearDisplayPresentationStatusListener(rearDisplayPresentationListener);
                        }
                        this.label = 1;
                        Object object3 = ProduceKt.awaitClose((ProducerScope)$this$callbackFlow, (Function0)((Function0)new Function0<Unit>(this.this$0, (Consumer<Integer>)rearDisplayListener, (Consumer<ExtensionWindowAreaStatus>)rearDisplayPresentationListener){
                            final /* synthetic */ WindowAreaControllerImpl this$0;
                            final /* synthetic */ Consumer<Integer> $rearDisplayListener;
                            final /* synthetic */ Consumer<ExtensionWindowAreaStatus> $rearDisplayPresentationListener;
                            {
                                this.this$0 = $receiver;
                                this.$rearDisplayListener = $rearDisplayListener;
                                this.$rearDisplayPresentationListener = $rearDisplayPresentationListener;
                                super(0);
                            }

                            public final void invoke() {
                                WindowAreaControllerImpl.access$getWindowAreaComponent$p(this.this$0).removeRearDisplayStatusListener(this.$rearDisplayListener);
                                if (WindowAreaControllerImpl.access$getVendorApiLevel$p(this.this$0) > 2) {
                                    WindowAreaControllerImpl.access$getWindowAreaComponent$p(this.this$0).removeRearDisplayPresentationStatusListener(this.$rearDisplayPresentationListener);
                                }
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<ProducerScope<? super List<? extends WindowAreaInfo>>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull ProducerScope<? super List<WindowAreaInfo>> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final void invokeSuspend$lambda$0(WindowAreaControllerImpl this$0, ProducerScope $$this$callbackFlow, Integer status) {
                Intrinsics.checkNotNullExpressionValue((Object)status, (String)"status");
                WindowAreaControllerImpl.access$updateRearDisplayAvailability(this$0, status);
                SendChannel sendChannel = $$this$callbackFlow.getChannel();
                Collection<V> collection = WindowAreaControllerImpl.access$getCurrentWindowAreaInfoMap$p(this$0).values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"currentWindowAreaInfoMap.values");
                sendChannel.trySend-JP2dKIU((Object)CollectionsKt.toList((Iterable)collection));
            }

            private static final void invokeSuspend$lambda$1(WindowAreaControllerImpl this$0, ProducerScope $$this$callbackFlow, ExtensionWindowAreaStatus extensionWindowAreaStatus) {
                Intrinsics.checkNotNullExpressionValue((Object)extensionWindowAreaStatus, (String)"extensionWindowAreaStatus");
                WindowAreaControllerImpl.access$updateRearDisplayPresentationAvailability(this$0, extensionWindowAreaStatus);
                SendChannel sendChannel = $$this$callbackFlow.getChannel();
                Collection<V> collection = WindowAreaControllerImpl.access$getCurrentWindowAreaInfoMap$p(this$0).values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"currentWindowAreaInfoMap.values");
                sendChannel.trySend-JP2dKIU((Object)CollectionsKt.toList((Iterable)collection));
            }
        }));
    }

    private final void updateRearDisplayAvailability(int status) {
        WindowMetrics windowMetrics;
        if (this.vendorApiLevel >= 3) {
            DisplayMetrics displayMetrics = this.windowAreaComponent.getRearDisplayMetrics();
            Intrinsics.checkNotNullExpressionValue((Object)displayMetrics, (String)"windowAreaComponent.rearDisplayMetrics");
            windowMetrics = WindowMetricsCalculator.Companion.fromDisplayMetrics$window_release(displayMetrics);
        } else {
            String string = Build.MANUFACTURER;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MANUFACTURER");
            String string2 = Build.MODEL;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"MODEL");
            DisplayMetrics displayMetrics = DeviceUtils.INSTANCE.getRearDisplayMetrics$window_release(string, string2);
            if (displayMetrics != null) {
                windowMetrics = WindowMetricsCalculator.Companion.fromDisplayMetrics$window_release(displayMetrics);
            } else {
                throw new IllegalArgumentException("DeviceUtils rear display metrics entry should not be null");
            }
        }
        WindowMetrics windowMetrics2 = windowMetrics;
        this.currentRearDisplayModeStatus = WindowAreaAdapter.INSTANCE.translate$window_release(status);
        this.updateRearDisplayWindowArea(WindowAreaCapability.Operation.OPERATION_TRANSFER_ACTIVITY_TO_AREA, this.currentRearDisplayModeStatus, windowMetrics2);
    }

    private final void updateRearDisplayPresentationAvailability(ExtensionWindowAreaStatus extensionWindowAreaStatus) {
        this.currentRearDisplayPresentationStatus = WindowAreaAdapter.INSTANCE.translate$window_release(extensionWindowAreaStatus.getWindowAreaStatus());
        DisplayMetrics displayMetrics = extensionWindowAreaStatus.getWindowAreaDisplayMetrics();
        Intrinsics.checkNotNullExpressionValue((Object)displayMetrics, (String)"extensionWindowAreaStatus.windowAreaDisplayMetrics");
        WindowMetrics windowMetrics = WindowMetricsCalculator.Companion.fromDisplayMetrics$window_release(displayMetrics);
        this.updateRearDisplayWindowArea(WindowAreaCapability.Operation.OPERATION_PRESENT_ON_AREA, this.currentRearDisplayPresentationStatus, windowMetrics);
    }

    private final void updateRearDisplayWindowArea(WindowAreaCapability.Operation operation, WindowAreaCapability.Status status, WindowMetrics metrics) {
        WindowAreaInfo rearDisplayAreaInfo = this.currentWindowAreaInfoMap.get(REAR_DISPLAY_BINDER_DESCRIPTOR);
        if (Intrinsics.areEqual((Object)status, (Object)WindowAreaCapability.Status.WINDOW_AREA_STATUS_UNSUPPORTED)) {
            WindowAreaInfo windowAreaInfo = rearDisplayAreaInfo;
            if (windowAreaInfo != null) {
                WindowAreaInfo info = windowAreaInfo;
                boolean bl = false;
                if (this.shouldRemoveWindowAreaInfo(info)) {
                    this.currentWindowAreaInfoMap.remove(REAR_DISPLAY_BINDER_DESCRIPTOR);
                } else {
                    WindowAreaCapability capability = new WindowAreaCapability(operation, status);
                    ((Map)info.getCapabilityMap$window_release()).put(operation, capability);
                }
            }
        } else {
            if (rearDisplayAreaInfo == null) {
                rearDisplayAreaInfo = new WindowAreaInfo(metrics, WindowAreaInfo.Type.TYPE_REAR_FACING, new Binder(REAR_DISPLAY_BINDER_DESCRIPTOR), this.windowAreaComponent);
            }
            WindowAreaCapability capability = new WindowAreaCapability(operation, status);
            ((Map)rearDisplayAreaInfo.getCapabilityMap$window_release()).put(operation, capability);
            rearDisplayAreaInfo.setMetrics(metrics);
            ((Map)this.currentWindowAreaInfoMap).put(REAR_DISPLAY_BINDER_DESCRIPTOR, rearDisplayAreaInfo);
        }
    }

    private final boolean shouldRemoveWindowAreaInfo(WindowAreaInfo windowAreaInfo) {
        Iterator<WindowAreaCapability> iterator = windowAreaInfo.getCapabilityMap$window_release().values().iterator();
        while (iterator.hasNext()) {
            WindowAreaCapability capability;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"windowAreaInfo.capabilityMap.values");
            if (Intrinsics.areEqual((Object)capability.getStatus(), (Object)WindowAreaCapability.Status.WINDOW_AREA_STATUS_UNSUPPORTED)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void transferActivityToWindowArea(@NotNull Binder token, @NotNull Activity activity, @NotNull Executor executor, @NotNull WindowAreaSessionCallback windowAreaSessionCallback) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)windowAreaSessionCallback, (String)"windowAreaSessionCallback");
        if (!Intrinsics.areEqual((Object)token.getInterfaceDescriptor(), (Object)REAR_DISPLAY_BINDER_DESCRIPTOR)) {
            executor.execute(() -> WindowAreaControllerImpl.transferActivityToWindowArea$lambda$1(windowAreaSessionCallback));
            return;
        }
        if (Intrinsics.areEqual((Object)this.currentRearDisplayModeStatus, (Object)WindowAreaCapability.Status.Companion.getWINDOW_AREA_STATUS_UNKNOWN$window_release())) {
            Log.d((String)TAG, (String)"Force updating currentRearDisplayModeStatus");
            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)ExecutorsKt.from((Executor)executor))), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, activity, executor, windowAreaSessionCallback, null){
                int label;
                final /* synthetic */ WindowAreaControllerImpl this$0;
                final /* synthetic */ Activity $activity;
                final /* synthetic */ Executor $executor;
                final /* synthetic */ WindowAreaSessionCallback $windowAreaSessionCallback;
                {
                    this.this$0 = $receiver;
                    this.$activity = $activity;
                    this.$executor = $executor;
                    this.$windowAreaSessionCallback = $windowAreaSessionCallback;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = FlowKt.first(this.this$0.getWindowAreaInfos(), (Continuation)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            WindowAreaControllerImpl.access$startRearDisplayMode(this.this$0, this.$activity, this.$executor, this.$windowAreaSessionCallback);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        } else {
            this.startRearDisplayMode(activity, executor, windowAreaSessionCallback);
        }
    }

    @Override
    public void presentContentOnWindowArea(@NotNull Binder token, @NotNull Activity activity, @NotNull Executor executor, @NotNull WindowAreaPresentationSessionCallback windowAreaPresentationSessionCallback) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)windowAreaPresentationSessionCallback, (String)"windowAreaPresentationSessionCallback");
        if (!Intrinsics.areEqual((Object)token.getInterfaceDescriptor(), (Object)REAR_DISPLAY_BINDER_DESCRIPTOR)) {
            executor.execute(() -> WindowAreaControllerImpl.presentContentOnWindowArea$lambda$2(windowAreaPresentationSessionCallback));
            return;
        }
        if (Intrinsics.areEqual((Object)this.currentRearDisplayPresentationStatus, (Object)WindowAreaCapability.Status.Companion.getWINDOW_AREA_STATUS_UNKNOWN$window_release())) {
            Log.d((String)TAG, (String)"Force updating currentRearDisplayPresentationStatus");
            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)ExecutorsKt.from((Executor)executor))), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, activity, executor, windowAreaPresentationSessionCallback, null){
                int label;
                final /* synthetic */ WindowAreaControllerImpl this$0;
                final /* synthetic */ Activity $activity;
                final /* synthetic */ Executor $executor;
                final /* synthetic */ WindowAreaPresentationSessionCallback $windowAreaPresentationSessionCallback;
                {
                    this.this$0 = $receiver;
                    this.$activity = $activity;
                    this.$executor = $executor;
                    this.$windowAreaPresentationSessionCallback = $windowAreaPresentationSessionCallback;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = FlowKt.first(this.this$0.getWindowAreaInfos(), (Continuation)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            WindowAreaControllerImpl.access$startRearDisplayPresentationMode(this.this$0, this.$activity, this.$executor, this.$windowAreaPresentationSessionCallback);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        } else {
            this.startRearDisplayPresentationMode(activity, executor, windowAreaPresentationSessionCallback);
        }
    }

    private final void startRearDisplayMode(Activity activity, Executor executor, WindowAreaSessionCallback windowAreaSessionCallback) {
        if (Intrinsics.areEqual((Object)this.currentRearDisplayModeStatus, (Object)WindowAreaCapability.Status.WINDOW_AREA_STATUS_ACTIVE)) {
            windowAreaSessionCallback.onSessionEnded(new IllegalStateException("The WindowArea feature is currently active, WindowAreaInfo#getActiveSessioncan be used to get an instance of the current active session"));
            return;
        }
        if (!Intrinsics.areEqual((Object)this.currentRearDisplayModeStatus, (Object)WindowAreaCapability.Status.WINDOW_AREA_STATUS_AVAILABLE)) {
            windowAreaSessionCallback.onSessionEnded(new IllegalStateException("The WindowArea feature is currently not available to be entered"));
            return;
        }
        this.rearDisplaySessionConsumer = new RearDisplaySessionConsumer(executor, windowAreaSessionCallback, this.windowAreaComponent);
        Consumer<Integer> consumer = this.rearDisplaySessionConsumer;
        if (consumer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rearDisplaySessionConsumer");
            consumer = null;
        }
        this.windowAreaComponent.startRearDisplaySession(activity, consumer);
    }

    private final void startRearDisplayPresentationMode(Activity activity, Executor executor, WindowAreaPresentationSessionCallback windowAreaPresentationSessionCallback) {
        if (!Intrinsics.areEqual((Object)this.currentRearDisplayPresentationStatus, (Object)WindowAreaCapability.Status.WINDOW_AREA_STATUS_AVAILABLE)) {
            windowAreaPresentationSessionCallback.onSessionEnded(new IllegalStateException("The WindowArea feature is currently not available to be entered"));
            return;
        }
        this.windowAreaComponent.startRearDisplayPresentationSession(activity, (Consumer)new RearDisplayPresentationSessionConsumer(executor, windowAreaPresentationSessionCallback, this.windowAreaComponent));
    }

    private static final void transferActivityToWindowArea$lambda$1(WindowAreaSessionCallback $windowAreaSessionCallback) {
        Intrinsics.checkNotNullParameter((Object)$windowAreaSessionCallback, (String)"$windowAreaSessionCallback");
        $windowAreaSessionCallback.onSessionEnded(new IllegalArgumentException("Invalid WindowAreaInfo token"));
    }

    private static final void presentContentOnWindowArea$lambda$2(WindowAreaPresentationSessionCallback $windowAreaPresentationSessionCallback) {
        Intrinsics.checkNotNullParameter((Object)$windowAreaPresentationSessionCallback, (String)"$windowAreaPresentationSessionCallback");
        $windowAreaPresentationSessionCallback.onSessionEnded(new IllegalArgumentException("Invalid WindowAreaInfo token"));
    }

    public static final /* synthetic */ WindowAreaComponent access$getWindowAreaComponent$p(WindowAreaControllerImpl $this) {
        return $this.windowAreaComponent;
    }

    public static final /* synthetic */ int access$getVendorApiLevel$p(WindowAreaControllerImpl $this) {
        return $this.vendorApiLevel;
    }

    public static final /* synthetic */ void access$updateRearDisplayAvailability(WindowAreaControllerImpl $this, int status) {
        $this.updateRearDisplayAvailability(status);
    }

    public static final /* synthetic */ HashMap access$getCurrentWindowAreaInfoMap$p(WindowAreaControllerImpl $this) {
        return $this.currentWindowAreaInfoMap;
    }

    public static final /* synthetic */ void access$updateRearDisplayPresentationAvailability(WindowAreaControllerImpl $this, ExtensionWindowAreaStatus extensionWindowAreaStatus) {
        $this.updateRearDisplayPresentationAvailability(extensionWindowAreaStatus);
    }

    public static final /* synthetic */ void access$startRearDisplayMode(WindowAreaControllerImpl $this, Activity activity, Executor executor, WindowAreaSessionCallback windowAreaSessionCallback) {
        $this.startRearDisplayMode(activity, executor, windowAreaSessionCallback);
    }

    public static final /* synthetic */ void access$startRearDisplayPresentationMode(WindowAreaControllerImpl $this, Activity activity, Executor executor, WindowAreaPresentationSessionCallback windowAreaPresentationSessionCallback) {
        $this.startRearDisplayPresentationMode(activity, executor, windowAreaPresentationSessionCallback);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/window/area/WindowAreaControllerImpl$Companion;", "", "()V", "REAR_DISPLAY_BINDER_DESCRIPTOR", "", "TAG", "window_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Landroidx/window/area/WindowAreaControllerImpl$RearDisplayPresentationSessionConsumer;", "Landroidx/window/extensions/core/util/function/Consumer;", "", "executor", "Ljava/util/concurrent/Executor;", "windowAreaPresentationSessionCallback", "Landroidx/window/area/WindowAreaPresentationSessionCallback;", "windowAreaComponent", "Landroidx/window/extensions/area/WindowAreaComponent;", "(Ljava/util/concurrent/Executor;Landroidx/window/area/WindowAreaPresentationSessionCallback;Landroidx/window/extensions/area/WindowAreaComponent;)V", "lastReportedSessionStatus", "accept", "", "t", "window_release"})
    public static final class RearDisplayPresentationSessionConsumer
    implements Consumer<Integer> {
        @NotNull
        private final Executor executor;
        @NotNull
        private final WindowAreaPresentationSessionCallback windowAreaPresentationSessionCallback;
        @NotNull
        private final WindowAreaComponent windowAreaComponent;
        private int lastReportedSessionStatus;

        public RearDisplayPresentationSessionConsumer(@NotNull Executor executor, @NotNull WindowAreaPresentationSessionCallback windowAreaPresentationSessionCallback, @NotNull WindowAreaComponent windowAreaComponent) {
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            Intrinsics.checkNotNullParameter((Object)windowAreaPresentationSessionCallback, (String)"windowAreaPresentationSessionCallback");
            Intrinsics.checkNotNullParameter((Object)windowAreaComponent, (String)"windowAreaComponent");
            this.executor = executor;
            this.windowAreaPresentationSessionCallback = windowAreaPresentationSessionCallback;
            this.windowAreaComponent = windowAreaComponent;
        }

        public void accept(int t) {
            int previousStatus = this.lastReportedSessionStatus;
            this.lastReportedSessionStatus = t;
            this.executor.execute(() -> RearDisplayPresentationSessionConsumer.accept$lambda$0(t, previousStatus, this));
        }

        private static final void accept$lambda$0(int $t, int $previousStatus, RearDisplayPresentationSessionConsumer this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            switch ($t) {
                case 1: {
                    if ($previousStatus == 2) {
                        this$0.windowAreaPresentationSessionCallback.onContainerVisibilityChanged(false);
                        break;
                    }
                    WindowAreaPresentationSessionCallback windowAreaPresentationSessionCallback = this$0.windowAreaPresentationSessionCallback;
                    WindowAreaComponent windowAreaComponent = this$0.windowAreaComponent;
                    ExtensionWindowAreaPresentation extensionWindowAreaPresentation = this$0.windowAreaComponent.getRearDisplayPresentation();
                    Intrinsics.checkNotNull((Object)extensionWindowAreaPresentation);
                    windowAreaPresentationSessionCallback.onSessionStarted(new RearDisplayPresentationSessionPresenterImpl(windowAreaComponent, extensionWindowAreaPresentation));
                    break;
                }
                case 2: {
                    this$0.windowAreaPresentationSessionCallback.onContainerVisibilityChanged(true);
                    break;
                }
                case 0: {
                    this$0.windowAreaPresentationSessionCallback.onSessionEnded(null);
                    break;
                }
                default: {
                    Log.e((String)TAG, (String)("Invalid session state value received: " + $t));
                }
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\b\u0010\u000f\u001a\u00020\rH\u0002J\b\u0010\u0010\u001a\u00020\rH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Landroidx/window/area/WindowAreaControllerImpl$RearDisplaySessionConsumer;", "Landroidx/window/extensions/core/util/function/Consumer;", "", "executor", "Ljava/util/concurrent/Executor;", "appCallback", "Landroidx/window/area/WindowAreaSessionCallback;", "extensionsComponent", "Landroidx/window/extensions/area/WindowAreaComponent;", "(Ljava/util/concurrent/Executor;Landroidx/window/area/WindowAreaSessionCallback;Landroidx/window/extensions/area/WindowAreaComponent;)V", "session", "Landroidx/window/area/WindowAreaSession;", "accept", "", "t", "onSessionFinished", "onSessionStarted", "window_release"})
    @SourceDebugExtension(value={"SMAP\nWindowAreaControllerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowAreaControllerImpl.kt\nandroidx/window/area/WindowAreaControllerImpl$RearDisplaySessionConsumer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,409:1\n1#2:410\n*E\n"})
    public static final class RearDisplaySessionConsumer
    implements Consumer<Integer> {
        @NotNull
        private final Executor executor;
        @NotNull
        private final WindowAreaSessionCallback appCallback;
        @NotNull
        private final WindowAreaComponent extensionsComponent;
        @Nullable
        private WindowAreaSession session;

        public RearDisplaySessionConsumer(@NotNull Executor executor, @NotNull WindowAreaSessionCallback appCallback, @NotNull WindowAreaComponent extensionsComponent) {
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            Intrinsics.checkNotNullParameter((Object)appCallback, (String)"appCallback");
            Intrinsics.checkNotNullParameter((Object)extensionsComponent, (String)"extensionsComponent");
            this.executor = executor;
            this.appCallback = appCallback;
            this.extensionsComponent = extensionsComponent;
        }

        public void accept(int t) {
            switch (t) {
                case 1: {
                    this.onSessionStarted();
                    break;
                }
                case 0: {
                    this.onSessionFinished();
                    break;
                }
                default: {
                    if (BuildConfig.INSTANCE.getVerificationMode() == VerificationMode.STRICT) {
                        Log.d((String)TAG, (String)("Received an unknown session status value: " + t));
                    }
                    this.onSessionFinished();
                }
            }
        }

        private final void onSessionStarted() {
            block0: {
                WindowAreaSession windowAreaSession = this.session = (WindowAreaSession)new RearDisplaySessionImpl(this.extensionsComponent);
                if (windowAreaSession == null) break block0;
                WindowAreaSession it = windowAreaSession;
                boolean bl = false;
                this.executor.execute(() -> RearDisplaySessionConsumer.onSessionStarted$lambda$1$lambda$0(this, it));
            }
        }

        private final void onSessionFinished() {
            this.session = null;
            this.executor.execute(() -> RearDisplaySessionConsumer.onSessionFinished$lambda$2(this));
        }

        private static final void onSessionStarted$lambda$1$lambda$0(RearDisplaySessionConsumer this$0, WindowAreaSession $it) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
            this$0.appCallback.onSessionStarted($it);
        }

        private static final void onSessionFinished$lambda$2(RearDisplaySessionConsumer this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this$0.appCallback.onSessionEnded(null);
        }
    }
}

