/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.area.utils;

import android.util.DisplayMetrics;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Landroidx/window/area/utils/DeviceMetrics;", "", "manufacturer", "", "model", "rearDisplayMetrics", "Landroid/util/DisplayMetrics;", "(Ljava/lang/String;Ljava/lang/String;Landroid/util/DisplayMetrics;)V", "getManufacturer", "()Ljava/lang/String;", "getModel", "getRearDisplayMetrics", "()Landroid/util/DisplayMetrics;", "equals", "", "other", "hashCode", "", "toString", "window_release"})
public final class DeviceMetrics {
    @NotNull
    private final String manufacturer;
    @NotNull
    private final String model;
    @NotNull
    private final DisplayMetrics rearDisplayMetrics;

    public DeviceMetrics(@NotNull String manufacturer, @NotNull String model, @NotNull DisplayMetrics rearDisplayMetrics) {
        Intrinsics.checkNotNullParameter((Object)manufacturer, (String)"manufacturer");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)rearDisplayMetrics, (String)"rearDisplayMetrics");
        this.manufacturer = manufacturer;
        this.model = model;
        this.rearDisplayMetrics = rearDisplayMetrics;
    }

    @NotNull
    public final String getManufacturer() {
        return this.manufacturer;
    }

    @NotNull
    public final String getModel() {
        return this.model;
    }

    @NotNull
    public final DisplayMetrics getRearDisplayMetrics() {
        return this.rearDisplayMetrics;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof DeviceMetrics && Intrinsics.areEqual((Object)this.manufacturer, (Object)((DeviceMetrics)other).manufacturer) && Intrinsics.areEqual((Object)this.model, (Object)((DeviceMetrics)other).model) && this.rearDisplayMetrics.equals(((DeviceMetrics)other).rearDisplayMetrics);
    }

    public int hashCode() {
        int result = this.manufacturer.hashCode();
        result = 31 * result + this.model.hashCode();
        result = 31 * result + this.rearDisplayMetrics.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return "DeviceMetrics{ Manufacturer: " + this.manufacturer + ", model: " + this.model + ", Rear display metrics: " + this.rearDisplayMetrics + " }";
    }
}

