/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.core;

import android.util.Log;
import androidx.annotation.IntRange;
import androidx.window.core.BuildConfig;
import androidx.window.core.VerificationMode;
import androidx.window.extensions.WindowExtensionsProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068G\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Landroidx/window/core/ExtensionsUtil;", "", "()V", "TAG", "", "safeVendorApiLevel", "", "getSafeVendorApiLevel", "()I", "window_release"})
public final class ExtensionsUtil {
    @NotNull
    public static final ExtensionsUtil INSTANCE = new ExtensionsUtil();
    @Nullable
    private static final String TAG = Reflection.getOrCreateKotlinClass(ExtensionsUtil.class).getSimpleName();

    private ExtensionsUtil() {
    }

    @IntRange(from=0L)
    public final int getSafeVendorApiLevel() {
        int n;
        try {
            n = WindowExtensionsProvider.getWindowExtensions().getVendorApiLevel();
        }
        catch (NoClassDefFoundError e) {
            if (BuildConfig.INSTANCE.getVerificationMode() == VerificationMode.LOG) {
                Log.d((String)TAG, (String)"Embedding extension version not found");
            }
            n = 0;
        }
        catch (UnsupportedOperationException e) {
            if (BuildConfig.INSTANCE.getVerificationMode() == VerificationMode.LOG) {
                Log.d((String)TAG, (String)"Stub Extension");
            }
            n = 0;
        }
        return n;
    }
}

