/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.embedding;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Binder;
import android.os.IBinder;
import android.view.WindowMetrics;
import androidx.window.WindowSdkExtensions;
import androidx.window.core.PredicateAdapter;
import androidx.window.embedding.ActivityFilter;
import androidx.window.embedding.ActivityRule;
import androidx.window.embedding.ActivityStack;
import androidx.window.embedding.EmbeddingRule;
import androidx.window.embedding.SplitAttributes;
import androidx.window.embedding.SplitAttributesCalculatorParams;
import androidx.window.embedding.SplitInfo;
import androidx.window.embedding.SplitPairFilter;
import androidx.window.embedding.SplitPairRule;
import androidx.window.embedding.SplitPlaceholderRule;
import androidx.window.embedding.SplitRule;
import androidx.window.extensions.core.util.function.Function;
import androidx.window.extensions.core.util.function.Predicate;
import androidx.window.extensions.embedding.ActivityRule;
import androidx.window.extensions.embedding.SplitAttributes;
import androidx.window.extensions.embedding.SplitPairRule;
import androidx.window.extensions.embedding.SplitPlaceholderRule;
import androidx.window.extensions.layout.WindowLayoutInfo;
import androidx.window.layout.WindowMetricsCalculator;
import androidx.window.layout.adapter.extensions.ExtensionsWindowLayoutInfoAdapter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 82\u00020\u0001:\u000389:B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000eJ\u0015\u0010\r\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017J\u0010\u0010\r\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0010\u0010\r\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001eJ\u001c\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030%H\u0002J\u000e\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0014J&\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00160+2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00140-J$\u0010.\u001a\u00020/2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\"\u001a\u0002002\n\u0010$\u001a\u0006\u0012\u0002\b\u00030%H\u0002J$\u00101\u001a\u0002022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\"\u001a\u0002032\n\u0010$\u001a\u0006\u0012\u0002\b\u00030%H\u0002J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0002R\u0012\u0010\u0005\u001a\u00060\u0006R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006;"}, d2={"Landroidx/window/embedding/EmbeddingAdapter;", "", "predicateAdapter", "Landroidx/window/core/PredicateAdapter;", "(Landroidx/window/core/PredicateAdapter;)V", "api1Impl", "Landroidx/window/embedding/EmbeddingAdapter$VendorApiLevel1Impl;", "api2Impl", "Landroidx/window/embedding/EmbeddingAdapter$VendorApiLevel2Impl;", "vendorApiLevel", "", "getVendorApiLevel", "()I", "translate", "", "Landroidx/window/extensions/embedding/EmbeddingRule;", "context", "Landroid/content/Context;", "rules", "Landroidx/window/embedding/EmbeddingRule;", "Landroidx/window/embedding/SplitAttributes;", "splitAttributes", "Landroidx/window/extensions/embedding/SplitAttributes;", "translate$window_release", "Landroidx/window/embedding/SplitAttributesCalculatorParams;", "params", "Landroidx/window/extensions/embedding/SplitAttributesCalculatorParams;", "Landroidx/window/embedding/SplitInfo;", "splitInfo", "Landroidx/window/extensions/embedding/SplitInfo;", "", "splitInfoList", "translateActivityRule", "Landroidx/window/extensions/embedding/ActivityRule;", "rule", "Landroidx/window/embedding/ActivityRule;", "predicateClass", "Ljava/lang/Class;", "translateFinishBehavior", "behavior", "Landroidx/window/embedding/SplitRule$FinishBehavior;", "translateSplitAttributes", "translateSplitAttributesCalculator", "Landroidx/window/extensions/core/util/function/Function;", "calculator", "Lkotlin/Function1;", "translateSplitPairRule", "Landroidx/window/extensions/embedding/SplitPairRule;", "Landroidx/window/embedding/SplitPairRule;", "translateSplitPlaceholderRule", "Landroidx/window/extensions/embedding/SplitPlaceholderRule;", "Landroidx/window/embedding/SplitPlaceholderRule;", "translateSplitType", "Landroidx/window/extensions/embedding/SplitAttributes$SplitType;", "splitType", "Landroidx/window/embedding/SplitAttributes$SplitType;", "Companion", "VendorApiLevel1Impl", "VendorApiLevel2Impl", "window_release"})
@SourceDebugExtension(value={"SMAP\nEmbeddingAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmbeddingAdapter.kt\nandroidx/window/embedding/EmbeddingAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,524:1\n1549#2:525\n1620#2,3:526\n1549#2:529\n1620#2,3:530\n1747#2,3:533\n1747#2,3:536\n1747#2,3:539\n1747#2,3:542\n1747#2,3:545\n1747#2,3:548\n*S KotlinDebug\n*F\n+ 1 EmbeddingAdapter.kt\nandroidx/window/embedding/EmbeddingAdapter\n*L\n71#1:525\n71#1:526,3\n307#1:529\n307#1:530,3\n158#1:533,3\n164#1:536,3\n247#1:539,3\n250#1:542,3\n290#1:545,3\n293#1:548,3\n*E\n"})
public final class EmbeddingAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PredicateAdapter predicateAdapter;
    @NotNull
    private final VendorApiLevel1Impl api1Impl;
    @NotNull
    private final VendorApiLevel2Impl api2Impl;
    @NotNull
    private static final Binder INVALID_SPLIT_INFO_TOKEN = new Binder();
    @NotNull
    private static final Binder INVALID_ACTIVITY_STACK_TOKEN = new Binder();

    public EmbeddingAdapter(@NotNull PredicateAdapter predicateAdapter) {
        Intrinsics.checkNotNullParameter((Object)predicateAdapter, (String)"predicateAdapter");
        this.predicateAdapter = predicateAdapter;
        this.api1Impl = new VendorApiLevel1Impl(this.predicateAdapter);
        this.api2Impl = new VendorApiLevel2Impl();
    }

    private final int getVendorApiLevel() {
        return WindowSdkExtensions.Companion.getInstance().getExtensionVersion();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SplitInfo> translate(@NotNull List<? extends androidx.window.extensions.embedding.SplitInfo> splitInfoList2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(splitInfoList2, (String)"splitInfoList");
        Iterable $this$map$iv = splitInfoList2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            androidx.window.extensions.embedding.SplitInfo splitInfo = (androidx.window.extensions.embedding.SplitInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.translate((androidx.window.extensions.embedding.SplitInfo)p0));
        }
        return (List)destination$iv$iv;
    }

    private final SplitInfo translate(androidx.window.extensions.embedding.SplitInfo splitInfo) {
        SplitInfo splitInfo2;
        switch (this.getVendorApiLevel()) {
            case 1: {
                splitInfo2 = this.api1Impl.translateCompat(splitInfo);
                break;
            }
            case 2: {
                splitInfo2 = this.api2Impl.translateCompat(splitInfo);
                break;
            }
            default: {
                androidx.window.extensions.embedding.ActivityStack activityStack = splitInfo.getPrimaryActivityStack();
                Intrinsics.checkNotNullExpressionValue((Object)activityStack, (String)"splitInfo.primaryActivityStack");
                androidx.window.extensions.embedding.ActivityStack primaryActivityStack = activityStack;
                androidx.window.extensions.embedding.ActivityStack activityStack2 = splitInfo.getSecondaryActivityStack();
                Intrinsics.checkNotNullExpressionValue((Object)activityStack2, (String)"splitInfo.secondaryActivityStack");
                androidx.window.extensions.embedding.ActivityStack secondaryActivityStack = activityStack2;
                List list = primaryActivityStack.getActivities();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"primaryActivityStack.activities");
                ActivityStack activityStack3 = new ActivityStack(list, primaryActivityStack.isEmpty());
                List list2 = secondaryActivityStack.getActivities();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"secondaryActivityStack.activities");
                ActivityStack activityStack4 = new ActivityStack(list2, secondaryActivityStack.isEmpty());
                androidx.window.extensions.embedding.SplitAttributes splitAttributes = splitInfo.getSplitAttributes();
                Intrinsics.checkNotNullExpressionValue((Object)splitAttributes, (String)"splitInfo.splitAttributes");
                SplitAttributes splitAttributes2 = this.translate$window_release(splitAttributes);
                IBinder iBinder = splitInfo.getToken();
                Intrinsics.checkNotNullExpressionValue((Object)iBinder, (String)"splitInfo.token");
                splitInfo2 = new SplitInfo(activityStack3, activityStack4, splitAttributes2, iBinder);
            }
        }
        return splitInfo2;
    }

    @NotNull
    public final SplitAttributes translate$window_release(@NotNull androidx.window.extensions.embedding.SplitAttributes splitAttributes) {
        SplitAttributes.LayoutDirection layoutDirection;
        SplitAttributes.SplitType splitType;
        Intrinsics.checkNotNullParameter((Object)splitAttributes, (String)"splitAttributes");
        SplitAttributes.Builder builder = new SplitAttributes.Builder();
        SplitAttributes.SplitType splitType2 = splitAttributes.getSplitType();
        Intrinsics.checkNotNullExpressionValue((Object)splitType2, (String)"splitAttributes.splitType");
        SplitAttributes.SplitType splitType3 = splitType2;
        if (splitType3 instanceof SplitAttributes.SplitType.HingeSplitType) {
            splitType = SplitAttributes.SplitType.SPLIT_TYPE_HINGE;
        } else if (splitType3 instanceof SplitAttributes.SplitType.ExpandContainersSplitType) {
            splitType = SplitAttributes.SplitType.SPLIT_TYPE_EXPAND;
        } else if (splitType3 instanceof SplitAttributes.SplitType.RatioSplitType) {
            splitType = SplitAttributes.SplitType.Companion.ratio(((SplitAttributes.SplitType.RatioSplitType)splitType3).getRatio());
        } else {
            throw new IllegalArgumentException("Unknown split type: " + splitType3);
        }
        SplitAttributes.Builder builder2 = builder.setSplitType(splitType);
        int layoutDirection2 = splitAttributes.getLayoutDirection();
        switch (layoutDirection2) {
            case 0: {
                layoutDirection = SplitAttributes.LayoutDirection.LEFT_TO_RIGHT;
                break;
            }
            case 1: {
                layoutDirection = SplitAttributes.LayoutDirection.RIGHT_TO_LEFT;
                break;
            }
            case 3: {
                layoutDirection = SplitAttributes.LayoutDirection.LOCALE;
                break;
            }
            case 4: {
                layoutDirection = SplitAttributes.LayoutDirection.TOP_TO_BOTTOM;
                break;
            }
            case 5: {
                layoutDirection = SplitAttributes.LayoutDirection.BOTTOM_TO_TOP;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown layout direction: " + layoutDirection2);
            }
        }
        return builder2.setLayoutDirection(layoutDirection).build();
    }

    @NotNull
    public final Function<androidx.window.extensions.embedding.SplitAttributesCalculatorParams, androidx.window.extensions.embedding.SplitAttributes> translateSplitAttributesCalculator(@NotNull Function1<? super SplitAttributesCalculatorParams, SplitAttributes> calculator) {
        Intrinsics.checkNotNullParameter(calculator, (String)"calculator");
        return arg_0 -> EmbeddingAdapter.translateSplitAttributesCalculator$lambda$0(this, calculator, arg_0);
    }

    @SuppressLint(value={"NewApi"})
    @NotNull
    public final SplitAttributesCalculatorParams translate(@NotNull androidx.window.extensions.embedding.SplitAttributesCalculatorParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        EmbeddingAdapter it = this;
        boolean bl = false;
        WindowMetrics windowMetrics = params.getParentWindowMetrics();
        Intrinsics.checkNotNullExpressionValue((Object)windowMetrics, (String)"params.parentWindowMetrics");
        WindowMetrics taskWindowMetrics = windowMetrics;
        Configuration configuration = params.getParentConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"params.parentConfiguration");
        Configuration taskConfiguration = configuration;
        WindowLayoutInfo windowLayoutInfo2 = params.getParentWindowLayoutInfo();
        Intrinsics.checkNotNullExpressionValue((Object)windowLayoutInfo2, (String)"params.parentWindowLayoutInfo");
        WindowLayoutInfo windowLayoutInfo3 = windowLayoutInfo2;
        androidx.window.extensions.embedding.SplitAttributes splitAttributes = params.getDefaultSplitAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)splitAttributes, (String)"params.defaultSplitAttributes");
        androidx.window.extensions.embedding.SplitAttributes defaultSplitAttributes = splitAttributes;
        boolean areDefaultConstraintsSatisfied = params.areDefaultConstraintsSatisfied();
        String splitRuleTag = params.getSplitRuleTag();
        androidx.window.layout.WindowMetrics windowMetrics2 = WindowMetricsCalculator.Companion.translateWindowMetrics$window_release(taskWindowMetrics);
        return new SplitAttributesCalculatorParams(windowMetrics2, taskConfiguration, ExtensionsWindowLayoutInfoAdapter.INSTANCE.translate$window_release(windowMetrics2, windowLayoutInfo3), this.translate$window_release(defaultSplitAttributes), areDefaultConstraintsSatisfied, splitRuleTag);
    }

    private final androidx.window.extensions.embedding.SplitPairRule translateSplitPairRule(Context context, SplitPairRule rule, Class<?> predicateClass) {
        if (this.getVendorApiLevel() < 2) {
            return this.api1Impl.translateSplitPairRuleCompat(context, rule, predicateClass);
        }
        Predicate activitiesPairPredicate = arg_0 -> EmbeddingAdapter.translateSplitPairRule$lambda$3(rule, arg_0);
        Predicate activityIntentPredicate = arg_0 -> EmbeddingAdapter.translateSplitPairRule$lambda$5(rule, arg_0);
        Predicate windowMetricsPredicate = arg_0 -> EmbeddingAdapter.translateSplitPairRule$lambda$6(rule, context, arg_0);
        String tag = rule.getTag();
        SplitPairRule.Builder builder = new SplitPairRule.Builder(activitiesPairPredicate, activityIntentPredicate, windowMetricsPredicate).setDefaultSplitAttributes(this.translateSplitAttributes(rule.getDefaultSplitAttributes())).setFinishPrimaryWithSecondary(this.translateFinishBehavior(rule.getFinishPrimaryWithSecondary())).setFinishSecondaryWithPrimary(this.translateFinishBehavior(rule.getFinishSecondaryWithPrimary())).setShouldClearTop(rule.getClearTop());
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"SplitPairRuleBuilder(\n  \u2026ldClearTop(rule.clearTop)");
        SplitPairRule.Builder builder2 = builder;
        if (tag != null) {
            builder2.setTag(tag);
        }
        androidx.window.extensions.embedding.SplitPairRule splitPairRule = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)splitPairRule, (String)"builder.build()");
        return splitPairRule;
    }

    @NotNull
    public final androidx.window.extensions.embedding.SplitAttributes translateSplitAttributes(@NotNull SplitAttributes splitAttributes) {
        int n;
        Intrinsics.checkNotNullParameter((Object)splitAttributes, (String)"splitAttributes");
        if (!(this.getVendorApiLevel() >= 2)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        SplitAttributes.Builder builder = new SplitAttributes.Builder().setSplitType(this.translateSplitType(splitAttributes.getSplitType()));
        SplitAttributes.LayoutDirection layoutDirection = splitAttributes.getLayoutDirection();
        if (Intrinsics.areEqual((Object)layoutDirection, (Object)SplitAttributes.LayoutDirection.LOCALE)) {
            n = 3;
        } else if (Intrinsics.areEqual((Object)layoutDirection, (Object)SplitAttributes.LayoutDirection.LEFT_TO_RIGHT)) {
            n = 0;
        } else if (Intrinsics.areEqual((Object)layoutDirection, (Object)SplitAttributes.LayoutDirection.RIGHT_TO_LEFT)) {
            n = 1;
        } else if (Intrinsics.areEqual((Object)layoutDirection, (Object)SplitAttributes.LayoutDirection.TOP_TO_BOTTOM)) {
            n = 4;
        } else if (Intrinsics.areEqual((Object)layoutDirection, (Object)SplitAttributes.LayoutDirection.BOTTOM_TO_TOP)) {
            n = 5;
        } else {
            throw new IllegalArgumentException("Unsupported layoutDirection:" + splitAttributes + ".layoutDirection");
        }
        androidx.window.extensions.embedding.SplitAttributes splitAttributes2 = builder.setLayoutDirection(n).build();
        Intrinsics.checkNotNullExpressionValue((Object)splitAttributes2, (String)"Builder()\n            .s\u2026   )\n            .build()");
        return splitAttributes2;
    }

    private final SplitAttributes.SplitType translateSplitType(SplitAttributes.SplitType splitType) {
        SplitAttributes.SplitType splitType2;
        if (!(this.getVendorApiLevel() >= 2)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        SplitAttributes.SplitType splitType3 = splitType;
        if (Intrinsics.areEqual((Object)splitType3, (Object)SplitAttributes.SplitType.SPLIT_TYPE_HINGE)) {
            splitType2 = (SplitAttributes.SplitType)new SplitAttributes.SplitType.HingeSplitType(this.translateSplitType(SplitAttributes.SplitType.SPLIT_TYPE_EQUAL));
        } else if (Intrinsics.areEqual((Object)splitType3, (Object)SplitAttributes.SplitType.SPLIT_TYPE_EXPAND)) {
            splitType2 = (SplitAttributes.SplitType)new SplitAttributes.SplitType.ExpandContainersSplitType();
        } else {
            float ratio2 = splitType.getValue$window_release();
            if (!((double)ratio2 > 0.0) || !((double)ratio2 < 1.0)) {
                throw new IllegalArgumentException("Unsupported SplitType: " + splitType + " with value: " + splitType.getValue$window_release());
            }
            splitType2 = (SplitAttributes.SplitType)new SplitAttributes.SplitType.RatioSplitType(ratio2);
        }
        return splitType2;
    }

    private final androidx.window.extensions.embedding.SplitPlaceholderRule translateSplitPlaceholderRule(Context context, SplitPlaceholderRule rule, Class<?> predicateClass) {
        if (this.getVendorApiLevel() < 2) {
            return this.api1Impl.translateSplitPlaceholderRuleCompat(context, rule, predicateClass);
        }
        Predicate activityPredicate = arg_0 -> EmbeddingAdapter.translateSplitPlaceholderRule$lambda$8(rule, arg_0);
        Predicate intentPredicate = arg_0 -> EmbeddingAdapter.translateSplitPlaceholderRule$lambda$10(rule, arg_0);
        Predicate windowMetricsPredicate = arg_0 -> EmbeddingAdapter.translateSplitPlaceholderRule$lambda$11(rule, context, arg_0);
        String tag = rule.getTag();
        SplitPlaceholderRule.Builder builder = new SplitPlaceholderRule.Builder(rule.getPlaceholderIntent(), activityPredicate, intentPredicate, windowMetricsPredicate).setSticky(rule.isSticky()).setDefaultSplitAttributes(this.translateSplitAttributes(rule.getDefaultSplitAttributes())).setFinishPrimaryWithPlaceholder(this.translateFinishBehavior(rule.getFinishPrimaryWithPlaceholder()));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"SplitPlaceholderRuleBuil\u2026holder)\n                )");
        SplitPlaceholderRule.Builder builder2 = builder;
        if (tag != null) {
            builder2.setTag(tag);
        }
        androidx.window.extensions.embedding.SplitPlaceholderRule splitPlaceholderRule = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)splitPlaceholderRule, (String)"builder.build()");
        return splitPlaceholderRule;
    }

    public final int translateFinishBehavior(@NotNull SplitRule.FinishBehavior behavior) {
        int n;
        Intrinsics.checkNotNullParameter((Object)behavior, (String)"behavior");
        SplitRule.FinishBehavior finishBehavior = behavior;
        if (Intrinsics.areEqual((Object)finishBehavior, (Object)SplitRule.FinishBehavior.NEVER)) {
            n = 0;
        } else if (Intrinsics.areEqual((Object)finishBehavior, (Object)SplitRule.FinishBehavior.ALWAYS)) {
            n = 1;
        } else if (Intrinsics.areEqual((Object)finishBehavior, (Object)SplitRule.FinishBehavior.ADJACENT)) {
            n = 2;
        } else {
            throw new IllegalArgumentException("Unknown finish behavior:" + behavior);
        }
        return n;
    }

    private final androidx.window.extensions.embedding.ActivityRule translateActivityRule(ActivityRule rule, Class<?> predicateClass) {
        if (this.getVendorApiLevel() < 2) {
            return this.api1Impl.translateActivityRuleCompat(rule, predicateClass);
        }
        Predicate activityPredicate = arg_0 -> EmbeddingAdapter.translateActivityRule$lambda$13(rule, arg_0);
        Predicate intentPredicate = arg_0 -> EmbeddingAdapter.translateActivityRule$lambda$15(rule, arg_0);
        ActivityRule.Builder builder = new ActivityRule.Builder(activityPredicate, intentPredicate).setShouldAlwaysExpand(rule.getAlwaysExpand());
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"ActivityRuleBuilder(acti\u2026Expand(rule.alwaysExpand)");
        ActivityRule.Builder builder2 = builder;
        String tag = rule.getTag();
        if (tag != null) {
            builder2.setTag(tag);
        }
        androidx.window.extensions.embedding.ActivityRule activityRule = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)activityRule, (String)"builder.build()");
        return activityRule;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<androidx.window.extensions.embedding.EmbeddingRule> translate(@NotNull Context context, @NotNull Set<? extends EmbeddingRule> rules) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(rules, (String)"rules");
        Class<?> clazz = this.predicateAdapter.predicateClassOrNull$window_release();
        if (clazz == null) {
            return SetsKt.emptySet();
        }
        Class<?> predicateClass = clazz;
        Iterable $this$map$iv = rules;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            androidx.window.extensions.embedding.EmbeddingRule embeddingRule;
            void rule;
            EmbeddingRule embeddingRule2 = (EmbeddingRule)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var13_13 = rule;
            if (var13_13 instanceof SplitPairRule) {
                embeddingRule = (androidx.window.extensions.embedding.EmbeddingRule)this.translateSplitPairRule(context, (SplitPairRule)rule, predicateClass);
            } else if (var13_13 instanceof SplitPlaceholderRule) {
                embeddingRule = (androidx.window.extensions.embedding.EmbeddingRule)this.translateSplitPlaceholderRule(context, (SplitPlaceholderRule)rule, predicateClass);
            } else if (var13_13 instanceof ActivityRule) {
                embeddingRule = (androidx.window.extensions.embedding.EmbeddingRule)this.translateActivityRule((ActivityRule)rule, predicateClass);
            } else {
                throw new IllegalArgumentException("Unsupported rule type");
            }
            collection.add(embeddingRule);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private static final androidx.window.extensions.embedding.SplitAttributes translateSplitAttributesCalculator$lambda$0(EmbeddingAdapter this$0, Function1 $calculator, androidx.window.extensions.embedding.SplitAttributesCalculatorParams oemParams) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$calculator, (String)"$calculator");
        Intrinsics.checkNotNullExpressionValue((Object)oemParams, (String)"oemParams");
        return this$0.translateSplitAttributes((SplitAttributes)$calculator.invoke((Object)this$0.translate(oemParams)));
    }

    private static final boolean translateSplitPairRule$lambda$3(SplitPairRule $rule, android.util.Pair activitiesPair) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$rule, (String)"$rule");
            Iterable $this$any$iv = $rule.getFilters();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SplitPairFilter filter = (SplitPairFilter)element$iv;
                    boolean bl2 = false;
                    Object object = activitiesPair.first;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"activitiesPair.first");
                    Activity activity = (Activity)object;
                    Object object2 = activitiesPair.second;
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"activitiesPair.second");
                    if (!filter.matchesActivityPair(activity, (Activity)object2)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean translateSplitPairRule$lambda$5(SplitPairRule $rule, android.util.Pair activityIntentPair) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$rule, (String)"$rule");
            Iterable $this$any$iv = $rule.getFilters();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SplitPairFilter filter = (SplitPairFilter)element$iv;
                    boolean bl2 = false;
                    Object object = activityIntentPair.first;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"activityIntentPair.first");
                    Activity activity = (Activity)object;
                    Object object2 = activityIntentPair.second;
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"activityIntentPair.second");
                    if (!filter.matchesActivityIntentPair(activity, (Intent)object2)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean translateSplitPairRule$lambda$6(SplitPairRule $rule, Context $context, WindowMetrics windowMetrics) {
        Intrinsics.checkNotNullParameter((Object)$rule, (String)"$rule");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullExpressionValue((Object)windowMetrics, (String)"windowMetrics");
        return $rule.checkParentMetrics$window_release($context, windowMetrics);
    }

    private static final boolean translateSplitPlaceholderRule$lambda$8(SplitPlaceholderRule $rule, Activity activity) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$rule, (String)"$rule");
            Iterable $this$any$iv = $rule.getFilters();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ActivityFilter filter = (ActivityFilter)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"activity");
                    if (!filter.matchesActivity(activity)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean translateSplitPlaceholderRule$lambda$10(SplitPlaceholderRule $rule, Intent intent) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$rule, (String)"$rule");
            Iterable $this$any$iv = $rule.getFilters();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ActivityFilter filter = (ActivityFilter)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"intent");
                    if (!filter.matchesIntent(intent)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean translateSplitPlaceholderRule$lambda$11(SplitPlaceholderRule $rule, Context $context, WindowMetrics windowMetrics) {
        Intrinsics.checkNotNullParameter((Object)$rule, (String)"$rule");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullExpressionValue((Object)windowMetrics, (String)"windowMetrics");
        return $rule.checkParentMetrics$window_release($context, windowMetrics);
    }

    private static final boolean translateActivityRule$lambda$13(ActivityRule $rule, Activity activity) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$rule, (String)"$rule");
            Iterable $this$any$iv = $rule.getFilters();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ActivityFilter filter = (ActivityFilter)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"activity");
                    if (!filter.matchesActivity(activity)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean translateActivityRule$lambda$15(ActivityRule $rule, Intent intent) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$rule, (String)"$rule");
            Iterable $this$any$iv = $rule.getFilters();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ActivityFilter filter = (ActivityFilter)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"intent");
                    if (!filter.matchesIntent(intent)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Landroidx/window/embedding/EmbeddingAdapter$Companion;", "", "()V", "INVALID_ACTIVITY_STACK_TOKEN", "Landroid/os/Binder;", "getINVALID_ACTIVITY_STACK_TOKEN", "()Landroid/os/Binder;", "INVALID_SPLIT_INFO_TOKEN", "getINVALID_SPLIT_INFO_TOKEN", "window_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Binder getINVALID_SPLIT_INFO_TOKEN() {
            return INVALID_SPLIT_INFO_TOKEN;
        }

        @NotNull
        public final Binder getINVALID_ACTIVITY_STACK_TOKEN() {
            return INVALID_ACTIVITY_STACK_TOKEN;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0002J\u0016\u0010\u000e\u001a\u00020\u00012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0003J\u0016\u0010\u0012\u001a\u00020\u00012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0003J\u0016\u0010\u0013\u001a\u00020\u00012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0010H\u0003J\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u001e\u001a\u00020\u00012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0010H\u0003J\u0018\u0010\u001f\u001a\u00020\u00012\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0003J\u001c\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020'0%2\u0006\u0010\r\u001a\u00020\bH\u0002J\"\u0010(\u001a\u00020)2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0018\u001a\u00020*2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bJ\"\u0010+\u001a\u00020,2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0018\u001a\u00020-2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bJ\u0014\u0010.\u001a\u00020/*\u00020/2\u0006\u00100\u001a\u00020\bH\u0002J\u0014\u0010.\u001a\u000201*\u0002012\u0006\u00100\u001a\u00020\bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u00062"}, d2={"Landroidx/window/embedding/EmbeddingAdapter$VendorApiLevel1Impl;", "", "predicateAdapter", "Landroidx/window/core/PredicateAdapter;", "(Landroidx/window/embedding/EmbeddingAdapter;Landroidx/window/core/PredicateAdapter;)V", "getPredicateAdapter", "()Landroidx/window/core/PredicateAdapter;", "getSplitAttributesCompat", "Landroidx/window/embedding/SplitAttributes;", "splitInfo", "Landroidx/window/extensions/embedding/SplitInfo;", "isSplitAttributesSupported", "", "attrs", "translateActivityIntentPredicates", "splitPairFilters", "", "Landroidx/window/embedding/SplitPairFilter;", "translateActivityPairPredicates", "translateActivityPredicates", "activityFilters", "Landroidx/window/embedding/ActivityFilter;", "translateActivityRuleCompat", "Landroidx/window/extensions/embedding/ActivityRule;", "rule", "Landroidx/window/embedding/ActivityRule;", "predicateClass", "Ljava/lang/Class;", "translateCompat", "Landroidx/window/embedding/SplitInfo;", "translateIntentPredicates", "translateParentMetricsPredicate", "context", "Landroid/content/Context;", "splitRule", "Landroidx/window/embedding/SplitRule;", "translateSplitAttributesCompatInternal", "Lkotlin/Pair;", "", "", "translateSplitPairRuleCompat", "Landroidx/window/extensions/embedding/SplitPairRule;", "Landroidx/window/embedding/SplitPairRule;", "translateSplitPlaceholderRuleCompat", "Landroidx/window/extensions/embedding/SplitPlaceholderRule;", "Landroidx/window/embedding/SplitPlaceholderRule;", "setDefaultSplitAttributesCompat", "Landroidx/window/extensions/embedding/SplitPairRule$Builder;", "defaultAttrs", "Landroidx/window/extensions/embedding/SplitPlaceholderRule$Builder;", "window_release"})
    private final class VendorApiLevel1Impl {
        @NotNull
        private final PredicateAdapter predicateAdapter;

        public VendorApiLevel1Impl(PredicateAdapter predicateAdapter) {
            Intrinsics.checkNotNullParameter((Object)predicateAdapter, (String)"predicateAdapter");
            this.predicateAdapter = predicateAdapter;
        }

        @NotNull
        public final PredicateAdapter getPredicateAdapter() {
            return this.predicateAdapter;
        }

        @NotNull
        public final SplitAttributes getSplitAttributesCompat(@NotNull androidx.window.extensions.embedding.SplitInfo splitInfo) {
            Intrinsics.checkNotNullParameter((Object)splitInfo, (String)"splitInfo");
            return new SplitAttributes.Builder().setSplitType(SplitAttributes.SplitType.Companion.buildSplitTypeFromValue$window_release(splitInfo.getSplitRatio())).setLayoutDirection(SplitAttributes.LayoutDirection.LOCALE).build();
        }

        @NotNull
        public final androidx.window.extensions.embedding.ActivityRule translateActivityRuleCompat(@NotNull ActivityRule rule, @NotNull Class<?> predicateClass) {
            Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
            Intrinsics.checkNotNullParameter(predicateClass, (String)"predicateClass");
            Object[] objectArray = new Class[]{predicateClass, predicateClass};
            Constructor constructor = ActivityRule.Builder.class.getConstructor((Class<?>[])objectArray);
            objectArray = new Object[]{this.translateActivityPredicates(rule.getFilters()), this.translateIntentPredicates(rule.getFilters())};
            androidx.window.extensions.embedding.ActivityRule activityRule = ((ActivityRule.Builder)constructor.newInstance(objectArray)).setShouldAlwaysExpand(rule.getAlwaysExpand()).build();
            Intrinsics.checkNotNullExpressionValue((Object)activityRule, (String)"ActivityRuleBuilder::cla\u2026\n                .build()");
            return activityRule;
        }

        @NotNull
        public final androidx.window.extensions.embedding.SplitPlaceholderRule translateSplitPlaceholderRuleCompat(@NotNull Context context, @NotNull SplitPlaceholderRule rule, @NotNull Class<?> predicateClass) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
            Intrinsics.checkNotNullParameter(predicateClass, (String)"predicateClass");
            Object[] objectArray = new Class[]{Intent.class, predicateClass, predicateClass, predicateClass};
            Constructor constructor = SplitPlaceholderRule.Builder.class.getConstructor((Class<?>[])objectArray);
            objectArray = new Object[]{rule.getPlaceholderIntent(), this.translateActivityPredicates(rule.getFilters()), this.translateIntentPredicates(rule.getFilters()), this.translateParentMetricsPredicate(context, rule)};
            SplitPlaceholderRule.Builder builder = ((SplitPlaceholderRule.Builder)constructor.newInstance(objectArray)).setSticky(rule.isSticky()).setFinishPrimaryWithSecondary(EmbeddingAdapter.this.translateFinishBehavior(rule.getFinishPrimaryWithPlaceholder()));
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"SplitPlaceholderRuleBuil\u2026holder)\n                )");
            androidx.window.extensions.embedding.SplitPlaceholderRule splitPlaceholderRule = this.setDefaultSplitAttributesCompat(builder, rule.getDefaultSplitAttributes()).build();
            Intrinsics.checkNotNullExpressionValue((Object)splitPlaceholderRule, (String)"SplitPlaceholderRuleBuil\u2026\n                .build()");
            return splitPlaceholderRule;
        }

        private final SplitPlaceholderRule.Builder setDefaultSplitAttributesCompat(SplitPlaceholderRule.Builder $this$setDefaultSplitAttributesCompat, SplitAttributes defaultAttrs) {
            SplitPlaceholderRule.Builder builder;
            SplitPlaceholderRule.Builder $this$setDefaultSplitAttributesCompat_u24lambda_u240 = builder = $this$setDefaultSplitAttributesCompat;
            boolean bl = false;
            Pair<Float, Integer> pair = this.translateSplitAttributesCompatInternal(defaultAttrs);
            float splitRatio = ((Number)pair.component1()).floatValue();
            int layoutDirection = ((Number)pair.component2()).intValue();
            $this$setDefaultSplitAttributesCompat_u24lambda_u240.setSplitRatio(splitRatio);
            $this$setDefaultSplitAttributesCompat_u24lambda_u240.setLayoutDirection(layoutDirection);
            return builder;
        }

        @NotNull
        public final androidx.window.extensions.embedding.SplitPairRule translateSplitPairRuleCompat(@NotNull Context context, @NotNull SplitPairRule rule, @NotNull Class<?> predicateClass) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)rule, (String)"rule");
            Intrinsics.checkNotNullParameter(predicateClass, (String)"predicateClass");
            Object[] objectArray = new Class[]{predicateClass, predicateClass, predicateClass};
            Constructor constructor = SplitPairRule.Builder.class.getConstructor((Class<?>[])objectArray);
            objectArray = new Object[]{this.translateActivityPairPredicates(rule.getFilters()), this.translateActivityIntentPredicates(rule.getFilters()), this.translateParentMetricsPredicate(context, rule)};
            Object t = constructor.newInstance(objectArray);
            Intrinsics.checkNotNullExpressionValue(t, (String)"SplitPairRuleBuilder::cl\u2026text, rule)\n            )");
            androidx.window.extensions.embedding.SplitPairRule splitPairRule = this.setDefaultSplitAttributesCompat((SplitPairRule.Builder)t, rule.getDefaultSplitAttributes()).setShouldClearTop(rule.getClearTop()).setFinishPrimaryWithSecondary(EmbeddingAdapter.this.translateFinishBehavior(rule.getFinishPrimaryWithSecondary())).setFinishSecondaryWithPrimary(EmbeddingAdapter.this.translateFinishBehavior(rule.getFinishSecondaryWithPrimary())).build();
            Intrinsics.checkNotNullExpressionValue((Object)splitPairRule, (String)"SplitPairRuleBuilder::cl\u2026                ).build()");
            return splitPairRule;
        }

        @SuppressLint(value={"ClassVerificationFailure", "NewApi"})
        private final Object translateActivityPairPredicates(Set<SplitPairFilter> splitPairFilters) {
            return this.predicateAdapter.buildPairPredicate(Reflection.getOrCreateKotlinClass(Activity.class), Reflection.getOrCreateKotlinClass(Activity.class), (Function2)new Function2<Activity, Activity, Boolean>(splitPairFilters){
                final /* synthetic */ Set<SplitPairFilter> $splitPairFilters;
                {
                    this.$splitPairFilters = $splitPairFilters;
                    super(2);
                }

                @NotNull
                public final Boolean invoke(@NotNull Activity first, @NotNull Activity second) {
                    boolean bl;
                    block3: {
                        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
                        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
                        Iterable $this$any$iv = this.$splitPairFilters;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                SplitPairFilter filter = (SplitPairFilter)element$iv;
                                boolean bl2 = false;
                                if (!filter.matchesActivityPair(first, second)) continue;
                                bl = true;
                                break block3;
                            }
                            bl = false;
                        }
                    }
                    return bl;
                }
            });
        }

        @SuppressLint(value={"ClassVerificationFailure", "NewApi"})
        private final Object translateActivityIntentPredicates(Set<SplitPairFilter> splitPairFilters) {
            return this.predicateAdapter.buildPairPredicate(Reflection.getOrCreateKotlinClass(Activity.class), Reflection.getOrCreateKotlinClass(Intent.class), (Function2)new Function2<Activity, Intent, Boolean>(splitPairFilters){
                final /* synthetic */ Set<SplitPairFilter> $splitPairFilters;
                {
                    this.$splitPairFilters = $splitPairFilters;
                    super(2);
                }

                @NotNull
                public final Boolean invoke(@NotNull Activity first, @NotNull Intent second) {
                    boolean bl;
                    block3: {
                        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
                        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
                        Iterable $this$any$iv = this.$splitPairFilters;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                SplitPairFilter filter = (SplitPairFilter)element$iv;
                                boolean bl2 = false;
                                if (!filter.matchesActivityIntentPair(first, second)) continue;
                                bl = true;
                                break block3;
                            }
                            bl = false;
                        }
                    }
                    return bl;
                }
            });
        }

        private final SplitPairRule.Builder setDefaultSplitAttributesCompat(SplitPairRule.Builder $this$setDefaultSplitAttributesCompat, SplitAttributes defaultAttrs) {
            SplitPairRule.Builder builder;
            SplitPairRule.Builder $this$setDefaultSplitAttributesCompat_u24lambda_u241 = builder = $this$setDefaultSplitAttributesCompat;
            boolean bl = false;
            Pair<Float, Integer> pair = this.translateSplitAttributesCompatInternal(defaultAttrs);
            float splitRatio = ((Number)pair.component1()).floatValue();
            int layoutDirection = ((Number)pair.component2()).intValue();
            $this$setDefaultSplitAttributesCompat_u24lambda_u241.setSplitRatio(splitRatio);
            $this$setDefaultSplitAttributesCompat_u24lambda_u241.setLayoutDirection(layoutDirection);
            return builder;
        }

        private final Pair<Float, Integer> translateSplitAttributesCompatInternal(SplitAttributes attrs) {
            Pair pair;
            if (!this.isSplitAttributesSupported(attrs)) {
                pair = new Pair((Object)Float.valueOf(0.0f), (Object)3);
            } else {
                int n;
                Float f = Float.valueOf(attrs.getSplitType().getValue$window_release());
                SplitAttributes.LayoutDirection layoutDirection = attrs.getLayoutDirection();
                if (Intrinsics.areEqual((Object)layoutDirection, (Object)SplitAttributes.LayoutDirection.LOCALE)) {
                    n = 3;
                } else if (Intrinsics.areEqual((Object)layoutDirection, (Object)SplitAttributes.LayoutDirection.LEFT_TO_RIGHT)) {
                    n = 0;
                } else if (Intrinsics.areEqual((Object)layoutDirection, (Object)SplitAttributes.LayoutDirection.RIGHT_TO_LEFT)) {
                    n = 1;
                } else {
                    throw new IllegalStateException("Unsupported layout direction must be covered in @isSplitAttributesSupported!");
                }
                pair = new Pair((Object)f, (Object)n);
            }
            return pair;
        }

        private final boolean isSplitAttributesSupported(SplitAttributes attrs) {
            Object[] objectArray;
            double d = attrs.getSplitType().getValue$window_release();
            return (0.0 <= d ? d <= 1.0 : false) && !(attrs.getSplitType().getValue$window_release() == 1.0f) && ArraysKt.contains((Object[])(objectArray = new SplitAttributes.LayoutDirection[]{SplitAttributes.LayoutDirection.LEFT_TO_RIGHT, SplitAttributes.LayoutDirection.RIGHT_TO_LEFT, SplitAttributes.LayoutDirection.LOCALE}), (Object)attrs.getLayoutDirection());
        }

        @SuppressLint(value={"ClassVerificationFailure", "NewApi"})
        private final Object translateActivityPredicates(Set<ActivityFilter> activityFilters) {
            return this.predicateAdapter.buildPredicate(Reflection.getOrCreateKotlinClass(Activity.class), (Function1)new Function1<Activity, Boolean>(activityFilters){
                final /* synthetic */ Set<ActivityFilter> $activityFilters;
                {
                    this.$activityFilters = $activityFilters;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Activity activity) {
                    boolean bl;
                    block3: {
                        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
                        Iterable $this$any$iv = this.$activityFilters;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                ActivityFilter filter = (ActivityFilter)element$iv;
                                boolean bl2 = false;
                                if (!filter.matchesActivity(activity)) continue;
                                bl = true;
                                break block3;
                            }
                            bl = false;
                        }
                    }
                    return bl;
                }
            });
        }

        @SuppressLint(value={"ClassVerificationFailure", "NewApi"})
        private final Object translateIntentPredicates(Set<ActivityFilter> activityFilters) {
            return this.predicateAdapter.buildPredicate(Reflection.getOrCreateKotlinClass(Intent.class), (Function1)new Function1<Intent, Boolean>(activityFilters){
                final /* synthetic */ Set<ActivityFilter> $activityFilters;
                {
                    this.$activityFilters = $activityFilters;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Intent intent) {
                    boolean bl;
                    block3: {
                        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                        Iterable $this$any$iv = this.$activityFilters;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                ActivityFilter filter = (ActivityFilter)element$iv;
                                boolean bl2 = false;
                                if (!filter.matchesIntent(intent)) continue;
                                bl = true;
                                break block3;
                            }
                            bl = false;
                        }
                    }
                    return bl;
                }
            });
        }

        @SuppressLint(value={"ClassVerificationFailure", "NewApi"})
        private final Object translateParentMetricsPredicate(Context context, SplitRule splitRule) {
            return this.predicateAdapter.buildPredicate(Reflection.getOrCreateKotlinClass(WindowMetrics.class), (Function1)new Function1<WindowMetrics, Boolean>(splitRule, context){
                final /* synthetic */ SplitRule $splitRule;
                final /* synthetic */ Context $context;
                {
                    this.$splitRule = $splitRule;
                    this.$context = $context;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull WindowMetrics windowMetrics) {
                    Intrinsics.checkNotNullParameter((Object)windowMetrics, (String)"windowMetrics");
                    return this.$splitRule.checkParentMetrics$window_release(this.$context, windowMetrics);
                }
            });
        }

        @NotNull
        public final SplitInfo translateCompat(@NotNull androidx.window.extensions.embedding.SplitInfo splitInfo) {
            Intrinsics.checkNotNullParameter((Object)splitInfo, (String)"splitInfo");
            List list = splitInfo.getPrimaryActivityStack().getActivities();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"splitInfo.primaryActivityStack.activities");
            ActivityStack activityStack = new ActivityStack(list, splitInfo.getPrimaryActivityStack().isEmpty());
            List list2 = splitInfo.getSecondaryActivityStack().getActivities();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"splitInfo.secondaryActivityStack.activities");
            return new SplitInfo(activityStack, new ActivityStack(list2, splitInfo.getSecondaryActivityStack().isEmpty()), this.getSplitAttributesCompat(splitInfo), (IBinder)Companion.getINVALID_SPLIT_INFO_TOKEN());
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/window/embedding/EmbeddingAdapter$VendorApiLevel2Impl;", "", "(Landroidx/window/embedding/EmbeddingAdapter;)V", "translateCompat", "Landroidx/window/embedding/SplitInfo;", "splitInfo", "Landroidx/window/extensions/embedding/SplitInfo;", "window_release"})
    private final class VendorApiLevel2Impl {
        @NotNull
        public final SplitInfo translateCompat(@NotNull androidx.window.extensions.embedding.SplitInfo splitInfo) {
            Intrinsics.checkNotNullParameter((Object)splitInfo, (String)"splitInfo");
            androidx.window.extensions.embedding.ActivityStack activityStack = splitInfo.getPrimaryActivityStack();
            Intrinsics.checkNotNullExpressionValue((Object)activityStack, (String)"splitInfo.primaryActivityStack");
            androidx.window.extensions.embedding.ActivityStack primaryActivityStack = activityStack;
            List list = primaryActivityStack.getActivities();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"primaryActivityStack.activities");
            ActivityStack primaryFragment = new ActivityStack(list, primaryActivityStack.isEmpty());
            androidx.window.extensions.embedding.ActivityStack activityStack2 = splitInfo.getSecondaryActivityStack();
            Intrinsics.checkNotNullExpressionValue((Object)activityStack2, (String)"splitInfo.secondaryActivityStack");
            androidx.window.extensions.embedding.ActivityStack secondaryActivityStack = activityStack2;
            List list2 = secondaryActivityStack.getActivities();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"secondaryActivityStack.activities");
            ActivityStack secondaryFragment = new ActivityStack(list2, secondaryActivityStack.isEmpty());
            androidx.window.extensions.embedding.SplitAttributes splitAttributes = splitInfo.getSplitAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)splitAttributes, (String)"splitInfo.splitAttributes");
            return new SplitInfo(primaryFragment, secondaryFragment, EmbeddingAdapter.this.translate$window_release(splitAttributes), (IBinder)Companion.getINVALID_SPLIT_INFO_TOKEN());
        }
    }
}

