/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.embedding;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import androidx.window.core.ActivityComponentInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u000bJ\u001d\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u000fJ\u001d\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0013J\u001d\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0018J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Landroidx/window/embedding/MatcherUtils;", "", "()V", "sDebugMatchers", "", "sMatchersTag", "", "areComponentsMatching", "activityComponent", "Landroidx/window/core/ActivityComponentInfo;", "ruleComponent", "areComponentsMatching$window_release", "isActivityMatching", "activity", "Landroid/app/Activity;", "isActivityMatching$window_release", "isIntentMatching", "intent", "Landroid/content/Intent;", "isIntentMatching$window_release", "validateComponentName", "", "packageName", "className", "validateComponentName$window_release", "wildcardMatch", "name", "pattern", "window_release"})
@SourceDebugExtension(value={"SMAP\nMatcherUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MatcherUtils.kt\nandroidx/window/embedding/MatcherUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1#2:137\n*E\n"})
public final class MatcherUtils {
    @NotNull
    public static final MatcherUtils INSTANCE = new MatcherUtils();
    public static final boolean sDebugMatchers = false;
    @NotNull
    public static final String sMatchersTag = "SplitRuleResolution";

    private MatcherUtils() {
    }

    public final boolean areComponentsMatching$window_release(@Nullable ActivityComponentInfo activityComponent, @NotNull ActivityComponentInfo ruleComponent) {
        Intrinsics.checkNotNullParameter((Object)ruleComponent, (String)"ruleComponent");
        if (activityComponent == null) {
            return Intrinsics.areEqual((Object)ruleComponent.getPackageName(), (Object)"*") && Intrinsics.areEqual((Object)ruleComponent.getClassName(), (Object)"*");
        }
        if (!(!StringsKt.contains$default((CharSequence)activityComponent.toString(), (CharSequence)"*", (boolean)false, (int)2, null))) {
            boolean $i$a$-require-MatcherUtils$areComponentsMatching$22 = false;
            String $i$a$-require-MatcherUtils$areComponentsMatching$22 = "Wildcard can only be part of the rule.";
            throw new IllegalArgumentException($i$a$-require-MatcherUtils$areComponentsMatching$22.toString());
        }
        boolean packagesMatch = Intrinsics.areEqual((Object)activityComponent.getPackageName(), (Object)ruleComponent.getPackageName()) || this.wildcardMatch(activityComponent.getPackageName(), ruleComponent.getPackageName());
        boolean classesMatch = Intrinsics.areEqual((Object)activityComponent.getClassName(), (Object)ruleComponent.getClassName()) || this.wildcardMatch(activityComponent.getClassName(), ruleComponent.getClassName());
        return packagesMatch && classesMatch;
    }

    public final boolean isActivityMatching$window_release(@NotNull Activity activity, @NotNull ActivityComponentInfo ruleComponent) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)ruleComponent, (String)"ruleComponent");
        ComponentName componentName = activity.getComponentName();
        Intrinsics.checkNotNullExpressionValue((Object)componentName, (String)"activity.componentName");
        if (this.areComponentsMatching$window_release(new ActivityComponentInfo(componentName), ruleComponent)) {
            return true;
        }
        Intent intent = activity.getIntent();
        if (intent != null) {
            Intent intent2 = intent;
            boolean bl2 = false;
            bl = INSTANCE.isIntentMatching$window_release(intent2, ruleComponent);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isIntentMatching$window_release(@NotNull Intent intent, @NotNull ActivityComponentInfo ruleComponent) {
        ActivityComponentInfo activityComponentInfo;
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter((Object)ruleComponent, (String)"ruleComponent");
        MatcherUtils matcherUtils = this;
        ComponentName componentName = intent.getComponent();
        if (componentName != null) {
            void p0;
            ComponentName componentName2 = componentName;
            MatcherUtils matcherUtils2 = matcherUtils;
            boolean bl = false;
            activityComponentInfo = new ActivityComponentInfo((ComponentName)p0);
            matcherUtils = matcherUtils2;
        } else {
            activityComponentInfo = null;
        }
        if (matcherUtils.areComponentsMatching$window_release(activityComponentInfo, ruleComponent)) {
            return true;
        }
        if (intent.getComponent() != null) {
            return false;
        }
        String string = intent.getPackage();
        if (string == null) {
            return false;
        }
        String packageName = string;
        return (Intrinsics.areEqual((Object)packageName, (Object)ruleComponent.getPackageName()) || this.wildcardMatch(packageName, ruleComponent.getPackageName())) && Intrinsics.areEqual((Object)ruleComponent.getClassName(), (Object)"*");
    }

    private final boolean wildcardMatch(String name, String pattern) {
        if (!StringsKt.contains$default((CharSequence)pattern, (CharSequence)"*", (boolean)false, (int)2, null)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)pattern, (Object)"*")) {
            return true;
        }
        if (!(StringsKt.indexOf$default((CharSequence)pattern, (String)"*", (int)0, (boolean)false, (int)6, null) == StringsKt.lastIndexOf$default((CharSequence)pattern, (String)"*", (int)0, (boolean)false, (int)6, null) && StringsKt.endsWith$default((String)pattern, (String)"*", (boolean)false, (int)2, null))) {
            boolean bl = false;
            String string = "Name pattern with a wildcard must only contain a single wildcard in the end";
            throw new IllegalArgumentException(string.toString());
        }
        String string = pattern.substring(0, pattern.length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return StringsKt.startsWith$default((String)name, (String)string, (boolean)false, (int)2, null);
    }

    public final void validateComponentName$window_release(@NotNull String packageName, @NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        if (!(((CharSequence)packageName).length() > 0)) {
            boolean $i$a$-require-MatcherUtils$validateComponentName$52 = false;
            String $i$a$-require-MatcherUtils$validateComponentName$52 = "Package name must not be empty";
            throw new IllegalArgumentException($i$a$-require-MatcherUtils$validateComponentName$52.toString());
        }
        if (!(((CharSequence)className).length() > 0)) {
            boolean $i$a$-require-MatcherUtils$validateComponentName$62 = false;
            String $i$a$-require-MatcherUtils$validateComponentName$62 = "Activity class name must not be empty";
            throw new IllegalArgumentException($i$a$-require-MatcherUtils$validateComponentName$62.toString());
        }
        if (!(!StringsKt.contains$default((CharSequence)packageName, (CharSequence)"*", (boolean)false, (int)2, null) || StringsKt.indexOf$default((CharSequence)packageName, (String)"*", (int)0, (boolean)false, (int)6, null) == packageName.length() - 1)) {
            boolean $i$a$-require-MatcherUtils$validateComponentName$72 = false;
            String $i$a$-require-MatcherUtils$validateComponentName$72 = "Wildcard in package name is only allowed at the end.";
            throw new IllegalArgumentException($i$a$-require-MatcherUtils$validateComponentName$72.toString());
        }
        if (!(!StringsKt.contains$default((CharSequence)className, (CharSequence)"*", (boolean)false, (int)2, null) || StringsKt.indexOf$default((CharSequence)className, (String)"*", (int)0, (boolean)false, (int)6, null) == className.length() - 1)) {
            boolean bl = false;
            String string = "Wildcard in class name is only allowed at the end.";
            throw new IllegalArgumentException(string.toString());
        }
    }
}

