/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.embedding;

import android.app.Activity;
import androidx.annotation.VisibleForTesting;
import androidx.window.SafeWindowExtensionsProvider;
import androidx.window.core.ConsumerAdapter;
import androidx.window.core.ExtensionsUtil;
import androidx.window.embedding.SafeActivityEmbeddingComponentProvider;
import androidx.window.extensions.WindowExtensions;
import androidx.window.extensions.core.util.function.Consumer;
import androidx.window.extensions.core.util.function.Function;
import androidx.window.extensions.embedding.ActivityEmbeddingComponent;
import androidx.window.reflection.ReflectionUtils;
import java.lang.reflect.Method;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0015\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0013\u001a\u00020\u0014H\u0002J\r\u0010\u0015\u001a\u00020\u0014H\u0001\u00a2\u0006\u0002\b\u0016J\r\u0010\u0017\u001a\u00020\u0014H\u0001\u00a2\u0006\u0002\b\u0018J\r\u0010\u0019\u001a\u00020\u0014H\u0001\u00a2\u0006\u0002\b\u001aJ\b\u0010\u001b\u001a\u00020\u0014H\u0002J\b\u0010\u001c\u001a\u00020\u0014H\u0002J\b\u0010\u001d\u001a\u00020\u0014H\u0002J\b\u0010\u001e\u001a\u00020\u0014H\u0002J\b\u0010\u001f\u001a\u00020\u0014H\u0002J\b\u0010 \u001a\u00020\u0014H\u0002J\b\u0010!\u001a\u00020\u0014H\u0002J\b\u0010\"\u001a\u00020\u0014H\u0002J\b\u0010#\u001a\u00020\u0014H\u0002J\b\u0010$\u001a\u00020\u0014H\u0002J\b\u0010%\u001a\u00020\u0014H\u0002J\b\u0010&\u001a\u00020\u0014H\u0002J\b\u0010'\u001a\u00020\u0014H\u0002J\b\u0010(\u001a\u00020\u0014H\u0002R\u0013\u0010\t\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Landroidx/window/embedding/SafeActivityEmbeddingComponentProvider;", "", "loader", "Ljava/lang/ClassLoader;", "consumerAdapter", "Landroidx/window/core/ConsumerAdapter;", "windowExtensions", "Landroidx/window/extensions/WindowExtensions;", "(Ljava/lang/ClassLoader;Landroidx/window/core/ConsumerAdapter;Landroidx/window/extensions/WindowExtensions;)V", "activityEmbeddingComponent", "Landroidx/window/extensions/embedding/ActivityEmbeddingComponent;", "getActivityEmbeddingComponent", "()Landroidx/window/extensions/embedding/ActivityEmbeddingComponent;", "activityEmbeddingComponentClass", "Ljava/lang/Class;", "getActivityEmbeddingComponentClass", "()Ljava/lang/Class;", "safeWindowExtensionsProvider", "Landroidx/window/SafeWindowExtensionsProvider;", "canUseActivityEmbeddingComponent", "", "hasValidVendorApiLevel1", "hasValidVendorApiLevel1$window_release", "hasValidVendorApiLevel2", "hasValidVendorApiLevel2$window_release", "isActivityEmbeddingComponentAccessible", "isActivityEmbeddingComponentAccessible$window_release", "isActivityEmbeddingComponentValid", "isClassActivityRuleValid", "isClassSplitAttributesValid", "isClassSplitInfoValid", "isClassSplitPairRuleValid", "isClassSplitPlaceholderRuleValid", "isClassSplitTypeValid", "isMethodClearSplitInfoCallbackValid", "isMethodGetSplitAttributesValid", "isMethodIsActivityEmbeddedValid", "isMethodSetEmbeddingRulesValid", "isMethodSetSplitInfoCallbackJavaConsumerValid", "isMethodSetSplitInfoCallbackWindowConsumerValid", "isMethodSplitAttributesCalculatorValid", "window_release"})
public final class SafeActivityEmbeddingComponentProvider {
    @NotNull
    private final ClassLoader loader;
    @NotNull
    private final ConsumerAdapter consumerAdapter;
    @NotNull
    private final WindowExtensions windowExtensions;
    @NotNull
    private final SafeWindowExtensionsProvider safeWindowExtensionsProvider;

    public SafeActivityEmbeddingComponentProvider(@NotNull ClassLoader loader, @NotNull ConsumerAdapter consumerAdapter, @NotNull WindowExtensions windowExtensions) {
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        Intrinsics.checkNotNullParameter((Object)consumerAdapter, (String)"consumerAdapter");
        Intrinsics.checkNotNullParameter((Object)windowExtensions, (String)"windowExtensions");
        this.loader = loader;
        this.consumerAdapter = consumerAdapter;
        this.windowExtensions = windowExtensions;
        this.safeWindowExtensionsProvider = new SafeWindowExtensionsProvider(this.loader);
    }

    @Nullable
    public final ActivityEmbeddingComponent getActivityEmbeddingComponent() {
        ActivityEmbeddingComponent activityEmbeddingComponent;
        if (this.canUseActivityEmbeddingComponent()) {
            ActivityEmbeddingComponent activityEmbeddingComponent2;
            try {
                activityEmbeddingComponent2 = this.windowExtensions.getActivityEmbeddingComponent();
            }
            catch (UnsupportedOperationException e) {
                activityEmbeddingComponent2 = null;
            }
            activityEmbeddingComponent = activityEmbeddingComponent2;
        } else {
            activityEmbeddingComponent = null;
        }
        return activityEmbeddingComponent;
    }

    private final boolean canUseActivityEmbeddingComponent() {
        if (!this.isActivityEmbeddingComponentAccessible$window_release()) {
            return false;
        }
        int n = ExtensionsUtil.INSTANCE.getSafeVendorApiLevel();
        return n == 1 ? this.hasValidVendorApiLevel1$window_release() : ((2 <= n ? n <= Integer.MAX_VALUE : false) ? this.hasValidVendorApiLevel2$window_release() : false);
    }

    @VisibleForTesting
    public final boolean isActivityEmbeddingComponentAccessible$window_release() {
        return this.safeWindowExtensionsProvider.isWindowExtensionsValid$window_release() && this.isActivityEmbeddingComponentValid();
    }

    @VisibleForTesting
    public final boolean hasValidVendorApiLevel1$window_release() {
        return this.isMethodSetEmbeddingRulesValid() && this.isMethodIsActivityEmbeddedValid() && this.isMethodSetSplitInfoCallbackJavaConsumerValid() && this.isClassActivityRuleValid() && this.isClassSplitInfoValid() && this.isClassSplitPairRuleValid() && this.isClassSplitPlaceholderRuleValid();
    }

    @VisibleForTesting
    public final boolean hasValidVendorApiLevel2$window_release() {
        return this.hasValidVendorApiLevel1$window_release() && this.isMethodSetSplitInfoCallbackWindowConsumerValid() && this.isMethodClearSplitInfoCallbackValid() && this.isMethodSplitAttributesCalculatorValid() && this.isMethodGetSplitAttributesValid() && this.isClassSplitAttributesValid() && this.isClassSplitTypeValid();
    }

    private final boolean isMethodSetEmbeddingRulesValid() {
        return ReflectionUtils.validateReflection$window_release("ActivityEmbeddingComponent#setEmbeddingRules is not valid", (Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ SafeActivityEmbeddingComponentProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                Class[] classArray = new Class[]{Set.class};
                Method setEmbeddingRulesMethod = SafeActivityEmbeddingComponentProvider.access$getActivityEmbeddingComponentClass(this.this$0).getMethod("setEmbeddingRules", classArray);
                Intrinsics.checkNotNullExpressionValue((Object)setEmbeddingRulesMethod, (String)"setEmbeddingRulesMethod");
                return ReflectionUtils.INSTANCE.isPublic$window_release(setEmbeddingRulesMethod);
            }
        }));
    }

    private final boolean isMethodIsActivityEmbeddedValid() {
        return ReflectionUtils.validateReflection$window_release("ActivityEmbeddingComponent#isActivityEmbedded is not valid", (Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ SafeActivityEmbeddingComponentProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                Class[] classArray = new Class[]{Activity.class};
                Method isActivityEmbeddedMethod = SafeActivityEmbeddingComponentProvider.access$getActivityEmbeddingComponentClass(this.this$0).getMethod("isActivityEmbedded", classArray);
                Intrinsics.checkNotNullExpressionValue((Object)isActivityEmbeddedMethod, (String)"isActivityEmbeddedMethod");
                return ReflectionUtils.INSTANCE.isPublic$window_release(isActivityEmbeddedMethod) && ReflectionUtils.INSTANCE.doesReturn$window_release(isActivityEmbeddedMethod, Boolean.TYPE);
            }
        }));
    }

    private final boolean isMethodClearSplitInfoCallbackValid() {
        return ReflectionUtils.validateReflection$window_release("ActivityEmbeddingComponent#clearSplitInfoCallback is not valid", (Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ SafeActivityEmbeddingComponentProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                Method clearSplitInfoCallbackMethod = SafeActivityEmbeddingComponentProvider.access$getActivityEmbeddingComponentClass(this.this$0).getMethod("clearSplitInfoCallback", new Class[0]);
                Intrinsics.checkNotNullExpressionValue((Object)clearSplitInfoCallbackMethod, (String)"clearSplitInfoCallbackMethod");
                return ReflectionUtils.INSTANCE.isPublic$window_release(clearSplitInfoCallbackMethod);
            }
        }));
    }

    private final boolean isMethodSplitAttributesCalculatorValid() {
        return ReflectionUtils.validateReflection$window_release("ActivityEmbeddingComponent#setSplitAttributesCalculator is not valid", (Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ SafeActivityEmbeddingComponentProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke() {
                boolean bl;
                Class[] classArray = new Class[]{Function.class};
                Method setSplitAttributesCalculatorMethod = SafeActivityEmbeddingComponentProvider.access$getActivityEmbeddingComponentClass(this.this$0).getMethod("setSplitAttributesCalculator", classArray);
                Method clearSplitAttributesCalculatorMethod = SafeActivityEmbeddingComponentProvider.access$getActivityEmbeddingComponentClass(this.this$0).getMethod("clearSplitAttributesCalculator", new Class[0]);
                Intrinsics.checkNotNullExpressionValue((Object)setSplitAttributesCalculatorMethod, (String)"setSplitAttributesCalculatorMethod");
                if (ReflectionUtils.INSTANCE.isPublic$window_release(setSplitAttributesCalculatorMethod)) {
                    Intrinsics.checkNotNullExpressionValue((Object)clearSplitAttributesCalculatorMethod, (String)"clearSplitAttributesCalculatorMethod");
                    if (ReflectionUtils.INSTANCE.isPublic$window_release(clearSplitAttributesCalculatorMethod)) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        }));
    }

    private final boolean isMethodGetSplitAttributesValid() {
        return ReflectionUtils.validateReflection$window_release("SplitInfo#getSplitAttributes is not valid", (Function0<Boolean>)((Function0)isMethodGetSplitAttributesValid.1.INSTANCE));
    }

    private final boolean isClassSplitAttributesValid() {
        return ReflectionUtils.validateReflection$window_release("Class SplitAttributes is not valid", (Function0<Boolean>)((Function0)isClassSplitAttributesValid.1.INSTANCE));
    }

    private final boolean isClassSplitTypeValid() {
        return ReflectionUtils.validateReflection$window_release("Class SplitAttributes.SplitType is not valid", (Function0<Boolean>)((Function0)isClassSplitTypeValid.1.INSTANCE));
    }

    private final boolean isMethodSetSplitInfoCallbackJavaConsumerValid() {
        return ReflectionUtils.validateReflection$window_release("ActivityEmbeddingComponent#setSplitInfoCallback is not valid", (Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ SafeActivityEmbeddingComponentProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                Class<?> clazz = SafeActivityEmbeddingComponentProvider.access$getConsumerAdapter$p(this.this$0).consumerClassOrNull$window_release();
                if (clazz == null) {
                    return false;
                }
                Class<?> consumerClass = clazz;
                Class[] classArray = new Class[]{consumerClass};
                Method setSplitInfoCallbackMethod = SafeActivityEmbeddingComponentProvider.access$getActivityEmbeddingComponentClass(this.this$0).getMethod("setSplitInfoCallback", classArray);
                Intrinsics.checkNotNullExpressionValue((Object)setSplitInfoCallbackMethod, (String)"setSplitInfoCallbackMethod");
                return ReflectionUtils.INSTANCE.isPublic$window_release(setSplitInfoCallbackMethod);
            }
        }));
    }

    private final boolean isClassActivityRuleValid() {
        return ReflectionUtils.validateReflection$window_release("Class ActivityRule is not valid", (Function0<Boolean>)((Function0)isClassActivityRuleValid.1.INSTANCE));
    }

    private final boolean isClassSplitInfoValid() {
        return ReflectionUtils.validateReflection$window_release("Class SplitInfo is not valid", (Function0<Boolean>)((Function0)isClassSplitInfoValid.1.INSTANCE));
    }

    private final boolean isClassSplitPairRuleValid() {
        return ReflectionUtils.validateReflection$window_release("Class SplitPairRule is not valid", (Function0<Boolean>)((Function0)isClassSplitPairRuleValid.1.INSTANCE));
    }

    private final boolean isClassSplitPlaceholderRuleValid() {
        return ReflectionUtils.validateReflection$window_release("Class SplitPlaceholderRule is not valid", (Function0<Boolean>)((Function0)isClassSplitPlaceholderRuleValid.1.INSTANCE));
    }

    private final boolean isMethodSetSplitInfoCallbackWindowConsumerValid() {
        return ReflectionUtils.validateReflection$window_release("ActivityEmbeddingComponent#setSplitInfoCallback is not valid", (Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ SafeActivityEmbeddingComponentProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                Class[] classArray = new Class[]{Consumer.class};
                Method setSplitInfoCallbackMethod = SafeActivityEmbeddingComponentProvider.access$getActivityEmbeddingComponentClass(this.this$0).getMethod("setSplitInfoCallback", classArray);
                Intrinsics.checkNotNullExpressionValue((Object)setSplitInfoCallbackMethod, (String)"setSplitInfoCallbackMethod");
                return ReflectionUtils.INSTANCE.isPublic$window_release(setSplitInfoCallbackMethod);
            }
        }));
    }

    private final boolean isActivityEmbeddingComponentValid() {
        return ReflectionUtils.validateReflection$window_release("WindowExtensions#getActivityEmbeddingComponent is not valid", (Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ SafeActivityEmbeddingComponentProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                Class<?> extensionsClass = SafeActivityEmbeddingComponentProvider.access$getSafeWindowExtensionsProvider$p(this.this$0).getWindowExtensionsClass$window_release();
                Method getActivityEmbeddingComponentMethod = extensionsClass.getMethod("getActivityEmbeddingComponent", new Class[0]);
                Class activityEmbeddingComponentClass = SafeActivityEmbeddingComponentProvider.access$getActivityEmbeddingComponentClass(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)getActivityEmbeddingComponentMethod, (String)"getActivityEmbeddingComponentMethod");
                return ReflectionUtils.INSTANCE.isPublic$window_release(getActivityEmbeddingComponentMethod) && ReflectionUtils.INSTANCE.doesReturn$window_release(getActivityEmbeddingComponentMethod, activityEmbeddingComponentClass);
            }
        }));
    }

    private final Class<?> getActivityEmbeddingComponentClass() {
        Class<?> clazz = this.loader.loadClass("androidx.window.extensions.embedding.ActivityEmbeddingComponent");
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"loader.loadClass(ACTIVIT\u2026MBEDDING_COMPONENT_CLASS)");
        return clazz;
    }

    public static final /* synthetic */ Class access$getActivityEmbeddingComponentClass(SafeActivityEmbeddingComponentProvider $this) {
        return $this.getActivityEmbeddingComponentClass();
    }

    public static final /* synthetic */ ConsumerAdapter access$getConsumerAdapter$p(SafeActivityEmbeddingComponentProvider $this) {
        return $this.consumerAdapter;
    }

    public static final /* synthetic */ SafeWindowExtensionsProvider access$getSafeWindowExtensionsProvider$p(SafeActivityEmbeddingComponentProvider $this) {
        return $this.safeWindowExtensionsProvider;
    }
}

