/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.layout;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import androidx.annotation.VisibleForTesting;
import androidx.window.SafeWindowExtensionsProvider;
import androidx.window.core.ConsumerAdapter;
import androidx.window.core.ExtensionsUtil;
import androidx.window.extensions.WindowExtensionsProvider;
import androidx.window.extensions.core.util.function.Consumer;
import androidx.window.extensions.layout.WindowLayoutComponent;
import androidx.window.reflection.ReflectionUtils;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\r\u0010\u0015\u001a\u00020\u0014H\u0001\u00a2\u0006\u0002\b\u0016J\r\u0010\u0017\u001a\u00020\u0014H\u0001\u00a2\u0006\u0002\b\u0018J\b\u0010\u0019\u001a\u00020\u0014H\u0002J\b\u0010\u001a\u001a\u00020\u0014H\u0002J\b\u0010\u001b\u001a\u00020\u0014H\u0002J\r\u0010\u001c\u001a\u00020\u0014H\u0001\u00a2\u0006\u0002\b\u001dJ\b\u0010\u001e\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\n\u00a8\u0006\u001f"}, d2={"Landroidx/window/layout/SafeWindowLayoutComponentProvider;", "", "loader", "Ljava/lang/ClassLoader;", "consumerAdapter", "Landroidx/window/core/ConsumerAdapter;", "(Ljava/lang/ClassLoader;Landroidx/window/core/ConsumerAdapter;)V", "foldingFeatureClass", "Ljava/lang/Class;", "getFoldingFeatureClass", "()Ljava/lang/Class;", "safeWindowExtensionsProvider", "Landroidx/window/SafeWindowExtensionsProvider;", "windowLayoutComponent", "Landroidx/window/extensions/layout/WindowLayoutComponent;", "getWindowLayoutComponent", "()Landroidx/window/extensions/layout/WindowLayoutComponent;", "windowLayoutComponentClass", "getWindowLayoutComponentClass", "canUseWindowLayoutComponent", "", "hasValidVendorApiLevel1", "hasValidVendorApiLevel1$window_release", "hasValidVendorApiLevel2", "hasValidVendorApiLevel2$window_release", "isFoldingFeatureValid", "isMethodWindowLayoutInfoListenerJavaConsumerValid", "isMethodWindowLayoutInfoListenerWindowConsumerValid", "isWindowLayoutComponentAccessible", "isWindowLayoutComponentAccessible$window_release", "isWindowLayoutProviderValid", "window_release"})
public final class SafeWindowLayoutComponentProvider {
    @NotNull
    private final ClassLoader loader;
    @NotNull
    private final ConsumerAdapter consumerAdapter;
    @NotNull
    private final SafeWindowExtensionsProvider safeWindowExtensionsProvider;

    public SafeWindowLayoutComponentProvider(@NotNull ClassLoader loader, @NotNull ConsumerAdapter consumerAdapter) {
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        Intrinsics.checkNotNullParameter((Object)consumerAdapter, (String)"consumerAdapter");
        this.loader = loader;
        this.consumerAdapter = consumerAdapter;
        this.safeWindowExtensionsProvider = new SafeWindowExtensionsProvider(this.loader);
    }

    @Nullable
    public final WindowLayoutComponent getWindowLayoutComponent() {
        WindowLayoutComponent windowLayoutComponent;
        if (this.canUseWindowLayoutComponent()) {
            WindowLayoutComponent windowLayoutComponent2;
            try {
                windowLayoutComponent2 = WindowExtensionsProvider.getWindowExtensions().getWindowLayoutComponent();
            }
            catch (UnsupportedOperationException e) {
                windowLayoutComponent2 = null;
            }
            windowLayoutComponent = windowLayoutComponent2;
        } else {
            windowLayoutComponent = null;
        }
        return windowLayoutComponent;
    }

    private final boolean canUseWindowLayoutComponent() {
        if (!this.isWindowLayoutComponentAccessible$window_release()) {
            return false;
        }
        int n = ExtensionsUtil.INSTANCE.getSafeVendorApiLevel();
        return n == 1 ? this.hasValidVendorApiLevel1$window_release() : ((2 <= n ? n <= Integer.MAX_VALUE : false) ? this.hasValidVendorApiLevel2$window_release() : false);
    }

    @VisibleForTesting
    public final boolean isWindowLayoutComponentAccessible$window_release() {
        return this.safeWindowExtensionsProvider.isWindowExtensionsValid$window_release() && this.isWindowLayoutProviderValid() && this.isFoldingFeatureValid();
    }

    @VisibleForTesting
    public final boolean hasValidVendorApiLevel1$window_release() {
        return this.isMethodWindowLayoutInfoListenerJavaConsumerValid();
    }

    @VisibleForTesting
    public final boolean hasValidVendorApiLevel2$window_release() {
        return this.hasValidVendorApiLevel1$window_release() && this.isMethodWindowLayoutInfoListenerWindowConsumerValid();
    }

    private final boolean isWindowLayoutProviderValid() {
        return ReflectionUtils.validateReflection$window_release("WindowExtensions#getWindowLayoutComponent is not valid", (Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ SafeWindowLayoutComponentProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                Class<?> extensionsClass = SafeWindowLayoutComponentProvider.access$getSafeWindowExtensionsProvider$p(this.this$0).getWindowExtensionsClass$window_release();
                Method getWindowLayoutComponentMethod = extensionsClass.getMethod("getWindowLayoutComponent", new Class[0]);
                Class windowLayoutComponentClass = SafeWindowLayoutComponentProvider.access$getWindowLayoutComponentClass(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)getWindowLayoutComponentMethod, (String)"getWindowLayoutComponentMethod");
                return ReflectionUtils.INSTANCE.isPublic$window_release(getWindowLayoutComponentMethod) && ReflectionUtils.INSTANCE.doesReturn$window_release(getWindowLayoutComponentMethod, windowLayoutComponentClass);
            }
        }));
    }

    private final boolean isFoldingFeatureValid() {
        return ReflectionUtils.validateReflection$window_release("FoldingFeature class is not valid", (Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ SafeWindowLayoutComponentProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke() {
                boolean bl;
                Class foldingFeatureClass = SafeWindowLayoutComponentProvider.access$getFoldingFeatureClass(this.this$0);
                Method getBoundsMethod = foldingFeatureClass.getMethod("getBounds", new Class[0]);
                Method getTypeMethod = foldingFeatureClass.getMethod("getType", new Class[0]);
                Method getStateMethod = foldingFeatureClass.getMethod("getState", new Class[0]);
                Intrinsics.checkNotNullExpressionValue((Object)getBoundsMethod, (String)"getBoundsMethod");
                if (ReflectionUtils.INSTANCE.doesReturn$window_release(getBoundsMethod, Reflection.getOrCreateKotlinClass(Rect.class)) && ReflectionUtils.INSTANCE.isPublic$window_release(getBoundsMethod)) {
                    Intrinsics.checkNotNullExpressionValue((Object)getTypeMethod, (String)"getTypeMethod");
                    if (ReflectionUtils.INSTANCE.doesReturn$window_release(getTypeMethod, Reflection.getOrCreateKotlinClass(Integer.TYPE)) && ReflectionUtils.INSTANCE.isPublic$window_release(getTypeMethod)) {
                        Intrinsics.checkNotNullExpressionValue((Object)getStateMethod, (String)"getStateMethod");
                        if (ReflectionUtils.INSTANCE.doesReturn$window_release(getStateMethod, Reflection.getOrCreateKotlinClass(Integer.TYPE)) && ReflectionUtils.INSTANCE.isPublic$window_release(getStateMethod)) {
                            bl = true;
                            return bl;
                        }
                    }
                }
                bl = false;
                return bl;
            }
        }));
    }

    private final boolean isMethodWindowLayoutInfoListenerJavaConsumerValid() {
        return ReflectionUtils.validateReflection$window_release("WindowLayoutComponent#addWindowLayoutInfoListener(" + Activity.class.getName() + ", java.util.function.Consumer) is not valid", (Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ SafeWindowLayoutComponentProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke() {
                boolean bl;
                Class<?> clazz = SafeWindowLayoutComponentProvider.access$getConsumerAdapter$p(this.this$0).consumerClassOrNull$window_release();
                if (clazz == null) {
                    return false;
                }
                Class<?> consumerClass = clazz;
                Class windowLayoutComponent = SafeWindowLayoutComponentProvider.access$getWindowLayoutComponentClass(this.this$0);
                Class[] classArray = new Class[]{Activity.class, consumerClass};
                Method addListenerMethod = windowLayoutComponent.getMethod("addWindowLayoutInfoListener", classArray);
                Class[] classArray2 = new Class[]{consumerClass};
                Method removeListenerMethod = windowLayoutComponent.getMethod("removeWindowLayoutInfoListener", classArray2);
                Intrinsics.checkNotNullExpressionValue((Object)addListenerMethod, (String)"addListenerMethod");
                if (ReflectionUtils.INSTANCE.isPublic$window_release(addListenerMethod)) {
                    Intrinsics.checkNotNullExpressionValue((Object)removeListenerMethod, (String)"removeListenerMethod");
                    if (ReflectionUtils.INSTANCE.isPublic$window_release(removeListenerMethod)) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        }));
    }

    private final boolean isMethodWindowLayoutInfoListenerWindowConsumerValid() {
        return ReflectionUtils.validateReflection$window_release("WindowLayoutComponent#addWindowLayoutInfoListener(" + Context.class.getName() + ", androidx.window.extensions.core.util.function.Consumer) is not valid", (Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ SafeWindowLayoutComponentProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke() {
                boolean bl;
                Class windowLayoutComponent = SafeWindowLayoutComponentProvider.access$getWindowLayoutComponentClass(this.this$0);
                Class[] classArray = new Class[]{Context.class, Consumer.class};
                Method addListenerMethod = windowLayoutComponent.getMethod("addWindowLayoutInfoListener", classArray);
                Class[] classArray2 = new Class[]{Consumer.class};
                Method removeListenerMethod = windowLayoutComponent.getMethod("removeWindowLayoutInfoListener", classArray2);
                Intrinsics.checkNotNullExpressionValue((Object)addListenerMethod, (String)"addListenerMethod");
                if (ReflectionUtils.INSTANCE.isPublic$window_release(addListenerMethod)) {
                    Intrinsics.checkNotNullExpressionValue((Object)removeListenerMethod, (String)"removeListenerMethod");
                    if (ReflectionUtils.INSTANCE.isPublic$window_release(removeListenerMethod)) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        }));
    }

    private final Class<?> getFoldingFeatureClass() {
        Class<?> clazz = this.loader.loadClass("androidx.window.extensions.layout.FoldingFeature");
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"loader.loadClass(FOLDING_FEATURE_CLASS)");
        return clazz;
    }

    private final Class<?> getWindowLayoutComponentClass() {
        Class<?> clazz = this.loader.loadClass("androidx.window.extensions.layout.WindowLayoutComponent");
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"loader.loadClass(WINDOW_LAYOUT_COMPONENT_CLASS)");
        return clazz;
    }

    public static final /* synthetic */ SafeWindowExtensionsProvider access$getSafeWindowExtensionsProvider$p(SafeWindowLayoutComponentProvider $this) {
        return $this.safeWindowExtensionsProvider;
    }

    public static final /* synthetic */ Class access$getWindowLayoutComponentClass(SafeWindowLayoutComponentProvider $this) {
        return $this.getWindowLayoutComponentClass();
    }

    public static final /* synthetic */ Class access$getFoldingFeatureClass(SafeWindowLayoutComponentProvider $this) {
        return $this.getFoldingFeatureClass();
    }

    public static final /* synthetic */ ConsumerAdapter access$getConsumerAdapter$p(SafeWindowLayoutComponentProvider $this) {
        return $this.consumerAdapter;
    }
}

