/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.layout.adapter.extensions;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.GuardedBy;
import androidx.annotation.VisibleForTesting;
import androidx.core.util.Consumer;
import androidx.window.core.ConsumerAdapter;
import androidx.window.extensions.layout.WindowLayoutComponent;
import androidx.window.layout.WindowLayoutInfo;
import androidx.window.layout.adapter.WindowBackend;
import androidx.window.layout.adapter.extensions.MulticastConsumer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0012\u001a\u00020\u0013H\u0017J&\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0016\u0010\u001a\u001a\u00020\u00152\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\u0004\u0012\u00020\f0\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Landroidx/window/layout/adapter/extensions/ExtensionWindowBackendApi1;", "Landroidx/window/layout/adapter/WindowBackend;", "component", "Landroidx/window/extensions/layout/WindowLayoutComponent;", "consumerAdapter", "Landroidx/window/core/ConsumerAdapter;", "(Landroidx/window/extensions/layout/WindowLayoutComponent;Landroidx/window/core/ConsumerAdapter;)V", "consumerToToken", "", "Landroidx/window/layout/adapter/extensions/MulticastConsumer;", "Landroidx/window/core/ConsumerAdapter$Subscription;", "contextToListeners", "Landroid/content/Context;", "globalLock", "Ljava/util/concurrent/locks/ReentrantLock;", "listenerToContext", "Landroidx/core/util/Consumer;", "Landroidx/window/layout/WindowLayoutInfo;", "hasRegisteredListeners", "", "registerLayoutChangeCallback", "", "context", "executor", "Ljava/util/concurrent/Executor;", "callback", "unregisterLayoutChangeCallback", "window_release"})
public final class ExtensionWindowBackendApi1
implements WindowBackend {
    @NotNull
    private final WindowLayoutComponent component;
    @NotNull
    private final ConsumerAdapter consumerAdapter;
    @NotNull
    private final ReentrantLock globalLock;
    @GuardedBy(value="globalLock")
    @NotNull
    private final Map<Context, MulticastConsumer> contextToListeners;
    @GuardedBy(value="globalLock")
    @NotNull
    private final Map<Consumer<WindowLayoutInfo>, Context> listenerToContext;
    @GuardedBy(value="globalLock")
    @NotNull
    private final Map<MulticastConsumer, ConsumerAdapter.Subscription> consumerToToken;

    public ExtensionWindowBackendApi1(@NotNull WindowLayoutComponent component, @NotNull ConsumerAdapter consumerAdapter) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)consumerAdapter, (String)"consumerAdapter");
        this.component = component;
        this.consumerAdapter = consumerAdapter;
        this.globalLock = new ReentrantLock();
        this.contextToListeners = new LinkedHashMap();
        this.listenerToContext = new LinkedHashMap();
        this.consumerToToken = new LinkedHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerLayoutChangeCallback(@NotNull Context context, @NotNull Executor executor, @NotNull Consumer<WindowLayoutInfo> callback) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Lock lock = this.globalLock;
        lock.lock();
        try {
            Unit unit;
            boolean bl = false;
            MulticastConsumer multicastConsumer = this.contextToListeners.get(context);
            if (multicastConsumer != null) {
                MulticastConsumer listener = multicastConsumer;
                boolean bl2 = false;
                listener.addListener(callback);
                this.listenerToContext.put(callback, context);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                ExtensionWindowBackendApi1 $this$registerLayoutChangeCallback_u24lambda_u242_u24lambda_u241 = this;
                boolean bl3 = false;
                MulticastConsumer consumer = new MulticastConsumer(context);
                $this$registerLayoutChangeCallback_u24lambda_u242_u24lambda_u241.contextToListeners.put(context, consumer);
                $this$registerLayoutChangeCallback_u24lambda_u242_u24lambda_u241.listenerToContext.put(callback, context);
                consumer.addListener(callback);
                if (!(context instanceof Activity)) {
                    consumer.accept(new androidx.window.extensions.layout.WindowLayoutInfo(CollectionsKt.emptyList()));
                    return;
                }
                ConsumerAdapter.Subscription disposableToken2 = $this$registerLayoutChangeCallback_u24lambda_u242_u24lambda_u241.consumerAdapter.createSubscription((Object)$this$registerLayoutChangeCallback_u24lambda_u242_u24lambda_u241.component, Reflection.getOrCreateKotlinClass(androidx.window.extensions.layout.WindowLayoutInfo.class), "addWindowLayoutInfoListener", "removeWindowLayoutInfoListener", (Activity)context, (Function1)new Function1<androidx.window.extensions.layout.WindowLayoutInfo, Unit>((Object)consumer){

                    public final void invoke(@NotNull androidx.window.extensions.layout.WindowLayoutInfo p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        ((MulticastConsumer)this.receiver).accept(p0);
                    }
                });
                $this$registerLayoutChangeCallback_u24lambda_u242_u24lambda_u241.consumerToToken.put(consumer, disposableToken2);
            }
            Unit unit2 = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterLayoutChangeCallback(@NotNull Consumer<WindowLayoutInfo> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Lock lock = this.globalLock;
        lock.lock();
        try {
            MulticastConsumer multicastConsumer;
            Context context;
            boolean bl = false;
            if (this.listenerToContext.get(callback) == null) {
                return;
            }
            Context context2 = context;
            if (this.contextToListeners.get(context2) == null) {
                return;
            }
            MulticastConsumer multicastListener = multicastConsumer;
            multicastListener.removeListener(callback);
            this.listenerToContext.remove(callback);
            if (multicastListener.isEmpty()) {
                this.contextToListeners.remove(context2);
                ConsumerAdapter.Subscription subscription = this.consumerToToken.remove(multicastListener);
                if (subscription != null) {
                    subscription.dispose();
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    @VisibleForTesting
    public boolean hasRegisteredListeners() {
        return !this.contextToListeners.isEmpty() || !this.listenerToContext.isEmpty() || !this.consumerToToken.isEmpty();
    }
}

