/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.layout.adapter.extensions;

import android.content.Context;
import androidx.annotation.GuardedBy;
import androidx.annotation.VisibleForTesting;
import androidx.window.extensions.core.util.function.Consumer;
import androidx.window.extensions.layout.WindowLayoutComponent;
import androidx.window.layout.WindowLayoutInfo;
import androidx.window.layout.adapter.WindowBackend;
import androidx.window.layout.adapter.extensions.MulticastConsumer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0017J&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0016\u0010\u0016\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0004\u0012\u00020\u00070\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Landroidx/window/layout/adapter/extensions/ExtensionWindowBackendApi2;", "Landroidx/window/layout/adapter/WindowBackend;", "component", "Landroidx/window/extensions/layout/WindowLayoutComponent;", "(Landroidx/window/extensions/layout/WindowLayoutComponent;)V", "contextToListeners", "", "Landroid/content/Context;", "Landroidx/window/layout/adapter/extensions/MulticastConsumer;", "globalLock", "Ljava/util/concurrent/locks/ReentrantLock;", "listenerToContext", "Landroidx/core/util/Consumer;", "Landroidx/window/layout/WindowLayoutInfo;", "hasRegisteredListeners", "", "registerLayoutChangeCallback", "", "context", "executor", "Ljava/util/concurrent/Executor;", "callback", "unregisterLayoutChangeCallback", "window_release"})
public final class ExtensionWindowBackendApi2
implements WindowBackend {
    @NotNull
    private final WindowLayoutComponent component;
    @NotNull
    private final ReentrantLock globalLock;
    @GuardedBy(value="globalLock")
    @NotNull
    private final Map<Context, MulticastConsumer> contextToListeners;
    @GuardedBy(value="globalLock")
    @NotNull
    private final Map<androidx.core.util.Consumer<WindowLayoutInfo>, Context> listenerToContext;

    public ExtensionWindowBackendApi2(@NotNull WindowLayoutComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.component = component;
        this.globalLock = new ReentrantLock();
        this.contextToListeners = new LinkedHashMap();
        this.listenerToContext = new LinkedHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerLayoutChangeCallback(@NotNull Context context, @NotNull Executor executor, @NotNull androidx.core.util.Consumer<WindowLayoutInfo> callback) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Lock lock = this.globalLock;
        lock.lock();
        try {
            Unit unit;
            boolean bl = false;
            MulticastConsumer multicastConsumer = this.contextToListeners.get(context);
            if (multicastConsumer != null) {
                MulticastConsumer listener = multicastConsumer;
                boolean bl2 = false;
                listener.addListener(callback);
                this.listenerToContext.put(callback, context);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                ExtensionWindowBackendApi2 $this$registerLayoutChangeCallback_u24lambda_u242_u24lambda_u241 = this;
                boolean bl3 = false;
                MulticastConsumer consumer = new MulticastConsumer(context);
                $this$registerLayoutChangeCallback_u24lambda_u242_u24lambda_u241.contextToListeners.put(context, consumer);
                $this$registerLayoutChangeCallback_u24lambda_u242_u24lambda_u241.listenerToContext.put(callback, context);
                consumer.addListener(callback);
                $this$registerLayoutChangeCallback_u24lambda_u242_u24lambda_u241.component.addWindowLayoutInfoListener(context, (Consumer)consumer);
            }
            Unit unit2 = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterLayoutChangeCallback(@NotNull androidx.core.util.Consumer<WindowLayoutInfo> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Lock lock = this.globalLock;
        lock.lock();
        try {
            MulticastConsumer multicastConsumer;
            Context context;
            boolean bl = false;
            if (this.listenerToContext.get(callback) == null) {
                return;
            }
            Context context2 = context;
            if (this.contextToListeners.get(context2) == null) {
                return;
            }
            MulticastConsumer multicastListener = multicastConsumer;
            multicastListener.removeListener(callback);
            this.listenerToContext.remove(callback);
            if (multicastListener.isEmpty()) {
                this.contextToListeners.remove(context2);
                this.component.removeWindowLayoutInfoListener((Consumer)multicastListener);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    @VisibleForTesting
    public boolean hasRegisteredListeners() {
        return !this.contextToListeners.isEmpty() || !this.listenerToContext.isEmpty();
    }
}

