/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.layout.adapter.extensions;

import android.content.Context;
import androidx.annotation.GuardedBy;
import androidx.window.extensions.core.util.function.Consumer;
import androidx.window.layout.WindowLayoutInfo;
import androidx.window.layout.adapter.extensions.ExtensionsWindowLayoutInfoAdapter;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0014\u0010\u0010\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0001J\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010\u0014\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0001R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u0004\u0018\u00010\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00010\f8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Landroidx/window/layout/adapter/extensions/MulticastConsumer;", "Landroidx/core/util/Consumer;", "Landroidx/window/extensions/layout/WindowLayoutInfo;", "Landroidx/window/extensions/core/util/function/Consumer;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "globalLock", "Ljava/util/concurrent/locks/ReentrantLock;", "lastKnownValue", "Landroidx/window/layout/WindowLayoutInfo;", "registeredListeners", "", "accept", "", "value", "addListener", "listener", "isEmpty", "", "removeListener", "window_release"})
@SourceDebugExtension(value={"SMAP\nMulticastConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MulticastConsumer.kt\nandroidx/window/layout/adapter/extensions/MulticastConsumer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n1855#2,2:67\n1#3:69\n*S KotlinDebug\n*F\n+ 1 MulticastConsumer.kt\nandroidx/window/layout/adapter/extensions/MulticastConsumer\n*L\n45#1:67,2\n*E\n"})
public final class MulticastConsumer
implements androidx.core.util.Consumer<androidx.window.extensions.layout.WindowLayoutInfo>,
Consumer<androidx.window.extensions.layout.WindowLayoutInfo> {
    @NotNull
    private final Context context;
    @NotNull
    private final ReentrantLock globalLock;
    @GuardedBy(value="globalLock")
    @Nullable
    private WindowLayoutInfo lastKnownValue;
    @GuardedBy(value="globalLock")
    @NotNull
    private final Set<androidx.core.util.Consumer<WindowLayoutInfo>> registeredListeners;

    public MulticastConsumer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.globalLock = new ReentrantLock();
        this.registeredListeners = new LinkedHashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(@NotNull androidx.window.extensions.layout.WindowLayoutInfo value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Lock lock = this.globalLock;
        lock.lock();
        try {
            WindowLayoutInfo newValue;
            boolean bl = false;
            this.lastKnownValue = newValue = ExtensionsWindowLayoutInfoAdapter.INSTANCE.translate$window_release(this.context, value);
            Iterable $this$forEach$iv = this.registeredListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                androidx.core.util.Consumer consumer = (androidx.core.util.Consumer)element$iv;
                boolean bl2 = false;
                consumer.accept((Object)newValue);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addListener(@NotNull androidx.core.util.Consumer<WindowLayoutInfo> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        Lock lock = this.globalLock;
        lock.lock();
        try {
            boolean bl = false;
            WindowLayoutInfo windowLayoutInfo2 = this.lastKnownValue;
            if (windowLayoutInfo2 != null) {
                WindowLayoutInfo value = windowLayoutInfo2;
                boolean bl2 = false;
                listener.accept((Object)value);
            }
            boolean bl3 = this.registeredListeners.add(listener);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeListener(@NotNull androidx.core.util.Consumer<WindowLayoutInfo> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        Lock lock = this.globalLock;
        lock.lock();
        try {
            boolean bl = false;
            boolean bl2 = this.registeredListeners.remove(listener);
        }
        finally {
            lock.unlock();
        }
    }

    public final boolean isEmpty() {
        return this.registeredListeners.isEmpty();
    }
}

