/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.app;

import android.app.Activity;
import android.app.ActivityOptions;
import android.app.PendingIntent;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.util.Pair;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class ActivityOptionsCompat {
    public static final String EXTRA_USAGE_TIME_REPORT = "android.activity.usage_time";
    public static final String EXTRA_USAGE_TIME_REPORT_PACKAGES = "android.usage_time_packages";

    @NonNull
    public static ActivityOptionsCompat makeCustomAnimation(@NonNull Context context, int enterResId, int exitResId) {
        return new ActivityOptionsCompatImpl(ActivityOptions.makeCustomAnimation((Context)context, (int)enterResId, (int)exitResId));
    }

    @NonNull
    public static ActivityOptionsCompat makeScaleUpAnimation(@NonNull View source, int startX, int startY, int startWidth, int startHeight) {
        return new ActivityOptionsCompatImpl(ActivityOptions.makeScaleUpAnimation((View)source, (int)startX, (int)startY, (int)startWidth, (int)startHeight));
    }

    @NonNull
    public static ActivityOptionsCompat makeClipRevealAnimation(@NonNull View source, int startX, int startY, int width, int height) {
        if (Build.VERSION.SDK_INT >= 23) {
            return new ActivityOptionsCompatImpl(Api23Impl.makeClipRevealAnimation(source, startX, startY, width, height));
        }
        return new ActivityOptionsCompat();
    }

    @NonNull
    public static ActivityOptionsCompat makeThumbnailScaleUpAnimation(@NonNull View source, @NonNull Bitmap thumbnail, int startX, int startY) {
        return new ActivityOptionsCompatImpl(ActivityOptions.makeThumbnailScaleUpAnimation((View)source, (Bitmap)thumbnail, (int)startX, (int)startY));
    }

    @NonNull
    public static ActivityOptionsCompat makeSceneTransitionAnimation(@NonNull Activity activity, @NonNull View sharedElement, @NonNull String sharedElementName) {
        if (Build.VERSION.SDK_INT >= 21) {
            return new ActivityOptionsCompatImpl(Api21Impl.makeSceneTransitionAnimation(activity, sharedElement, sharedElementName));
        }
        return new ActivityOptionsCompat();
    }

    @NonNull
    public static ActivityOptionsCompat makeSceneTransitionAnimation(@NonNull Activity activity, Pair<View, String> ... sharedElements) {
        if (Build.VERSION.SDK_INT >= 21) {
            android.util.Pair[] pairs = null;
            if (sharedElements != null) {
                pairs = new android.util.Pair[sharedElements.length];
                for (int i = 0; i < sharedElements.length; ++i) {
                    pairs[i] = android.util.Pair.create((Object)((View)sharedElements[i].first), (Object)((String)sharedElements[i].second));
                }
            }
            return new ActivityOptionsCompatImpl(Api21Impl.makeSceneTransitionAnimation(activity, pairs));
        }
        return new ActivityOptionsCompat();
    }

    @NonNull
    public static ActivityOptionsCompat makeTaskLaunchBehind() {
        if (Build.VERSION.SDK_INT >= 21) {
            return new ActivityOptionsCompatImpl(Api21Impl.makeTaskLaunchBehind());
        }
        return new ActivityOptionsCompat();
    }

    @NonNull
    public static ActivityOptionsCompat makeBasic() {
        if (Build.VERSION.SDK_INT >= 23) {
            return new ActivityOptionsCompatImpl(Api23Impl.makeBasic());
        }
        return new ActivityOptionsCompat();
    }

    protected ActivityOptionsCompat() {
    }

    @NonNull
    public ActivityOptionsCompat setLaunchBounds(@Nullable Rect screenSpacePixelRect) {
        return this;
    }

    @Nullable
    public Rect getLaunchBounds() {
        return null;
    }

    @Nullable
    public Bundle toBundle() {
        return null;
    }

    public void update(@NonNull ActivityOptionsCompat otherOptions) {
    }

    public void requestUsageTimeReport(@NonNull PendingIntent receiver) {
    }

    @NonNull
    public ActivityOptionsCompat setShareIdentityEnabled(boolean shareIdentity) {
        return this;
    }

    @NonNull
    public ActivityOptionsCompat setPendingIntentBackgroundActivityStartMode(int state) {
        return this;
    }

    private static class ActivityOptionsCompatImpl
    extends ActivityOptionsCompat {
        private final ActivityOptions mActivityOptions;

        ActivityOptionsCompatImpl(ActivityOptions activityOptions) {
            this.mActivityOptions = activityOptions;
        }

        @Override
        public Bundle toBundle() {
            return this.mActivityOptions.toBundle();
        }

        @Override
        public void update(@NonNull ActivityOptionsCompat otherOptions) {
            if (otherOptions instanceof ActivityOptionsCompatImpl) {
                ActivityOptionsCompatImpl otherImpl = (ActivityOptionsCompatImpl)otherOptions;
                this.mActivityOptions.update(otherImpl.mActivityOptions);
            }
        }

        @Override
        public void requestUsageTimeReport(@NonNull PendingIntent receiver) {
            if (Build.VERSION.SDK_INT >= 23) {
                Api23Impl.requestUsageTimeReport(this.mActivityOptions, receiver);
            }
        }

        @Override
        @NonNull
        public ActivityOptionsCompat setLaunchBounds(@Nullable Rect screenSpacePixelRect) {
            if (Build.VERSION.SDK_INT < 24) {
                return this;
            }
            return new ActivityOptionsCompatImpl(Api24Impl.setLaunchBounds(this.mActivityOptions, screenSpacePixelRect));
        }

        @Override
        public Rect getLaunchBounds() {
            if (Build.VERSION.SDK_INT < 24) {
                return null;
            }
            return Api24Impl.getLaunchBounds(this.mActivityOptions);
        }

        @Override
        @NonNull
        public ActivityOptionsCompat setShareIdentityEnabled(boolean shareIdentity) {
            if (Build.VERSION.SDK_INT < 34) {
                return this;
            }
            return new ActivityOptionsCompatImpl(Api34Impl.setShareIdentityEnabled(this.mActivityOptions, shareIdentity));
        }

        @Override
        @NonNull
        public ActivityOptionsCompat setPendingIntentBackgroundActivityStartMode(int state) {
            if (Build.VERSION.SDK_INT >= 34) {
                Api34Impl.setPendingIntentBackgroundActivityStartMode(this.mActivityOptions, state);
            } else if (Build.VERSION.SDK_INT >= 33) {
                boolean isAllowed = state != 2;
                Api33Impl.setPendingIntentBackgroundActivityLaunchAllowed(this.mActivityOptions, isAllowed);
            }
            return this;
        }
    }

    @RequiresApi(value=23)
    static class Api23Impl {
        private Api23Impl() {
        }

        static ActivityOptions makeClipRevealAnimation(View source, int startX, int startY, int width, int height) {
            return ActivityOptions.makeClipRevealAnimation((View)source, (int)startX, (int)startY, (int)width, (int)height);
        }

        static ActivityOptions makeBasic() {
            return ActivityOptions.makeBasic();
        }

        static void requestUsageTimeReport(ActivityOptions activityOptions, PendingIntent receiver) {
            activityOptions.requestUsageTimeReport(receiver);
        }
    }

    @RequiresApi(value=21)
    static class Api21Impl {
        private Api21Impl() {
        }

        static ActivityOptions makeSceneTransitionAnimation(Activity activity, View sharedElement, String sharedElementName) {
            return ActivityOptions.makeSceneTransitionAnimation((Activity)activity, (View)sharedElement, (String)sharedElementName);
        }

        @SafeVarargs
        static ActivityOptions makeSceneTransitionAnimation(Activity activity, android.util.Pair<View, String> ... sharedElements) {
            return ActivityOptions.makeSceneTransitionAnimation((Activity)activity, sharedElements);
        }

        static ActivityOptions makeTaskLaunchBehind() {
            return ActivityOptions.makeTaskLaunchBehind();
        }
    }

    @RequiresApi(value=34)
    static class Api34Impl {
        private Api34Impl() {
        }

        static ActivityOptions setShareIdentityEnabled(ActivityOptions activityOptions, boolean shareIdentity) {
            return activityOptions.setShareIdentityEnabled(shareIdentity);
        }

        static ActivityOptions setPendingIntentBackgroundActivityStartMode(ActivityOptions activityOptions, int state) {
            return activityOptions.setPendingIntentBackgroundActivityStartMode(state);
        }
    }

    @RequiresApi(value=33)
    static class Api33Impl {
        private Api33Impl() {
        }

        static void setPendingIntentBackgroundActivityLaunchAllowed(ActivityOptions activityOptions, boolean allowed) {
            activityOptions.setPendingIntentBackgroundActivityLaunchAllowed(allowed);
        }
    }

    @RequiresApi(value=24)
    static class Api24Impl {
        private Api24Impl() {
        }

        static ActivityOptions setLaunchBounds(ActivityOptions activityOptions, Rect screenSpacePixelRect) {
            return activityOptions.setLaunchBounds(screenSpacePixelRect);
        }

        static Rect getLaunchBounds(ActivityOptions activityOptions) {
            return activityOptions.getLaunchBounds();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface BackgroundActivityStartMode {
    }
}

