/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.content;

import android.content.Context;
import android.os.Binder;
import android.os.Process;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.app.AppOpsManagerCompat;
import androidx.core.util.ObjectsCompat;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class PermissionChecker {
    public static final int PERMISSION_GRANTED = 0;
    public static final int PERMISSION_DENIED = -1;
    public static final int PERMISSION_DENIED_APP_OP = -2;

    private PermissionChecker() {
    }

    public static int checkPermission(@NonNull Context context, @NonNull String permission2, int pid, int uid, @Nullable String packageName) {
        if (context.checkPermission(permission2, pid, uid) == -1) {
            return -1;
        }
        String op = AppOpsManagerCompat.permissionToOp(permission2);
        if (op == null) {
            return 0;
        }
        if (packageName == null) {
            String[] packageNames = context.getPackageManager().getPackagesForUid(uid);
            if (packageNames == null || packageNames.length <= 0) {
                return -1;
            }
            packageName = packageNames[0];
        }
        int proxyUid = Process.myUid();
        String proxyPackageName = context.getPackageName();
        boolean isCheckSelfPermission = proxyUid == uid && ObjectsCompat.equals(proxyPackageName, packageName);
        int checkOpResult = isCheckSelfPermission ? AppOpsManagerCompat.checkOrNoteProxyOp(context, uid, op, packageName) : AppOpsManagerCompat.noteProxyOpNoThrow(context, op, packageName);
        return checkOpResult == 0 ? 0 : -2;
    }

    public static int checkSelfPermission(@NonNull Context context, @NonNull String permission2) {
        return PermissionChecker.checkPermission(context, permission2, Process.myPid(), Process.myUid(), context.getPackageName());
    }

    public static int checkCallingPermission(@NonNull Context context, @NonNull String permission2, @Nullable String packageName) {
        if (Binder.getCallingPid() == Process.myPid()) {
            return -1;
        }
        return PermissionChecker.checkPermission(context, permission2, Binder.getCallingPid(), Binder.getCallingUid(), packageName);
    }

    public static int checkCallingOrSelfPermission(@NonNull Context context, @NonNull String permission2) {
        String packageName = Binder.getCallingPid() == Process.myPid() ? context.getPackageName() : null;
        return PermissionChecker.checkPermission(context, permission2, Binder.getCallingPid(), Binder.getCallingUid(), packageName);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static @interface PermissionResult {
    }
}

