/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.graphics;

import android.graphics.Path;
import android.graphics.PointF;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.core.graphics.PathSegment;
import java.util.ArrayList;
import java.util.Collection;

public final class PathUtils {
    @RequiresApi(value=26)
    @NonNull
    public static Collection<PathSegment> flatten(@NonNull Path path) {
        return PathUtils.flatten(path, 0.5f);
    }

    @RequiresApi(value=26)
    @NonNull
    public static Collection<PathSegment> flatten(@NonNull Path path, @FloatRange(from=0.0) float error) {
        float[] pathData = Api26Impl.approximate(path, error);
        int pointCount = pathData.length / 3;
        ArrayList<PathSegment> segments = new ArrayList<PathSegment>(pointCount);
        for (int i = 1; i < pointCount; ++i) {
            int index = i * 3;
            int prevIndex = (i - 1) * 3;
            float d = pathData[index];
            float x = pathData[index + 1];
            float y = pathData[index + 2];
            float pd = pathData[prevIndex];
            float px = pathData[prevIndex + 1];
            float py = pathData[prevIndex + 2];
            if (d == pd || x == px && y == py) continue;
            segments.add(new PathSegment(new PointF(px, py), pd, new PointF(x, y), d));
        }
        return segments;
    }

    private PathUtils() {
    }

    @RequiresApi(value=26)
    static class Api26Impl {
        private Api26Impl() {
        }

        static float[] approximate(Path path, float acceptableError) {
            return path.approximate(acceptableError);
        }
    }
}

