/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.graphics;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.graphics.fonts.Font;
import android.graphics.fonts.FontFamily;
import android.graphics.fonts.FontStyle;
import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.content.res.FontResourcesParserCompat;
import androidx.core.graphics.TypefaceCompatBaseImpl;
import androidx.core.provider.FontsContractCompat;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@RequiresApi(value=29)
public class TypefaceCompatApi29Impl
extends TypefaceCompatBaseImpl {
    private static final String TAG = "TypefaceCompatApi29Impl";

    private static int getMatchScore(@NonNull FontStyle o1, @NonNull FontStyle o2) {
        return Math.abs(o1.getWeight() - o2.getWeight()) / 100 + (o1.getSlant() == o2.getSlant() ? 0 : 2);
    }

    private Font findBaseFont(@NonNull FontFamily family, int style) {
        FontStyle desiredStyle = new FontStyle((style & 1) != 0 ? 700 : 400, (style & 2) != 0 ? 1 : 0);
        Font bestFont = family.getFont(0);
        int bestScore = TypefaceCompatApi29Impl.getMatchScore(desiredStyle, bestFont.getStyle());
        for (int i = 1; i < family.getSize(); ++i) {
            Font candidate = family.getFont(i);
            int score = TypefaceCompatApi29Impl.getMatchScore(desiredStyle, candidate.getStyle());
            if (score >= bestScore) continue;
            bestFont = candidate;
            bestScore = score;
        }
        return bestFont;
    }

    @Override
    protected FontsContractCompat.FontInfo findBestInfo(FontsContractCompat.FontInfo[] fonts, int style) {
        throw new RuntimeException("Do not use this function in API 29 or later.");
    }

    @Override
    protected Typeface createFromInputStream(Context context, InputStream is) {
        throw new RuntimeException("Do not use this function in API 29 or later.");
    }

    @Override
    @Nullable
    public Typeface createFromFontInfo(Context context, @Nullable CancellationSignal cancellationSignal, @NonNull FontsContractCompat.FontInfo[] fonts, int style) {
        ContentResolver resolver = context.getContentResolver();
        try {
            FontFamily family = TypefaceCompatApi29Impl.getFontFamily(cancellationSignal, fonts, resolver);
            if (family == null) {
                return null;
            }
            return new Typeface.CustomFallbackBuilder(family).setStyle(this.findBaseFont(family, style).getStyle()).build();
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"Font load failed", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static FontFamily getFontFamily(@Nullable CancellationSignal cancellationSignal, @NonNull FontsContractCompat.FontInfo[] fonts, ContentResolver resolver) {
        FontFamily.Builder familyBuilder = null;
        for (FontsContractCompat.FontInfo font : fonts) {
            try (ParcelFileDescriptor pfd = resolver.openFileDescriptor(font.getUri(), "r", cancellationSignal);){
                if (pfd == null) continue;
                Font platformFont = new Font.Builder(pfd).setWeight(font.getWeight()).setSlant(font.isItalic() ? 1 : 0).setTtcIndex(font.getTtcIndex()).build();
                if (familyBuilder == null) {
                    familyBuilder = new FontFamily.Builder(platformFont);
                    continue;
                }
                familyBuilder.addFont(platformFont);
            }
            catch (IOException e) {
                Log.w((String)TAG, (String)"Font load failed", (Throwable)e);
            }
        }
        if (familyBuilder == null) {
            return null;
        }
        FontFamily family = familyBuilder.build();
        return family;
    }

    @Override
    @Nullable
    public Typeface createFromFontInfoWithFallback(@NonNull Context context, @Nullable CancellationSignal cancellationSignal, @NonNull List<FontsContractCompat.FontInfo[]> fonts, int style) {
        ContentResolver resolver = context.getContentResolver();
        try {
            FontFamily family = TypefaceCompatApi29Impl.getFontFamily(cancellationSignal, fonts.get(0), resolver);
            if (family == null) {
                return null;
            }
            Typeface.CustomFallbackBuilder builder = new Typeface.CustomFallbackBuilder(family);
            for (int i = 1; i < fonts.size(); ++i) {
                FontFamily fallbackFamily = TypefaceCompatApi29Impl.getFontFamily(cancellationSignal, fonts.get(i), resolver);
                if (fallbackFamily == null) continue;
                builder.addCustomFallback(fallbackFamily);
            }
            return builder.setStyle(this.findBaseFont(family, style).getStyle()).build();
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"Font load failed", (Throwable)e);
            return null;
        }
    }

    @Override
    @Nullable
    public Typeface createFromFontFamilyFilesResourceEntry(Context context, FontResourcesParserCompat.FontFamilyFilesResourceEntry familyEntry, Resources resources, int style) {
        try {
            FontFamily.Builder familyBuilder = null;
            for (FontResourcesParserCompat.FontFileResourceEntry entry : familyEntry.getEntries()) {
                try {
                    Font platformFont = new Font.Builder(resources, entry.getResourceId()).setWeight(entry.getWeight()).setSlant(entry.isItalic() ? 1 : 0).setTtcIndex(entry.getTtcIndex()).setFontVariationSettings(entry.getVariationSettings()).build();
                    if (familyBuilder == null) {
                        familyBuilder = new FontFamily.Builder(platformFont);
                        continue;
                    }
                    familyBuilder.addFont(platformFont);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (familyBuilder == null) {
                return null;
            }
            FontFamily family = familyBuilder.build();
            return new Typeface.CustomFallbackBuilder(family).setStyle(this.findBaseFont(family, style).getStyle()).build();
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"Font load failed", (Throwable)e);
            return null;
        }
    }

    @Override
    @Nullable
    public Typeface createFromResourcesFontFile(Context context, Resources resources, int id2, String path, int style) {
        FontFamily family = null;
        Font font = null;
        try {
            font = new Font.Builder(resources, id2).build();
            family = new FontFamily.Builder(font).build();
            return new Typeface.CustomFallbackBuilder(family).setStyle(font.getStyle()).build();
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"Font load failed", (Throwable)e);
            return null;
        }
    }

    @Override
    @NonNull
    Typeface createWeightStyle(@NonNull Context context, @NonNull Typeface base, int weight, boolean italic) {
        return Typeface.create((Typeface)base, (int)weight, (boolean)italic);
    }
}

