/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.graphics;

import android.content.Context;
import android.graphics.Typeface;
import android.util.Log;
import android.util.SparseArray;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.collection.LongSparseArray;
import androidx.core.content.res.FontResourcesParserCompat;
import androidx.core.graphics.TypefaceCompatBaseImpl;
import java.lang.reflect.Field;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
final class WeightTypefaceApi14 {
    private static final String TAG = "WeightTypeface";
    private static final String NATIVE_INSTANCE_FIELD = "native_instance";
    private static final Field sNativeInstance;
    @GuardedBy(value="sWeightCacheLock")
    private static final LongSparseArray<SparseArray<Typeface>> sWeightTypefaceCache;
    private static final Object sWeightCacheLock;

    private static boolean isPrivateApiAvailable() {
        return sNativeInstance != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    static Typeface createWeightStyle(@NonNull TypefaceCompatBaseImpl compat, @NonNull Context context, @NonNull Typeface base, int weight, boolean italic) {
        Typeface typeface;
        if (!WeightTypefaceApi14.isPrivateApiAvailable()) {
            return null;
        }
        int key = weight << 1 | (italic ? 1 : 0);
        Object object = sWeightCacheLock;
        synchronized (object) {
            long baseNativeInstance = WeightTypefaceApi14.getNativeInstance(base);
            SparseArray innerCache = (SparseArray)sWeightTypefaceCache.get(baseNativeInstance);
            if (innerCache == null) {
                innerCache = new SparseArray(4);
                sWeightTypefaceCache.put(baseNativeInstance, (Object)innerCache);
            } else {
                typeface = (Typeface)innerCache.get(key);
                if (typeface != null) {
                    return typeface;
                }
            }
            typeface = WeightTypefaceApi14.getBestFontFromFamily(compat, context, base, weight, italic);
            if (typeface == null) {
                typeface = WeightTypefaceApi14.platformTypefaceCreate(base, weight, italic);
            }
            innerCache.put(key, (Object)typeface);
        }
        return typeface;
    }

    private static Typeface platformTypefaceCreate(Typeface base, int weight, boolean italic) {
        boolean isBold = weight >= 600;
        int style = 0;
        style = !isBold && !italic ? 0 : (!isBold ? 2 : (!italic ? 1 : 3));
        return Typeface.create((Typeface)base, (int)style);
    }

    @Nullable
    private static Typeface getBestFontFromFamily(@NonNull TypefaceCompatBaseImpl compat, @NonNull Context context, @NonNull Typeface base, int weight, boolean italic) {
        FontResourcesParserCompat.FontFamilyFilesResourceEntry family = compat.getFontFamily(base);
        if (family == null) {
            return null;
        }
        return compat.createFromFontFamilyFilesResourceEntry(context, family, context.getResources(), weight, italic);
    }

    private static long getNativeInstance(@NonNull Typeface typeface) {
        try {
            Number num = (Number)sNativeInstance.get(typeface);
            return num.longValue();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private WeightTypefaceApi14() {
    }

    static {
        Field nativeInstance;
        try {
            nativeInstance = Typeface.class.getDeclaredField(NATIVE_INSTANCE_FIELD);
            nativeInstance.setAccessible(true);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.getClass().getName(), (Throwable)e);
            nativeInstance = null;
        }
        sNativeInstance = nativeInstance;
        sWeightTypefaceCache = new LongSparseArray(3);
        sWeightCacheLock = new Object();
    }
}

