/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.graphics.drawable;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Shader;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.core.content.ContextCompat;
import androidx.core.content.res.ResourcesCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.util.ObjectsCompat;
import androidx.core.util.Preconditions;
import androidx.versionedparcelable.CustomVersionedParcelable;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;

public class IconCompat
extends CustomVersionedParcelable {
    private static final String TAG = "IconCompat";
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_BITMAP = 1;
    public static final int TYPE_RESOURCE = 2;
    public static final int TYPE_DATA = 3;
    public static final int TYPE_URI = 4;
    public static final int TYPE_ADAPTIVE_BITMAP = 5;
    public static final int TYPE_URI_ADAPTIVE_BITMAP = 6;
    private static final float ADAPTIVE_ICON_INSET_FACTOR = 0.25f;
    private static final float DEFAULT_VIEW_PORT_SCALE = 0.6666667f;
    private static final float ICON_DIAMETER_FACTOR = 0.9166667f;
    private static final float BLUR_FACTOR = 0.010416667f;
    private static final float KEY_SHADOW_OFFSET_FACTOR = 0.020833334f;
    private static final int KEY_SHADOW_ALPHA = 61;
    private static final int AMBIENT_SHADOW_ALPHA = 30;
    @VisibleForTesting
    static final String EXTRA_TYPE = "type";
    @VisibleForTesting
    static final String EXTRA_OBJ = "obj";
    @VisibleForTesting
    static final String EXTRA_INT1 = "int1";
    @VisibleForTesting
    static final String EXTRA_INT2 = "int2";
    @VisibleForTesting
    static final String EXTRA_TINT_LIST = "tint_list";
    @VisibleForTesting
    static final String EXTRA_TINT_MODE = "tint_mode";
    @VisibleForTesting
    static final String EXTRA_STRING1 = "string1";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public int mType = -1;
    Object mObj1;
    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public byte[] mData = null;
    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public Parcelable mParcelable = null;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public int mInt1 = 0;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public int mInt2 = 0;
    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public ColorStateList mTintList = null;
    static final PorterDuff.Mode DEFAULT_TINT_MODE = PorterDuff.Mode.SRC_IN;
    PorterDuff.Mode mTintMode = DEFAULT_TINT_MODE;
    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public String mTintModeStr = null;
    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public String mString1;

    @NonNull
    public static IconCompat createWithResource(@NonNull Context context, @DrawableRes int resId) {
        ObjectsCompat.requireNonNull(context);
        return IconCompat.createWithResource(context.getResources(), context.getPackageName(), resId);
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static IconCompat createWithResource(@Nullable Resources r, @NonNull String pkg, @DrawableRes int resId) {
        ObjectsCompat.requireNonNull(pkg);
        if (resId == 0) {
            throw new IllegalArgumentException("Drawable resource ID must not be 0");
        }
        IconCompat rep = new IconCompat(2);
        rep.mInt1 = resId;
        if (r != null) {
            try {
                rep.mObj1 = r.getResourceName(resId);
            }
            catch (Resources.NotFoundException e) {
                throw new IllegalArgumentException("Icon resource cannot be found");
            }
        } else {
            rep.mObj1 = pkg;
        }
        rep.mString1 = pkg;
        return rep;
    }

    @NonNull
    public static IconCompat createWithBitmap(@NonNull Bitmap bits) {
        ObjectsCompat.requireNonNull(bits);
        IconCompat rep = new IconCompat(1);
        rep.mObj1 = bits;
        return rep;
    }

    @NonNull
    public static IconCompat createWithAdaptiveBitmap(@NonNull Bitmap bits) {
        ObjectsCompat.requireNonNull(bits);
        IconCompat rep = new IconCompat(5);
        rep.mObj1 = bits;
        return rep;
    }

    @NonNull
    public static IconCompat createWithData(@NonNull byte[] data, int offset, int length) {
        ObjectsCompat.requireNonNull(data);
        IconCompat rep = new IconCompat(3);
        rep.mObj1 = data;
        rep.mInt1 = offset;
        rep.mInt2 = length;
        return rep;
    }

    @NonNull
    public static IconCompat createWithContentUri(@NonNull String uri) {
        ObjectsCompat.requireNonNull(uri);
        IconCompat rep = new IconCompat(4);
        rep.mObj1 = uri;
        return rep;
    }

    @NonNull
    public static IconCompat createWithContentUri(@NonNull Uri uri) {
        ObjectsCompat.requireNonNull(uri);
        return IconCompat.createWithContentUri(uri.toString());
    }

    @NonNull
    public static IconCompat createWithAdaptiveBitmapContentUri(@NonNull String uri) {
        ObjectsCompat.requireNonNull(uri);
        IconCompat rep = new IconCompat(6);
        rep.mObj1 = uri;
        return rep;
    }

    @NonNull
    public static IconCompat createWithAdaptiveBitmapContentUri(@NonNull Uri uri) {
        ObjectsCompat.requireNonNull(uri);
        return IconCompat.createWithAdaptiveBitmapContentUri(uri.toString());
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public IconCompat() {
    }

    IconCompat(int mType) {
        this.mType = mType;
    }

    public int getType() {
        if (this.mType == -1 && Build.VERSION.SDK_INT >= 23) {
            return Api23Impl.getType(this.mObj1);
        }
        return this.mType;
    }

    @NonNull
    public String getResPackage() {
        if (this.mType == -1 && Build.VERSION.SDK_INT >= 23) {
            return Api23Impl.getResPackage(this.mObj1);
        }
        if (this.mType != 2) {
            throw new IllegalStateException("called getResPackage() on " + (Object)((Object)this));
        }
        if (this.mString1 == null || TextUtils.isEmpty((CharSequence)this.mString1)) {
            return ((String)this.mObj1).split(":", -1)[0];
        }
        return this.mString1;
    }

    @DrawableRes
    public int getResId() {
        if (this.mType == -1 && Build.VERSION.SDK_INT >= 23) {
            return Api23Impl.getResId(this.mObj1);
        }
        if (this.mType != 2) {
            throw new IllegalStateException("called getResId() on " + (Object)((Object)this));
        }
        return this.mInt1;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @Nullable
    public Bitmap getBitmap() {
        if (this.mType == -1 && Build.VERSION.SDK_INT >= 23) {
            if (this.mObj1 instanceof Bitmap) {
                return (Bitmap)this.mObj1;
            }
            return null;
        }
        if (this.mType == 1) {
            return (Bitmap)this.mObj1;
        }
        if (this.mType == 5) {
            return IconCompat.createLegacyIconFromAdaptiveIcon((Bitmap)this.mObj1, true);
        }
        throw new IllegalStateException("called getBitmap() on " + (Object)((Object)this));
    }

    @NonNull
    public Uri getUri() {
        if (this.mType == -1 && Build.VERSION.SDK_INT >= 23) {
            return Api23Impl.getUri(this.mObj1);
        }
        if (this.mType != 4 && this.mType != 6) {
            throw new IllegalStateException("called getUri() on " + (Object)((Object)this));
        }
        return Uri.parse((String)((String)this.mObj1));
    }

    @NonNull
    public IconCompat setTint(@ColorInt int tint) {
        return this.setTintList(ColorStateList.valueOf((int)tint));
    }

    @NonNull
    public IconCompat setTintList(@Nullable ColorStateList tintList) {
        this.mTintList = tintList;
        return this;
    }

    @NonNull
    public IconCompat setTintMode(@Nullable PorterDuff.Mode mode) {
        this.mTintMode = mode;
        return this;
    }

    @Deprecated
    @RequiresApi(value=23)
    @NonNull
    public Icon toIcon() {
        return this.toIcon(null);
    }

    @RequiresApi(value=23)
    @NonNull
    public Icon toIcon(@Nullable Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            return Api23Impl.toIcon(this, context);
        }
        throw new UnsupportedOperationException("This method is only supported on API level 23+");
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public void checkResource(@NonNull Context context) {
        if (this.mType == 2 && this.mObj1 != null) {
            String fullResName = (String)this.mObj1;
            if (!fullResName.contains(":")) {
                return;
            }
            String resName = fullResName.split(":", -1)[1];
            String resType = resName.split("/", -1)[0];
            resName = resName.split("/", -1)[1];
            String resPackage = fullResName.split(":", -1)[0];
            if ("0_resource_name_obfuscated".equals(resName)) {
                Log.i((String)TAG, (String)"Found obfuscated resource, not trying to update resource id for it");
                return;
            }
            String appPackage = this.getResPackage();
            Resources res = IconCompat.getResources(context, appPackage);
            int id2 = res.getIdentifier(resName, resType, resPackage);
            if (this.mInt1 != id2) {
                Log.i((String)TAG, (String)("Id has changed for " + appPackage + " " + fullResName));
                this.mInt1 = id2;
            }
        }
    }

    @Nullable
    public Drawable loadDrawable(@NonNull Context context) {
        this.checkResource(context);
        if (Build.VERSION.SDK_INT >= 23) {
            return Api23Impl.loadDrawable(this.toIcon(context), context);
        }
        Drawable result = this.loadDrawableInner(context);
        if (result != null && (this.mTintList != null || this.mTintMode != DEFAULT_TINT_MODE)) {
            result.mutate();
            DrawableCompat.setTintList(result, this.mTintList);
            DrawableCompat.setTintMode(result, this.mTintMode);
        }
        return result;
    }

    private Drawable loadDrawableInner(Context context) {
        switch (this.mType) {
            case 1: {
                return new BitmapDrawable(context.getResources(), (Bitmap)this.mObj1);
            }
            case 5: {
                return new BitmapDrawable(context.getResources(), IconCompat.createLegacyIconFromAdaptiveIcon((Bitmap)this.mObj1, false));
            }
            case 2: {
                String resPackage = this.getResPackage();
                if (TextUtils.isEmpty((CharSequence)resPackage)) {
                    resPackage = context.getPackageName();
                }
                Resources res = IconCompat.getResources(context, resPackage);
                try {
                    return ResourcesCompat.getDrawable(res, this.mInt1, context.getTheme());
                }
                catch (RuntimeException e) {
                    Log.e((String)TAG, (String)String.format("Unable to load resource 0x%08x from pkg=%s", this.mInt1, this.mObj1), (Throwable)e);
                    break;
                }
            }
            case 3: {
                return new BitmapDrawable(context.getResources(), BitmapFactory.decodeByteArray((byte[])((byte[])this.mObj1), (int)this.mInt1, (int)this.mInt2));
            }
            case 4: {
                InputStream is = this.getUriInputStream(context);
                if (is == null) break;
                return new BitmapDrawable(context.getResources(), BitmapFactory.decodeStream((InputStream)is));
            }
            case 6: {
                InputStream is = this.getUriInputStream(context);
                if (is == null) break;
                if (Build.VERSION.SDK_INT >= 26) {
                    return Api26Impl.createAdaptiveIconDrawable(null, (Drawable)new BitmapDrawable(context.getResources(), BitmapFactory.decodeStream((InputStream)is)));
                }
                return new BitmapDrawable(context.getResources(), IconCompat.createLegacyIconFromAdaptiveIcon(BitmapFactory.decodeStream((InputStream)is), false));
            }
        }
        return null;
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public InputStream getUriInputStream(@NonNull Context context) {
        Uri uri = this.getUri();
        String scheme = uri.getScheme();
        if ("content".equals(scheme) || "file".equals(scheme)) {
            try {
                return context.getContentResolver().openInputStream(uri);
            }
            catch (Exception e) {
                Log.w((String)TAG, (String)("Unable to load image from URI: " + uri), (Throwable)e);
            }
        } else {
            try {
                return new FileInputStream(new File((String)this.mObj1));
            }
            catch (FileNotFoundException e) {
                Log.w((String)TAG, (String)("Unable to load image from path: " + uri), (Throwable)e);
            }
        }
        return null;
    }

    static Resources getResources(Context context, String resPackage) {
        if ("android".equals(resPackage)) {
            return Resources.getSystem();
        }
        PackageManager pm = context.getPackageManager();
        try {
            ApplicationInfo ai = pm.getApplicationInfo(resPackage, 8192);
            if (ai != null) {
                return pm.getResourcesForApplication(ai);
            }
            return null;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)String.format("Unable to find pkg=%s for icon", resPackage), (Throwable)e);
            return null;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public void addToShortcutIntent(@NonNull Intent outIntent, @Nullable Drawable badge, @NonNull Context c) {
        Bitmap icon;
        this.checkResource(c);
        switch (this.mType) {
            case 1: {
                icon = (Bitmap)this.mObj1;
                if (badge == null) break;
                icon = icon.copy(icon.getConfig(), true);
                break;
            }
            case 5: {
                icon = IconCompat.createLegacyIconFromAdaptiveIcon((Bitmap)this.mObj1, true);
                break;
            }
            case 2: {
                try {
                    Context context = c.createPackageContext(this.getResPackage(), 0);
                    if (badge == null) {
                        outIntent.putExtra("android.intent.extra.shortcut.ICON_RESOURCE", (Parcelable)Intent.ShortcutIconResource.fromContext((Context)context, (int)this.mInt1));
                        return;
                    }
                    Drawable dr = ContextCompat.getDrawable(context, this.mInt1);
                    if (dr.getIntrinsicWidth() <= 0 || dr.getIntrinsicHeight() <= 0) {
                        int size = ((ActivityManager)context.getSystemService("activity")).getLauncherLargeIconSize();
                        icon = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    } else {
                        icon = Bitmap.createBitmap((int)dr.getIntrinsicWidth(), (int)dr.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    }
                    dr.setBounds(0, 0, icon.getWidth(), icon.getHeight());
                    dr.draw(new Canvas(icon));
                    break;
                }
                catch (PackageManager.NameNotFoundException e) {
                    throw new IllegalArgumentException("Can't find package " + this.mObj1, e);
                }
            }
            default: {
                throw new IllegalArgumentException("Icon type not supported for intent shortcuts");
            }
        }
        if (badge != null) {
            int w = icon.getWidth();
            int h = icon.getHeight();
            badge.setBounds(w / 2, h / 2, w, h);
            badge.draw(new Canvas(icon));
        }
        outIntent.putExtra("android.intent.extra.shortcut.ICON", (Parcelable)icon);
    }

    @NonNull
    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        switch (this.mType) {
            case 1: 
            case 5: {
                bundle.putParcelable(EXTRA_OBJ, (Parcelable)((Bitmap)this.mObj1));
                break;
            }
            case -1: {
                bundle.putParcelable(EXTRA_OBJ, (Parcelable)this.mObj1);
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                bundle.putString(EXTRA_OBJ, (String)this.mObj1);
                break;
            }
            case 3: {
                bundle.putByteArray(EXTRA_OBJ, (byte[])this.mObj1);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid icon");
            }
        }
        bundle.putInt(EXTRA_TYPE, this.mType);
        bundle.putInt(EXTRA_INT1, this.mInt1);
        bundle.putInt(EXTRA_INT2, this.mInt2);
        bundle.putString(EXTRA_STRING1, this.mString1);
        if (this.mTintList != null) {
            bundle.putParcelable(EXTRA_TINT_LIST, (Parcelable)this.mTintList);
        }
        if (this.mTintMode != DEFAULT_TINT_MODE) {
            bundle.putString(EXTRA_TINT_MODE, this.mTintMode.name());
        }
        return bundle;
    }

    @NonNull
    public String toString() {
        if (this.mType == -1) {
            return String.valueOf(this.mObj1);
        }
        StringBuilder sb = new StringBuilder("Icon(typ=").append(IconCompat.typeToString(this.mType));
        switch (this.mType) {
            case 1: 
            case 5: {
                sb.append(" size=").append(((Bitmap)this.mObj1).getWidth()).append("x").append(((Bitmap)this.mObj1).getHeight());
                break;
            }
            case 2: {
                sb.append(" pkg=").append(this.mString1).append(" id=").append(String.format("0x%08x", this.getResId()));
                break;
            }
            case 3: {
                sb.append(" len=").append(this.mInt1);
                if (this.mInt2 == 0) break;
                sb.append(" off=").append(this.mInt2);
                break;
            }
            case 4: 
            case 6: {
                sb.append(" uri=").append(this.mObj1);
            }
        }
        if (this.mTintList != null) {
            sb.append(" tint=");
            sb.append(this.mTintList);
        }
        if (this.mTintMode != DEFAULT_TINT_MODE) {
            sb.append(" mode=").append(this.mTintMode);
        }
        sb.append(")");
        return sb.toString();
    }

    public void onPreParceling(boolean isStream) {
        this.mTintModeStr = this.mTintMode.name();
        switch (this.mType) {
            case -1: {
                if (isStream) {
                    throw new IllegalArgumentException("Can't serialize Icon created with IconCompat#createFromIcon");
                }
                this.mParcelable = (Parcelable)this.mObj1;
                break;
            }
            case 1: 
            case 5: {
                if (isStream) {
                    Bitmap bitmap = (Bitmap)this.mObj1;
                    ByteArrayOutputStream data = new ByteArrayOutputStream();
                    bitmap.compress(Bitmap.CompressFormat.PNG, 90, (OutputStream)data);
                    this.mData = data.toByteArray();
                    break;
                }
                this.mParcelable = (Parcelable)this.mObj1;
                break;
            }
            case 4: 
            case 6: {
                this.mData = this.mObj1.toString().getBytes(Charset.forName("UTF-16"));
                break;
            }
            case 2: {
                this.mData = ((String)this.mObj1).getBytes(Charset.forName("UTF-16"));
                break;
            }
            case 3: {
                this.mData = (byte[])this.mObj1;
            }
        }
    }

    public void onPostParceling() {
        this.mTintMode = PorterDuff.Mode.valueOf((String)this.mTintModeStr);
        switch (this.mType) {
            case -1: {
                if (this.mParcelable != null) {
                    this.mObj1 = this.mParcelable;
                    break;
                }
                throw new IllegalArgumentException("Invalid icon");
            }
            case 1: 
            case 5: {
                if (this.mParcelable != null) {
                    this.mObj1 = this.mParcelable;
                    break;
                }
                this.mObj1 = this.mData;
                this.mType = 3;
                this.mInt1 = 0;
                this.mInt2 = this.mData.length;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                this.mObj1 = new String(this.mData, Charset.forName("UTF-16"));
                if (this.mType != 2 || this.mString1 != null) break;
                this.mString1 = ((String)this.mObj1).split(":", -1)[0];
                break;
            }
            case 3: {
                this.mObj1 = this.mData;
            }
        }
    }

    private static String typeToString(int x) {
        switch (x) {
            case 1: {
                return "BITMAP";
            }
            case 5: {
                return "BITMAP_MASKABLE";
            }
            case 3: {
                return "DATA";
            }
            case 2: {
                return "RESOURCE";
            }
            case 4: {
                return "URI";
            }
            case 6: {
                return "URI_MASKABLE";
            }
        }
        return "UNKNOWN";
    }

    @Nullable
    public static IconCompat createFromBundle(@NonNull Bundle bundle) {
        int type = bundle.getInt(EXTRA_TYPE);
        IconCompat icon = new IconCompat(type);
        icon.mInt1 = bundle.getInt(EXTRA_INT1);
        icon.mInt2 = bundle.getInt(EXTRA_INT2);
        icon.mString1 = bundle.getString(EXTRA_STRING1);
        if (bundle.containsKey(EXTRA_TINT_LIST)) {
            icon.mTintList = (ColorStateList)bundle.getParcelable(EXTRA_TINT_LIST);
        }
        if (bundle.containsKey(EXTRA_TINT_MODE)) {
            icon.mTintMode = PorterDuff.Mode.valueOf((String)bundle.getString(EXTRA_TINT_MODE));
        }
        switch (type) {
            case -1: 
            case 1: 
            case 5: {
                icon.mObj1 = bundle.getParcelable(EXTRA_OBJ);
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                icon.mObj1 = bundle.getString(EXTRA_OBJ);
                break;
            }
            case 3: {
                icon.mObj1 = bundle.getByteArray(EXTRA_OBJ);
                break;
            }
            default: {
                Log.w((String)TAG, (String)("Unknown type " + type));
                return null;
            }
        }
        return icon;
    }

    @RequiresApi(value=23)
    @Nullable
    public static IconCompat createFromIcon(@NonNull Context context, @NonNull Icon icon) {
        Preconditions.checkNotNull(icon);
        return Api23Impl.createFromIcon(context, icon);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @RequiresApi(value=23)
    @Nullable
    public static IconCompat createFromIcon(@NonNull Icon icon) {
        return Api23Impl.createFromIconInner(icon);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @RequiresApi(value=23)
    @Nullable
    public static IconCompat createFromIconOrNullIfZeroResId(@NonNull Icon icon) {
        if (Api23Impl.getType(icon) == 2 && Api23Impl.getResId(icon) == 0) {
            return null;
        }
        return Api23Impl.createFromIconInner(icon);
    }

    @VisibleForTesting
    static Bitmap createLegacyIconFromAdaptiveIcon(Bitmap adaptiveIconBitmap, boolean addShadow) {
        int size = (int)(0.6666667f * (float)Math.min(adaptiveIconBitmap.getWidth(), adaptiveIconBitmap.getHeight()));
        Bitmap icon = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(icon);
        Paint paint = new Paint(3);
        float center = (float)size * 0.5f;
        float radius = center * 0.9166667f;
        if (addShadow) {
            float blur = 0.010416667f * (float)size;
            paint.setColor(0);
            paint.setShadowLayer(blur, 0.0f, 0.020833334f * (float)size, 0x3D000000);
            canvas.drawCircle(center, center, radius, paint);
            paint.setShadowLayer(blur, 0.0f, 0.0f, 0x1E000000);
            canvas.drawCircle(center, center, radius, paint);
            paint.clearShadowLayer();
        }
        paint.setColor(-16777216);
        BitmapShader shader = new BitmapShader(adaptiveIconBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        Matrix shift = new Matrix();
        shift.setTranslate((float)(-(adaptiveIconBitmap.getWidth() - size)) / 2.0f, (float)(-(adaptiveIconBitmap.getHeight() - size)) / 2.0f);
        shader.setLocalMatrix(shift);
        paint.setShader((Shader)shader);
        canvas.drawCircle(center, center, radius, paint);
        canvas.setBitmap(null);
        return icon;
    }

    @RequiresApi(value=23)
    static class Api23Impl {
        private Api23Impl() {
        }

        @Nullable
        static IconCompat createFromIcon(@NonNull Context context, @NonNull Icon icon) {
            switch (Api23Impl.getType(icon)) {
                case 2: {
                    String resPackage = Api23Impl.getResPackage(icon);
                    try {
                        return IconCompat.createWithResource(IconCompat.getResources(context, resPackage), resPackage, Api23Impl.getResId(icon));
                    }
                    catch (Resources.NotFoundException e) {
                        throw new IllegalArgumentException("Icon resource cannot be found");
                    }
                }
                case 4: {
                    return IconCompat.createWithContentUri(Api23Impl.getUri(icon));
                }
                case 6: {
                    return IconCompat.createWithAdaptiveBitmapContentUri(Api23Impl.getUri(icon));
                }
            }
            IconCompat iconCompat = new IconCompat(-1);
            iconCompat.mObj1 = icon;
            return iconCompat;
        }

        static int getType(@NonNull Object icon) {
            if (Build.VERSION.SDK_INT >= 28) {
                return Api28Impl.getType(icon);
            }
            try {
                return (Integer)icon.getClass().getMethod("getType", new Class[0]).invoke(icon, new Object[0]);
            }
            catch (IllegalAccessException e) {
                Log.e((String)IconCompat.TAG, (String)("Unable to get icon type " + icon), (Throwable)e);
                return -1;
            }
            catch (InvocationTargetException e) {
                Log.e((String)IconCompat.TAG, (String)("Unable to get icon type " + icon), (Throwable)e);
                return -1;
            }
            catch (NoSuchMethodException e) {
                Log.e((String)IconCompat.TAG, (String)("Unable to get icon type " + icon), (Throwable)e);
                return -1;
            }
        }

        @Nullable
        static String getResPackage(@NonNull Object icon) {
            if (Build.VERSION.SDK_INT >= 28) {
                return Api28Impl.getResPackage(icon);
            }
            try {
                return (String)icon.getClass().getMethod("getResPackage", new Class[0]).invoke(icon, new Object[0]);
            }
            catch (IllegalAccessException e) {
                Log.e((String)IconCompat.TAG, (String)"Unable to get icon package", (Throwable)e);
                return null;
            }
            catch (InvocationTargetException e) {
                Log.e((String)IconCompat.TAG, (String)"Unable to get icon package", (Throwable)e);
                return null;
            }
            catch (NoSuchMethodException e) {
                Log.e((String)IconCompat.TAG, (String)"Unable to get icon package", (Throwable)e);
                return null;
            }
        }

        static IconCompat createFromIconInner(@NonNull Object icon) {
            Preconditions.checkNotNull(icon);
            switch (Api23Impl.getType(icon)) {
                case 2: {
                    return IconCompat.createWithResource(null, Api23Impl.getResPackage(icon), Api23Impl.getResId(icon));
                }
                case 4: {
                    return IconCompat.createWithContentUri(Api23Impl.getUri(icon));
                }
                case 6: {
                    return IconCompat.createWithAdaptiveBitmapContentUri(Api23Impl.getUri(icon));
                }
            }
            IconCompat iconCompat = new IconCompat(-1);
            iconCompat.mObj1 = icon;
            return iconCompat;
        }

        @IdRes
        @DrawableRes
        static int getResId(@NonNull Object icon) {
            if (Build.VERSION.SDK_INT >= 28) {
                return Api28Impl.getResId(icon);
            }
            try {
                return (Integer)icon.getClass().getMethod("getResId", new Class[0]).invoke(icon, new Object[0]);
            }
            catch (IllegalAccessException e) {
                Log.e((String)IconCompat.TAG, (String)"Unable to get icon resource", (Throwable)e);
                return 0;
            }
            catch (InvocationTargetException e) {
                Log.e((String)IconCompat.TAG, (String)"Unable to get icon resource", (Throwable)e);
                return 0;
            }
            catch (NoSuchMethodException e) {
                Log.e((String)IconCompat.TAG, (String)"Unable to get icon resource", (Throwable)e);
                return 0;
            }
        }

        @Nullable
        static Uri getUri(@NonNull Object icon) {
            if (Build.VERSION.SDK_INT >= 28) {
                return Api28Impl.getUri(icon);
            }
            try {
                return (Uri)icon.getClass().getMethod("getUri", new Class[0]).invoke(icon, new Object[0]);
            }
            catch (IllegalAccessException e) {
                Log.e((String)IconCompat.TAG, (String)"Unable to get icon uri", (Throwable)e);
                return null;
            }
            catch (InvocationTargetException e) {
                Log.e((String)IconCompat.TAG, (String)"Unable to get icon uri", (Throwable)e);
                return null;
            }
            catch (NoSuchMethodException e) {
                Log.e((String)IconCompat.TAG, (String)"Unable to get icon uri", (Throwable)e);
                return null;
            }
        }

        static Icon toIcon(IconCompat iconCompat, Context context) {
            Icon icon;
            switch (iconCompat.mType) {
                case -1: {
                    return (Icon)iconCompat.mObj1;
                }
                case 1: {
                    icon = Icon.createWithBitmap((Bitmap)((Bitmap)iconCompat.mObj1));
                    break;
                }
                case 5: {
                    if (Build.VERSION.SDK_INT >= 26) {
                        icon = Api26Impl.createWithAdaptiveBitmap((Bitmap)iconCompat.mObj1);
                        break;
                    }
                    icon = Icon.createWithBitmap((Bitmap)IconCompat.createLegacyIconFromAdaptiveIcon((Bitmap)iconCompat.mObj1, false));
                    break;
                }
                case 2: {
                    icon = Icon.createWithResource((String)iconCompat.getResPackage(), (int)iconCompat.mInt1);
                    break;
                }
                case 3: {
                    icon = Icon.createWithData((byte[])((byte[])iconCompat.mObj1), (int)iconCompat.mInt1, (int)iconCompat.mInt2);
                    break;
                }
                case 4: {
                    icon = Icon.createWithContentUri((String)((String)iconCompat.mObj1));
                    break;
                }
                case 6: {
                    if (Build.VERSION.SDK_INT >= 30) {
                        icon = Api30Impl.createWithAdaptiveBitmapContentUri(iconCompat.getUri());
                        break;
                    }
                    if (context == null) {
                        throw new IllegalArgumentException("Context is required to resolve the file uri of the icon: " + iconCompat.getUri());
                    }
                    InputStream is = iconCompat.getUriInputStream(context);
                    if (is == null) {
                        throw new IllegalStateException("Cannot load adaptive icon from uri: " + iconCompat.getUri());
                    }
                    if (Build.VERSION.SDK_INT >= 26) {
                        icon = Api26Impl.createWithAdaptiveBitmap(BitmapFactory.decodeStream((InputStream)is));
                        break;
                    }
                    icon = Icon.createWithBitmap((Bitmap)IconCompat.createLegacyIconFromAdaptiveIcon(BitmapFactory.decodeStream((InputStream)is), false));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type");
                }
            }
            if (iconCompat.mTintList != null) {
                icon.setTintList(iconCompat.mTintList);
            }
            if (iconCompat.mTintMode != DEFAULT_TINT_MODE) {
                icon.setTintMode(iconCompat.mTintMode);
            }
            return icon;
        }

        static Drawable loadDrawable(Icon icon, Context context) {
            return icon.loadDrawable(context);
        }
    }

    @RequiresApi(value=26)
    static class Api26Impl {
        private Api26Impl() {
        }

        static Drawable createAdaptiveIconDrawable(Drawable backgroundDrawable, Drawable foregroundDrawable) {
            return new AdaptiveIconDrawable(backgroundDrawable, foregroundDrawable);
        }

        static Icon createWithAdaptiveBitmap(Bitmap bits) {
            return Icon.createWithAdaptiveBitmap((Bitmap)bits);
        }
    }

    @RequiresApi(value=30)
    static class Api30Impl {
        private Api30Impl() {
        }

        static Icon createWithAdaptiveBitmapContentUri(Uri uri) {
            return Icon.createWithAdaptiveBitmapContentUri((Uri)uri);
        }
    }

    @RequiresApi(value=28)
    static class Api28Impl {
        private Api28Impl() {
        }

        static String getResPackage(Object icon) {
            return ((Icon)icon).getResPackage();
        }

        static int getType(Object icon) {
            return ((Icon)icon).getType();
        }

        static int getResId(Object icon) {
            return ((Icon)icon).getResId();
        }

        static Uri getUri(Object icon) {
            return ((Icon)icon).getUri();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface IconType {
    }
}

