/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.hardware.fingerprint;

import android.content.Context;
import android.hardware.fingerprint.FingerprintManager;
import android.os.Build;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RequiresPermission;
import androidx.annotation.RestrictTo;
import androidx.core.os.CancellationSignal;
import java.security.Signature;
import javax.crypto.Cipher;
import javax.crypto.Mac;

@Deprecated
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class FingerprintManagerCompat {
    private final Context mContext;

    @NonNull
    public static FingerprintManagerCompat from(@NonNull Context context) {
        return new FingerprintManagerCompat(context);
    }

    private FingerprintManagerCompat(Context context) {
        this.mContext = context;
    }

    @RequiresPermission(value="android.permission.USE_FINGERPRINT")
    public boolean hasEnrolledFingerprints() {
        if (Build.VERSION.SDK_INT >= 23) {
            FingerprintManager fp = FingerprintManagerCompat.getFingerprintManagerOrNull(this.mContext);
            return fp != null && Api23Impl.hasEnrolledFingerprints(fp);
        }
        return false;
    }

    @RequiresPermission(value="android.permission.USE_FINGERPRINT")
    public boolean isHardwareDetected() {
        if (Build.VERSION.SDK_INT >= 23) {
            FingerprintManager fp = FingerprintManagerCompat.getFingerprintManagerOrNull(this.mContext);
            return fp != null && Api23Impl.isHardwareDetected(fp);
        }
        return false;
    }

    @Deprecated
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @RequiresPermission(value="android.permission.USE_FINGERPRINT")
    public void authenticate(@Nullable CryptoObject crypto, int flags, @Nullable CancellationSignal cancel, @NonNull AuthenticationCallback callback, @Nullable Handler handler) {
        this.authenticate(crypto, flags, cancel != null ? (android.os.CancellationSignal)cancel.getCancellationSignalObject() : null, callback, handler);
    }

    @RequiresPermission(value="android.permission.USE_FINGERPRINT")
    public void authenticate(@Nullable CryptoObject crypto, int flags, @Nullable android.os.CancellationSignal cancel, @NonNull AuthenticationCallback callback, @Nullable Handler handler) {
        FingerprintManager fp;
        if (Build.VERSION.SDK_INT >= 23 && (fp = FingerprintManagerCompat.getFingerprintManagerOrNull(this.mContext)) != null) {
            Api23Impl.authenticate(fp, FingerprintManagerCompat.wrapCryptoObject(crypto), cancel, flags, FingerprintManagerCompat.wrapCallback(callback), handler);
        }
    }

    @Nullable
    @RequiresApi(value=23)
    private static FingerprintManager getFingerprintManagerOrNull(@NonNull Context context) {
        return Api23Impl.getFingerprintManagerOrNull(context);
    }

    @RequiresApi(value=23)
    private static FingerprintManager.CryptoObject wrapCryptoObject(CryptoObject cryptoObject) {
        return Api23Impl.wrapCryptoObject(cryptoObject);
    }

    @RequiresApi(value=23)
    static CryptoObject unwrapCryptoObject(FingerprintManager.CryptoObject cryptoObject) {
        return Api23Impl.unwrapCryptoObject(cryptoObject);
    }

    @RequiresApi(value=23)
    private static FingerprintManager.AuthenticationCallback wrapCallback(final AuthenticationCallback callback) {
        return new FingerprintManager.AuthenticationCallback(){

            public void onAuthenticationError(int errMsgId, CharSequence errString) {
                callback.onAuthenticationError(errMsgId, errString);
            }

            public void onAuthenticationHelp(int helpMsgId, CharSequence helpString) {
                callback.onAuthenticationHelp(helpMsgId, helpString);
            }

            public void onAuthenticationSucceeded(FingerprintManager.AuthenticationResult result) {
                callback.onAuthenticationSucceeded(new AuthenticationResult(FingerprintManagerCompat.unwrapCryptoObject(Api23Impl.getCryptoObject(result))));
            }

            public void onAuthenticationFailed() {
                callback.onAuthenticationFailed();
            }
        };
    }

    @RequiresApi(value=23)
    static class Api23Impl {
        private Api23Impl() {
        }

        @RequiresPermission(value="android.permission.USE_FINGERPRINT")
        static boolean hasEnrolledFingerprints(Object fingerprintManager) {
            return ((FingerprintManager)fingerprintManager).hasEnrolledFingerprints();
        }

        @RequiresPermission(value="android.permission.USE_FINGERPRINT")
        static boolean isHardwareDetected(Object fingerprintManager) {
            return ((FingerprintManager)fingerprintManager).isHardwareDetected();
        }

        @RequiresPermission(value="android.permission.USE_FINGERPRINT")
        static void authenticate(Object fingerprintManager, Object crypto, android.os.CancellationSignal cancel, int flags, Object callback, Handler handler) {
            ((FingerprintManager)fingerprintManager).authenticate((FingerprintManager.CryptoObject)crypto, cancel, flags, (FingerprintManager.AuthenticationCallback)callback, handler);
        }

        static FingerprintManager.CryptoObject getCryptoObject(Object authenticationResult) {
            return ((FingerprintManager.AuthenticationResult)authenticationResult).getCryptoObject();
        }

        public static FingerprintManager getFingerprintManagerOrNull(Context context) {
            if (Build.VERSION.SDK_INT == 23) {
                return (FingerprintManager)context.getSystemService(FingerprintManager.class);
            }
            if (Build.VERSION.SDK_INT > 23 && context.getPackageManager().hasSystemFeature("android.hardware.fingerprint")) {
                return (FingerprintManager)context.getSystemService(FingerprintManager.class);
            }
            return null;
        }

        public static FingerprintManager.CryptoObject wrapCryptoObject(CryptoObject cryptoObject) {
            if (cryptoObject == null) {
                return null;
            }
            if (cryptoObject.getCipher() != null) {
                return new FingerprintManager.CryptoObject(cryptoObject.getCipher());
            }
            if (cryptoObject.getSignature() != null) {
                return new FingerprintManager.CryptoObject(cryptoObject.getSignature());
            }
            if (cryptoObject.getMac() != null) {
                return new FingerprintManager.CryptoObject(cryptoObject.getMac());
            }
            return null;
        }

        public static CryptoObject unwrapCryptoObject(Object cryptoObjectObj) {
            FingerprintManager.CryptoObject cryptoObject = (FingerprintManager.CryptoObject)cryptoObjectObj;
            if (cryptoObject == null) {
                return null;
            }
            if (cryptoObject.getCipher() != null) {
                return new CryptoObject(cryptoObject.getCipher());
            }
            if (cryptoObject.getSignature() != null) {
                return new CryptoObject(cryptoObject.getSignature());
            }
            if (cryptoObject.getMac() != null) {
                return new CryptoObject(cryptoObject.getMac());
            }
            return null;
        }
    }

    public static class CryptoObject {
        private final Signature mSignature;
        private final Cipher mCipher;
        private final Mac mMac;

        public CryptoObject(@NonNull Signature signature) {
            this.mSignature = signature;
            this.mCipher = null;
            this.mMac = null;
        }

        public CryptoObject(@NonNull Cipher cipher) {
            this.mCipher = cipher;
            this.mSignature = null;
            this.mMac = null;
        }

        public CryptoObject(@NonNull Mac mac) {
            this.mMac = mac;
            this.mCipher = null;
            this.mSignature = null;
        }

        @Nullable
        public Signature getSignature() {
            return this.mSignature;
        }

        @Nullable
        public Cipher getCipher() {
            return this.mCipher;
        }

        @Nullable
        public Mac getMac() {
            return this.mMac;
        }
    }

    public static abstract class AuthenticationCallback {
        public void onAuthenticationError(int errMsgId, @NonNull CharSequence errString) {
        }

        public void onAuthenticationHelp(int helpMsgId, @NonNull CharSequence helpString) {
        }

        public void onAuthenticationSucceeded(@NonNull AuthenticationResult result) {
        }

        public void onAuthenticationFailed() {
        }
    }

    public static final class AuthenticationResult {
        private final CryptoObject mCryptoObject;

        public AuthenticationResult(@NonNull CryptoObject crypto) {
            this.mCryptoObject = crypto;
        }

        @NonNull
        public CryptoObject getCryptoObject() {
            return this.mCryptoObject;
        }
    }
}

