/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.net;

import android.net.TrafficStats;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.core.net.DatagramSocketWrapper;
import java.net.DatagramSocket;
import java.net.Socket;
import java.net.SocketException;

public final class TrafficStatsCompat {
    @Deprecated
    public static void clearThreadStatsTag() {
        TrafficStats.clearThreadStatsTag();
    }

    @Deprecated
    public static int getThreadStatsTag() {
        return TrafficStats.getThreadStatsTag();
    }

    @Deprecated
    public static void incrementOperationCount(int operationCount) {
        TrafficStats.incrementOperationCount((int)operationCount);
    }

    @Deprecated
    public static void incrementOperationCount(int tag, int operationCount) {
        TrafficStats.incrementOperationCount((int)tag, (int)operationCount);
    }

    @Deprecated
    public static void setThreadStatsTag(int tag) {
        TrafficStats.setThreadStatsTag((int)tag);
    }

    @Deprecated
    public static void tagSocket(Socket socket) throws SocketException {
        TrafficStats.tagSocket((Socket)socket);
    }

    @Deprecated
    public static void untagSocket(Socket socket) throws SocketException {
        TrafficStats.untagSocket((Socket)socket);
    }

    public static void tagDatagramSocket(@NonNull DatagramSocket socket) throws SocketException {
        if (Build.VERSION.SDK_INT >= 24) {
            Api24Impl.tagDatagramSocket(socket);
        } else {
            ParcelFileDescriptor pfd = ParcelFileDescriptor.fromDatagramSocket((DatagramSocket)socket);
            TrafficStats.tagSocket((Socket)new DatagramSocketWrapper(socket, pfd.getFileDescriptor()));
            pfd.detachFd();
        }
    }

    public static void untagDatagramSocket(@NonNull DatagramSocket socket) throws SocketException {
        if (Build.VERSION.SDK_INT >= 24) {
            Api24Impl.untagDatagramSocket(socket);
        } else {
            ParcelFileDescriptor pfd = ParcelFileDescriptor.fromDatagramSocket((DatagramSocket)socket);
            TrafficStats.untagSocket((Socket)new DatagramSocketWrapper(socket, pfd.getFileDescriptor()));
            pfd.detachFd();
        }
    }

    private TrafficStatsCompat() {
    }

    @RequiresApi(value=24)
    static class Api24Impl {
        private Api24Impl() {
        }

        static void tagDatagramSocket(DatagramSocket socket) throws SocketException {
            TrafficStats.tagDatagramSocket((DatagramSocket)socket);
        }

        static void untagDatagramSocket(DatagramSocket socket) throws SocketException {
            TrafficStats.untagDatagramSocket((DatagramSocket)socket);
        }
    }
}

