/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.os;

import android.os.Build;
import android.os.ext.SdkExtensions;
import androidx.annotation.ChecksSdkIntAtLeast;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import java.lang.annotation.RetentionPolicy;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.RequiresOptIn;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0019\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0007J\b\u0010\n\u001a\u00020\tH\u0007J\b\u0010\u000b\u001a\u00020\tH\u0007J\b\u0010\f\u001a\u00020\tH\u0007J\b\u0010\r\u001a\u00020\tH\u0007J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0007J\b\u0010\u0012\u001a\u00020\tH\u0007J\b\u0010\u0013\u001a\u00020\tH\u0007J\b\u0010\u0014\u001a\u00020\tH\u0007J\b\u0010\u0015\u001a\u00020\tH\u0007J\b\u0010\u0016\u001a\u00020\tH\u0007J\b\u0010\u0017\u001a\u00020\tH\u0007J\b\u0010\u0018\u001a\u00020\tH\u0007R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Landroidx/core/os/BuildCompat;", "", "()V", "AD_SERVICES_EXTENSION_INT", "", "R_EXTENSION_INT", "S_EXTENSION_INT", "T_EXTENSION_INT", "isAtLeastN", "", "isAtLeastNMR1", "isAtLeastO", "isAtLeastOMR1", "isAtLeastP", "isAtLeastPreReleaseCodename", "codename", "", "buildCodename", "isAtLeastQ", "isAtLeastR", "isAtLeastS", "isAtLeastSv2", "isAtLeastT", "isAtLeastU", "isAtLeastV", "Api30Impl", "PrereleaseSdkCheck", "core_release"})
public final class BuildCompat {
    @NotNull
    public static final BuildCompat INSTANCE = new BuildCompat();
    @JvmField
    @ChecksSdkIntAtLeast(extension=30)
    public static final int R_EXTENSION_INT = Build.VERSION.SDK_INT >= 30 ? Api30Impl.INSTANCE.getExtensionVersion(30) : 0;
    @JvmField
    @ChecksSdkIntAtLeast(extension=31)
    public static final int S_EXTENSION_INT = Build.VERSION.SDK_INT >= 30 ? Api30Impl.INSTANCE.getExtensionVersion(31) : 0;
    @JvmField
    @ChecksSdkIntAtLeast(extension=33)
    public static final int T_EXTENSION_INT = Build.VERSION.SDK_INT >= 30 ? Api30Impl.INSTANCE.getExtensionVersion(33) : 0;
    @JvmField
    @ChecksSdkIntAtLeast(extension=1000000)
    public static final int AD_SERVICES_EXTENSION_INT = Build.VERSION.SDK_INT >= 30 ? Api30Impl.INSTANCE.getExtensionVersion(1000000) : 0;

    private BuildCompat() {
    }

    @JvmStatic
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @VisibleForTesting
    public static final boolean isAtLeastPreReleaseCodename(@NotNull String codename, @NotNull String buildCodename) {
        Intrinsics.checkNotNullParameter((Object)codename, (String)"codename");
        Intrinsics.checkNotNullParameter((Object)buildCodename, (String)"buildCodename");
        if (Intrinsics.areEqual((Object)"REL", (Object)buildCodename)) {
            return false;
        }
        String string = buildCodename.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        String string2 = codename.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        return string.compareTo(string2) >= 0;
    }

    @JvmStatic
    @Deprecated(message="Android N is a finalized release and this method is no longer necessary. It will be removed in a future release of this library. Instead, use `Build.VERSION.SDK_INT >= 24`.", replaceWith=@ReplaceWith(expression="android.os.Build.VERSION.SDK_INT >= 24", imports={}))
    @ChecksSdkIntAtLeast(api=24)
    public static final boolean isAtLeastN() {
        return Build.VERSION.SDK_INT >= 24;
    }

    @JvmStatic
    @Deprecated(message="Android N MR1 is a finalized release and this method is no longer necessary. It will be removed in a future release of this library. Instead, use `Build.VERSION.SDK_INT >= 25`.", replaceWith=@ReplaceWith(expression="android.os.Build.VERSION.SDK_INT >= 25", imports={}))
    @ChecksSdkIntAtLeast(api=25)
    public static final boolean isAtLeastNMR1() {
        return Build.VERSION.SDK_INT >= 25;
    }

    @JvmStatic
    @Deprecated(message="Android O is a finalized release and this method is no longer necessary. It will be removed in a future release of this library. Instead use `Build.VERSION.SDK_INT >= 26`.", replaceWith=@ReplaceWith(expression="android.os.Build.VERSION.SDK_INT >= 26", imports={}))
    @ChecksSdkIntAtLeast(api=26)
    public static final boolean isAtLeastO() {
        return Build.VERSION.SDK_INT >= 26;
    }

    @JvmStatic
    @Deprecated(message="Android O MR1 is a finalized release and this method is no longer necessary. It will be removed in a future release of this library. Instead, use `Build.VERSION.SDK_INT >= 27`.", replaceWith=@ReplaceWith(expression="android.os.Build.VERSION.SDK_INT >= 27", imports={}))
    @ChecksSdkIntAtLeast(api=27)
    public static final boolean isAtLeastOMR1() {
        return Build.VERSION.SDK_INT >= 27;
    }

    @JvmStatic
    @Deprecated(message="Android P is a finalized release and this method is no longer necessary. It will be removed in a future release of this library. Instead, use `Build.VERSION.SDK_INT >= 28`.", replaceWith=@ReplaceWith(expression="android.os.Build.VERSION.SDK_INT >= 28", imports={}))
    @ChecksSdkIntAtLeast(api=28)
    public static final boolean isAtLeastP() {
        return Build.VERSION.SDK_INT >= 28;
    }

    @JvmStatic
    @Deprecated(message="Android Q is a finalized release and this method is no longer necessary. It will be removed in a future release of this library. Instead, use `Build.VERSION.SDK_INT >= 29`.", replaceWith=@ReplaceWith(expression="android.os.Build.VERSION.SDK_INT >= 29", imports={}))
    @ChecksSdkIntAtLeast(api=29)
    public static final boolean isAtLeastQ() {
        return Build.VERSION.SDK_INT >= 29;
    }

    @JvmStatic
    @Deprecated(message="Android R is a finalized release and this method is no longer necessary. It will be removed in a future release of this library. Instead, use `Build.VERSION.SDK_INT >= 30`.", replaceWith=@ReplaceWith(expression="android.os.Build.VERSION.SDK_INT >= 30", imports={}))
    @ChecksSdkIntAtLeast(api=30)
    public static final boolean isAtLeastR() {
        return Build.VERSION.SDK_INT >= 30;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    @Deprecated(message="Android S is a finalized release and this method is no longer necessary. It will be removed in a future release of this library. Instead, use `Build.VERSION.SDK_INT >= 31`.", replaceWith=@ReplaceWith(expression="android.os.Build.VERSION.SDK_INT >= 31", imports={}))
    @ChecksSdkIntAtLeast(api=31, codename="S")
    public static final boolean isAtLeastS() {
        if (Build.VERSION.SDK_INT >= 31) return true;
        if (Build.VERSION.SDK_INT < 30) return false;
        String string = Build.VERSION.CODENAME;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CODENAME");
        if (!BuildCompat.isAtLeastPreReleaseCodename("S", string)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    @Deprecated(message="Android Sv2 is a finalized release and this method is no longer necessary. It will be removed in a future release of this library. Instead, use `Build.VERSION.SDK_INT >= 32`.", replaceWith=@ReplaceWith(expression="android.os.Build.VERSION.SDK_INT >= 32", imports={}))
    @ChecksSdkIntAtLeast(api=32, codename="Sv2")
    public static final boolean isAtLeastSv2() {
        if (Build.VERSION.SDK_INT >= 32) return true;
        if (Build.VERSION.SDK_INT < 31) return false;
        String string = Build.VERSION.CODENAME;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CODENAME");
        if (!BuildCompat.isAtLeastPreReleaseCodename("Sv2", string)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    @Deprecated(message="Android Tiramisu is a finalized release and this method is no longer necessary. It will be removed in a future release of this library. Instead, use `Build.VERSION.SDK_INT >= 33`.", replaceWith=@ReplaceWith(expression="android.os.Build.VERSION.SDK_INT >= 33", imports={}))
    @ChecksSdkIntAtLeast(api=33, codename="Tiramisu")
    public static final boolean isAtLeastT() {
        if (Build.VERSION.SDK_INT >= 33) return true;
        if (Build.VERSION.SDK_INT < 32) return false;
        String string = Build.VERSION.CODENAME;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CODENAME");
        if (!BuildCompat.isAtLeastPreReleaseCodename("Tiramisu", string)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    @Deprecated(message="Android UpsideDownCase is a finalized release and this method is no longer necessary. It will be removed in a future release of this library. Instead, use `Build.VERSION.SDK_INT >= 34`.", replaceWith=@ReplaceWith(expression="android.os.Build.VERSION.SDK_INT >= 34", imports={}))
    @ChecksSdkIntAtLeast(api=34, codename="UpsideDownCake")
    public static final boolean isAtLeastU() {
        if (Build.VERSION.SDK_INT >= 34) return true;
        if (Build.VERSION.SDK_INT < 33) return false;
        String string = Build.VERSION.CODENAME;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CODENAME");
        if (!BuildCompat.isAtLeastPreReleaseCodename("UpsideDownCake", string)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    @ChecksSdkIntAtLeast(api=35, codename="VanillaIceCream")
    public static final boolean isAtLeastV() {
        if (Build.VERSION.SDK_INT >= 35) return true;
        if (Build.VERSION.SDK_INT < 34) return false;
        String string = Build.VERSION.CODENAME;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CODENAME");
        if (!BuildCompat.isAtLeastPreReleaseCodename("VanillaIceCream", string)) return false;
        return true;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c3\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u0006"}, d2={"Landroidx/core/os/BuildCompat$Api30Impl;", "", "()V", "getExtensionVersion", "", "extension", "core_release"})
    @RequiresApi(value=30)
    private static final class Api30Impl {
        @NotNull
        public static final Api30Impl INSTANCE = new Api30Impl();

        private Api30Impl() {
        }

        public final int getExtensionVersion(int extension) {
            return SdkExtensions.getExtensionVersion((int)extension);
        }
    }

    @Retention(value=AnnotationRetention.BINARY)
    @java.lang.annotation.Retention(value=RetentionPolicy.CLASS)
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Landroidx/core/os/BuildCompat$PrereleaseSdkCheck;", "", "core_release"})
    @RequiresOptIn
    public static @interface PrereleaseSdkCheck {
    }
}

