/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.os;

import android.os.Build;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.core.os.LocaleListCompat;
import androidx.core.os.LocaleListInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;

final class LocaleListCompatWrapper
implements LocaleListInterface {
    private final Locale[] mList;
    @NonNull
    private final String mStringRepresentation;
    private static final Locale[] sEmptyList = new Locale[0];
    private static final Locale LOCALE_EN_XA = new Locale("en", "XA");
    private static final Locale LOCALE_AR_XB = new Locale("ar", "XB");
    private static final Locale EN_LATN = LocaleListCompat.forLanguageTagCompat("en-Latn");

    @Override
    @Nullable
    public Object getLocaleList() {
        return null;
    }

    @Override
    public Locale get(int index) {
        return 0 <= index && index < this.mList.length ? this.mList[index] : null;
    }

    @Override
    public boolean isEmpty() {
        return this.mList.length == 0;
    }

    @Override
    public int size() {
        return this.mList.length;
    }

    @Override
    public int indexOf(Locale locale) {
        for (int i = 0; i < this.mList.length; ++i) {
            if (!this.mList[i].equals(locale)) continue;
            return i;
        }
        return -1;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof LocaleListCompatWrapper)) {
            return false;
        }
        Locale[] otherList = ((LocaleListCompatWrapper)other).mList;
        if (this.mList.length != otherList.length) {
            return false;
        }
        for (int i = 0; i < this.mList.length; ++i) {
            if (this.mList[i].equals(otherList[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        for (Locale locale : this.mList) {
            result = 31 * result + locale.hashCode();
        }
        return result;
    }

    @NonNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < this.mList.length; ++i) {
            sb.append(this.mList[i]);
            if (i >= this.mList.length - 1) continue;
            sb.append(',');
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String toLanguageTags() {
        return this.mStringRepresentation;
    }

    LocaleListCompatWrapper(Locale ... list) {
        if (list.length == 0) {
            this.mList = sEmptyList;
            this.mStringRepresentation = "";
        } else {
            ArrayList<Locale> localeList = new ArrayList<Locale>();
            HashSet<Locale> seenLocales = new HashSet<Locale>();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < list.length; ++i) {
                Locale l = list[i];
                if (l == null) {
                    throw new NullPointerException("list[" + i + "] is null");
                }
                if (seenLocales.contains(l)) continue;
                Locale localeClone = (Locale)l.clone();
                localeList.add(localeClone);
                LocaleListCompatWrapper.toLanguageTag(sb, localeClone);
                if (i < list.length - 1) {
                    sb.append(',');
                }
                seenLocales.add(localeClone);
            }
            this.mList = localeList.toArray(new Locale[0]);
            this.mStringRepresentation = sb.toString();
        }
    }

    @VisibleForTesting
    static void toLanguageTag(StringBuilder builder, Locale locale) {
        builder.append(locale.getLanguage());
        String country = locale.getCountry();
        if (country != null && !country.isEmpty()) {
            builder.append('-');
            builder.append(locale.getCountry());
        }
    }

    private static String getLikelyScript(Locale locale) {
        if (Build.VERSION.SDK_INT >= 21) {
            String script = Api21Impl.getScript(locale);
            if (!script.isEmpty()) {
                return script;
            }
            return "";
        }
        return "";
    }

    private static boolean isPseudoLocale(Locale locale) {
        return LOCALE_EN_XA.equals(locale) || LOCALE_AR_XB.equals(locale);
    }

    @IntRange(from=0L, to=1L)
    private static int matchScore(Locale supported, Locale desired) {
        if (supported.equals(desired)) {
            return 1;
        }
        if (!supported.getLanguage().equals(desired.getLanguage())) {
            return 0;
        }
        if (LocaleListCompatWrapper.isPseudoLocale(supported) || LocaleListCompatWrapper.isPseudoLocale(desired)) {
            return 0;
        }
        String supportedScr = LocaleListCompatWrapper.getLikelyScript(supported);
        if (supportedScr.isEmpty()) {
            String supportedRegion = supported.getCountry();
            return supportedRegion.isEmpty() || supportedRegion.equals(desired.getCountry()) ? 1 : 0;
        }
        String desiredScr = LocaleListCompatWrapper.getLikelyScript(desired);
        return supportedScr.equals(desiredScr) ? 1 : 0;
    }

    private int findFirstMatchIndex(Locale supportedLocale) {
        for (int idx = 0; idx < this.mList.length; ++idx) {
            int score = LocaleListCompatWrapper.matchScore(supportedLocale, this.mList[idx]);
            if (score <= 0) continue;
            return idx;
        }
        return Integer.MAX_VALUE;
    }

    private int computeFirstMatchIndex(Collection<String> supportedLocales, boolean assumeEnglishIsSupported) {
        if (this.mList.length == 1) {
            return 0;
        }
        if (this.mList.length == 0) {
            return -1;
        }
        int bestIndex = Integer.MAX_VALUE;
        if (assumeEnglishIsSupported) {
            int idx = this.findFirstMatchIndex(EN_LATN);
            if (idx == 0) {
                return 0;
            }
            if (idx < bestIndex) {
                bestIndex = idx;
            }
        }
        for (String languageTag : supportedLocales) {
            Locale supportedLocale = LocaleListCompat.forLanguageTagCompat(languageTag);
            int idx = this.findFirstMatchIndex(supportedLocale);
            if (idx == 0) {
                return 0;
            }
            if (idx >= bestIndex) continue;
            bestIndex = idx;
        }
        if (bestIndex == Integer.MAX_VALUE) {
            return 0;
        }
        return bestIndex;
    }

    private Locale computeFirstMatch(Collection<String> supportedLocales, boolean assumeEnglishIsSupported) {
        int bestIndex = this.computeFirstMatchIndex(supportedLocales, assumeEnglishIsSupported);
        return bestIndex == -1 ? null : this.mList[bestIndex];
    }

    @Override
    public Locale getFirstMatch(@NonNull String[] supportedLocales) {
        return this.computeFirstMatch(Arrays.asList(supportedLocales), false);
    }

    @RequiresApi(value=21)
    static class Api21Impl {
        private Api21Impl() {
        }

        static String getScript(Locale locale) {
            return locale.getScript();
        }
    }
}

