/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.os;

import android.annotation.SuppressLint;
import android.os.BadParcelableException;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ParcelCompat {
    public static boolean readBoolean(@NonNull Parcel in) {
        return in.readInt() != 0;
    }

    public static void writeBoolean(@NonNull Parcel out, boolean value) {
        if (Build.VERSION.SDK_INT >= 29) {
            Api29Impl.writeBoolean(out, value);
        } else {
            out.writeInt(value ? 1 : 0);
        }
    }

    public static <T> void readList(@NonNull Parcel in, @NonNull List<? super T> outVal, @Nullable ClassLoader loader, @NonNull Class<T> clazz) {
        if (Build.VERSION.SDK_INT >= 34) {
            Api33Impl.readList(in, outVal, loader, clazz);
        } else {
            in.readList(outVal, loader);
        }
    }

    @SuppressLint(value={"ConcreteCollection", "NullableCollection"})
    @Nullable
    public static <T> ArrayList<T> readArrayList(@NonNull Parcel in, @Nullable ClassLoader loader, @NonNull Class<? extends T> clazz) {
        if (Build.VERSION.SDK_INT >= 34) {
            return Api33Impl.readArrayList(in, loader, clazz);
        }
        return in.readArrayList(loader);
    }

    @SuppressLint(value={"ArrayReturn", "NullableCollection"})
    @Nullable
    public static <T> Object[] readArray(@NonNull Parcel in, @Nullable ClassLoader loader, @NonNull Class<T> clazz) {
        if (Build.VERSION.SDK_INT >= 34) {
            return Api33Impl.readArray(in, loader, clazz);
        }
        return in.readArray(loader);
    }

    @Nullable
    public static <T> SparseArray<T> readSparseArray(@NonNull Parcel in, @Nullable ClassLoader loader, @NonNull Class<? extends T> clazz) {
        if (Build.VERSION.SDK_INT >= 34) {
            return Api33Impl.readSparseArray(in, loader, clazz);
        }
        return in.readSparseArray(loader);
    }

    public static <K, V> void readMap(@NonNull Parcel in, @NonNull Map<? super K, ? super V> outVal, @Nullable ClassLoader loader, @NonNull Class<K> clazzKey, @NonNull Class<V> clazzValue) {
        if (Build.VERSION.SDK_INT >= 34) {
            Api33Impl.readMap(in, outVal, loader, clazzKey, clazzValue);
        } else {
            in.readMap(outVal, loader);
        }
    }

    @SuppressLint(value={"ConcreteCollection", "NullableCollection"})
    @Nullable
    public static <K, V> HashMap<K, V> readHashMap(@NonNull Parcel in, @Nullable ClassLoader loader, @NonNull Class<? extends K> clazzKey, @NonNull Class<? extends V> clazzValue) {
        if (Build.VERSION.SDK_INT >= 34) {
            return Api33Impl.readHashMap(in, loader, clazzKey, clazzValue);
        }
        return in.readHashMap(loader);
    }

    @Nullable
    public static <T extends Parcelable> T readParcelable(@NonNull Parcel in, @Nullable ClassLoader loader, @NonNull Class<T> clazz) {
        if (Build.VERSION.SDK_INT >= 34) {
            return Api33Impl.readParcelable(in, loader, clazz);
        }
        Parcelable parcelable = in.readParcelable(loader);
        if (parcelable != null && !clazz.isInstance(parcelable)) {
            throw new BadParcelableException("Parcelable " + parcelable.getClass() + " is not a subclass of required class " + clazz.getName() + " provided in the parameter");
        }
        return (T)parcelable;
    }

    @Nullable
    @RequiresApi(value=30)
    public static <T> Parcelable.Creator<T> readParcelableCreator(@NonNull Parcel in, @Nullable ClassLoader loader, @NonNull Class<T> clazz) {
        if (Build.VERSION.SDK_INT >= 34) {
            return Api33Impl.readParcelableCreator(in, loader, clazz);
        }
        return Api30Impl.readParcelableCreator(in, loader);
    }

    @Deprecated
    @SuppressLint(value={"ArrayReturn", "NullableCollection"})
    @Nullable
    public static <T> T[] readParcelableArray(@NonNull Parcel in, @Nullable ClassLoader loader, @NonNull Class<T> clazz) {
        if (Build.VERSION.SDK_INT >= 34) {
            return Api33Impl.readParcelableArray(in, loader, clazz);
        }
        Parcelable[] parcelables = in.readParcelableArray(loader);
        if (clazz.isAssignableFrom(Parcelable.class)) {
            return parcelables;
        }
        Object[] typedParcelables = (Object[])Array.newInstance(clazz, parcelables.length);
        for (int i = 0; i < parcelables.length; ++i) {
            try {
                typedParcelables[i] = clazz.cast(parcelables[i]);
                continue;
            }
            catch (ClassCastException e) {
                throw new BadParcelableException("Parcelable at index " + i + " is not a subclass of required class " + clazz.getName() + " provided in the parameter");
            }
        }
        return typedParcelables;
    }

    @SuppressLint(value={"ArrayReturn", "NullableCollection"})
    @Nullable
    public static <T> Parcelable[] readParcelableArrayTyped(@NonNull Parcel in, @Nullable ClassLoader loader, @NonNull Class<T> clazz) {
        if (Build.VERSION.SDK_INT >= 34) {
            return (Parcelable[])Api33Impl.readParcelableArray(in, loader, clazz);
        }
        return in.readParcelableArray(loader);
    }

    @NonNull
    @RequiresApi(api=29)
    public static <T> List<T> readParcelableList(@NonNull Parcel in, @NonNull List<T> list, @Nullable ClassLoader cl, @NonNull Class<T> clazz) {
        if (Build.VERSION.SDK_INT >= 34) {
            return Api33Impl.readParcelableList(in, list, cl, clazz);
        }
        return Api29Impl.readParcelableList(in, list, cl);
    }

    @Nullable
    public static <T extends Serializable> T readSerializable(@NonNull Parcel in, @Nullable ClassLoader loader, @NonNull Class<T> clazz) {
        if (Build.VERSION.SDK_INT >= 33) {
            return Api33Impl.readSerializable(in, loader, clazz);
        }
        return (T)in.readSerializable();
    }

    private ParcelCompat() {
    }

    @RequiresApi(value=29)
    static class Api29Impl {
        private Api29Impl() {
        }

        static <T extends Parcelable> List<T> readParcelableList(@NonNull Parcel in, @NonNull List<T> list, @Nullable ClassLoader cl) {
            return in.readParcelableList(list, cl);
        }

        static void writeBoolean(@NonNull Parcel parcel, boolean val) {
            parcel.writeBoolean(val);
        }
    }

    @RequiresApi(value=33)
    static class Api33Impl {
        private Api33Impl() {
        }

        static <T extends Serializable> T readSerializable(@NonNull Parcel in, @Nullable ClassLoader loader, @NonNull Class<T> clazz) {
            return (T)((Serializable)in.readSerializable(loader, clazz));
        }

        static <T extends Parcelable> T readParcelable(@NonNull Parcel in, @Nullable ClassLoader loader, @NonNull Class<T> clazz) {
            return (T)((Parcelable)in.readParcelable(loader, clazz));
        }

        static <T> Parcelable.Creator<T> readParcelableCreator(Parcel in, ClassLoader loader, Class<T> clazz) {
            return in.readParcelableCreator(loader, clazz);
        }

        static <T> T[] readParcelableArray(@NonNull Parcel in, @Nullable ClassLoader loader, @NonNull Class<T> clazz) {
            return in.readParcelableArray(loader, clazz);
        }

        static <T> List<T> readParcelableList(@NonNull Parcel in, @NonNull List<T> list, @Nullable ClassLoader cl, @NonNull Class<T> clazz) {
            return in.readParcelableList(list, cl, clazz);
        }

        static <T> void readList(@NonNull Parcel in, @NonNull List<? super T> outVal, @Nullable ClassLoader loader, @NonNull Class<T> clazz) {
            in.readList(outVal, loader, clazz);
        }

        static <T> ArrayList<T> readArrayList(Parcel in, ClassLoader loader, Class<? extends T> clazz) {
            return in.readArrayList(loader, clazz);
        }

        static <T> T[] readArray(Parcel in, ClassLoader loader, Class<T> clazz) {
            return in.readArray(loader, clazz);
        }

        static <T> SparseArray<T> readSparseArray(Parcel in, ClassLoader loader, Class<? extends T> clazz) {
            return in.readSparseArray(loader, clazz);
        }

        static <K, V> void readMap(Parcel in, Map<? super K, ? super V> outVal, ClassLoader loader, Class<K> clazzKey, Class<V> clazzValue) {
            in.readMap(outVal, loader, clazzKey, clazzValue);
        }

        static <V, K> HashMap<K, V> readHashMap(Parcel in, ClassLoader loader, Class<? extends K> clazzKey, Class<? extends V> clazzValue) {
            return in.readHashMap(loader, clazzKey, clazzValue);
        }
    }

    @RequiresApi(value=30)
    static class Api30Impl {
        private Api30Impl() {
        }

        static Parcelable.Creator<?> readParcelableCreator(@NonNull Parcel in, @Nullable ClassLoader loader) {
            return in.readParcelableCreator(loader);
        }
    }
}

