/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.os;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.Process;
import android.os.UserHandle;
import androidx.annotation.RequiresApi;
import java.lang.reflect.Method;

public final class ProcessCompat {
    private ProcessCompat() {
    }

    public static boolean isApplicationUid(int uid) {
        if (Build.VERSION.SDK_INT >= 24) {
            return Api24Impl.isApplicationUid(uid);
        }
        return Api19Impl.isApplicationUid(uid);
    }

    @RequiresApi(value=24)
    static class Api24Impl {
        private Api24Impl() {
        }

        static boolean isApplicationUid(int uid) {
            return Process.isApplicationUid((int)uid);
        }
    }

    static class Api19Impl {
        private static final Object sResolvedLock = new Object();
        private static Method sMethodUserHandleIsAppMethod;
        private static boolean sResolved;

        private Api19Impl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressLint(value={"DiscouragedPrivateApi"})
        static boolean isApplicationUid(int uid) {
            try {
                Object object = sResolvedLock;
                synchronized (object) {
                    if (!sResolved) {
                        sResolved = true;
                        sMethodUserHandleIsAppMethod = UserHandle.class.getDeclaredMethod("isApp", Integer.TYPE);
                    }
                }
                if (sMethodUserHandleIsAppMethod != null) {
                    Boolean result = (Boolean)sMethodUserHandleIsAppMethod.invoke(null, uid);
                    if (result == null) {
                        throw new NullPointerException();
                    }
                    return result;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
    }
}

