/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.os;

import android.os.Bundle;
import android.os.CancellationSignal;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.os.ProfilingRequest;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b'\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00002\u00020\u0002B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u00020\u000bH%J\b\u0010\f\u001a\u00020\rH%J\r\u0010\u000e\u001a\u00028\u0000H%\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0015R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/core/os/ProfilingRequestBuilder;", "T", "", "()V", "mCancellationSignal", "Landroid/os/CancellationSignal;", "mTag", "", "build", "Landroidx/core/os/ProfilingRequest;", "getParams", "Landroid/os/Bundle;", "getProfilingType", "", "getThis", "()Landroidx/core/os/ProfilingRequestBuilder;", "setCancellationSignal", "cancellationSignal", "(Landroid/os/CancellationSignal;)Landroidx/core/os/ProfilingRequestBuilder;", "setTag", "tag", "(Ljava/lang/String;)Landroidx/core/os/ProfilingRequestBuilder;", "core_release"})
@RequiresApi(api=35)
public abstract class ProfilingRequestBuilder<T extends ProfilingRequestBuilder<T>> {
    @Nullable
    private String mTag;
    @Nullable
    private CancellationSignal mCancellationSignal;

    @NotNull
    public final T setTag(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.mTag = tag;
        return this.getThis();
    }

    @NotNull
    public final T setCancellationSignal(@NotNull CancellationSignal cancellationSignal) {
        Intrinsics.checkNotNullParameter((Object)cancellationSignal, (String)"cancellationSignal");
        this.mCancellationSignal = cancellationSignal;
        return this.getThis();
    }

    @NotNull
    public final ProfilingRequest build() {
        return new ProfilingRequest(this.getProfilingType(), this.getParams(), this.mTag, this.mCancellationSignal);
    }

    @RestrictTo(value={RestrictTo.Scope.SUBCLASSES})
    protected abstract int getProfilingType();

    @RestrictTo(value={RestrictTo.Scope.SUBCLASSES})
    @NotNull
    protected abstract T getThis();

    @RestrictTo(value={RestrictTo.Scope.SUBCLASSES})
    @NotNull
    protected abstract Bundle getParams();
}

