/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.provider;

import android.graphics.Typeface;
import androidx.annotation.NonNull;
import androidx.core.provider.CalleeHandler;
import androidx.core.provider.FontRequestWorker;
import androidx.core.provider.FontsContractCompat;
import androidx.core.provider.RequestExecutor;
import java.util.concurrent.Executor;

class CallbackWrapper {
    @NonNull
    private final FontsContractCompat.FontRequestCallback mCallback;
    @NonNull
    private final Executor mExecutor;

    CallbackWrapper(@NonNull FontsContractCompat.FontRequestCallback callback, @NonNull Executor executor) {
        this.mCallback = callback;
        this.mExecutor = executor;
    }

    CallbackWrapper(@NonNull FontsContractCompat.FontRequestCallback callback) {
        this(callback, RequestExecutor.createHandlerExecutor(CalleeHandler.create()));
    }

    private void onTypefaceRetrieved(final @NonNull Typeface typeface) {
        final FontsContractCompat.FontRequestCallback callback = this.mCallback;
        this.mExecutor.execute(new Runnable(){

            @Override
            public void run() {
                callback.onTypefaceRetrieved(typeface);
            }
        });
    }

    private void onTypefaceRequestFailed(final int reason) {
        final FontsContractCompat.FontRequestCallback callback = this.mCallback;
        this.mExecutor.execute(new Runnable(){

            @Override
            public void run() {
                callback.onTypefaceRequestFailed(reason);
            }
        });
    }

    void onTypefaceResult(@NonNull FontRequestWorker.TypefaceResult typefaceResult) {
        if (typefaceResult.isSuccess()) {
            this.onTypefaceRetrieved(typefaceResult.mTypeface);
        } else {
            this.onTypefaceRequestFailed(typefaceResult.mResult);
        }
    }
}

