/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.provider;

import android.content.ContentProviderClient;
import android.content.ContentUris;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.content.pm.Signature;
import android.content.res.Resources;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.CancellationSignal;
import android.os.RemoteException;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.collection.LruCache;
import androidx.core.content.res.FontResourcesParserCompat;
import androidx.core.provider.FontRequest;
import androidx.core.provider.FontsContractCompat;
import androidx.tracing.Trace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

class FontProvider {
    private static final LruCache<ProviderCacheKey, ProviderInfo> sProviderCache = new LruCache(2);
    private static final Comparator<byte[]> sByteArrayComparator = (l, r) -> {
        if (((byte[])l).length != ((byte[])r).length) {
            return ((byte[])l).length - ((byte[])r).length;
        }
        for (int i = 0; i < ((byte[])l).length; ++i) {
            if (l[i] == r[i]) continue;
            return l[i] - r[i];
        }
        return 0;
    };

    private FontProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    static FontsContractCompat.FontFamilyResult getFontFamilyResult(@NonNull Context context, @NonNull List<FontRequest> requests, @Nullable CancellationSignal cancellationSignal) throws PackageManager.NameNotFoundException {
        Trace.beginSection((String)"FontProvider.getFontFamilyResult");
        try {
            ArrayList<FontsContractCompat.FontInfo[]> queryResults = new ArrayList<FontsContractCompat.FontInfo[]>();
            for (int i = 0; i < requests.size(); ++i) {
                FontRequest request = requests.get(i);
                ProviderInfo providerInfo = FontProvider.getProvider(context.getPackageManager(), request, context.getResources());
                if (providerInfo == null) {
                    FontsContractCompat.FontFamilyResult fontFamilyResult = FontsContractCompat.FontFamilyResult.create(1, (FontsContractCompat.FontInfo[])null);
                    return fontFamilyResult;
                }
                FontsContractCompat.FontInfo[] fonts = FontProvider.query(context, request, providerInfo.authority, cancellationSignal);
                queryResults.add(fonts);
            }
            FontsContractCompat.FontFamilyResult fontFamilyResult = FontsContractCompat.FontFamilyResult.create(0, queryResults);
            return fontFamilyResult;
        }
        finally {
            Trace.endSection();
        }
    }

    @VisibleForTesting
    static void clearProviderCache() {
        sProviderCache.evictAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @Nullable
    static ProviderInfo getProvider(@NonNull PackageManager packageManager, @NonNull FontRequest request, @Nullable Resources resources) throws PackageManager.NameNotFoundException {
        Trace.beginSection((String)"FontProvider.getProvider");
        try {
            List<List<byte[]>> requestCertificatesList = FontProvider.getCertificates(request, resources);
            ProviderCacheKey cacheKey = new ProviderCacheKey(request.getProviderAuthority(), request.getProviderPackage(), requestCertificatesList);
            ProviderInfo cachedPackageInfo = (ProviderInfo)sProviderCache.get((Object)cacheKey);
            if (cachedPackageInfo != null) {
                ProviderInfo providerInfo = cachedPackageInfo;
                return providerInfo;
            }
            String providerAuthority = request.getProviderAuthority();
            ProviderInfo info = packageManager.resolveContentProvider(providerAuthority, 0);
            if (info == null) {
                throw new PackageManager.NameNotFoundException("No package found for authority: " + providerAuthority);
            }
            if (!info.packageName.equals(request.getProviderPackage())) {
                throw new PackageManager.NameNotFoundException("Found content provider " + providerAuthority + ", but package was not " + request.getProviderPackage());
            }
            PackageInfo packageInfo = packageManager.getPackageInfo(info.packageName, 64);
            List<byte[]> signatures = FontProvider.convertToByteArrayList(packageInfo.signatures);
            Collections.sort(signatures, sByteArrayComparator);
            for (int i = 0; i < requestCertificatesList.size(); ++i) {
                ArrayList<byte[]> requestSignatures = new ArrayList<byte[]>((Collection)requestCertificatesList.get(i));
                Collections.sort(requestSignatures, sByteArrayComparator);
                if (!FontProvider.equalsByteArrayList(signatures, requestSignatures)) continue;
                sProviderCache.put((Object)cacheKey, (Object)info);
                ProviderInfo providerInfo = info;
                return providerInfo;
            }
            ProviderInfo providerInfo = null;
            return providerInfo;
        }
        finally {
            Trace.endSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @NonNull
    static FontsContractCompat.FontInfo[] query(Context context, FontRequest request, String authority, CancellationSignal cancellationSignal) {
        Trace.beginSection((String)"FontProvider.query");
        try {
            ArrayList<FontsContractCompat.FontInfo> result = new ArrayList<FontsContractCompat.FontInfo>();
            Uri uri = new Uri.Builder().scheme("content").authority(authority).build();
            Uri fileBaseUri = new Uri.Builder().scheme("content").authority(authority).appendPath("file").build();
            Cursor cursor = null;
            ContentQueryWrapper queryWrapper = ContentQueryWrapper.make(context, uri);
            try {
                String[] projection = new String[]{"_id", "file_id", "font_ttc_index", "font_variation_settings", "font_weight", "font_italic", "result_code"};
                Trace.beginSection((String)"ContentQueryWrapper.query");
                try {
                    cursor = queryWrapper.query(uri, projection, "query = ?", new String[]{request.getQuery()}, null, cancellationSignal);
                }
                finally {
                    Trace.endSection();
                }
                if (cursor != null && cursor.getCount() > 0) {
                    int resultCodeColumnIndex = cursor.getColumnIndex("result_code");
                    result = new ArrayList();
                    int idColumnIndex = cursor.getColumnIndex("_id");
                    int fileIdColumnIndex = cursor.getColumnIndex("file_id");
                    int ttcIndexColumnIndex = cursor.getColumnIndex("font_ttc_index");
                    int weightColumnIndex = cursor.getColumnIndex("font_weight");
                    int italicColumnIndex = cursor.getColumnIndex("font_italic");
                    while (cursor.moveToNext()) {
                        Uri fileUri;
                        long id2;
                        int ttcIndex;
                        int resultCode = resultCodeColumnIndex != -1 ? cursor.getInt(resultCodeColumnIndex) : 0;
                        int n = ttcIndex = ttcIndexColumnIndex != -1 ? cursor.getInt(ttcIndexColumnIndex) : 0;
                        if (fileIdColumnIndex == -1) {
                            id2 = cursor.getLong(idColumnIndex);
                            fileUri = ContentUris.withAppendedId((Uri)uri, (long)id2);
                        } else {
                            id2 = cursor.getLong(fileIdColumnIndex);
                            fileUri = ContentUris.withAppendedId((Uri)fileBaseUri, (long)id2);
                        }
                        int weight = weightColumnIndex != -1 ? cursor.getInt(weightColumnIndex) : 400;
                        boolean italic = italicColumnIndex != -1 && cursor.getInt(italicColumnIndex) == 1;
                        result.add(FontsContractCompat.FontInfo.create(fileUri, ttcIndex, weight, italic, resultCode));
                    }
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
                queryWrapper.close();
            }
            FontsContractCompat.FontInfo[] fontInfoArray = result.toArray(new FontsContractCompat.FontInfo[0]);
            return fontInfoArray;
        }
        finally {
            Trace.endSection();
        }
    }

    private static List<List<byte[]>> getCertificates(FontRequest request, Resources resources) {
        if (request.getCertificates() != null) {
            return request.getCertificates();
        }
        int resourceId = request.getCertificatesArrayResId();
        return FontResourcesParserCompat.readCerts(resources, resourceId);
    }

    private static boolean equalsByteArrayList(List<byte[]> signatures, List<byte[]> requestSignatures) {
        if (signatures.size() != requestSignatures.size()) {
            return false;
        }
        for (int i = 0; i < signatures.size(); ++i) {
            if (Arrays.equals(signatures.get(i), requestSignatures.get(i))) continue;
            return false;
        }
        return true;
    }

    private static List<byte[]> convertToByteArrayList(Signature[] signatures) {
        ArrayList<byte[]> shaList = new ArrayList<byte[]>();
        for (Signature signature : signatures) {
            shaList.add(signature.toByteArray());
        }
        return shaList;
    }

    private static class ProviderCacheKey {
        String mAuthority;
        String mPackageName;
        List<List<byte[]>> mCertificates;

        ProviderCacheKey(String authority, String packageName, List<List<byte[]>> certificates) {
            this.mAuthority = authority;
            this.mPackageName = packageName;
            this.mCertificates = certificates;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ProviderCacheKey)) {
                return false;
            }
            ProviderCacheKey that = (ProviderCacheKey)o;
            return Objects.equals(this.mAuthority, that.mAuthority) && Objects.equals(this.mPackageName, that.mPackageName) && Objects.equals(this.mCertificates, that.mCertificates);
        }

        public int hashCode() {
            return Objects.hash(this.mAuthority, this.mPackageName, this.mCertificates);
        }
    }

    private static interface ContentQueryWrapper {
        public Cursor query(Uri var1, String[] var2, String var3, String[] var4, String var5, CancellationSignal var6);

        public void close();

        public static ContentQueryWrapper make(Context context, Uri uri) {
            if (Build.VERSION.SDK_INT < 24) {
                return new ContentQueryWrapperApi16Impl(context, uri);
            }
            return new ContentQueryWrapperApi24Impl(context, uri);
        }
    }

    @RequiresApi(value=24)
    private static class ContentQueryWrapperApi24Impl
    implements ContentQueryWrapper {
        private final ContentProviderClient mClient;

        ContentQueryWrapperApi24Impl(Context context, Uri uri) {
            this.mClient = context.getContentResolver().acquireUnstableContentProviderClient(uri);
        }

        @Override
        public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder, CancellationSignal cancellationSignal) {
            if (this.mClient == null) {
                return null;
            }
            try {
                return this.mClient.query(uri, projection, selection, selectionArgs, sortOrder, cancellationSignal);
            }
            catch (RemoteException e) {
                Log.w((String)"FontsProvider", (String)"Unable to query the content provider", (Throwable)e);
                return null;
            }
        }

        @Override
        public void close() {
            if (this.mClient != null) {
                this.mClient.close();
            }
        }
    }

    private static class ContentQueryWrapperApi16Impl
    implements ContentQueryWrapper {
        private final ContentProviderClient mClient;

        ContentQueryWrapperApi16Impl(Context context, Uri uri) {
            this.mClient = context.getContentResolver().acquireUnstableContentProviderClient(uri);
        }

        @Override
        public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder, CancellationSignal cancellationSignal) {
            if (this.mClient == null) {
                return null;
            }
            try {
                return this.mClient.query(uri, projection, selection, selectionArgs, sortOrder, cancellationSignal);
            }
            catch (RemoteException e) {
                Log.w((String)"FontsProvider", (String)"Unable to query the content provider", (Throwable)e);
                return null;
            }
        }

        @Override
        public void close() {
            if (this.mClient != null) {
                this.mClient.release();
            }
        }
    }
}

