/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.provider;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Typeface;
import android.os.Build;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.LruCache;
import androidx.collection.SimpleArrayMap;
import androidx.core.graphics.TypefaceCompat;
import androidx.core.provider.CallbackWrapper;
import androidx.core.provider.FontProvider;
import androidx.core.provider.FontRequest;
import androidx.core.provider.FontsContractCompat;
import androidx.core.provider.RequestExecutor;
import androidx.core.util.Consumer;
import androidx.tracing.Trace;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

class FontRequestWorker {
    static final LruCache<String, Typeface> sTypefaceCache = new LruCache(16);
    private static final ExecutorService DEFAULT_EXECUTOR_SERVICE = RequestExecutor.createDefaultExecutor("fonts-androidx", 10, 10000);
    static final Object LOCK = new Object();
    @GuardedBy(value="LOCK")
    static final SimpleArrayMap<String, ArrayList<Consumer<TypefaceResult>>> PENDING_REPLIES = new SimpleArrayMap();

    private FontRequestWorker() {
    }

    static void resetTypefaceCache() {
        sTypefaceCache.evictAll();
    }

    static Typeface requestFontSync(final @NonNull Context context, final @NonNull FontRequest request, @NonNull CallbackWrapper callback, final int style, int timeoutInMillis) {
        final String id2 = FontRequestWorker.createCacheId(List.of(request), style);
        Typeface cached = (Typeface)sTypefaceCache.get((Object)id2);
        if (cached != null) {
            callback.onTypefaceResult(new TypefaceResult(cached));
            return cached;
        }
        if (timeoutInMillis == -1) {
            TypefaceResult typefaceResult = FontRequestWorker.getFontSync(id2, context, List.of(request), style);
            callback.onTypefaceResult(typefaceResult);
            return typefaceResult.mTypeface;
        }
        Callable<TypefaceResult> fetcher = new Callable<TypefaceResult>(){

            @Override
            public TypefaceResult call() {
                return FontRequestWorker.getFontSync(id2, context, List.of(request), style);
            }
        };
        try {
            TypefaceResult typefaceResult = RequestExecutor.submit(DEFAULT_EXECUTOR_SERVICE, fetcher, timeoutInMillis);
            callback.onTypefaceResult(typefaceResult);
            return typefaceResult.mTypeface;
        }
        catch (InterruptedException e) {
            callback.onTypefaceResult(new TypefaceResult(-3));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Typeface requestFontAsync(final @NonNull Context context, final @NonNull List<FontRequest> requests, final int style, @Nullable Executor executor, final @NonNull CallbackWrapper callback) {
        final String id2 = FontRequestWorker.createCacheId(requests, style);
        Typeface cached = (Typeface)sTypefaceCache.get((Object)id2);
        if (cached != null) {
            callback.onTypefaceResult(new TypefaceResult(cached));
            return cached;
        }
        Consumer<TypefaceResult> reply = new Consumer<TypefaceResult>(){

            @Override
            public void accept(TypefaceResult typefaceResult) {
                if (typefaceResult == null) {
                    typefaceResult = new TypefaceResult(-3);
                }
                callback.onTypefaceResult(typefaceResult);
            }
        };
        Object object = LOCK;
        synchronized (object) {
            ArrayList<2> pendingReplies = (ArrayList<2>)PENDING_REPLIES.get((Object)id2);
            if (pendingReplies != null) {
                pendingReplies.add(reply);
                return null;
            }
            pendingReplies = new ArrayList<2>();
            pendingReplies.add(reply);
            PENDING_REPLIES.put((Object)id2, pendingReplies);
        }
        Callable<TypefaceResult> fetcher = new Callable<TypefaceResult>(){

            @Override
            public TypefaceResult call() {
                try {
                    return FontRequestWorker.getFontSync(id2, context, requests, style);
                }
                catch (Throwable t) {
                    return new TypefaceResult(-3);
                }
            }
        };
        Executor finalExecutor = executor == null ? DEFAULT_EXECUTOR_SERVICE : executor;
        RequestExecutor.execute(finalExecutor, fetcher, new Consumer<TypefaceResult>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(TypefaceResult typefaceResult) {
                ArrayList replies;
                Object object = LOCK;
                synchronized (object) {
                    replies = (ArrayList)PENDING_REPLIES.get((Object)id2);
                    if (replies == null) {
                        return;
                    }
                    PENDING_REPLIES.remove((Object)id2);
                }
                for (int i = 0; i < replies.size(); ++i) {
                    ((Consumer)replies.get(i)).accept(typefaceResult);
                }
            }
        });
        return null;
    }

    private static String createCacheId(@NonNull List<FontRequest> requests, int style) {
        StringBuilder cacheId = new StringBuilder();
        for (int i = 0; i < requests.size(); ++i) {
            cacheId.append(requests.get(i).getId()).append("-").append(style);
            if (i >= requests.size() - 1) continue;
            cacheId.append(";");
        }
        return cacheId.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    static TypefaceResult getFontSync(@NonNull String cacheId, @NonNull Context context, @NonNull List<FontRequest> requests, int style) {
        Trace.beginSection((String)"getFontSync");
        try {
            FontsContractCompat.FontFamilyResult result;
            Typeface cached = (Typeface)sTypefaceCache.get((Object)cacheId);
            if (cached != null) {
                TypefaceResult typefaceResult = new TypefaceResult(cached);
                return typefaceResult;
            }
            try {
                result = FontProvider.getFontFamilyResult(context, requests, null);
            }
            catch (PackageManager.NameNotFoundException e) {
                TypefaceResult typefaceResult = new TypefaceResult(-1);
                Trace.endSection();
                return typefaceResult;
            }
            int fontFamilyResultStatus = FontRequestWorker.getFontFamilyResultStatus(result);
            if (fontFamilyResultStatus != 0) {
                TypefaceResult typefaceResult = new TypefaceResult(fontFamilyResultStatus);
                return typefaceResult;
            }
            Typeface typeface = result.hasFallback() && Build.VERSION.SDK_INT >= 29 ? TypefaceCompat.createFromFontInfoWithFallback(context, null, result.getFontsWithFallbacks(), style) : TypefaceCompat.createFromFontInfo(context, null, result.getFonts(), style);
            if (typeface != null) {
                sTypefaceCache.put((Object)cacheId, (Object)typeface);
                TypefaceResult typefaceResult = new TypefaceResult(typeface);
                return typefaceResult;
            }
            TypefaceResult typefaceResult = new TypefaceResult(-3);
            return typefaceResult;
        }
        finally {
            Trace.endSection();
        }
    }

    @SuppressLint(value={"WrongConstant"})
    private static int getFontFamilyResultStatus(@NonNull FontsContractCompat.FontFamilyResult fontFamilyResult) {
        if (fontFamilyResult.getStatusCode() != 0) {
            switch (fontFamilyResult.getStatusCode()) {
                case 1: {
                    return -2;
                }
            }
            return -3;
        }
        FontsContractCompat.FontInfo[] fonts = fontFamilyResult.getFonts();
        if (fonts == null || fonts.length == 0) {
            return 1;
        }
        for (FontsContractCompat.FontInfo font : fonts) {
            int resultCode = font.getResultCode();
            if (resultCode == 0) continue;
            return resultCode < 0 ? -3 : resultCode;
        }
        return 0;
    }

    static final class TypefaceResult {
        final Typeface mTypeface;
        final int mResult;

        TypefaceResult(int result) {
            this.mTypeface = null;
            this.mResult = result;
        }

        @SuppressLint(value={"WrongConstant"})
        TypefaceResult(@NonNull Typeface typeface) {
            this.mTypeface = typeface;
            this.mResult = 0;
        }

        @SuppressLint(value={"WrongConstant"})
        boolean isSuccess() {
            return this.mResult == 0;
        }
    }
}

