/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.telephony;

import android.annotation.SuppressLint;
import android.os.Build;
import android.telephony.TelephonyManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RequiresPermission;
import androidx.core.telephony.SubscriptionManagerCompat;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class TelephonyManagerCompat {
    private static Method sGetDeviceIdMethod;
    private static Method sGetSubIdMethod;

    @SuppressLint(value={"MissingPermission"})
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    @Nullable
    public static String getImei(@NonNull TelephonyManager telephonyManager) {
        int subId;
        if (Build.VERSION.SDK_INT >= 26) {
            return Api26Impl.getImei(telephonyManager);
        }
        if (Build.VERSION.SDK_INT >= 22 && (subId = TelephonyManagerCompat.getSubscriptionId(telephonyManager)) != Integer.MAX_VALUE && subId != -1) {
            int slotIndex = SubscriptionManagerCompat.getSlotIndex(subId);
            if (Build.VERSION.SDK_INT >= 23) {
                return Api23Impl.getDeviceId(telephonyManager, slotIndex);
            }
            try {
                if (sGetDeviceIdMethod == null) {
                    sGetDeviceIdMethod = TelephonyManager.class.getDeclaredMethod("getDeviceId", Integer.TYPE);
                    sGetDeviceIdMethod.setAccessible(true);
                }
                return (String)sGetDeviceIdMethod.invoke((Object)telephonyManager, slotIndex);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            return null;
        }
        return telephonyManager.getDeviceId();
    }

    @SuppressLint(value={"SoonBlockedPrivateApi"})
    public static int getSubscriptionId(@NonNull TelephonyManager telephonyManager) {
        if (Build.VERSION.SDK_INT >= 30) {
            return Api30Impl.getSubscriptionId(telephonyManager);
        }
        if (Build.VERSION.SDK_INT >= 22) {
            try {
                Integer subId;
                if (sGetSubIdMethod == null) {
                    sGetSubIdMethod = TelephonyManager.class.getDeclaredMethod("getSubId", new Class[0]);
                    sGetSubIdMethod.setAccessible(true);
                }
                if ((subId = (Integer)sGetSubIdMethod.invoke((Object)telephonyManager, new Object[0])) != null && subId != -1) {
                    return subId;
                }
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return Integer.MAX_VALUE;
    }

    private TelephonyManagerCompat() {
    }

    @RequiresApi(value=26)
    private static class Api26Impl {
        private Api26Impl() {
        }

        @SuppressLint(value={"MissingPermission"})
        @RequiresPermission(value="android.permission.READ_PHONE_STATE")
        @Nullable
        static String getImei(TelephonyManager telephonyManager) {
            return telephonyManager.getImei();
        }
    }

    @RequiresApi(value=23)
    private static class Api23Impl {
        private Api23Impl() {
        }

        @SuppressLint(value={"MissingPermission"})
        @RequiresPermission(value="android.permission.READ_PHONE_STATE")
        @Nullable
        static String getDeviceId(TelephonyManager telephonyManager, int slotIndex) {
            return telephonyManager.getDeviceId(slotIndex);
        }
    }

    @RequiresApi(value=30)
    private static class Api30Impl {
        private Api30Impl() {
        }

        static int getSubscriptionId(TelephonyManager telephonyManager) {
            return telephonyManager.getSubscriptionId();
        }
    }
}

