/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.text.util;

import android.icu.number.LocalizedNumberFormatter;
import android.icu.number.NumberFormatter;
import android.icu.number.UnlocalizedNumberFormatter;
import android.icu.text.DateFormat;
import android.icu.text.DateTimePatternGenerator;
import android.icu.util.Calendar;
import android.icu.util.MeasureUnit;
import android.os.Build;
import android.text.format.DateFormat;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Locale;

@RequiresApi(value=21)
public final class LocalePreferences {
    private static final String TAG = LocalePreferences.class.getSimpleName();
    private static final String[] WEATHER_FAHRENHEIT_COUNTRIES = new String[]{"BS", "BZ", "KY", "PR", "PW", "US"};

    @NonNull
    public static String getHourCycle() {
        return LocalePreferences.getHourCycle(true);
    }

    @NonNull
    public static String getHourCycle(@NonNull Locale locale) {
        return LocalePreferences.getHourCycle(locale, true);
    }

    @NonNull
    public static String getHourCycle(boolean resolved) {
        Locale defaultLocale = Build.VERSION.SDK_INT >= 24 ? Api24Impl.getDefaultLocale() : LocalePreferences.getDefaultLocale();
        return LocalePreferences.getHourCycle(defaultLocale, resolved);
    }

    @NonNull
    public static String getHourCycle(@NonNull Locale locale, boolean resolved) {
        String result = LocalePreferences.getUnicodeLocaleType("hc", "", locale, resolved);
        if (result != null) {
            return result;
        }
        if (Build.VERSION.SDK_INT >= 33) {
            return Api33Impl.getHourCycle(locale);
        }
        return LocalePreferences.getBaseHourCycle(locale);
    }

    @NonNull
    public static String getCalendarType() {
        return LocalePreferences.getCalendarType(true);
    }

    @NonNull
    public static String getCalendarType(@NonNull Locale locale) {
        return LocalePreferences.getCalendarType(locale, true);
    }

    @NonNull
    public static String getCalendarType(boolean resolved) {
        Locale defaultLocale = Build.VERSION.SDK_INT >= 24 ? Api24Impl.getDefaultLocale() : LocalePreferences.getDefaultLocale();
        return LocalePreferences.getCalendarType(defaultLocale, resolved);
    }

    @NonNull
    public static String getCalendarType(@NonNull Locale locale, boolean resolved) {
        String result = LocalePreferences.getUnicodeLocaleType("ca", "", locale, resolved);
        if (result != null) {
            return result;
        }
        if (Build.VERSION.SDK_INT >= 24) {
            return Api24Impl.getCalendarType(locale);
        }
        return resolved ? "gregorian" : "";
    }

    @NonNull
    public static String getTemperatureUnit() {
        return LocalePreferences.getTemperatureUnit(true);
    }

    @NonNull
    public static String getTemperatureUnit(@NonNull Locale locale) {
        return LocalePreferences.getTemperatureUnit(locale, true);
    }

    @NonNull
    public static String getTemperatureUnit(boolean resolved) {
        Locale defaultLocale = Build.VERSION.SDK_INT >= 24 ? Api24Impl.getDefaultLocale() : LocalePreferences.getDefaultLocale();
        return LocalePreferences.getTemperatureUnit(defaultLocale, resolved);
    }

    @NonNull
    public static String getTemperatureUnit(@NonNull Locale locale, boolean resolved) {
        String result = LocalePreferences.getUnicodeLocaleType("mu", "", locale, resolved);
        if (result != null) {
            return result;
        }
        if (Build.VERSION.SDK_INT >= 33) {
            return Api33Impl.getResolvedTemperatureUnit(locale);
        }
        return LocalePreferences.getTemperatureHardCoded(locale);
    }

    @NonNull
    public static String getFirstDayOfWeek() {
        return LocalePreferences.getFirstDayOfWeek(true);
    }

    @NonNull
    public static String getFirstDayOfWeek(@NonNull Locale locale) {
        return LocalePreferences.getFirstDayOfWeek(locale, true);
    }

    @NonNull
    public static String getFirstDayOfWeek(boolean resolved) {
        Locale defaultLocale = Build.VERSION.SDK_INT >= 24 ? Api24Impl.getDefaultLocale() : LocalePreferences.getDefaultLocale();
        return LocalePreferences.getFirstDayOfWeek(defaultLocale, resolved);
    }

    @NonNull
    public static String getFirstDayOfWeek(@NonNull Locale locale, boolean resolved) {
        String result = LocalePreferences.getUnicodeLocaleType("fw", "", locale, resolved);
        return result != null ? result : LocalePreferences.getBaseFirstDayOfWeek(locale);
    }

    private static String getUnicodeLocaleType(String tag, String defaultValue, Locale locale, boolean resolved) {
        String ext = locale.getUnicodeLocaleType(tag);
        if (ext != null) {
            return ext;
        }
        if (!resolved) {
            return defaultValue;
        }
        return null;
    }

    private static String getTemperatureHardCoded(Locale locale) {
        return Arrays.binarySearch(WEATHER_FAHRENHEIT_COUNTRIES, locale.getCountry()) >= 0 ? "fahrenhe" : "celsius";
    }

    private static String getBaseHourCycle(@NonNull Locale locale) {
        String pattern = DateFormat.getBestDateTimePattern((Locale)locale, (String)"jm");
        return pattern.contains("H") ? "h23" : "h12";
    }

    private static String getBaseFirstDayOfWeek(@NonNull Locale locale) {
        return LocalePreferences.getStringOfFirstDayOfWeek(java.util.Calendar.getInstance(locale).getFirstDayOfWeek());
    }

    private static String getStringOfFirstDayOfWeek(int fw) {
        String[] arrDays = new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat"};
        return fw >= 1 && fw <= 7 ? arrDays[fw - 1] : "";
    }

    private static Locale getDefaultLocale() {
        return Locale.getDefault();
    }

    private LocalePreferences() {
    }

    public static class FirstDayOfWeek {
        private static final String U_EXTENSION_TAG = "fw";
        public static final String SUNDAY = "sun";
        public static final String MONDAY = "mon";
        public static final String TUESDAY = "tue";
        public static final String WEDNESDAY = "wed";
        public static final String THURSDAY = "thu";
        public static final String FRIDAY = "fri";
        public static final String SATURDAY = "sat";
        public static final String DEFAULT = "";

        private FirstDayOfWeek() {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public static @interface Days {
        }
    }

    public static class TemperatureUnit {
        private static final String U_EXTENSION_TAG = "mu";
        public static final String CELSIUS = "celsius";
        public static final String FAHRENHEIT = "fahrenhe";
        public static final String KELVIN = "kelvin";
        public static final String DEFAULT = "";

        private TemperatureUnit() {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public static @interface TemperatureUnits {
        }
    }

    public static class CalendarType {
        private static final String U_EXTENSION_TAG = "ca";
        public static final String CHINESE = "chinese";
        public static final String DANGI = "dangi";
        public static final String GREGORIAN = "gregorian";
        public static final String HEBREW = "hebrew";
        public static final String INDIAN = "indian";
        public static final String ISLAMIC = "islamic";
        public static final String ISLAMIC_CIVIL = "islamic-civil";
        public static final String ISLAMIC_RGSA = "islamic-rgsa";
        public static final String ISLAMIC_TBLA = "islamic-tbla";
        public static final String ISLAMIC_UMALQURA = "islamic-umalqura";
        public static final String PERSIAN = "persian";
        public static final String DEFAULT = "";

        private CalendarType() {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public static @interface CalendarTypes {
        }
    }

    public static class HourCycle {
        private static final String U_EXTENSION_TAG = "hc";
        public static final String H11 = "h11";
        public static final String H12 = "h12";
        public static final String H23 = "h23";
        public static final String H24 = "h24";
        public static final String DEFAULT = "";

        private HourCycle() {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public static @interface HourCycleTypes {
        }
    }

    @RequiresApi(value=24)
    private static class Api24Impl {
        static String getCalendarType(@NonNull Locale locale) {
            return Calendar.getInstance((Locale)locale).getType();
        }

        static Locale getDefaultLocale() {
            return Locale.getDefault(Locale.Category.FORMAT);
        }

        private Api24Impl() {
        }
    }

    @RequiresApi(value=33)
    private static class Api33Impl {
        static String getResolvedTemperatureUnit(@NonNull Locale locale) {
            LocalizedNumberFormatter nf = ((UnlocalizedNumberFormatter)((UnlocalizedNumberFormatter)NumberFormatter.with().usage("weather")).unit(MeasureUnit.CELSIUS)).locale(locale);
            String unit = nf.format(1L).getOutputUnit().getIdentifier();
            if (unit.startsWith("fahrenhe")) {
                return "fahrenhe";
            }
            return unit;
        }

        static String getHourCycle(@NonNull Locale locale) {
            return Api33Impl.getHourCycleType(DateTimePatternGenerator.getInstance((Locale)locale).getDefaultHourCycle());
        }

        private static String getHourCycleType(DateFormat.HourCycle hourCycle) {
            switch (hourCycle) {
                case HOUR_CYCLE_11: {
                    return "h11";
                }
                case HOUR_CYCLE_12: {
                    return "h12";
                }
                case HOUR_CYCLE_23: {
                    return "h23";
                }
                case HOUR_CYCLE_24: {
                    return "h24";
                }
            }
            return "";
        }

        private Api33Impl() {
        }
    }
}

