/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view;

import android.content.Context;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.view.DifferentialMotionFlingTarget;
import androidx.core.view.VelocityTrackerCompat;
import androidx.core.view.ViewConfigurationCompat;

public class DifferentialMotionFlingController {
    private final Context mContext;
    private final DifferentialMotionFlingTarget mTarget;
    private final FlingVelocityThresholdCalculator mVelocityThresholdCalculator;
    private final DifferentialVelocityProvider mVelocityProvider;
    @Nullable
    private VelocityTracker mVelocityTracker;
    private float mLastFlingVelocity;
    private int mLastProcessedAxis = -1;
    private int mLastProcessedSource = -1;
    private int mLastProcessedDeviceId = -1;
    private final int[] mFlingVelocityThresholds = new int[]{Integer.MAX_VALUE, 0};

    public DifferentialMotionFlingController(@NonNull Context context, @NonNull DifferentialMotionFlingTarget target) {
        this(context, target, DifferentialMotionFlingController::calculateFlingVelocityThresholds, DifferentialMotionFlingController::getCurrentVelocity);
    }

    @VisibleForTesting
    DifferentialMotionFlingController(Context context, DifferentialMotionFlingTarget target, FlingVelocityThresholdCalculator velocityThresholdCalculator, DifferentialVelocityProvider velocityProvider) {
        this.mContext = context;
        this.mTarget = target;
        this.mVelocityThresholdCalculator = velocityThresholdCalculator;
        this.mVelocityProvider = velocityProvider;
    }

    public void onMotionEvent(@NonNull MotionEvent event, int axis) {
        boolean flingParamsChanged = this.calculateFlingVelocityThresholds(event, axis);
        if (this.mFlingVelocityThresholds[0] == Integer.MAX_VALUE) {
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
            return;
        }
        float scaledVelocity = this.getCurrentVelocity(event, axis) * this.mTarget.getScaledScrollFactor();
        float velocityDirection = Math.signum(scaledVelocity);
        if (flingParamsChanged || velocityDirection != Math.signum(this.mLastFlingVelocity) && velocityDirection != 0.0f) {
            this.mTarget.stopDifferentialMotionFling();
        }
        if (Math.abs(scaledVelocity) < (float)this.mFlingVelocityThresholds[0]) {
            return;
        }
        boolean flung = this.mTarget.startDifferentialMotionFling(scaledVelocity = Math.max((float)(-this.mFlingVelocityThresholds[1]), Math.min(scaledVelocity, (float)this.mFlingVelocityThresholds[1])));
        this.mLastFlingVelocity = flung ? scaledVelocity : 0.0f;
    }

    private boolean calculateFlingVelocityThresholds(MotionEvent event, int axis) {
        int source = event.getSource();
        int deviceId = event.getDeviceId();
        if (this.mLastProcessedSource != source || this.mLastProcessedDeviceId != deviceId || this.mLastProcessedAxis != axis) {
            this.mVelocityThresholdCalculator.calculateFlingVelocityThresholds(this.mContext, this.mFlingVelocityThresholds, event, axis);
            this.mLastProcessedSource = source;
            this.mLastProcessedDeviceId = deviceId;
            this.mLastProcessedAxis = axis;
            return true;
        }
        return false;
    }

    private static void calculateFlingVelocityThresholds(Context context, int[] buffer, MotionEvent event, int axis) {
        ViewConfiguration vc = ViewConfiguration.get((Context)context);
        buffer[0] = ViewConfigurationCompat.getScaledMinimumFlingVelocity(context, vc, event.getDeviceId(), axis, event.getSource());
        buffer[1] = ViewConfigurationCompat.getScaledMaximumFlingVelocity(context, vc, event.getDeviceId(), axis, event.getSource());
    }

    private float getCurrentVelocity(MotionEvent event, int axis) {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        return this.mVelocityProvider.getCurrentVelocity(this.mVelocityTracker, event, axis);
    }

    private static float getCurrentVelocity(VelocityTracker vt, MotionEvent event, int axis) {
        VelocityTrackerCompat.addMovement(vt, event);
        VelocityTrackerCompat.computeCurrentVelocity(vt, 1000);
        return VelocityTrackerCompat.getAxisVelocity(vt, axis);
    }

    @VisibleForTesting
    static interface FlingVelocityThresholdCalculator {
        public void calculateFlingVelocityThresholds(Context var1, int[] var2, MotionEvent var3, int var4);
    }

    @VisibleForTesting
    static interface DifferentialVelocityProvider {
        public float getCurrentVelocity(VelocityTracker var1, MotionEvent var2, int var3);
    }
}

