/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view;

import android.os.Build;
import android.view.View;
import android.view.WindowInsets;
import android.view.WindowInsetsController;
import android.view.inputmethod.InputMethodManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import java.util.concurrent.atomic.AtomicBoolean;

public final class SoftwareKeyboardControllerCompat {
    private final Impl mImpl;

    public SoftwareKeyboardControllerCompat(@NonNull View view) {
        this.mImpl = Build.VERSION.SDK_INT >= 30 ? new Impl30(view) : (Build.VERSION.SDK_INT >= 20 ? new Impl20(view) : new Impl());
    }

    @Deprecated
    @RequiresApi(value=30)
    SoftwareKeyboardControllerCompat(@NonNull WindowInsetsController windowInsetsController) {
        this.mImpl = new Impl30(windowInsetsController);
    }

    public void show() {
        this.mImpl.show();
    }

    public void hide() {
        this.mImpl.hide();
    }

    @RequiresApi(value=30)
    private static class Impl30
    extends Impl20 {
        @Nullable
        private View mView;
        @Nullable
        private WindowInsetsController mWindowInsetsController;

        Impl30(@NonNull View view) {
            super(view);
            this.mView = view;
        }

        Impl30(@Nullable WindowInsetsController windowInsetsController) {
            super(null);
            this.mWindowInsetsController = windowInsetsController;
        }

        @Override
        void show() {
            if (this.mView != null && Build.VERSION.SDK_INT < 33) {
                InputMethodManager imm = (InputMethodManager)this.mView.getContext().getSystemService("input_method");
                imm.isActive();
            }
            WindowInsetsController insetsController = null;
            if (this.mWindowInsetsController != null) {
                insetsController = this.mWindowInsetsController;
            } else if (this.mView != null) {
                insetsController = this.mView.getWindowInsetsController();
            }
            if (insetsController != null) {
                insetsController.show(WindowInsets.Type.ime());
            }
            super.show();
        }

        @Override
        void hide() {
            WindowInsetsController insetsController = null;
            if (this.mWindowInsetsController != null) {
                insetsController = this.mWindowInsetsController;
            } else if (this.mView != null) {
                insetsController = this.mView.getWindowInsetsController();
            }
            if (insetsController != null) {
                AtomicBoolean isImeInsetsControllable = new AtomicBoolean(false);
                WindowInsetsController.OnControllableInsetsChangedListener listener = (windowInsetsController, typeMask) -> isImeInsetsControllable.set((typeMask & 8) != 0);
                insetsController.addOnControllableInsetsChangedListener(listener);
                if (!isImeInsetsControllable.get() && this.mView != null) {
                    InputMethodManager imm = (InputMethodManager)this.mView.getContext().getSystemService("input_method");
                    imm.hideSoftInputFromWindow(this.mView.getWindowToken(), 0);
                }
                insetsController.removeOnControllableInsetsChangedListener(listener);
                insetsController.hide(WindowInsets.Type.ime());
            } else {
                super.hide();
            }
        }
    }

    private static class Impl {
        Impl() {
        }

        void show() {
        }

        void hide() {
        }
    }

    @RequiresApi(value=20)
    private static class Impl20
    extends Impl {
        @Nullable
        private final View mView;

        Impl20(@Nullable View view) {
            this.mView = view;
        }

        @Override
        void show() {
            View view = this.mView;
            if (view == null) {
                return;
            }
            if (view.isInEditMode() || view.onCheckIsTextEditor()) {
                view.requestFocus();
            } else {
                view = view.getRootView().findFocus();
            }
            if (view == null) {
                view = this.mView.getRootView().findViewById(0x1020002);
            }
            if (view != null && view.hasWindowFocus()) {
                View finalView = view;
                finalView.post(() -> {
                    InputMethodManager imm = (InputMethodManager)finalView.getContext().getSystemService("input_method");
                    imm.showSoftInput(finalView, 0);
                });
            }
        }

        @Override
        void hide() {
            if (this.mView != null) {
                ((InputMethodManager)this.mView.getContext().getSystemService("input_method")).hideSoftInputFromWindow(this.mView.getWindowToken(), 0);
            }
        }
    }
}

