/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.os.Build;
import android.view.View;
import android.view.ViewPropertyAnimator;
import android.view.animation.Interpolator;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.view.ViewPropertyAnimatorListener;
import androidx.core.view.ViewPropertyAnimatorUpdateListener;
import java.lang.ref.WeakReference;

public final class ViewPropertyAnimatorCompat {
    private final WeakReference<View> mView;

    ViewPropertyAnimatorCompat(View view) {
        this.mView = new WeakReference<View>(view);
    }

    @NonNull
    public ViewPropertyAnimatorCompat setDuration(long value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().setDuration(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat alpha(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().alpha(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat alphaBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().alphaBy(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat translationX(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().translationX(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat translationY(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().translationY(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat withEndAction(@NonNull Runnable runnable) {
        View view = (View)this.mView.get();
        if (view != null) {
            ViewPropertyAnimator animator = view.animate();
            animator.withEndAction(runnable);
        }
        return this;
    }

    public long getDuration() {
        View view = (View)this.mView.get();
        if (view != null) {
            return view.animate().getDuration();
        }
        return 0L;
    }

    @NonNull
    public ViewPropertyAnimatorCompat setInterpolator(@Nullable Interpolator value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().setInterpolator((TimeInterpolator)value);
        }
        return this;
    }

    @Nullable
    public Interpolator getInterpolator() {
        View view = (View)this.mView.get();
        if (view != null) {
            ViewPropertyAnimator animator = view.animate();
            return (Interpolator)animator.getInterpolator();
        }
        return null;
    }

    @NonNull
    public ViewPropertyAnimatorCompat setStartDelay(long value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().setStartDelay(value);
        }
        return this;
    }

    public long getStartDelay() {
        View view = (View)this.mView.get();
        if (view != null) {
            return view.animate().getStartDelay();
        }
        return 0L;
    }

    @NonNull
    public ViewPropertyAnimatorCompat rotation(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().rotation(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat rotationBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().rotationBy(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat rotationX(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().rotationX(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat rotationXBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().rotationXBy(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat rotationY(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().rotationY(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat rotationYBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().rotationYBy(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat scaleX(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().scaleX(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat scaleXBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().scaleXBy(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat scaleY(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().scaleY(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat scaleYBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().scaleYBy(value);
        }
        return this;
    }

    public void cancel() {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().cancel();
        }
    }

    @NonNull
    public ViewPropertyAnimatorCompat x(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().x(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat xBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().xBy(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat y(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().y(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat yBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().yBy(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat translationXBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().translationXBy(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat translationYBy(float value) {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().translationYBy(value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat translationZBy(float value) {
        View view = (View)this.mView.get();
        if (view != null && Build.VERSION.SDK_INT >= 21) {
            ViewPropertyAnimator animator = view.animate();
            Api21Impl.translationZBy(animator, value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat translationZ(float value) {
        View view = (View)this.mView.get();
        if (view != null && Build.VERSION.SDK_INT >= 21) {
            ViewPropertyAnimator animator = view.animate();
            Api21Impl.translationZ(animator, value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat z(float value) {
        View view = (View)this.mView.get();
        if (view != null && Build.VERSION.SDK_INT >= 21) {
            ViewPropertyAnimator animator = view.animate();
            Api21Impl.z(animator, value);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat zBy(float value) {
        View view = (View)this.mView.get();
        if (view != null && Build.VERSION.SDK_INT >= 21) {
            ViewPropertyAnimator animator = view.animate();
            Api21Impl.zBy(animator, value);
        }
        return this;
    }

    public void start() {
        View view = (View)this.mView.get();
        if (view != null) {
            view.animate().start();
        }
    }

    @NonNull
    @SuppressLint(value={"WrongConstant"})
    public ViewPropertyAnimatorCompat withLayer() {
        View view = (View)this.mView.get();
        if (view != null) {
            ViewPropertyAnimator animator = view.animate();
            animator.withLayer();
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat withStartAction(@NonNull Runnable runnable) {
        View view = (View)this.mView.get();
        if (view != null) {
            ViewPropertyAnimator animator = view.animate();
            animator.withStartAction(runnable);
        }
        return this;
    }

    @NonNull
    public ViewPropertyAnimatorCompat setListener(@Nullable ViewPropertyAnimatorListener listener) {
        View view = (View)this.mView.get();
        if (view != null) {
            this.setListenerInternal(view, listener);
        }
        return this;
    }

    private void setListenerInternal(final View view, final ViewPropertyAnimatorListener listener) {
        if (listener != null) {
            view.animate().setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationCancel(Animator animation) {
                    listener.onAnimationCancel(view);
                }

                public void onAnimationEnd(Animator animation) {
                    listener.onAnimationEnd(view);
                }

                public void onAnimationStart(Animator animation) {
                    listener.onAnimationStart(view);
                }
            });
        } else {
            view.animate().setListener(null);
        }
    }

    @NonNull
    public ViewPropertyAnimatorCompat setUpdateListener(@Nullable ViewPropertyAnimatorUpdateListener listener) {
        View view = (View)this.mView.get();
        if (view != null) {
            ValueAnimator.AnimatorUpdateListener wrapped = null;
            if (listener != null) {
                wrapped = valueAnimator -> listener.onAnimationUpdate(view);
            }
            ViewPropertyAnimator animator = view.animate();
            animator.setUpdateListener(wrapped);
        }
        return this;
    }

    @RequiresApi(value=21)
    static class Api21Impl {
        private Api21Impl() {
        }

        static ViewPropertyAnimator translationZBy(ViewPropertyAnimator viewPropertyAnimator, float value) {
            return viewPropertyAnimator.translationZBy(value);
        }

        static ViewPropertyAnimator translationZ(ViewPropertyAnimator viewPropertyAnimator, float value) {
            return viewPropertyAnimator.translationZ(value);
        }

        static ViewPropertyAnimator z(ViewPropertyAnimator viewPropertyAnimator, float value) {
            return viewPropertyAnimator.z(value);
        }

        static ViewPropertyAnimator zBy(ViewPropertyAnimator viewPropertyAnimator, float value) {
            return viewPropertyAnimator.zBy(value);
        }
    }
}

