/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.widget;

import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.widget.TintableImageSourceView;

public class ImageViewCompat {
    @Nullable
    public static ColorStateList getImageTintList(@NonNull ImageView view) {
        if (Build.VERSION.SDK_INT >= 21) {
            return Api21Impl.getImageTintList(view);
        }
        return view instanceof TintableImageSourceView ? ((TintableImageSourceView)view).getSupportImageTintList() : null;
    }

    public static void setImageTintList(@NonNull ImageView view, @Nullable ColorStateList tintList) {
        if (Build.VERSION.SDK_INT >= 21) {
            Drawable imageViewDrawable;
            Api21Impl.setImageTintList(view, tintList);
            if (Build.VERSION.SDK_INT == 21 && (imageViewDrawable = view.getDrawable()) != null && Api21Impl.getImageTintList(view) != null) {
                if (imageViewDrawable.isStateful()) {
                    imageViewDrawable.setState(view.getDrawableState());
                }
                view.setImageDrawable(imageViewDrawable);
            }
        } else if (view instanceof TintableImageSourceView) {
            ((TintableImageSourceView)view).setSupportImageTintList(tintList);
        }
    }

    @Nullable
    public static PorterDuff.Mode getImageTintMode(@NonNull ImageView view) {
        if (Build.VERSION.SDK_INT >= 21) {
            return Api21Impl.getImageTintMode(view);
        }
        return view instanceof TintableImageSourceView ? ((TintableImageSourceView)view).getSupportImageTintMode() : null;
    }

    public static void setImageTintMode(@NonNull ImageView view, @Nullable PorterDuff.Mode mode) {
        if (Build.VERSION.SDK_INT >= 21) {
            Drawable imageViewDrawable;
            Api21Impl.setImageTintMode(view, mode);
            if (Build.VERSION.SDK_INT == 21 && (imageViewDrawable = view.getDrawable()) != null && Api21Impl.getImageTintList(view) != null) {
                if (imageViewDrawable.isStateful()) {
                    imageViewDrawable.setState(view.getDrawableState());
                }
                view.setImageDrawable(imageViewDrawable);
            }
        } else if (view instanceof TintableImageSourceView) {
            ((TintableImageSourceView)view).setSupportImageTintMode(mode);
        }
    }

    private ImageViewCompat() {
    }

    @RequiresApi(value=21)
    static class Api21Impl {
        private Api21Impl() {
        }

        static ColorStateList getImageTintList(ImageView imageView) {
            return imageView.getImageTintList();
        }

        static void setImageTintList(ImageView imageView, ColorStateList tint) {
            imageView.setImageTintList(tint);
        }

        static PorterDuff.Mode getImageTintMode(ImageView imageView) {
            return imageView.getImageTintMode();
        }

        static void setImageTintMode(ImageView imageView, PorterDuff.Mode tintMode) {
            imageView.setImageTintMode(tintMode);
        }
    }
}

