/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.maui;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.NonNull;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.microsoft.maui.PlatformContentViewGroup;
import com.microsoft.maui.PlatformShadowDrawable;
import com.microsoft.maui.glide.ShadowBitmapPool;

public abstract class PlatformWrapperView
extends PlatformContentViewGroup {
    private final BitmapPool bitmapPool;
    private final Rect viewBounds;
    private Paint shadowPaint;
    private Bitmap shadowBitmap;
    private float shadowBitmapX;
    private float shadowBitmapY;
    private Canvas shadowCanvas;
    private Shader shadowShader;
    private boolean shadowInvalidated = true;
    private boolean hasClip = false;
    private int paintType = 0;
    private float offsetX = 0.0f;
    private float offsetY = 0.0f;
    private float radius = 0.0f;
    private int[] colors = new int[0];
    private float[] positions = new float[0];
    private float[] bounds = new float[0];

    public PlatformWrapperView(Context context) {
        super(context);
        this.viewBounds = new Rect();
        this.bitmapPool = ShadowBitmapPool.get(context);
        this.setClipChildren(false);
        this.setWillNotDraw(true);
    }

    @Override
    protected void setHasClip(boolean hasClip) {
        super.setHasClip(hasClip);
        this.hasClip = hasClip;
        this.shadowInvalidated = true;
    }

    @Deprecated
    protected final void setHasShadow(boolean hasShadow) {
    }

    protected final void updateShadow(int paintType, float radius, float offsetX, float offsetY, int[] colors, float[] positions, float[] bounds) {
        this.paintType = paintType;
        this.radius = radius;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.colors = colors;
        this.positions = positions;
        this.bounds = bounds;
        if (paintType == 0) {
            this.shadowPaint = null;
            this.shadowCanvas = null;
            if (this.shadowBitmap != null) {
                this.bitmapPool.put(this.shadowBitmap);
                this.shadowBitmap = null;
            }
        } else {
            this.shadowCanvas = new Canvas();
            this.shadowPaint = new Paint();
            this.shadowPaint.setAntiAlias(true);
            this.shadowPaint.setDither(true);
            this.shadowPaint.setFilterBitmap(true);
            this.shadowPaint.setStyle(Paint.Style.FILL_AND_STROKE);
            if (radius > 0.0f) {
                this.shadowPaint.setMaskFilter((MaskFilter)new BlurMaskFilter(radius, BlurMaskFilter.Blur.NORMAL));
            }
            if (paintType == 1) {
                this.shadowPaint.setColor(colors.length > 0 ? colors[0] : -16777216);
            }
        }
        this.shadowInvalidated = true;
        this.invalidate();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.shadowInvalidated = true;
        if (this.shadowBitmap != null) {
            this.bitmapPool.put(this.shadowBitmap);
            this.shadowBitmap = null;
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.shadowInvalidated = true;
    }

    public void requestLayout() {
        super.requestLayout();
        this.shadowInvalidated = true;
    }

    public void invalidate() {
        super.invalidate();
        this.shadowInvalidated = true;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.getChildCount() == 0) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        View child = this.getChildAt(0);
        this.viewBounds.set(0, 0, View.MeasureSpec.getSize((int)widthMeasureSpec), View.MeasureSpec.getSize((int)heightMeasureSpec));
        child.measure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(child.getMeasuredWidth(), child.getMeasuredHeight());
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        if (this.paintType != 0) {
            int viewWidth = this.viewBounds.width();
            int viewHeight = this.viewBounds.height();
            if (this.getChildCount() > 0) {
                View child = this.getChildAt(0);
                if (viewWidth == 0) {
                    viewWidth = child.getMeasuredWidth();
                }
                if (viewHeight == 0) {
                    viewHeight = child.getMeasuredHeight();
                }
            }
            if (viewWidth > 0 && viewHeight > 0) {
                this.drawShadow(canvas, viewWidth, viewHeight);
            }
        }
        super.dispatchDraw(canvas);
    }

    protected void drawShadow(@NonNull Canvas canvas, int viewWidth, int viewHeight) {
        if (this.getChildCount() > 0) {
            View child = this.getChildAt(0);
            Drawable background = child.getBackground();
            if (background != null && background instanceof PlatformShadowDrawable && ((PlatformShadowDrawable)background).canDrawShadow()) {
                int left = child.getLeft();
                int top = child.getTop();
                int right = child.getRight();
                int bottom = child.getBottom();
                background.setBounds(0, 0, right - left, bottom - top);
                this.drawShadowViaPlatformShadowDrawable(canvas, (PlatformShadowDrawable)background, viewWidth, viewHeight);
                return;
            }
            this.drawShadowViaDispatchDraw(canvas, viewWidth, viewHeight);
        }
    }

    private void drawShadowViaPlatformShadowDrawable(@NonNull Canvas canvas, @NonNull PlatformShadowDrawable drawable, int viewWidth, int viewHeight) {
        int radiusSafeSpace = this.getRadiusSafeSpace();
        int bitmapWidth = viewWidth + radiusSafeSpace;
        int bitmapHeight = viewHeight + radiusSafeSpace;
        this.updateShadowShader(bitmapWidth, bitmapHeight);
        Path clipPath = this.hasClip ? this.getClipPath(viewWidth, viewHeight) : null;
        canvas.save();
        canvas.translate(this.offsetX, this.offsetY);
        drawable.drawShadow(canvas, this.shadowPaint, clipPath);
        canvas.restore();
    }

    private void drawShadowViaDispatchDraw(@NonNull Canvas canvas, int viewWidth, int viewHeight) {
        if (this.shadowInvalidated) {
            this.shadowInvalidated = false;
            int radiusSafeSpace = this.getRadiusSafeSpace();
            int bitmapWidth = PlatformWrapperView.normalizeForPool(viewWidth + radiusSafeSpace);
            int bitmapHeight = PlatformWrapperView.normalizeForPool(viewHeight + radiusSafeSpace);
            int drawOriginX = (bitmapWidth - viewWidth) / 2;
            int drawOriginY = (bitmapHeight - viewHeight) / 2;
            if (this.shadowBitmap != null) {
                if (this.shadowBitmap.getWidth() == bitmapWidth && this.shadowBitmap.getHeight() == bitmapHeight) {
                    this.shadowBitmap.eraseColor(0);
                } else {
                    this.bitmapPool.put(this.shadowBitmap);
                    this.shadowBitmap = this.bitmapPool.get(bitmapWidth, bitmapHeight, Bitmap.Config.ARGB_8888);
                }
            } else {
                this.shadowBitmap = this.bitmapPool.get(bitmapWidth, bitmapHeight, Bitmap.Config.ARGB_8888);
            }
            this.shadowCanvas.setBitmap(this.shadowBitmap);
            Bitmap extractAlpha = this.bitmapPool.get(PlatformWrapperView.normalizeForPool(viewWidth), PlatformWrapperView.normalizeForPool(viewHeight), Bitmap.Config.ALPHA_8);
            Canvas alphaCanvas = new Canvas(extractAlpha);
            super.dispatchDraw(alphaCanvas);
            this.updateShadowShader(bitmapWidth, bitmapHeight);
            this.shadowCanvas.drawBitmap(extractAlpha, (float)drawOriginX, (float)drawOriginY, this.shadowPaint);
            this.bitmapPool.put(extractAlpha);
            this.shadowBitmapX = this.offsetX - (float)drawOriginX;
            this.shadowBitmapY = this.offsetY - (float)drawOriginY;
        }
        canvas.drawBitmap(this.shadowBitmap, this.shadowBitmapX, this.shadowBitmapY, null);
    }

    private int getRadiusSafeSpace() {
        return (int)(this.radius * 3.0f);
    }

    private static int normalizeForPool(int pixels) {
        return (int)(Math.ceil((double)pixels / 48.0) * 48.0);
    }

    private void updateShadowShader(int bitmapWidth, int bitmapHeight) {
        RadialGradient shader = null;
        if (this.paintType == 2) {
            shader = new LinearGradient(this.bounds[0] * (float)bitmapWidth, this.bounds[1] * (float)bitmapHeight, this.bounds[2] * (float)bitmapWidth, this.bounds[3] * (float)bitmapHeight, this.colors, this.positions, Shader.TileMode.CLAMP);
        } else if (this.paintType == 3) {
            shader = new RadialGradient(this.bounds[0] * (float)bitmapWidth, this.bounds[1] * (float)bitmapHeight, this.bounds[2] * (float)Math.max(bitmapWidth, bitmapHeight), this.colors, this.positions, Shader.TileMode.CLAMP);
        }
        if (shader != null) {
            this.shadowPaint.setShader(shader);
        }
    }
}

