/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.maui.glide;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.request.target.CustomTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.microsoft.maui.ImageLoaderCallback;
import com.microsoft.maui.PlatformLogger;
import com.microsoft.maui.glide.MauiTarget;

public class MauiCustomTarget
extends CustomTarget<Drawable>
implements MauiTarget {
    private static final PlatformLogger logger = new PlatformLogger("MauiCustomTarget");
    private final Context context;
    private final ImageLoaderCallback callback;
    private final String resourceLogIdentifier;
    private boolean completed = false;

    public MauiCustomTarget(Context context, ImageLoaderCallback callback, Object model) {
        this.context = context;
        this.callback = callback;
        this.resourceLogIdentifier = MauiCustomTarget.logger.isVerboseLoggable && model != null ? model.toString() : null;
    }

    @Override
    public void load(RequestBuilder<Drawable> builder) {
        builder.into((Target)this);
    }

    public void onLoadFailed(@Nullable Drawable errorDrawable) {
        if (this.completed) {
            return;
        }
        this.completed = true;
        if (MauiCustomTarget.logger.isVerboseLoggable) {
            logger.v("onLoadFailed: " + this.resourceLogIdentifier);
        }
        this.callback.onComplete(false, errorDrawable, null);
    }

    public void onResourceReady(@NonNull Drawable resource, @Nullable Transition<? super Drawable> transition) {
        if (this.completed) {
            return;
        }
        this.completed = true;
        if (MauiCustomTarget.logger.isVerboseLoggable) {
            logger.v("onResourceReady: " + this.resourceLogIdentifier);
        }
        this.callback.onComplete(true, resource, this::clear);
    }

    public void onLoadCleared(@Nullable Drawable placeholder) {
        if (MauiCustomTarget.logger.isVerboseLoggable) {
            logger.v("onLoadCleared: " + this.resourceLogIdentifier);
        }
    }

    private void post(Runnable runnable) {
        Looper looper = Looper.getMainLooper();
        if (looper.isCurrentThread()) {
            runnable.run();
            return;
        }
        Handler handler = new Handler(looper);
        handler.post(runnable);
    }

    private void clear() {
        this.post(() -> Glide.with((Context)this.context).clear((Target)this));
    }
}

