/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.maui.glide;

import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.request.target.CustomViewTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.microsoft.maui.ImageLoaderCallback;
import com.microsoft.maui.PlatformLogger;
import com.microsoft.maui.R;
import com.microsoft.maui.glide.MauiTarget;

public class MauiCustomViewTarget
extends CustomViewTarget<ImageView, Drawable>
implements MauiTarget {
    private static final PlatformLogger logger = new PlatformLogger("MauiCustomViewTarget");
    @IdRes
    private static final int RUNNING_CALLBACKS_TAG = R.id.maui_custom_view_target_running_callbacks_tag;
    private final ImageLoaderCallback callback;
    private final String resourceLogIdentifier;
    private boolean completed = false;

    public MauiCustomViewTarget(@NonNull ImageView view, ImageLoaderCallback callback, Object model) {
        super((View)view);
        this.callback = callback;
        this.resourceLogIdentifier = MauiCustomViewTarget.logger.isVerboseLoggable && model != null ? model.toString() : null;
    }

    @Override
    public void load(RequestBuilder<Drawable> builder) {
        if (this.getIsInvokingCallbacks()) {
            if (MauiCustomViewTarget.logger.isVerboseLoggable) {
                logger.v("defer load: " + this.resourceLogIdentifier);
            }
            ((ImageView)this.view).post(() -> this.load(builder));
            return;
        }
        builder.into((Target)this);
    }

    protected void onResourceCleared(@Nullable Drawable placeholder) {
        if (MauiCustomViewTarget.logger.isVerboseLoggable) {
            logger.v("onResourceCleared: " + this.resourceLogIdentifier);
        }
        ((ImageView)this.view).setImageDrawable(placeholder);
    }

    public void onLoadFailed(@Nullable Drawable errorDrawable) {
        if (this.completed) {
            return;
        }
        this.completed = true;
        if (MauiCustomViewTarget.logger.isVerboseLoggable) {
            logger.v("onLoadFailed: " + this.resourceLogIdentifier);
        }
        try {
            this.setIsInvokingCallbacks(true);
            this.callback.onComplete(false, errorDrawable, null);
        }
        finally {
            this.setIsInvokingCallbacks(false);
        }
    }

    public void onResourceReady(@NonNull Drawable resource, @Nullable Transition<? super Drawable> transition) {
        if (this.completed) {
            return;
        }
        this.completed = true;
        if (MauiCustomViewTarget.logger.isVerboseLoggable) {
            logger.v("onResourceReady: " + this.resourceLogIdentifier);
        }
        ((ImageView)this.view).setImageDrawable(resource);
        try {
            this.setIsInvokingCallbacks(true);
            this.callback.onComplete(true, resource, null);
        }
        finally {
            this.setIsInvokingCallbacks(false);
        }
    }

    private void setIsInvokingCallbacks(boolean isInvokingCallbacks) {
        ((ImageView)this.view).setTag(RUNNING_CALLBACKS_TAG, (Object)isInvokingCallbacks);
    }

    private boolean getIsInvokingCallbacks() {
        Object tag = ((ImageView)this.view).getTag(RUNNING_CALLBACKS_TAG);
        return tag != null && tag instanceof Boolean && (Boolean)tag != false;
    }
}

