/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.maui.glide.font;

import android.graphics.Typeface;
import androidx.annotation.ColorInt;
import com.bumptech.glide.signature.ObjectKey;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class FontModel {
    private final int color;
    private final String glyph;
    private final float textSize;
    private final Typeface typeface;

    public static String getGlyphHex(String glyph) {
        if (glyph == null) {
            return null;
        }
        byte[] ba = glyph.getBytes(StandardCharsets.UTF_16BE);
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < ba.length; ++i) {
            str.append(String.format("%02x", ba[i]));
        }
        return str.toString();
    }

    public FontModel(@ColorInt int color, String glyph, float textSize, Typeface typeface) {
        this.color = color;
        this.glyph = glyph;
        this.textSize = textSize;
        this.typeface = typeface;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FontModel other = (FontModel)o;
        return this.color == other.color && Objects.equals(this.glyph, other.glyph) && this.textSize == other.textSize && this.typeface == other.typeface;
    }

    public int hashCode() {
        return Objects.hash(this.color, this.glyph, Float.valueOf(this.textSize), this.typeface);
    }

    public String toString() {
        return "FontModel{color=" + String.format("#%08X", 0xFFFFFFFF & this.color) + ", glyph='" + FontModel.getGlyphHex(this.glyph) + '\'' + ", textSize=" + this.textSize + ", typeface=" + this.typeface + '}';
    }

    public int getColor() {
        return this.color;
    }

    public String getGlyph() {
        return this.glyph;
    }

    public float getTextSize() {
        return this.textSize;
    }

    public Typeface getTypeface() {
        return this.typeface;
    }

    public ObjectKey getCacheKey() {
        return new ObjectKey((Object)(Integer.toString(this.color) + this.glyph + String.valueOf(this.textSize) + this.typeface.toString()));
    }
}

