/*
 * Decompiled with CFR 0.152.
 */
package androidx.profileinstaller;

import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.profileinstaller.DexProfileData;
import androidx.profileinstaller.ProfileInstaller;
import androidx.profileinstaller.ProfileTranscoder;
import androidx.profileinstaller.ProfileVersion;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class DeviceProfileWriter {
    @NonNull
    private final AssetManager mAssetManager;
    @NonNull
    private final Executor mExecutor;
    @NonNull
    private final ProfileInstaller.DiagnosticsCallback mDiagnostics;
    @Nullable
    private final byte[] mDesiredVersion;
    @NonNull
    private final File mCurProfile;
    @NonNull
    private final String mApkName;
    @NonNull
    private final String mProfileSourceLocation;
    @NonNull
    private final String mProfileMetaSourceLocation;
    private boolean mDeviceSupportsAotProfile = false;
    @Nullable
    private DexProfileData[] mProfile;
    @Nullable
    private byte[] mTranscodedProfile;

    private void result(int code, @Nullable Object data) {
        this.mExecutor.execute(() -> this.mDiagnostics.onResultReceived(code, data));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public DeviceProfileWriter(@NonNull AssetManager assetManager, @NonNull Executor executor, @NonNull ProfileInstaller.DiagnosticsCallback diagnosticsCallback, @NonNull String apkName, @NonNull String profileSourceLocation, @NonNull String profileMetaSourceLocation, @NonNull File curProfile) {
        this.mAssetManager = assetManager;
        this.mExecutor = executor;
        this.mDiagnostics = diagnosticsCallback;
        this.mApkName = apkName;
        this.mProfileSourceLocation = profileSourceLocation;
        this.mProfileMetaSourceLocation = profileMetaSourceLocation;
        this.mCurProfile = curProfile;
        this.mDesiredVersion = DeviceProfileWriter.desiredVersion();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public boolean deviceAllowsProfileInstallerAotWrites() {
        if (this.mDesiredVersion == null) {
            this.result(3, Build.VERSION.SDK_INT);
            return false;
        }
        if (this.mCurProfile.exists()) {
            if (!this.mCurProfile.canWrite()) {
                this.result(4, null);
                return false;
            }
        } else {
            try {
                if (!this.mCurProfile.createNewFile()) {
                    this.result(4, null);
                    return false;
                }
            }
            catch (IOException e) {
                this.result(4, null);
                return false;
            }
        }
        this.mDeviceSupportsAotProfile = true;
        return true;
    }

    private void assertDeviceAllowsProfileInstallerAotWritesCalled() {
        if (!this.mDeviceSupportsAotProfile) {
            throw new IllegalStateException("This device doesn't support aot. Did you call deviceSupportsAotProfile()?");
        }
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public DeviceProfileWriter read() {
        this.assertDeviceAllowsProfileInstallerAotWritesCalled();
        if (this.mDesiredVersion == null) {
            return this;
        }
        InputStream profileStream = this.getProfileInputStream(this.mAssetManager);
        if (profileStream != null) {
            this.mProfile = this.readProfileInternal(profileStream);
        }
        if (this.mProfile != null) {
            DeviceProfileWriter profileWriter;
            DexProfileData[] profile = this.mProfile;
            if (DeviceProfileWriter.requiresMetadata() && (profileWriter = this.addMetadata(profile, this.mDesiredVersion)) != null) {
                return profileWriter;
            }
        }
        return this;
    }

    @Nullable
    private InputStream openStreamFromAssets(AssetManager assetManager, String location) throws IOException {
        FileInputStream profileStream;
        block2: {
            profileStream = null;
            try {
                AssetFileDescriptor descriptor = assetManager.openFd(location);
                profileStream = descriptor.createInputStream();
            }
            catch (FileNotFoundException e) {
                String message = e.getMessage();
                if (message == null || !message.contains("compressed")) break block2;
                this.mDiagnostics.onDiagnosticReceived(5, null);
            }
        }
        return profileStream;
    }

    @Nullable
    private InputStream getProfileInputStream(AssetManager assetManager) {
        InputStream profileStream = null;
        try {
            profileStream = this.openStreamFromAssets(assetManager, this.mProfileSourceLocation);
        }
        catch (FileNotFoundException e) {
            this.mDiagnostics.onResultReceived(6, e);
        }
        catch (IOException e) {
            this.mDiagnostics.onResultReceived(7, e);
        }
        return profileStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private DexProfileData[] readProfileInternal(InputStream profileStream) {
        DexProfileData[] profile = null;
        try {
            byte[] baselineVersion = ProfileTranscoder.readHeader(profileStream, ProfileTranscoder.MAGIC_PROF);
            profile = ProfileTranscoder.readProfile(profileStream, baselineVersion, this.mApkName);
        }
        catch (IOException e) {
            this.mDiagnostics.onResultReceived(7, e);
        }
        catch (IllegalStateException e) {
            this.mDiagnostics.onResultReceived(8, e);
        }
        finally {
            try {
                profileStream.close();
            }
            catch (IOException e) {
                this.mDiagnostics.onResultReceived(7, e);
            }
        }
        return profile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private DeviceProfileWriter addMetadata(DexProfileData[] profile, byte[] desiredVersion) {
        try (InputStream is = this.openStreamFromAssets(this.mAssetManager, this.mProfileMetaSourceLocation);){
            if (is == null) return null;
            byte[] metaVersion = ProfileTranscoder.readHeader(is, ProfileTranscoder.MAGIC_PROFM);
            this.mProfile = ProfileTranscoder.readMeta(is, metaVersion, desiredVersion, profile);
            DeviceProfileWriter deviceProfileWriter = this;
            return deviceProfileWriter;
        }
        catch (FileNotFoundException e) {
            this.mDiagnostics.onResultReceived(9, e);
            return null;
        }
        catch (IOException e) {
            this.mDiagnostics.onResultReceived(7, e);
            return null;
        }
        catch (IllegalStateException e) {
            this.mProfile = null;
            this.mDiagnostics.onResultReceived(8, e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public DeviceProfileWriter transcodeIfNeeded() {
        DexProfileData[] profile = this.mProfile;
        byte[] desiredVersion = this.mDesiredVersion;
        if (profile == null) return this;
        if (desiredVersion == null) {
            return this;
        }
        this.assertDeviceAllowsProfileInstallerAotWritesCalled();
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            ProfileTranscoder.writeHeader(os, desiredVersion);
            boolean success = ProfileTranscoder.transcodeAndWriteBody(os, desiredVersion, profile);
            if (!success) {
                this.mDiagnostics.onResultReceived(5, null);
                this.mProfile = null;
                DeviceProfileWriter deviceProfileWriter = this;
                return deviceProfileWriter;
            }
            this.mTranscodedProfile = os.toByteArray();
        }
        catch (IOException e) {
            this.mDiagnostics.onResultReceived(7, e);
        }
        catch (IllegalStateException e) {
            this.mDiagnostics.onResultReceived(8, e);
        }
        this.mProfile = null;
        return this;
    }

    /*
     * Exception decompiling
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public boolean write() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    private static byte[] desiredVersion() {
        if (Build.VERSION.SDK_INT < 24) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 31) {
            return ProfileVersion.V015_S;
        }
        switch (Build.VERSION.SDK_INT) {
            case 24: 
            case 25: {
                return ProfileVersion.V001_N;
            }
            case 26: {
                return ProfileVersion.V005_O;
            }
            case 27: {
                return ProfileVersion.V009_O_MR1;
            }
            case 28: 
            case 29: 
            case 30: {
                return ProfileVersion.V010_P;
            }
        }
        return null;
    }

    private static boolean requiresMetadata() {
        if (Build.VERSION.SDK_INT < 24) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 31) {
            return true;
        }
        switch (Build.VERSION.SDK_INT) {
            case 24: 
            case 25: {
                return true;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                return false;
            }
        }
        return false;
    }
}

