/*
 * Decompiled with CFR 0.152.
 */
package androidx.profileinstaller;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;

class Encoding {
    static final int SIZEOF_BYTE = 8;
    static final int UINT_8_SIZE = 1;
    static final int UINT_16_SIZE = 2;
    static final int UINT_32_SIZE = 4;

    private Encoding() {
    }

    static int utf8Length(@NonNull String s) {
        return s.getBytes(StandardCharsets.UTF_8).length;
    }

    static void writeUInt(@NonNull OutputStream os, long value, int numberOfBytes) throws IOException {
        byte[] buffer = new byte[numberOfBytes];
        for (int i = 0; i < numberOfBytes; ++i) {
            buffer[i] = (byte)(value >> i * 8 & 0xFFL);
        }
        os.write(buffer);
    }

    static void writeUInt8(@NonNull OutputStream os, int value) throws IOException {
        Encoding.writeUInt(os, value, 1);
    }

    static void writeUInt16(@NonNull OutputStream os, int value) throws IOException {
        Encoding.writeUInt(os, value, 2);
    }

    static void writeUInt32(@NonNull OutputStream os, long value) throws IOException {
        Encoding.writeUInt(os, value, 4);
    }

    static void writeString(@NonNull OutputStream os, @NonNull String s) throws IOException {
        os.write(s.getBytes(StandardCharsets.UTF_8));
    }

    static int bitsToBytes(int numberOfBits) {
        return (numberOfBits + 8 - 1 & 0xFFFFFFF8) / 8;
    }

    @NonNull
    static byte[] read(@NonNull InputStream is, int length) throws IOException {
        int result;
        byte[] buffer = new byte[length];
        for (int offset = 0; offset < length; offset += result) {
            result = is.read(buffer, offset, length - offset);
            if (result >= 0) continue;
            throw Encoding.error("Not enough bytes to read: " + length);
        }
        return buffer;
    }

    static long readUInt(@NonNull InputStream is, int numberOfBytes) throws IOException {
        byte[] buffer = Encoding.read(is, numberOfBytes);
        long value = 0L;
        for (int i = 0; i < numberOfBytes; ++i) {
            long next = buffer[i] & 0xFF;
            value += next << i * 8;
        }
        return value;
    }

    static int readUInt8(@NonNull InputStream is) throws IOException {
        return (int)Encoding.readUInt(is, 1);
    }

    static int readUInt16(@NonNull InputStream is) throws IOException {
        return (int)Encoding.readUInt(is, 2);
    }

    static long readUInt32(@NonNull InputStream is) throws IOException {
        return Encoding.readUInt(is, 4);
    }

    @NonNull
    static String readString(InputStream is, int size) throws IOException {
        return new String(Encoding.read(is, size), StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    static byte[] readCompressed(@NonNull InputStream is, int compressedDataSize, int uncompressedDataSize) throws IOException {
        Inflater inf = new Inflater();
        try {
            int totalBytesRead;
            int bytesRead;
            byte[] result = new byte[uncompressedDataSize];
            int totalBytesInflated = 0;
            byte[] input = new byte[2048];
            for (totalBytesRead = 0; !inf.finished() && !inf.needsDictionary() && totalBytesRead < compressedDataSize; totalBytesRead += bytesRead) {
                bytesRead = is.read(input);
                if (bytesRead < 0) {
                    throw Encoding.error("Invalid zip data. Stream ended after $totalBytesRead bytes. Expected " + compressedDataSize + " bytes");
                }
                inf.setInput(input, 0, bytesRead);
                try {
                    totalBytesInflated += inf.inflate(result, totalBytesInflated, uncompressedDataSize - totalBytesInflated);
                    continue;
                }
                catch (DataFormatException e) {
                    throw Encoding.error(e.getMessage());
                }
            }
            if (totalBytesRead != compressedDataSize) {
                throw Encoding.error("Didn't read enough bytes during decompression. expected=" + compressedDataSize + " actual=" + totalBytesRead);
            }
            if (!inf.finished()) {
                throw Encoding.error("Inflater did not finish");
            }
            byte[] byArray = result;
            return byArray;
        }
        finally {
            inf.end();
        }
    }

    static void writeCompressed(@NonNull OutputStream os, byte[] data) throws IOException {
        Encoding.writeUInt32(os, data.length);
        byte[] outputData = Encoding.compress(data);
        Encoding.writeUInt32(os, outputData.length);
        os.write(outputData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] compress(@NonNull byte[] data) throws IOException {
        Deflater compressor = new Deflater(1);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (DeflaterOutputStream deflater = new DeflaterOutputStream((OutputStream)out, compressor);){
            deflater.write(data);
        }
        finally {
            compressor.end();
        }
        return out.toByteArray();
    }

    static void writeAll(@NonNull InputStream is, @NonNull OutputStream os, @Nullable FileLock lock) throws IOException {
        int length;
        boolean isValid;
        boolean bl = isValid = lock != null && lock.isValid();
        if (!isValid) {
            throw new IOException("Unable to acquire a lock on the underlying file channel.");
        }
        byte[] buf = new byte[512];
        while ((length = is.read(buf)) > 0) {
            os.write(buf, 0, length);
        }
    }

    @NonNull
    static RuntimeException error(@Nullable String message) {
        return new IllegalStateException(message);
    }
}

