/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.app;

import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentFactory;
import androidx.lifecycle.Lifecycle;

@SuppressLint(value={"BanParcelableUsage"})
final class FragmentState
implements Parcelable {
    final String mClassName;
    final String mWho;
    final boolean mFromLayout;
    final boolean mInDynamicContainer;
    final int mFragmentId;
    final int mContainerId;
    final String mTag;
    final boolean mRetainInstance;
    final boolean mRemoving;
    final boolean mDetached;
    final boolean mHidden;
    final int mMaxLifecycleState;
    final String mTargetWho;
    final int mTargetRequestCode;
    final boolean mUserVisibleHint;
    public static final Parcelable.Creator<FragmentState> CREATOR = new Parcelable.Creator<FragmentState>(){

        public FragmentState createFromParcel(Parcel in) {
            return new FragmentState(in);
        }

        public FragmentState[] newArray(int size) {
            return new FragmentState[size];
        }
    };

    FragmentState(Fragment frag) {
        this.mClassName = frag.getClass().getName();
        this.mWho = frag.mWho;
        this.mFromLayout = frag.mFromLayout;
        this.mInDynamicContainer = frag.mInDynamicContainer;
        this.mFragmentId = frag.mFragmentId;
        this.mContainerId = frag.mContainerId;
        this.mTag = frag.mTag;
        this.mRetainInstance = frag.mRetainInstance;
        this.mRemoving = frag.mRemoving;
        this.mDetached = frag.mDetached;
        this.mHidden = frag.mHidden;
        this.mMaxLifecycleState = frag.mMaxState.ordinal();
        this.mTargetWho = frag.mTargetWho;
        this.mTargetRequestCode = frag.mTargetRequestCode;
        this.mUserVisibleHint = frag.mUserVisibleHint;
    }

    FragmentState(Parcel in) {
        this.mClassName = in.readString();
        this.mWho = in.readString();
        this.mFromLayout = in.readInt() != 0;
        this.mInDynamicContainer = in.readInt() != 0;
        this.mFragmentId = in.readInt();
        this.mContainerId = in.readInt();
        this.mTag = in.readString();
        this.mRetainInstance = in.readInt() != 0;
        this.mRemoving = in.readInt() != 0;
        this.mDetached = in.readInt() != 0;
        this.mHidden = in.readInt() != 0;
        this.mMaxLifecycleState = in.readInt();
        this.mTargetWho = in.readString();
        this.mTargetRequestCode = in.readInt();
        this.mUserVisibleHint = in.readInt() != 0;
    }

    @NonNull
    Fragment instantiate(@NonNull FragmentFactory fragmentFactory, @NonNull ClassLoader classLoader) {
        Fragment fragment = fragmentFactory.instantiate(classLoader, this.mClassName);
        fragment.mWho = this.mWho;
        fragment.mFromLayout = this.mFromLayout;
        fragment.mInDynamicContainer = this.mInDynamicContainer;
        fragment.mRestored = true;
        fragment.mFragmentId = this.mFragmentId;
        fragment.mContainerId = this.mContainerId;
        fragment.mTag = this.mTag;
        fragment.mRetainInstance = this.mRetainInstance;
        fragment.mRemoving = this.mRemoving;
        fragment.mDetached = this.mDetached;
        fragment.mHidden = this.mHidden;
        fragment.mMaxState = Lifecycle.State.values()[this.mMaxLifecycleState];
        fragment.mTargetWho = this.mTargetWho;
        fragment.mTargetRequestCode = this.mTargetRequestCode;
        fragment.mUserVisibleHint = this.mUserVisibleHint;
        return fragment;
    }

    @NonNull
    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("FragmentState{");
        sb.append(this.mClassName);
        sb.append(" (");
        sb.append(this.mWho);
        sb.append(")}:");
        if (this.mFromLayout) {
            sb.append(" fromLayout");
        }
        if (this.mInDynamicContainer) {
            sb.append(" dynamicContainer");
        }
        if (this.mContainerId != 0) {
            sb.append(" id=0x");
            sb.append(Integer.toHexString(this.mContainerId));
        }
        if (this.mTag != null && !this.mTag.isEmpty()) {
            sb.append(" tag=");
            sb.append(this.mTag);
        }
        if (this.mRetainInstance) {
            sb.append(" retainInstance");
        }
        if (this.mRemoving) {
            sb.append(" removing");
        }
        if (this.mDetached) {
            sb.append(" detached");
        }
        if (this.mHidden) {
            sb.append(" hidden");
        }
        if (this.mTargetWho != null) {
            sb.append(" targetWho=");
            sb.append(this.mTargetWho);
            sb.append(" targetRequestCode=");
            sb.append(this.mTargetRequestCode);
        }
        if (this.mUserVisibleHint) {
            sb.append(" userVisibleHint");
        }
        return sb.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mClassName);
        dest.writeString(this.mWho);
        dest.writeInt(this.mFromLayout ? 1 : 0);
        dest.writeInt(this.mInDynamicContainer ? 1 : 0);
        dest.writeInt(this.mFragmentId);
        dest.writeInt(this.mContainerId);
        dest.writeString(this.mTag);
        dest.writeInt(this.mRetainInstance ? 1 : 0);
        dest.writeInt(this.mRemoving ? 1 : 0);
        dest.writeInt(this.mDetached ? 1 : 0);
        dest.writeInt(this.mHidden ? 1 : 0);
        dest.writeInt(this.mMaxLifecycleState);
        dest.writeString(this.mTargetWho);
        dest.writeInt(this.mTargetRequestCode);
        dest.writeInt(this.mUserVisibleHint ? 1 : 0);
    }
}

