/*
 * Decompiled with CFR 0.152.
 */
package androidx.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TypeEvaluator;
import android.content.Context;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.res.TypedArrayUtils;
import androidx.transition.ObjectAnimatorUtils;
import androidx.transition.R;
import androidx.transition.RectEvaluator;
import androidx.transition.Styleable;
import androidx.transition.Transition;
import androidx.transition.TransitionListenerAdapter;
import androidx.transition.TransitionUtils;
import androidx.transition.TransitionValues;
import androidx.transition.ViewGroupUtils;
import androidx.transition.ViewUtils;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;

public class ChangeBounds
extends Transition {
    private static final String PROPNAME_BOUNDS = "android:changeBounds:bounds";
    private static final String PROPNAME_CLIP = "android:changeBounds:clip";
    private static final String PROPNAME_PARENT = "android:changeBounds:parent";
    private static final String PROPNAME_WINDOW_X = "android:changeBounds:windowX";
    private static final String PROPNAME_WINDOW_Y = "android:changeBounds:windowY";
    private static final String[] sTransitionProperties = new String[]{"android:changeBounds:bounds", "android:changeBounds:clip", "android:changeBounds:parent", "android:changeBounds:windowX", "android:changeBounds:windowY"};
    private static final Property<ViewBounds, PointF> TOP_LEFT_PROPERTY = new Property<ViewBounds, PointF>(PointF.class, "topLeft"){

        public void set(ViewBounds viewBounds, PointF topLeft) {
            viewBounds.setTopLeft(topLeft);
        }

        public PointF get(ViewBounds viewBounds) {
            return null;
        }
    };
    private static final Property<ViewBounds, PointF> BOTTOM_RIGHT_PROPERTY = new Property<ViewBounds, PointF>(PointF.class, "bottomRight"){

        public void set(ViewBounds viewBounds, PointF bottomRight) {
            viewBounds.setBottomRight(bottomRight);
        }

        public PointF get(ViewBounds viewBounds) {
            return null;
        }
    };
    private static final Property<View, PointF> BOTTOM_RIGHT_ONLY_PROPERTY = new Property<View, PointF>(PointF.class, "bottomRight"){

        public void set(View view, PointF bottomRight) {
            int left = view.getLeft();
            int top = view.getTop();
            int right = Math.round(bottomRight.x);
            int bottom = Math.round(bottomRight.y);
            ViewUtils.setLeftTopRightBottom(view, left, top, right, bottom);
        }

        public PointF get(View view) {
            return null;
        }
    };
    private static final Property<View, PointF> TOP_LEFT_ONLY_PROPERTY = new Property<View, PointF>(PointF.class, "topLeft"){

        public void set(View view, PointF topLeft) {
            int left = Math.round(topLeft.x);
            int top = Math.round(topLeft.y);
            int right = view.getRight();
            int bottom = view.getBottom();
            ViewUtils.setLeftTopRightBottom(view, left, top, right, bottom);
        }

        public PointF get(View view) {
            return null;
        }
    };
    private static final Property<View, PointF> POSITION_PROPERTY = new Property<View, PointF>(PointF.class, "position"){

        public void set(View view, PointF topLeft) {
            int left = Math.round(topLeft.x);
            int top = Math.round(topLeft.y);
            int right = left + view.getWidth();
            int bottom = top + view.getHeight();
            ViewUtils.setLeftTopRightBottom(view, left, top, right, bottom);
        }

        public PointF get(View view) {
            return null;
        }
    };
    private boolean mResizeClip = false;
    private static final RectEvaluator sRectEvaluator = new RectEvaluator();

    public ChangeBounds() {
    }

    public ChangeBounds(@NonNull Context context, @NonNull AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, Styleable.CHANGE_BOUNDS);
        boolean resizeClip = TypedArrayUtils.getNamedBoolean((TypedArray)a, (XmlPullParser)((XmlResourceParser)attrs), (String)"resizeClip", (int)0, (boolean)false);
        a.recycle();
        this.setResizeClip(resizeClip);
    }

    @Override
    public boolean isSeekingSupported() {
        return true;
    }

    @Override
    @NonNull
    public String[] getTransitionProperties() {
        return sTransitionProperties;
    }

    public void setResizeClip(boolean resizeClip) {
        this.mResizeClip = resizeClip;
    }

    public boolean getResizeClip() {
        return this.mResizeClip;
    }

    private void captureValues(TransitionValues values) {
        View view = values.view;
        if (view.isLaidOut() || view.getWidth() != 0 || view.getHeight() != 0) {
            values.values.put(PROPNAME_BOUNDS, new Rect(view.getLeft(), view.getTop(), view.getRight(), view.getBottom()));
            values.values.put(PROPNAME_PARENT, values.view.getParent());
            if (this.mResizeClip) {
                values.values.put(PROPNAME_CLIP, view.getClipBounds());
            }
        }
    }

    @Override
    public void captureStartValues(@NonNull TransitionValues transitionValues) {
        Rect clipSize;
        this.captureValues(transitionValues);
        if (this.mResizeClip && (clipSize = (Rect)transitionValues.view.getTag(R.id.transition_clip)) != null) {
            transitionValues.values.put(PROPNAME_CLIP, clipSize);
        }
    }

    @Override
    public void captureEndValues(@NonNull TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    @Override
    @Nullable
    public Animator createAnimator(@NonNull ViewGroup sceneRoot, @Nullable TransitionValues startValues, @Nullable TransitionValues endValues) {
        if (startValues == null || endValues == null) {
            return null;
        }
        Map<String, Object> startParentVals = startValues.values;
        Map<String, Object> endParentVals = endValues.values;
        ViewGroup startParent = (ViewGroup)startParentVals.get(PROPNAME_PARENT);
        ViewGroup endParent = (ViewGroup)endParentVals.get(PROPNAME_PARENT);
        if (startParent == null || endParent == null) {
            return null;
        }
        View view = endValues.view;
        Rect startBounds = (Rect)startValues.values.get(PROPNAME_BOUNDS);
        Rect endBounds = (Rect)endValues.values.get(PROPNAME_BOUNDS);
        int startLeft = startBounds.left;
        int endLeft = endBounds.left;
        int startTop = startBounds.top;
        int endTop = endBounds.top;
        int startRight = startBounds.right;
        int endRight = endBounds.right;
        int startBottom = startBounds.bottom;
        int endBottom = endBounds.bottom;
        int startWidth = startRight - startLeft;
        int startHeight = startBottom - startTop;
        int endWidth = endRight - endLeft;
        int endHeight = endBottom - endTop;
        Rect startClip = (Rect)startValues.values.get(PROPNAME_CLIP);
        Rect endClip = (Rect)endValues.values.get(PROPNAME_CLIP);
        int numChanges = 0;
        if (startWidth != 0 && startHeight != 0 || endWidth != 0 && endHeight != 0) {
            if (startLeft != endLeft || startTop != endTop) {
                ++numChanges;
            }
            if (startRight != endRight || startBottom != endBottom) {
                ++numChanges;
            }
        }
        if (startClip != null && !startClip.equals((Object)endClip) || startClip == null && endClip != null) {
            ++numChanges;
        }
        if (numChanges > 0) {
            ObjectAnimator anim;
            if (!this.mResizeClip) {
                ViewUtils.setLeftTopRightBottom(view, startLeft, startTop, startRight, startBottom);
                if (numChanges == 2) {
                    if (startWidth == endWidth && startHeight == endHeight) {
                        Path topLeftPath = this.getPathMotion().getPath(startLeft, startTop, endLeft, endTop);
                        anim = ObjectAnimatorUtils.ofPointF(view, POSITION_PROPERTY, topLeftPath);
                    } else {
                        final ViewBounds viewBounds = new ViewBounds(view);
                        Path topLeftPath = this.getPathMotion().getPath(startLeft, startTop, endLeft, endTop);
                        ObjectAnimator topLeftAnimator = ObjectAnimatorUtils.ofPointF(viewBounds, TOP_LEFT_PROPERTY, topLeftPath);
                        Path bottomRightPath = this.getPathMotion().getPath(startRight, startBottom, endRight, endBottom);
                        ObjectAnimator bottomRightAnimator = ObjectAnimatorUtils.ofPointF(viewBounds, BOTTOM_RIGHT_PROPERTY, bottomRightPath);
                        AnimatorSet set = new AnimatorSet();
                        set.playTogether(new Animator[]{topLeftAnimator, bottomRightAnimator});
                        anim = set;
                        set.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){
                            private final ViewBounds mViewBounds;
                            {
                                this.mViewBounds = viewBounds;
                            }
                        });
                    }
                } else if (startLeft != endLeft || startTop != endTop) {
                    Path topLeftPath = this.getPathMotion().getPath(startLeft, startTop, endLeft, endTop);
                    anim = ObjectAnimatorUtils.ofPointF(view, TOP_LEFT_ONLY_PROPERTY, topLeftPath);
                } else {
                    Path bottomRight = this.getPathMotion().getPath(startRight, startBottom, endRight, endBottom);
                    anim = ObjectAnimatorUtils.ofPointF(view, BOTTOM_RIGHT_ONLY_PROPERTY, bottomRight);
                }
            } else {
                boolean endClipIsNull;
                boolean startClipIsNull;
                int maxWidth = Math.max(startWidth, endWidth);
                int maxHeight = Math.max(startHeight, endHeight);
                ViewUtils.setLeftTopRightBottom(view, startLeft, startTop, startLeft + maxWidth, startTop + maxHeight);
                ObjectAnimator positionAnimator = null;
                if (startLeft != endLeft || startTop != endTop) {
                    Path topLeftPath = this.getPathMotion().getPath(startLeft, startTop, endLeft, endTop);
                    positionAnimator = ObjectAnimatorUtils.ofPointF(view, POSITION_PROPERTY, topLeftPath);
                }
                boolean bl = startClipIsNull = startClip == null;
                if (startClipIsNull) {
                    startClip = new Rect(0, 0, startWidth, startHeight);
                }
                boolean bl2 = endClipIsNull = endClip == null;
                if (endClipIsNull) {
                    endClip = new Rect(0, 0, endWidth, endHeight);
                }
                ObjectAnimator clipAnimator = null;
                if (!startClip.equals((Object)endClip)) {
                    view.setClipBounds(startClip);
                    clipAnimator = ObjectAnimator.ofObject((Object)view, (String)"clipBounds", (TypeEvaluator)sRectEvaluator, (Object[])new Object[]{startClip, endClip});
                    ClipListener listener = new ClipListener(view, startClip, startClipIsNull, endClip, endClipIsNull, startLeft, startTop, startRight, startBottom, endLeft, endTop, endRight, endBottom);
                    clipAnimator.addListener((Animator.AnimatorListener)listener);
                    this.addListener(listener);
                }
                anim = TransitionUtils.mergeAnimators((Animator)positionAnimator, clipAnimator);
            }
            if (view.getParent() instanceof ViewGroup) {
                ViewGroup parent = (ViewGroup)view.getParent();
                ViewGroupUtils.suppressLayout(parent, true);
                this.getRootTransition().addListener(new SuppressLayoutListener(parent));
            }
            return anim;
        }
        return null;
    }

    private static class ViewBounds {
        private int mLeft;
        private int mTop;
        private int mRight;
        private int mBottom;
        private final View mView;
        private int mTopLeftCalls;
        private int mBottomRightCalls;

        ViewBounds(View view) {
            this.mView = view;
        }

        void setTopLeft(PointF topLeft) {
            this.mLeft = Math.round(topLeft.x);
            this.mTop = Math.round(topLeft.y);
            ++this.mTopLeftCalls;
            if (this.mTopLeftCalls == this.mBottomRightCalls) {
                this.setLeftTopRightBottom();
            }
        }

        void setBottomRight(PointF bottomRight) {
            this.mRight = Math.round(bottomRight.x);
            this.mBottom = Math.round(bottomRight.y);
            ++this.mBottomRightCalls;
            if (this.mTopLeftCalls == this.mBottomRightCalls) {
                this.setLeftTopRightBottom();
            }
        }

        private void setLeftTopRightBottom() {
            ViewUtils.setLeftTopRightBottom(this.mView, this.mLeft, this.mTop, this.mRight, this.mBottom);
            this.mTopLeftCalls = 0;
            this.mBottomRightCalls = 0;
        }
    }

    private static class ClipListener
    extends AnimatorListenerAdapter
    implements Transition.TransitionListener {
        private final View mView;
        private final Rect mStartClip;
        private final boolean mStartClipIsNull;
        private final Rect mEndClip;
        private final boolean mEndClipIsNull;
        private final int mStartLeft;
        private final int mStartTop;
        private final int mStartRight;
        private final int mStartBottom;
        private final int mEndLeft;
        private final int mEndTop;
        private final int mEndRight;
        private final int mEndBottom;
        private boolean mIsCanceled;

        ClipListener(View view, Rect startClip, boolean startClipIsNull, Rect endClip, boolean endClipIsNull, int startLeft, int startTop, int startRight, int startBottom, int endLeft, int endTop, int endRight, int endBottom) {
            this.mView = view;
            this.mStartClip = startClip;
            this.mStartClipIsNull = startClipIsNull;
            this.mEndClip = endClip;
            this.mEndClipIsNull = endClipIsNull;
            this.mStartLeft = startLeft;
            this.mStartTop = startTop;
            this.mStartRight = startRight;
            this.mStartBottom = startBottom;
            this.mEndLeft = endLeft;
            this.mEndTop = endTop;
            this.mEndRight = endRight;
            this.mEndBottom = endBottom;
        }

        public void onAnimationStart(Animator animation) {
            this.onAnimationStart(animation, false);
        }

        public void onAnimationEnd(Animator animation) {
            this.onAnimationEnd(animation, false);
        }

        public void onAnimationStart(Animator animation, boolean isReverse) {
            int maxWidth = Math.max(this.mStartRight - this.mStartLeft, this.mEndRight - this.mEndLeft);
            int maxHeight = Math.max(this.mStartBottom - this.mStartTop, this.mEndBottom - this.mEndTop);
            int left = isReverse ? this.mEndLeft : this.mStartLeft;
            int top = isReverse ? this.mEndTop : this.mStartTop;
            ViewUtils.setLeftTopRightBottom(this.mView, left, top, left + maxWidth, top + maxHeight);
            Rect clip = isReverse ? this.mEndClip : this.mStartClip;
            this.mView.setClipBounds(clip);
        }

        public void onAnimationEnd(Animator animation, boolean isReverse) {
            if (this.mIsCanceled) {
                return;
            }
            Rect clip = isReverse ? (this.mStartClipIsNull ? null : this.mStartClip) : (this.mEndClipIsNull ? null : this.mEndClip);
            this.mView.setClipBounds(clip);
            if (isReverse) {
                ViewUtils.setLeftTopRightBottom(this.mView, this.mStartLeft, this.mStartTop, this.mStartRight, this.mStartBottom);
            } else {
                ViewUtils.setLeftTopRightBottom(this.mView, this.mEndLeft, this.mEndTop, this.mEndRight, this.mEndBottom);
            }
        }

        @Override
        public void onTransitionCancel(@NonNull Transition transition) {
            this.mIsCanceled = true;
        }

        @Override
        public void onTransitionPause(@NonNull Transition transition) {
            Rect pauseClip = this.mView.getClipBounds();
            this.mView.setTag(R.id.transition_clip, (Object)pauseClip);
            Rect clip = this.mEndClipIsNull ? null : this.mEndClip;
            this.mView.setClipBounds(clip);
        }

        @Override
        public void onTransitionResume(@NonNull Transition transition) {
            Rect pauseClip = (Rect)this.mView.getTag(R.id.transition_clip);
            this.mView.setTag(R.id.transition_clip, null);
            this.mView.setClipBounds(pauseClip);
        }

        @Override
        public void onTransitionStart(@NonNull Transition transition) {
        }

        @Override
        public void onTransitionEnd(@NonNull Transition transition) {
        }
    }

    private static class SuppressLayoutListener
    extends TransitionListenerAdapter {
        boolean mCanceled = false;
        final ViewGroup mParent;

        SuppressLayoutListener(@NonNull ViewGroup parent) {
            this.mParent = parent;
        }

        @Override
        public void onTransitionCancel(@NonNull Transition transition) {
            ViewGroupUtils.suppressLayout(this.mParent, false);
            this.mCanceled = true;
        }

        @Override
        public void onTransitionEnd(@NonNull Transition transition) {
            if (!this.mCanceled) {
                ViewGroupUtils.suppressLayout(this.mParent, false);
            }
            transition.removeListener(this);
        }

        @Override
        public void onTransitionPause(@NonNull Transition transition) {
            ViewGroupUtils.suppressLayout(this.mParent, false);
        }

        @Override
        public void onTransitionResume(@NonNull Transition transition) {
            ViewGroupUtils.suppressLayout(this.mParent, true);
        }
    }
}

