/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.serialization;

import androidx.navigation.NavType;
import androidx.navigation.serialization.InternalNavType;
import androidx.navigation.serialization.InternalType;
import androidx.navigation.serialization.UNKNOWN;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KType;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u0006\u0012\u0002\b\u00030\u0001*\u00020\u0002H\u0002\u001a\u0010\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004*\u00020\u0002H\u0000\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\f\u0010\t\u001a\u00020\n*\u00020\u0002H\u0002\u00a8\u0006\u000b"}, d2={"getClass", "Ljava/lang/Class;", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getNavType", "Landroidx/navigation/NavType;", "matchKType", "", "kType", "Lkotlin/reflect/KType;", "toInternalType", "Landroidx/navigation/serialization/InternalType;", "navigation-common_release"})
public final class NavTypeConverterKt {
    @NotNull
    public static final NavType<?> getNavType(@NotNull SerialDescriptor $this$getNavType) {
        NavType<Object> navType;
        Intrinsics.checkNotNullParameter((Object)$this$getNavType, (String)"<this>");
        block0 : switch (WhenMappings.$EnumSwitchMapping$0[NavTypeConverterKt.toInternalType($this$getNavType).ordinal()]) {
            case 1: {
                navType = NavType.IntType;
                break;
            }
            case 8: {
                navType = InternalNavType.INSTANCE.getIntNullableType();
                break;
            }
            case 2: {
                navType = NavType.BoolType;
                break;
            }
            case 9: {
                navType = InternalNavType.INSTANCE.getBoolNullableType();
                break;
            }
            case 10: {
                navType = InternalNavType.INSTANCE.getDoubleType();
                break;
            }
            case 11: {
                navType = InternalNavType.INSTANCE.getDoubleNullableType();
                break;
            }
            case 3: {
                navType = NavType.FloatType;
                break;
            }
            case 12: {
                navType = InternalNavType.INSTANCE.getFloatNullableType();
                break;
            }
            case 4: {
                navType = NavType.LongType;
                break;
            }
            case 13: {
                navType = InternalNavType.INSTANCE.getLongNullableType();
                break;
            }
            case 5: {
                navType = InternalNavType.INSTANCE.getStringNonNullableType();
                break;
            }
            case 6: {
                navType = NavType.StringType;
                break;
            }
            case 14: {
                navType = NavType.IntArrayType;
                break;
            }
            case 15: {
                navType = NavType.BoolArrayType;
                break;
            }
            case 16: {
                navType = InternalNavType.INSTANCE.getDoubleArrayType();
                break;
            }
            case 17: {
                navType = NavType.FloatArrayType;
                break;
            }
            case 18: {
                navType = NavType.LongArrayType;
                break;
            }
            case 19: {
                InternalType typeParameter = NavTypeConverterKt.toInternalType($this$getNavType.getElementDescriptor(0));
                if (typeParameter == InternalType.STRING) {
                    navType = NavType.StringArrayType;
                    break;
                }
                navType = UNKNOWN.INSTANCE;
                break;
            }
            case 20: {
                InternalType typeParameter = NavTypeConverterKt.toInternalType($this$getNavType.getElementDescriptor(0));
                switch (WhenMappings.$EnumSwitchMapping$0[typeParameter.ordinal()]) {
                    case 1: {
                        navType = NavType.IntListType;
                        break block0;
                    }
                    case 2: {
                        navType = NavType.BoolListType;
                        break block0;
                    }
                    case 3: {
                        navType = NavType.FloatListType;
                        break block0;
                    }
                    case 4: {
                        navType = NavType.LongListType;
                        break block0;
                    }
                    case 5: {
                        navType = NavType.StringListType;
                        break block0;
                    }
                    case 6: {
                        navType = InternalNavType.INSTANCE.getStringNullableListType();
                        break block0;
                    }
                    case 7: {
                        Class<?> clazz = NavTypeConverterKt.getClass($this$getNavType.getElementDescriptor(0));
                        Intrinsics.checkNotNull(clazz, (String)"null cannot be cast to non-null type java.lang.Class<kotlin.Enum<*>>");
                        navType = new InternalNavType.EnumListType(clazz);
                        break block0;
                    }
                }
                navType = UNKNOWN.INSTANCE;
                break;
            }
            case 7: {
                navType = NavType.Companion.parseSerializableOrParcelableType$navigation_common_release(NavTypeConverterKt.getClass($this$getNavType), false);
                if (navType != null) break;
                navType = UNKNOWN.INSTANCE;
                break;
            }
            case 21: {
                Class<?> clazz = NavTypeConverterKt.getClass($this$getNavType);
                if (Enum.class.isAssignableFrom(clazz)) {
                    Intrinsics.checkNotNull(clazz, (String)"null cannot be cast to non-null type java.lang.Class<kotlin.Enum<*>?>");
                    navType = new InternalNavType.EnumNullableType(clazz);
                    break;
                }
                navType = UNKNOWN.INSTANCE;
                break;
            }
            default: {
                navType = UNKNOWN.INSTANCE;
            }
        }
        NavType<Object> type = navType;
        return type;
    }

    private static final InternalType toInternalType(SerialDescriptor $this$toInternalType) {
        String serialName = StringsKt.replace$default((String)$this$toInternalType.getSerialName(), (String)"?", (String)"", (boolean)false, (int)4, null);
        return Intrinsics.areEqual((Object)$this$toInternalType.getKind(), (Object)SerialKind.ENUM.INSTANCE) ? ($this$toInternalType.isNullable() ? InternalType.ENUM_NULLABLE : InternalType.ENUM) : (Intrinsics.areEqual((Object)serialName, (Object)"kotlin.Int") ? ($this$toInternalType.isNullable() ? InternalType.INT_NULLABLE : InternalType.INT) : (Intrinsics.areEqual((Object)serialName, (Object)"kotlin.Boolean") ? ($this$toInternalType.isNullable() ? InternalType.BOOL_NULLABLE : InternalType.BOOL) : (Intrinsics.areEqual((Object)serialName, (Object)"kotlin.Double") ? ($this$toInternalType.isNullable() ? InternalType.DOUBLE_NULLABLE : InternalType.DOUBLE) : (Intrinsics.areEqual((Object)serialName, (Object)"kotlin.Double") ? InternalType.DOUBLE : (Intrinsics.areEqual((Object)serialName, (Object)"kotlin.Float") ? ($this$toInternalType.isNullable() ? InternalType.FLOAT_NULLABLE : InternalType.FLOAT) : (Intrinsics.areEqual((Object)serialName, (Object)"kotlin.Long") ? ($this$toInternalType.isNullable() ? InternalType.LONG_NULLABLE : InternalType.LONG) : (Intrinsics.areEqual((Object)serialName, (Object)"kotlin.String") ? ($this$toInternalType.isNullable() ? InternalType.STRING_NULLABLE : InternalType.STRING) : (Intrinsics.areEqual((Object)serialName, (Object)"kotlin.IntArray") ? InternalType.INT_ARRAY : (Intrinsics.areEqual((Object)serialName, (Object)"kotlin.DoubleArray") ? InternalType.DOUBLE_ARRAY : (Intrinsics.areEqual((Object)serialName, (Object)"kotlin.BooleanArray") ? InternalType.BOOL_ARRAY : (Intrinsics.areEqual((Object)serialName, (Object)"kotlin.FloatArray") ? InternalType.FLOAT_ARRAY : (Intrinsics.areEqual((Object)serialName, (Object)"kotlin.LongArray") ? InternalType.LONG_ARRAY : (Intrinsics.areEqual((Object)serialName, (Object)"kotlin.Array") ? InternalType.ARRAY : (StringsKt.startsWith$default((String)serialName, (String)"kotlin.collections.ArrayList", (boolean)false, (int)2, null) ? InternalType.LIST : InternalType.UNKNOWN))))))))))))));
    }

    private static final Class<?> getClass(SerialDescriptor $this$getClass) {
        String className = StringsKt.replace$default((String)$this$getClass.getSerialName(), (String)"?", (String)"", (boolean)false, (int)4, null);
        try {
            Class<?> clazz = Class.forName(className);
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(className)");
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            while (StringsKt.contains$default((CharSequence)className, (CharSequence)".", (boolean)false, (int)2, null)) {
                className = new Regex("(\\.+)(?!.*\\.)").replace((CharSequence)className, "\\$");
                try {
                    Class<?> clazz = Class.forName(className);
                    Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(className)");
                    return clazz;
                }
                catch (ClassNotFoundException classNotFoundException2) {
                }
            }
            throw new IllegalArgumentException("Cannot find class with name \"" + $this$getClass.getSerialName() + "\". Ensure that the serialName for this argument is the default fully qualified name");
        }
    }

    public static final boolean matchKType(@NotNull SerialDescriptor $this$matchKType, @NotNull KType kType) {
        Intrinsics.checkNotNullParameter((Object)$this$matchKType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)kType, (String)"kType");
        if ($this$matchKType.isNullable() != kType.isMarkedNullable()) {
            return false;
        }
        KSerializer kTypeSerializer = SerializersKt.serializerOrNull((KType)kType);
        if (kTypeSerializer == null) {
            boolean bl = false;
            String string = "Custom serializers declared directly on a class field via @Serializable(with = ...) is currently not supported by safe args for both custom types and third-party types. Please use @Serializable or @Serializable(with = ...) on the class or object declaration.";
            throw new IllegalStateException(string.toString());
        }
        return Intrinsics.areEqual((Object)$this$matchKType, (Object)kTypeSerializer.getDescriptor());
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InternalType.values().length];
            try {
                nArray[InternalType.INT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InternalType.BOOL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InternalType.FLOAT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InternalType.LONG.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InternalType.STRING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InternalType.STRING_NULLABLE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InternalType.ENUM.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InternalType.INT_NULLABLE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InternalType.BOOL_NULLABLE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InternalType.DOUBLE.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InternalType.DOUBLE_NULLABLE.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InternalType.FLOAT_NULLABLE.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InternalType.LONG_NULLABLE.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InternalType.INT_ARRAY.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InternalType.BOOL_ARRAY.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InternalType.DOUBLE_ARRAY.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InternalType.FLOAT_ARRAY.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InternalType.LONG_ARRAY.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InternalType.ARRAY.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InternalType.LIST.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InternalType.ENUM_NULLABLE.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

