/*
 * Decompiled with CFR 0.152.
 */
package androidx.savedstate;

import android.os.Bundle;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.savedstate.SavedStateRegistry;
import androidx.savedstate.SavedStateRegistryOwner;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0002\u000e\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Landroidx/savedstate/Recreator;", "Landroidx/lifecycle/LifecycleEventObserver;", "owner", "Landroidx/savedstate/SavedStateRegistryOwner;", "(Landroidx/savedstate/SavedStateRegistryOwner;)V", "onStateChanged", "", "source", "Landroidx/lifecycle/LifecycleOwner;", "event", "Landroidx/lifecycle/Lifecycle$Event;", "reflectiveNew", "className", "", "Companion", "SavedStateProvider", "savedstate_release"})
public final class Recreator
implements LifecycleEventObserver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SavedStateRegistryOwner owner;
    @NotNull
    public static final String CLASSES_KEY = "classes_to_restore";
    @NotNull
    public static final String COMPONENT_KEY = "androidx.savedstate.Restarter";

    public Recreator(@NotNull SavedStateRegistryOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        this.owner = owner;
    }

    public void onStateChanged(@NotNull LifecycleOwner source, @NotNull Lifecycle.Event event) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event != Lifecycle.Event.ON_CREATE) {
            throw new AssertionError((Object)"Next event must be ON_CREATE");
        }
        source.getLifecycle().removeObserver((LifecycleObserver)this);
        Bundle bundle = this.owner.getSavedStateRegistry().consumeRestoredStateForKey(COMPONENT_KEY);
        if (bundle == null) {
            return;
        }
        Bundle bundle2 = bundle;
        ArrayList arrayList = bundle2.getStringArrayList(CLASSES_KEY);
        if (arrayList == null) {
            throw new IllegalStateException("Bundle with restored state for the component \"androidx.savedstate.Restarter\" must contain list of strings by the key \"classes_to_restore\"");
        }
        List classes = arrayList;
        for (String className : classes) {
            this.reflectiveNew(className);
        }
    }

    private final void reflectiveNew(String className) {
        SavedStateRegistry.AutoRecreated autoRecreated;
        Constructor<SavedStateRegistry.AutoRecreated> e2;
        Class<SavedStateRegistry.AutoRecreated> clazz;
        try {
            Class<SavedStateRegistry.AutoRecreated> clazz2 = Class.forName(className, false, Recreator.class.getClassLoader()).asSubclass(SavedStateRegistry.AutoRecreated.class);
            Intrinsics.checkNotNullExpressionValue(clazz2, (String)"{\n                Class.\u2026class.java)\n            }");
            clazz = clazz2;
        }
        catch (ClassNotFoundException e2) {
            throw new RuntimeException("Class " + className + " wasn't found", e2);
        }
        Class<SavedStateRegistry.AutoRecreated> clazz3 = clazz;
        try {
            e2 = clazz3.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e3) {
            throw new IllegalStateException("Class " + clazz3.getSimpleName() + " must have default constructor in order to be automatically recreated", e3);
        }
        Constructor<SavedStateRegistry.AutoRecreated> constructor = e2;
        constructor.setAccessible(true);
        try {
            SavedStateRegistry.AutoRecreated autoRecreated2 = constructor.newInstance(new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)autoRecreated2, (String)"{\n                constr\u2026wInstance()\n            }");
            autoRecreated = autoRecreated2;
        }
        catch (Exception e4) {
            throw new RuntimeException("Failed to instantiate " + className, e4);
        }
        SavedStateRegistry.AutoRecreated newInstance = autoRecreated;
        newInstance.onRecreated(this.owner);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/savedstate/Recreator$Companion;", "", "()V", "CLASSES_KEY", "", "COMPONENT_KEY", "savedstate_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Landroidx/savedstate/Recreator$SavedStateProvider;", "Landroidx/savedstate/SavedStateRegistry$SavedStateProvider;", "registry", "Landroidx/savedstate/SavedStateRegistry;", "(Landroidx/savedstate/SavedStateRegistry;)V", "classes", "", "", "add", "", "className", "saveState", "Landroid/os/Bundle;", "savedstate_release"})
    public static final class SavedStateProvider
    implements SavedStateRegistry.SavedStateProvider {
        @NotNull
        private final Set<String> classes;

        public SavedStateProvider(@NotNull SavedStateRegistry registry) {
            Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
            this.classes = new LinkedHashSet();
            registry.registerSavedStateProvider(Recreator.COMPONENT_KEY, this);
        }

        @Override
        @NotNull
        public Bundle saveState() {
            Bundle bundle;
            Bundle $this$saveState_u24lambda_u240 = bundle = new Bundle();
            boolean bl = false;
            $this$saveState_u24lambda_u240.putStringArrayList(Recreator.CLASSES_KEY, new ArrayList(this.classes));
            return bundle;
        }

        public final void add(@NotNull String className) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            this.classes.add(className);
        }
    }
}

